/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.components;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.components.UICreator;
import java.util.Properties;

public class DefaultUICreator
implements UICreator {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public String constructCell(Properties cellProps, String val) {
        StringBuffer htmlCode = new StringBuffer();
        if (cellProps.size() > 0) {
            if (cellProps.get("LINK") != null) {
                htmlCode.append("<A ");
                htmlCode.append(this.getAttributeAsString(cellProps, val));
                htmlCode.append(">");
                if (cellProps.get("DISPLAY_TEXT") != null) {
                    htmlCode.append(rb.getString(cellProps.get("DISPLAY_TEXT").toString()));
                }
            }
            if (cellProps.get("icon_text") != null) {
                htmlCode.append("<IMG SRC='images/" + cellProps.get("icon_text") + "' id='" + cellProps.get("id") + "' border='" + cellProps.get("border") + "' >");
            }
            if (cellProps.get("LINK") != null) {
                if (cellProps.get("DISPLAY_TEXT") == null) {
                    htmlCode.append("</A>");
                } else {
                    htmlCode.append("</A>");
                }
            }
        }
        return htmlCode.toString();
    }

    public String getAttributeAsString(Properties cellProps, String val) {
        StringBuffer attrList = new StringBuffer(" ");
        for (String string : cellProps.keySet()) {
            String value = (String)cellProps.get(string);
            attrList.append(string);
            attrList.append("='");
            String tempStr = this.getEscapedString(value);
            attrList.append(tempStr);
            attrList.append("' ");
        }
        return attrList.toString();
    }

    public String getEscapedString(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer charBuffer = new StringBuffer();
        for (int len = 0; len < text.length(); ++len) {
            char ch = text.charAt(len);
            if (ch == '\r' || ch == '\n' || ch == '\"' || ch == '\'' || ch == '/') {
                charBuffer.append("&#");
                charBuffer.append((int)ch);
                continue;
            }
            charBuffer.append(ch);
        }
        return charBuffer.toString();
    }
}

