/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.components;

import com.adventnet.sym.adsm.common.webclient.components.UICreator;
import java.util.Properties;

public class InputElementCreator
implements UICreator {
    @Override
    public String constructCell(Properties elementProps, String value) {
        return this.createElement(elementProps, value);
    }

    public String createElement(Properties elementProps, String value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getHtmlForElement(elementProps, value));
        return buffer.toString();
    }

    public String getHtmlForElement(Properties elementProps, String value) {
        StringBuffer htmlCode = new StringBuffer("<INPUT ");
        htmlCode.append(this.getAttributesAsString(elementProps, value));
        String type = (String)elementProps.get("type");
        htmlCode.append(">");
        if ("radio".equals(type) || "checkbox".equals(type)) {
            htmlCode.append(elementProps.get("value"));
        }
        return htmlCode.toString();
    }

    public String getAttributesAsString(Properties elementProps, String val) {
        StringBuffer attrList = new StringBuffer(" ");
        for (String string : elementProps.keySet()) {
            String tmpstr;
            String value;
            if (string.equals("value")) {
                if (val != null) {
                    attrList.append(string);
                    attrList.append("='");
                    attrList.append(val);
                    attrList.append("'  ");
                    continue;
                }
                value = (String)elementProps.get(string);
                attrList.append(string);
                attrList.append("='");
                tmpstr = InputElementCreator.getEscapedString(value);
                attrList.append(tmpstr);
                attrList.append("'  ");
                continue;
            }
            value = (String)elementProps.get(string);
            attrList.append(string);
            attrList.append("='");
            tmpstr = InputElementCreator.getEscapedString(value);
            attrList.append(tmpstr);
            attrList.append("'  ");
        }
        return attrList.toString();
    }

    public static String getEscapedString(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer charBuffer = new StringBuffer();
        for (int length = 0; length < text.length(); ++length) {
            char ch = text.charAt(length);
            if (ch == '\r' || ch == '\n' || ch == '\"' || ch == '\'') {
                charBuffer.append("&#");
                charBuffer.append((int)ch);
                continue;
            }
            charBuffer.append(ch);
        }
        return charBuffer.toString();
    }
}

