/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class ADAPURLGenerator
implements CategoryToolTipGenerator,
PieToolTipGenerator,
XYToolTipGenerator,
CategoryURLGenerator,
PieURLGenerator,
XYURLGenerator {
    int series1 = 0;
    private HashMap chartHash;
    private String mColumn;
    private String actionName;
    private String domainName;
    private String graphTitle;
    private int cvID;
    private int graphOptID;
    private String noofday;
    private String xlabel;
    private String chartType;
    private String jsMethod = null;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ADAPURLGenerator(HashMap chartHash) {
        this.mColumn = (String)chartHash.get("mcolumn");
        this.actionName = (String)chartHash.get("actionname");
        this.domainName = (String)chartHash.get("domainName");
        this.cvID = Integer.parseInt(chartHash.get("cvID").toString());
        this.graphOptID = Integer.parseInt(chartHash.get("graphOptID").toString());
        this.graphTitle = (String)chartHash.get("graphTitle");
        this.noofday = String.valueOf((Long)chartHash.get("noofday"));
        this.xlabel = (String)chartHash.get("xlabel");
        this.chartType = (String)chartHash.get("charttype");
        this.chartHash = chartHash;
    }

    public String generateToolTip(CategoryDataset data, int series, int category) {
        Number value = data.getValue(series, category);
        String toReturn = "";
        Comparable seriesKey = data.getRowKey(series);
        Comparable categoryKey = data.getColumnKey(category);
        String seriesName = seriesKey.toString();
        String categoryName = categoryKey.toString();
        String title = (String)this.chartHash.get("xlabel");
        String yLabel = (String)this.chartHash.get("ylabel");
        int width = 0;
        String textAlignOptions = "VAUTO, HAUTO, WRAP";
        if (width > 0) {
            textAlignOptions = "VAUTO, HAUTO, WIDTH, '" + width + "'";
        } else if (width < 0) {
            textAlignOptions = "VAUTO, HAUTO";
        }
        if (value != null) {
            if (this.mColumn == null) {
                String chartType = (String)this.chartHash.get("charttype");
                if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                    toReturn = categoryName + " " + seriesName + " :  " + yLabel + "   " + value;
                    title = title + " : <b>" + categoryName + "</b>";
                } else {
                    toReturn = categoryName + " : " + yLabel + "  " + value;
                }
            } else {
                toReturn = seriesName + " :  " + yLabel + "   " + value;
                title = title + " : <b>" + categoryName + "</b>";
            }
        }
        return toReturn;
    }

    public String generateToolTip(PieDataset data, Comparable key) {
        String result = "";
        Number value = data.getValue(key);
        int width = 0;
        String textAlignOptions = "VAUTO, HAUTO, WRAP";
        String xLabel = (String)this.chartHash.get("xlabel");
        String yLabel = (String)this.chartHash.get("ylabel");
        if (width > 0) {
            textAlignOptions = "VAUTO, HAUTO, WIDTH, '" + width + "'";
        } else if (width < 0) {
            textAlignOptions = "VAUTO, HAUTO";
        }
        if (value != null) {
            String sectionLabel = key.toString();
            result = sectionLabel + " : " + yLabel + "  " + this.numberFormat.format(value);
        }
        return result;
    }

    public String generateToolTip(XYDataset data, int series, int item) {
        String xLabel = (String)this.chartHash.get("xlabel");
        String yLabel = (String)this.chartHash.get("ylabel");
        String result = " ";
        Double x = data.getXValue(series, item);
        try {
            Double y = data.getYValue(series, item);
            if (y != null) {
                if (xLabel.equalsIgnoreCase("hour")) {
                    Date date = new Date(((Number)x).longValue());
                    int hour = date.getHours();
                    result = result + hour + " hours : " + yLabel + " = " + ((Number)y).intValue();
                } else {
                    Timestamp timestamp = new Timestamp(((Number)x).longValue());
                    Date date = new Date(timestamp.getTime());
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM");
                    result = result + dateFormat.format(date) + " : " + yLabel + " = " + ((Number)y).intValue();
                }
            } else {
                result = rb.handleGetObject("adap.DefaultToolTipGenerator.result__yLabel__Unavailable", new String[]{yLabel});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getJsMethod(String jsMethod) {
        jsMethod = "parent." + jsMethod;
        return jsMethod;
    }

    public String generateURL(CategoryDataset data, int series, int category) {
        List list = data.getColumnKeys();
        List rowlist = data.getRowKeys();
        if (series == 2) {
            ++this.series1;
        }
        Comparable seriesKey = data.getRowKey(series);
        String seriesName = seriesKey.toString();
        String categoryName = data.getColumnKey(category).toString();
        String jsMethod = this.actionName;
        Object jsLink = null;
        String links = null;
        links = this.mColumn == null ? (this.chartType.equalsIgnoreCase("stackedhorizontalbar") || this.chartType.equalsIgnoreCase("stackedverticalbar") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("stackedverticalbar3d") ? "javascript:showReports(this,{'DIRECT_URL':'none','DIALOG_URL':{'FUNCTION_NAME':'" + jsMethod + "','DAY':'" + categoryName + "','DOMAIN_NAME':'" + this.domainName + "','CVID':'" + this.cvID + "','GRAPH_OPT_ID':'" + this.graphOptID + "','GRAPH_TITLE':'" + this.graphTitle + "','NO_OF_DAY':'" + this.noofday + "','X_LABEL':'" + seriesName + "','CHART_TYPE':'" + this.chartType + "'}})" : "javascript:showReports(this,{'DIRECT_URL':'none','DIALOG_URL':{'FUNCTION_NAME':'" + jsMethod + "','DAY':'" + categoryName + "','DOMAIN_NAME':'" + this.domainName + "','CVID':'" + this.cvID + "','GRAPH_OPT_ID':'" + this.graphOptID + "','GRAPH_TITLE':'" + this.graphTitle + "','NO_OF_DAY':'" + this.noofday + "','X_LABEL':'" + this.xlabel + "','CHART_TYPE':'" + this.chartType + "'}})") : "javascript:showReports(this,{'DIRECT_URL':'none','DIALOG_URL':{'FUNCTION_NAME':'" + jsMethod + "','DAY':'" + seriesName + "','DOMAIN_NAME':'" + this.domainName + "','CVID':'" + this.cvID + "','GRAPH_OPT_ID':'" + this.graphOptID + "','GRAPH_TITLE':'" + this.graphTitle + "','NO_OF_DAY':'" + this.noofday + "','X_LABEL':'" + this.xlabel + "','CHART_TYPE':'" + this.chartType + "'}})";
        return links;
    }

    public String generateURL(PieDataset data, Comparable category, int pieIndex) {
        String jsMethod = this.actionName;
        String links = "javascript:showReports(this,{'DIRECT_URL':'none','DIALOG_URL':{'FUNCTION_NAME':'" + jsMethod + "','DAY':'" + category.toString() + "','DOMAIN_NAME':'" + this.domainName + "','CVID':'" + this.cvID + "','GRAPH_OPT_ID':'" + this.graphOptID + "','GRAPH_TITLE':'" + this.graphTitle + "','NO_OF_DAY':'" + this.noofday + "','X_LABEL':'" + this.xlabel + "','CHART_TYPE':'" + this.chartType + "'}})";
        return links;
    }

    public String generateURL(XYDataset dataset, int series, int item) {
        String jsMethod = this.actionName;
        Double value = new Double(dataset.getXValue(series, item));
        String links = "javascript:showReports(this,{'DIRECT_URL':'none','DIALOG_URL':{'FUNCTION_NAME':'" + jsMethod + "','DAY':'" + value.toString() + "','DOMAIN_NAME':'" + this.domainName + "','CVID':'" + this.cvID + "','GRAPH_OPT_ID':'" + this.graphOptID + "','GRAPH_TITLE':'" + this.graphTitle + "','NO_OF_DAY':'" + this.noofday + "','X_LABEL':'" + this.xlabel + "','CHART_TYPE':'" + this.chartType + "'}})";
        return links;
    }
}

