/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.export;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRDesignUtil {
    public static int pageWidth = 595;
    public static int pageHeight = 842;
    public static int columnWidth = 535;
    public static int columnSpacing = 0;
    public static int leftMargin = 30;
    public static int rightMargin = 30;
    public static int topMargin = 20;
    public static int bottomMargin = 20;
    public static int x = 0;
    public static int y = 0;
    public static int width;
    public static int normalSize;
    public static int groupPad;

    public static JRDesignReportFont getJRDesignReportFont(String name, String fontName, int size, boolean bold, boolean isDefault) {
        JRDesignReportFont font = new JRDesignReportFont();
        font.setName(name);
        font.setDefault(isDefault);
        font.setFontName(fontName);
        font.setSize(size);
        font.setBold(bold);
        font.setPdfFontName("Helvetica");
        font.setPdfEncoding("Cp1252");
        font.setPdfEmbedded(false);
        return font;
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign) {
        return JRDesignUtil.getJRDesignTextField(x, y, width, height, font, backColor, foreColor, hAlign, vAlign, true);
    }

    public static JRDesignStaticText getJRDesignStaticText(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign) {
        JRDesignStaticText stxt = new JRDesignStaticText();
        stxt.setX(x);
        stxt.setY(y);
        stxt.setWidth(width);
        stxt.setHeight(height);
        stxt.setMode((byte)1);
        stxt.setPositionType((byte)2);
        if (font != null) {
            stxt.setFont((JRFont)font);
        }
        if (hAlign >= 0) {
            stxt.setTextAlignment(hAlign);
        }
        if (vAlign >= 0) {
            stxt.setVerticalAlignment(vAlign);
        }
        if (backColor != null) {
            stxt.setBackcolor(backColor);
        }
        if (foreColor != null) {
            stxt.setForecolor(foreColor);
        }
        return stxt;
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign, boolean isStrech) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(x);
        textField.setY(y);
        textField.setWidth(width);
        textField.setHeight(height);
        textField.setMode((byte)1);
        textField.setStretchWithOverflow(true);
        if (isStrech) {
            textField.setStretchType((byte)1);
        }
        textField.setPositionType((byte)2);
        if (font != null) {
            textField.setFont((JRFont)font);
        }
        if (hAlign >= 0) {
            textField.setTextAlignment(hAlign);
        }
        if (vAlign >= 0) {
            textField.setVerticalAlignment(vAlign);
        }
        if (backColor != null) {
            textField.setBackcolor(backColor);
        }
        if (foreColor != null) {
            textField.setForecolor(foreColor);
        }
        return textField;
    }

    public static void fillNoDataBand(JasperDesign jasperDesign, JRDesignBand detailBand, String reportType) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            detailBand.setHeight(40);
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", normalSize, true, false);
            JRDesignReportFont normalFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRDesignUtil.getJRDesignReportFont("pagefooter_reportname", "Verdana", normalSize + 1, true, false);
            JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(50, 0, 200, 35, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            txt.setMode((byte)1);
            txt.setStretchType((byte)1);
            txt.setPositionType((byte)2);
            txt.setKey("NoData");
            txt.setPrintRepeatedValues(true);
            txt.setRemoveLineWhenBlank(false);
            txt.setPrintInFirstWholeBand(false);
            txt.setPrintWhenDetailOverflows(false);
            JRBaseBox box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(155, 166, 109));
            box.setBottomBorder((byte)1);
            box.setBottomBorderColor(new Color(155, 166, 109));
            box.setLeftPadding(1);
            detailBand.setSplitAllowed(false);
            txt.setBox((JRBox)box);
            txt.setBackcolor(new Color(239, 239, 231));
            txt.setForecolor(Color.BLACK);
            txt.setText(rb.getString("adap.JRDesignUtil.No_Data_Found"));
            detailBand.addElement((JRDesignElement)txt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType) {
        boolean isSplitAllowed = false;
        pageWidth = 0;
        pageHeight = 842;
        columnWidth = 535;
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        x = 0;
        y = 0;
        normalSize = 9;
        groupPad = 10;
        try {
            columnHeaderBand.setHeight(35);
            detailBand.setHeight(30);
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", normalSize, true, false);
            JRDesignReportFont normalFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRDesignUtil.getJRDesignReportFont("pagefooter_reportname", "Verdana", normalSize + 1, true, false);
            for (Object object : attributeList) {
                HashMap columnMap = (HashMap)object;
                String displayName = (String)columnMap.get("DISPLAYNAME");
                String columnName = (String)columnMap.get("COLUMNALIAS");
                String dateFormat = (String)columnMap.get("DATE_FORMAT");
                JRDesignField field = new JRDesignField();
                field.setName(columnName.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                width = (Integer)columnWidths.get(displayName);
                pageWidth += width;
                JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(x, 0, width, 35, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(displayName.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(155, 166, 109));
                box.setBottomBorder((byte)1);
                box.setBottomBorderColor(new Color(155, 166, 109));
                box.setLeftPadding(1);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(239, 239, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                columnHeaderBand.addElement((JRDesignElement)txt);
                JRDesignTextField txtField = JRDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                if (dateFormat == null) {
                    exp.setText("$F{" + columnName + "}");
                } else {
                    exp.setText("new SimpleDateFormat(\"" + dateFormat + "\").format(new java.util.Date(Long.valueOf($F{" + columnName + "}).longValue()*1000L))");
                }
                txtField.setBox((JRBox)box);
                txtField.setExpression((JRExpression)exp);
                detailBand.setSplitAllowed(false);
                txtField.setPrintWhenDetailOverflows(true);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                detailBand.addElement((JRDesignElement)txtField);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    x += width + 0;
                    continue;
                }
                x += width + 2;
            }
            pageWidth = pageWidth < 595 ? 595 : (pageWidth += 120);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageWidth;
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType) {
        Hashtable<String, Integer> columnWidths = new Hashtable<String, Integer>();
        int width = columnWidth / attributeList.size();
        String val = null;
        for (Object object : attributeList) {
            int length;
            HashMap columnMap = (HashMap)object;
            String displayName = null;
            displayName = (String)columnMap.get("DISPLAYNAME");
            StringBuffer sb = new StringBuffer();
            sb.append(displayName);
            val = sb.toString();
            if (val == null) {
                val = "-";
            }
            String str = val.toString();
            if (reportType.toLowerCase().indexOf("html") != -1 || reportType.toLowerCase().indexOf("pdf") != -1) {
                str = ClientUtil.getSplitString(str, 100 / attributeList.size());
            }
            int strLength = str.length();
            if (displayName.length() > strLength) {
                strLength = displayName.length();
            }
            if ((length = strLength * 4) < 40) {
                length = 60;
            }
            columnWidths.put(displayName, length);
        }
        ArrayList<String> lengthyList = new ArrayList<String>();
        int remTotalWidth = 0;
        if (!reportType.toLowerCase().equals("csvde")) {
            for (Object object : attributeList) {
                HashMap columnMap = (HashMap)object;
                String columnName = (String)columnMap.get("DISPLAYNAME");
                if (columnWidths.isEmpty()) continue;
                int w = (Integer)columnWidths.get(columnName);
                if (w > width) {
                    lengthyList.add(columnName);
                    continue;
                }
                remTotalWidth += width - w;
            }
        }
        int extraWidth = 0;
        if (lengthyList.size() > 0) {
            extraWidth = remTotalWidth / lengthyList.size();
        }
        for (int i = 0; i < lengthyList.size(); ++i) {
            String columnName = (String)lengthyList.get(i);
            int w = (Integer)columnWidths.get(columnName);
            columnWidths.put(columnName, w + extraWidth);
        }
        return columnWidths;
    }

    static {
        normalSize = 9;
        groupPad = 10;
    }
}

