/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.export;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;

public class ReportExporter {
    private static ReportExporter reportExporter;

    private ReportExporter() {
    }

    public static ReportExporter getInstance() {
        if (reportExporter == null) {
            reportExporter = new ReportExporter();
        }
        return reportExporter;
    }

    public void exportAsPdf(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + toolID + ".pdf"));
        JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)output);
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsHTML(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
        HashMap imagesMap = new HashMap();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bos);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        exporter.exportReport();
        byte[] html = bos.toByteArray();
        bos.close();
        FileOutputStream fs = new FileOutputStream(dir + File.separator + toolID + ".html");
        fs.write(html);
        fs.close();
    }

    public void exportAsCSV(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)",");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Integer(200));
        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Integer(50));
        exporter.exportReport();
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + toolID + ".csv"));
        ((OutputStream)output).write(baos.toByteArray());
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsXLS(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + toolID + ".xls"));
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsPdf(JasperPrint print, String toolID, HttpServletResponse response) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        byte[] buf = JasperExportManager.exportReportToPdf((JasperPrint)print);
        response.setContentType("application/pdf");
        response.setContentLength(buf.length);
        response.setHeader("content-disposition", "attachment; filename=" + toolID + ".pdf");
        ServletOutputStream out = response.getOutputStream();
        out.write(buf, 0, buf.length);
        out.close();
    }

    public void exportAsJpeg(JasperPrint print, String toolID, HttpServletResponse response) throws Exception {
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        BufferedImage bufferedImage = new BufferedImage(500, 350, 1);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)response.getOutputStream());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)"ChassisImg.jpg");
        exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)bufferedImage.createGraphics());
    }

    public void exportAsHtml(JasperPrint print, String toolID, HttpServletResponse response, HttpSession session) throws Exception {
        PrintWriter out = response.getWriter();
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)out);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
        HashMap imagesMap = (HashMap)session.getAttribute("IMAGES_MAP");
        if (imagesMap == null) {
            imagesMap = new HashMap();
        }
        session.setAttribute("IMAGES_MAP", imagesMap);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(false));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(false));
        exporter.exportReport();
    }

    public void exportAsXls(JasperPrint print, String toolID, HttpServletResponse response) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        response.reset();
        response.setContentType("application/xls");
        response.setHeader("content-disposition", "inline;filename=" + toolID + ".xls");
        ServletOutputStream os = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.exportReport();
        os.close();
    }

    public void exportAsCsv(JasperPrint print, String designFileName, HttpServletResponse response) throws Exception {
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        response.reset();
        response.setContentType("application/msexcel-comma");
        response.setHeader("content-disposition", "attachment;filename=" + designFileName + ".csv");
        ServletOutputStream os = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
        exporter.exportReport();
        os.close();
    }

    private JasperPrint getReport(String bpath, String dFile, Map reportParams, JRDataSource jrds) throws Exception {
        String designFileName = dFile;
        String compileFileName = bpath + "jasper" + File.separator + designFileName + ".jasper";
        JasperPrint print = null;
        print = JasperFillManager.fillReport((String)compileFileName, (Map)reportParams, (JRDataSource)jrds);
        return print;
    }
}

