/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.format;

import com.adventnet.sym.adsm.common.webclient.graphs.format.DataFormatter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultDataFormatter
implements DataFormatter {
    private static final Logger LOGGER = Logger.getLogger(DefaultDataFormatter.class.getName());
    private static String[] numberColumns = new String[]{"Total_Request", "Perc", "COUNT", "count", "PERC_BYTES", "Request_Count", "TotalCount", "Total_Events", "TotalEvents", "ALERT_COUNT", "TotalTime", "MaxIn", "MaxOut", "MinIn", "MinOut", "AvgIn", "AvgOut", "Kbps", "EVT_COUNT", "EVENT_CNT", "Times", "ErrorCount", "WarningCount", "InfoCount", "SuccCount", "FailCount", "Attempts", "Per_Attempts", "High", "Medium", "Low", "Count", "Per_Count", "Event_Count", "Hits", "Per_Hits", "Error", "Warning", "Failure", "Others", "Total", "CRITICAL_CNT", "ERROR_CNT", "WARNING_CNT", "INFORMATION_CNT", "TOTAL_CNT", "hits", "percent", "page_view", "EVTCOUNT", "errorno", "severity", "state", "transfer"};
    private static HashSet numColList = DefaultDataFormatter.getColsAsSet(numberColumns);
    private static String[] byteColumns = new String[]{"BYTES", "TotalBytes", "Total_Bytes", "Bytes", "Sum_of_Bytes", "Sum_of_Total_Bytes"};
    private static HashSet byteColList = DefaultDataFormatter.getColsAsSet(byteColumns);
    String[] byteColumns2 = new String[]{"sc_bytes", "cs_bytes"};
    List byteColList2 = Arrays.asList(this.byteColumns2);
    private HashMap durationMap = new HashMap();
    private String[] bw = new String[]{" B", " KB", " MB", " GB", " TB"};

    public DefaultDataFormatter() {
        for (int i = 0; i < 100; ++i) {
            String range = "" + (i - 1) * 1000 + "-" + i * 1000;
            this.durationMap.put("" + i, range);
        }
        this.durationMap.put("Total", "Total");
    }

    private static HashSet getColsAsSet(String[] columns) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < columns.length; ++i) {
            set.add(columns[i]);
        }
        return set;
    }

    @Override
    public String unit(String columnName) {
        return "";
    }

    public boolean toFormat(List list, String columnName) {
        if (list.contains(columnName)) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!columnName.startsWith((String)list.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean toFormat(HashSet set, String columnName) {
        if (set.contains(columnName)) {
            return true;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!columnName.startsWith((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object format(String columnName, Object obj) {
        if (obj == null || "".equals(obj)) {
            return "";
        }
        try {
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMaximumIntegerDigits(12);
            formatter.setMaximumFractionDigits(2);
            if (this.toFormat(byteColList, columnName)) {
                return formatter.parse(formatter.format(((Number)obj).doubleValue() / 1048576.0));
            }
            if (this.toFormat(numColList, columnName)) {
                if (obj instanceof String) {
                    obj = new Double(obj.toString());
                }
                return formatter.parse(formatter.format(obj));
            }
            if (this.toFormat(this.byteColList2, columnName)) {
                long bytes = ((Number)obj).longValue();
                double retVal = bytes;
                int i = 0;
                boolean b = true;
                do {
                    if (!(b = (bytes >>= 10) > 0L)) continue;
                    retVal /= 1024.0;
                    ++i;
                } while (b);
                return formatter.parse(formatter.format(retVal)) + this.bw[i];
            }
            if (columnName.startsWith("TIMESTAMP")) {
                String DATE_FORMAT = "HH:mm:ss MMM dd yyyy";
                SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                if (obj instanceof String) {
                    return df.format(new Date(new Long((String)obj)));
                }
                if (obj instanceof Long) {
                    return df.format(new Date((Long)obj));
                }
                return obj;
            }
            if (columnName.equals("Duration")) {
                return this.formatDuration(((Number)obj).intValue());
            }
            if (columnName.equals("TimeConsumed")) {
                return formatter.parse(formatter.format(((Number)obj).doubleValue() / 3600.0));
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.FINER, "Exception <->{0}<->{1}", new Object[]{e, obj});
            return obj;
        }
    }

    public String formatDuration(int value) {
        StringBuffer result = new StringBuffer();
        if (value > 86400) {
            int days = value / 86400;
            int dayHrs = value % 86400 / 3600;
            if (days == 1) {
                result.append("1 Day ");
            } else {
                result.append(days);
                result.append(" Days ");
            }
            result.append(dayHrs);
            result.append(" Hrs");
        } else if (value > 3600) {
            int hours = value / 3600;
            int hourMins = value % 3600 / 60;
            if (hours == 1) {
                result.append("1 Hr ");
            } else {
                result.append(hours);
                result.append(" Hrs ");
            }
            result.append(hourMins);
            result.append(" Mins");
        } else if (value > 60) {
            int mins = value / 60;
            int secs = value % 60;
            if (mins == 1) {
                result.append("1 Min ");
            } else {
                result.append(mins);
                result.append(" Mins ");
            }
            result.append(secs);
            result.append(" Secs");
        } else {
            result.append(value);
            result.append(" Secs");
        }
        return result.toString();
    }
}

