/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class ChartUtil {
    public static int isExport = 0;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static String installationDir = System.getProperty("server.dir");
    public static String fileSep = System.getProperty("file.separator");
    public static String imgPath = installationDir + fileSep + "webapps" + fileSep + "adap" + fileSep + "images" + fileSep + "graph_bg.gif";

    public static void setExport(int value) {
        isExport = value;
    }

    public static void process2DPieCharts(JFreeChart chart, HashMap chartHash) {
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage(rb.getString("adap.ChartUtil.No_Data_Available"));
        plot.setStartAngle(315.0);
        plot.setInteriorGap(0.05);
        plot.setOutlinePaint(null);
        plot.setOutlineStroke(null);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setLabelGenerator(null);
        plot.setSectionPaint(0, (Paint)new Color(108, 163, 36));
        plot.setSectionPaint(1, (Paint)new Color(229, 190, 3));
        plot.setSectionPaint(2, (Paint)new Color(247, 72, 25));
        plot.setSectionPaint(3, (Paint)new Color(8, 118, 192));
        plot.setSectionPaint(4, (Paint)new Color(245, 131, 43));
        plot.setSectionPaint(5, (Paint)new Color(249, 100, 76));
        plot.setSectionPaint(6, (Paint)new Color(130, 249, 209));
        plot.setSectionPaint(7, (Paint)new Color(150, 94, 119));
        plot.setSectionPaint(8, (Paint)new Color(251, 118, 245));
        plot.setSectionPaint(9, (Paint)new Color(183, 211, 101));
        plot.setSectionPaint(10, (Paint)new Color(183, 211, 101));
        plot.setSectionPaint(11, (Paint)new Color(137, 163, 183));
        plot.setSectionOutlinePaint(0, (Paint)new Color(108, 163, 36));
        plot.setSectionOutlinePaint(1, (Paint)new Color(229, 190, 3));
        plot.setSectionOutlinePaint(2, (Paint)new Color(247, 72, 25));
        plot.setSectionOutlinePaint(3, (Paint)new Color(8, 118, 192));
        plot.setSectionOutlinePaint(4, (Paint)new Color(245, 131, 43));
        plot.setSectionOutlinePaint(5, (Paint)new Color(249, 100, 76));
        plot.setSectionOutlinePaint(6, (Paint)new Color(130, 249, 209));
        plot.setSectionOutlinePaint(7, (Paint)new Color(150, 94, 119));
        plot.setSectionOutlinePaint(8, (Paint)new Color(251, 118, 245));
        plot.setSectionOutlinePaint(9, (Paint)new Color(183, 211, 101));
        plot.setSectionOutlinePaint(10, (Paint)new Color(183, 211, 101));
        plot.setSectionOutlinePaint(11, (Paint)new Color(137, 163, 183));
        plot.setOutlinePaint((Paint)new Color(255, 255, 255));
        if (isExport != 0) {
            DecimalFormat decimalformat1 = new DecimalFormat("##");
            StandardPieSectionLabelGenerator generator = new StandardPieSectionLabelGenerator("{1}");
            plot.setLabelGenerator((PieSectionLabelGenerator)generator);
            isExport = 0;
        }
        PieDataset dataset = plot.getDataset();
        List keyList = dataset.getKeys();
        String[] alertSeverties = new String[]{rb.getString("adap.NotificationAPI.Clear"), rb.getString("adap.NotificationAPI.Attention"), rb.getString("adap.NotificationAPI.Trouble"), rb.getString("adap.NotificationAPI.Critical")};
        Integer[][] severityColors = new Integer[][]{{56, 218, 67}, {255, 243, 139}, {234, 148, 14}, {255, 22, 22}};
        for (int i = 0; i < alertSeverties.length; ++i) {
            String severity = alertSeverties[i];
            if (keyList.indexOf(severity) == -1) continue;
            int index = keyList.indexOf(severity);
            plot.setSectionPaint(index, (Paint)new Color(severityColors[i][0], severityColors[i][1], severityColors[i][2]));
            plot.setSectionOutlinePaint(index, (Paint)new Color(severityColors[i][0], severityColors[i][1], severityColors[i][2]));
        }
        JFreeChart pieChart = chart;
    }

    public static void processPieCharts(JFreeChart chart, HashMap chartHash) {
        JFreeChart pieChart;
        LegendTitle legendTitle;
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setNoDataMessage(rb.getString("adap.ChartUtil.No_Data_Available"));
        plot.setStartAngle(315.0);
        plot.setInteriorGap(0.05);
        plot.setOutlinePaint(null);
        plot.setOutlineStroke(null);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setDepthFactor(0.15);
        plot.setLabelGenerator(null);
        plot.setSectionPaint(0, (Paint)new Color(108, 163, 36));
        plot.setSectionPaint(1, (Paint)new Color(229, 190, 3));
        plot.setSectionPaint(2, (Paint)new Color(247, 72, 25));
        plot.setSectionPaint(3, (Paint)new Color(8, 118, 192));
        plot.setSectionPaint(4, (Paint)new Color(245, 131, 43));
        plot.setSectionPaint(5, (Paint)new Color(249, 100, 76));
        plot.setSectionPaint(6, (Paint)new Color(130, 249, 209));
        plot.setSectionPaint(7, (Paint)new Color(150, 94, 119));
        plot.setSectionPaint(8, (Paint)new Color(251, 118, 245));
        plot.setSectionPaint(9, (Paint)new Color(183, 211, 101));
        plot.setSectionPaint(10, (Paint)new Color(183, 211, 101));
        plot.setSectionPaint(11, (Paint)new Color(137, 163, 183));
        plot.setSectionOutlinePaint(0, (Paint)new Color(108, 163, 36));
        plot.setSectionOutlinePaint(1, (Paint)new Color(229, 190, 3));
        plot.setSectionOutlinePaint(2, (Paint)new Color(247, 72, 25));
        plot.setSectionOutlinePaint(3, (Paint)new Color(8, 118, 192));
        plot.setSectionOutlinePaint(4, (Paint)new Color(245, 131, 43));
        plot.setSectionOutlinePaint(5, (Paint)new Color(249, 100, 76));
        plot.setSectionOutlinePaint(6, (Paint)new Color(130, 249, 209));
        plot.setSectionOutlinePaint(7, (Paint)new Color(150, 94, 119));
        plot.setSectionOutlinePaint(8, (Paint)new Color(251, 118, 245));
        plot.setSectionOutlinePaint(9, (Paint)new Color(183, 211, 101));
        plot.setSectionOutlinePaint(10, (Paint)new Color(183, 211, 101));
        plot.setSectionOutlinePaint(11, (Paint)new Color(137, 163, 183));
        if (isExport != 0) {
            DecimalFormat decimalformat1 = new DecimalFormat("##");
            StandardPieSectionLabelGenerator generator = new StandardPieSectionLabelGenerator("{1}");
            plot.setLabelGenerator((PieSectionLabelGenerator)generator);
            isExport = 0;
        }
        if ((legendTitle = (pieChart = chart).getLegend()) != null) {
            legendTitle.setItemFont(new Font("SansSerif", 0, 10));
            if (chartHash.get("legendorientation") != null) {
                legendTitle.setPosition(RectangleEdge.RIGHT);
                legendTitle.setBorder(new BlockBorder((Paint)Color.WHITE));
            }
        }
    }

    public static void processBarCharts(JFreeChart chart, HashMap chartHash) {
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        int xOffset = 5;
        int yOffset = 5;
        plot.setNoDataMessage(rb.getString("adap.ChartUtil.No_Data_Available"));
        plot.setForegroundAlpha(1.0f);
        BarRenderer3D b3D = (BarRenderer3D)plot.getRenderer();
        if (b3D == null) {
            b3D = new BarRenderer3D((double)xOffset, (double)yOffset);
        }
        b3D.setItemMargin(2.0);
        b3D.setDrawBarOutline(true);
        plot.setRenderer((CategoryItemRenderer)b3D);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)new Color(204, 204, 204));
        plot.setOutlineStroke(null);
        BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
        renderer.setItemMargin(0.1);
        if (isExport != 0) {
            renderer.setMaximumBarWidth(0.08);
        } else {
            renderer.setMaximumBarWidth(0.05);
        }
        renderer.setSeriesPaint(0, (Paint)new Color(254, 226, 111));
        renderer.setSeriesPaint(1, (Paint)new Color(29, 120, 15));
        renderer.setSeriesPaint(2, (Paint)new Color(254, 170, 110));
        renderer.setSeriesPaint(3, (Paint)new Color(115, 79, 231));
        renderer.setSeriesPaint(4, (Paint)new Color(253, 196, 0));
        renderer.setSeriesOutlinePaint(0, (Paint)new Color(177, 158, 77));
        renderer.setSeriesOutlinePaint(1, (Paint)new Color(29, 120, 15));
        renderer.setSeriesOutlinePaint(2, (Paint)new Color(254, 170, 110));
        renderer.setSeriesOutlinePaint(3, (Paint)new Color(115, 79, 231));
        renderer.setSeriesOutlinePaint(4, (Paint)new Color(253, 196, 0));
        if (isExport != 0) {
            DecimalFormat decimalformat1 = new DecimalFormat("##");
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)decimalformat1));
            renderer.setItemLabelsVisible(true);
            renderer.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER));
            isExport = 0;
        }
        CategoryAxis ca = new CategoryAxis();
        ca.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5));
        ca.setCategoryMargin(0.25);
        ca.setLowerMargin(0.04);
        ca.setUpperMargin(0.04);
        String xLabel = (String)chartHash.get("xlabel");
        if (xLabel != null) {
            ca.setLabel(xLabel);
        }
        plot.setDomainAxis(ca);
        ValueAxis va = plot.getRangeAxis();
        va.setLowerBound(0.0);
        va.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart barChart = chart;
        barChart.removeLegend();
        LegendTitle legendTitle = barChart.getLegend();
        if (legendTitle != null) {
            legendTitle.setItemFont(new Font("SansSerif", 0, 10));
        }
    }

    public static void processStackedBarCharts(JFreeChart chart, HashMap chartHash) {
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setDomainGridlinesVisible(true);
        plot.setNoDataMessage(rb.getString("adap.ChartUtil.No_Data_Available"));
        plot.setForegroundAlpha(1.0f);
        StackedBarRenderer3D renderer = (StackedBarRenderer3D)plot.getRenderer();
        if (isExport != 0) {
            renderer.setMaximumBarWidth(0.08);
        } else {
            renderer.setMaximumBarWidth(0.05);
        }
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)new Color(204, 204, 204));
        plot.setOutlinePaint(null);
        plot.setOutlineStroke(null);
        renderer.setSeriesPaint(0, (Paint)new Color(82, 176, 51));
        renderer.setSeriesPaint(1, (Paint)new Color(231, 82, 31));
        renderer.setSeriesPaint(2, (Paint)new Color(0, 153, 255));
        renderer.setSeriesPaint(3, (Paint)new Color(115, 79, 231));
        renderer.setSeriesPaint(4, (Paint)new Color(253, 196, 0));
        renderer.setSeriesOutlinePaint(0, (Paint)new Color(82, 176, 51));
        renderer.setSeriesOutlinePaint(1, (Paint)new Color(231, 82, 31));
        renderer.setSeriesOutlinePaint(2, (Paint)new Color(0, 153, 255));
        renderer.setSeriesOutlinePaint(3, (Paint)new Color(115, 79, 231));
        renderer.setSeriesOutlinePaint(4, (Paint)new Color(253, 196, 0));
        if (isExport != 0) {
            DecimalFormat decimalformat1 = new DecimalFormat("##");
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)decimalformat1));
            renderer.setItemLabelsVisible(true);
            renderer.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER));
            isExport = 0;
        }
        CategoryAxis ca = new CategoryAxis();
        ca.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.4));
        ca.setCategoryMargin(0.4);
        ca.setLowerMargin(0.02);
        ca.setUpperMargin(0.02);
        plot.setDomainAxis(ca);
        ValueAxis va = plot.getRangeAxis();
        va.setLowerBound(0.0);
        JFreeChart stackedBarChart = chart;
        LegendTitle legendTitle = stackedBarChart.getLegend();
        stackedBarChart.removeLegend();
        if (legendTitle != null) {
            legendTitle.setItemFont(new Font("SansSerif", 0, 10));
        }
        CategoryDataset dataset = plot.getDataset();
        List keyList = dataset.getRowKeys();
        String[] alertSeverties = new String[]{"Account Modified", "Account Creation", "Account Deleted"};
        Integer[][] severityColors = new Integer[][]{{0, 153, 255}, {82, 176, 51}, {231, 82, 31}};
        String severity = "";
        for (int i = 0; i < alertSeverties.length; ++i) {
            severity = alertSeverties[i];
            if (keyList.indexOf(severity) == -1) continue;
            int index = keyList.indexOf(severity);
            renderer.setSeriesPaint(index, (Paint)new Color(severityColors[i][0], severityColors[i][1], severityColors[i][2]));
            renderer.setSeriesOutlinePaint(index, (Paint)new Color(severityColors[i][0], severityColors[i][1], severityColors[i][2]));
        }
        String[] status = new String[]{"Success", "Failure"};
        Integer[][] statusColors = new Integer[][]{{82, 176, 51}, {231, 82, 31}};
        for (int i = 0; i < status.length; ++i) {
            if (keyList.indexOf(status[i]) == -1) continue;
            int index = keyList.indexOf(status[i]);
            renderer.setSeriesPaint(keyList.indexOf(status[i]), (Paint)new Color(statusColors[i][0], statusColors[i][1], statusColors[i][2]));
            renderer.setSeriesOutlinePaint(keyList.indexOf(status[i]), (Paint)new Color(statusColors[i][0], statusColors[i][1], statusColors[i][2]));
        }
    }

    public static void processLineCharts(JFreeChart chart, HashMap chartHash) {
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setNoDataMessage(rb.getString("adap.ChartUtil.No_Data_Available"));
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)new Color(204, 204, 204));
        plot.setOutlineStroke(null);
        plot.setForegroundAlpha(1.0f);
        CategoryItemRenderer itemRenderer = plot.getRenderer();
        if (itemRenderer instanceof LineAndShapeRenderer) {
            LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)itemRenderer;
            lineRenderer.setShapesVisible(true);
            lineRenderer.setShapesFilled(true);
            lineRenderer.setShape((Shape)new Rectangle(-2, -2, 3, 3), true);
            lineRenderer.setSeriesPaint(0, (Paint)new Color(255, 85, 85));
            lineRenderer.setSeriesPaint(1, (Paint)new Color(85, 85, 255));
            lineRenderer.setSeriesPaint(2, (Paint)new Color(8, 164, 8));
        }
        CategoryAxis ca = new CategoryAxis();
        ca.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5));
        ca.setCategoryMargin(0.25);
        ca.setLowerMargin(0.04);
        ca.setUpperMargin(0.04);
        ca.setTickLabelFont(new Font("SansSerif", 0, 10));
        String xLabel = (String)chartHash.get("xlabel");
        if (xLabel != null) {
            ca.setLabel(xLabel);
        }
        plot.setDomainAxis(ca);
        ValueAxis va = plot.getRangeAxis();
        va.setTickLabelFont(new Font("SansSerif", 0, 10));
        va.setLabelFont(new Font("SansSerif", 0, 10));
        JFreeChart lineChart = chart;
        LegendTitle legendTitle = lineChart.getLegend();
        if (legendTitle != null) {
            legendTitle.setItemFont(new Font("SansSerif", 0, 10));
        }
    }

    public static void processTimeSeriesChart(JFreeChart chart, HashMap chartHash) {
        LegendTitle legendTitle;
        String xLabel = (String)chartHash.get("xlabel");
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setNoDataMessage(rb.getString("adap.ChartUtil.No_Data_Available"));
        plot.setForegroundAlpha(1.0f);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)new Color(204, 204, 204));
        plot.setOutlineStroke(null);
        plot.setDomainGridlineStroke(null);
        DateAxis domainAxis = new DateAxis(xLabel);
        domainAxis.setVerticalTickLabels(true);
        domainAxis.setAutoTickUnitSelection(true);
        domainAxis.setLowerMargin(0.05);
        if (xLabel.equalsIgnoreCase(rb.getString("adap.AUDGraphOptions.xlabel.DAY"))) {
            domainAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MMM"));
        }
        plot.setDomainAxis((ValueAxis)domainAxis);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setShapesVisible(true);
            renderer.setShapesFilled(true);
            Dimension dimension = new Dimension();
            dimension.setSize(2.5, 2.5);
            Point point = new Point();
            point.setLocation(-1.5, -1.5);
            renderer.setShape((Shape)new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        }
        if ((legendTitle = chart.getLegend()) != null) {
            legendTitle.setItemFont(new Font("SansSerif", 0, 10));
        }
    }
}

