/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorProducer {
    private static final Logger LOGGER = Logger.getLogger(ColorProducer.class.getName());
    private static HashMap colorTableMap = null;
    private static boolean debug = false;

    public static HashMap getColorMap(String tableName, String columnName, String colorColumn) {
        String key = tableName + "." + columnName + "." + colorColumn;
        HashMap resultMap = (HashMap)colorTableMap.get(key);
        if (resultMap == null) {
            resultMap = ColorProducer.loadColors(tableName, columnName, colorColumn);
            colorTableMap.put(key, resultMap);
        }
        return resultMap;
    }

    private static HashMap loadColors(String tableName, String columnName, String colorColumn) {
        try {
            ColorProducer.debug(" TRYING TO LOAD COLOR ==" + colorColumn + " and " + columnName + " in ==" + tableName);
            SelectQueryImpl select = new SelectQueryImpl(new Table(tableName));
            select.addSelectColumn(new Column(tableName, "*"));
            DataObject dobj = DataAccess.get((SelectQuery)select);
            HashMap<String, String> colorMap = new HashMap<String, String>();
            Iterator iter = dobj.getRows(tableName);
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String key = (String)row.get(columnName);
                String value = (String)row.get(colorColumn);
                if (key == null || value == null) continue;
                colorMap.put(key, value);
            }
            ColorProducer.debug("COLOR MAP AFTER LOADING FROM DATABASE ==" + colorMap);
            return colorMap;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    public static void reload() {
        StringTokenizer token = null;
        for (Map.Entry entry : colorTableMap.entrySet()) {
            String key = (String)entry.getKey();
            token = new StringTokenizer(key, ".");
            String tableName = token.nextToken();
            String columnName = token.nextToken();
            String colorColumn = token.nextToken();
            colorTableMap.put(key, ColorProducer.loadColors(tableName, columnName, colorColumn));
        }
        ColorProducer.debug(" AFTER RELOAD COLOR MAP IS ==" + colorTableMap);
    }

    private static void debug(String st) {
        if (debug) {
            LOGGER.log(Level.FINER, st);
        }
    }

    static {
        colorTableMap = new HashMap();
        debug = new Boolean(System.getProperty("debug"));
    }
}

