/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.util;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import de.laures.cewolf.links.LinkGenerator;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class DefaultLinkGenerator
implements LinkGenerator {
    int series1 = 0;
    private HashMap chartHash;
    private String mColumn;
    private String actionName;
    private String domainName;
    private String graphTitle;
    private int cvID;
    private int graphOptID;
    private String noofday;
    private String xlabel;
    private String chartType;
    private DataObject cache = null;
    private String jsMethod = null;

    public DefaultLinkGenerator(HashMap chartHash) {
        this.chartHash = chartHash;
        this.mColumn = (String)chartHash.get("mColumn");
        this.actionName = (String)chartHash.get("actionname");
        this.domainName = (String)chartHash.get("domainName");
        this.cvID = Integer.parseInt(chartHash.get("cvID").toString());
        this.graphOptID = Integer.parseInt(chartHash.get("graphOptID").toString());
        this.graphTitle = (String)chartHash.get("graphTitle");
        this.noofday = String.valueOf((Long)chartHash.get("noofday"));
        this.xlabel = (String)chartHash.get("xlabel");
        this.chartType = (String)chartHash.get("charttype");
    }

    public String generateLink(Object dataset, Object category) {
        PieDataset data = (PieDataset)dataset;
        String jsMethod = this.getJsMethod(this.actionName);
        String jsLink = this.getLink(jsMethod, category.toString());
        return jsLink;
    }

    public String generateLink(Object dataset, int series, Object category) {
        CategoryDataset data = (CategoryDataset)dataset;
        List list = data.getColumnKeys();
        List rowlist = data.getRowKeys();
        if (series == 2) {
            ++this.series1;
        }
        Comparable seriesKey = data.getRowKey(series);
        String seriesName = seriesKey.toString();
        String categoryName = category.toString();
        String jsMethod = this.getJsMethod(this.actionName);
        String jsLink = null;
        jsLink = this.mColumn == null ? (this.chartType.equalsIgnoreCase("stackedhorizontalbar") || this.chartType.equalsIgnoreCase("stackedverticalbar") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("stackedverticalbar3d") ? this.getLink(jsMethod, categoryName, seriesName) : this.getLink(jsMethod, categoryName)) : this.getLink(jsMethod, categoryName + ";;;" + seriesName);
        return jsLink;
    }

    public String generateLink(Object data, int series, int item) {
        XYDataset dataset = (XYDataset)data;
        String jsMethod = this.getJsMethod(this.actionName);
        String link = null;
        link = this.mColumn != null ? this.getLink(jsMethod, String.valueOf(dataset.getXValue(series, item)) + ";;;" + dataset.getSeriesKey(series).toString()) : this.getLink(jsMethod, String.valueOf(dataset.getXValue(series, item)));
        return link;
    }

    private String getJsMethod(String jsMethod) {
        jsMethod = "javascript:" + jsMethod;
        return jsMethod;
    }

    private String getLink(String jsMethod, String value) {
        value = ClientUtil.scriptEscape(value);
        StringBuffer jsLink = new StringBuffer(jsMethod);
        jsLink.append("('").append(value).append("','").append(this.domainName).append("','").append(this.cvID).append("','").append(this.graphOptID).append("','").append(this.graphTitle).append("','").append(this.noofday).append("','").append(this.xlabel).append("','").append(this.chartType).append("')");
        return jsLink.toString();
    }

    private String getLink(String jsMethod, String value, String seriesName) {
        value = ClientUtil.scriptEscape(value);
        StringBuffer jsLink = new StringBuffer(jsMethod);
        jsLink.append("('").append(value).append("','").append(this.domainName).append("','").append(this.cvID).append("','").append(this.graphOptID).append("','").append(this.graphTitle).append("','").append(this.noofday).append("','").append(seriesName).append("','").append(this.chartType).append("')");
        return jsLink.toString();
    }
}

