/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import de.laures.cewolf.tooltips.ToolTipGenerator;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class DefaultToolTipGenerator
implements ToolTipGenerator {
    private NumberFormat numberFormat;
    private String mColumn;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public DefaultToolTipGenerator() {
        this.numberFormat = NumberFormat.getInstance();
    }

    public DefaultToolTipGenerator(String mColumn) {
        this.mColumn = mColumn;
    }

    public String generateToolTip(PieDataset data, Comparable key, int pieIndex, HashMap chartHash) {
        String result = "";
        Number value = data.getValue(key);
        int width = 0;
        String textAlignOptions = "VAUTO, HAUTO, WRAP";
        String xLabel = (String)chartHash.get("xlabel");
        String yLabel = (String)chartHash.get("ylabel");
        if (width > 0) {
            textAlignOptions = "VAUTO, HAUTO, WIDTH, '" + width + "'";
        } else if (width < 0) {
            textAlignOptions = "VAUTO, HAUTO";
        }
        if (value != null) {
            String sectionLabel = key.toString();
            result = sectionLabel + " : " + yLabel + "  " + this.numberFormat.format(value);
        }
        return result;
    }

    public String generateToolTip(CategoryDataset data, int series, int category, HashMap chartHash) {
        Number value = data.getValue(series, category);
        String toReturn = "";
        Comparable seriesKey = data.getRowKey(series);
        Comparable categoryKey = data.getColumnKey(category);
        String seriesName = seriesKey.toString();
        String categoryName = categoryKey.toString();
        String title = (String)chartHash.get("xlabel");
        String yLabel = (String)chartHash.get("ylabel");
        int width = 0;
        String textAlignOptions = "VAUTO, HAUTO, WRAP";
        if (width > 0) {
            textAlignOptions = "VAUTO, HAUTO, WIDTH, '" + width + "'";
        } else if (width < 0) {
            textAlignOptions = "VAUTO, HAUTO";
        }
        categoryName = EscapeUtil.escSplCharsAsJS((Object)categoryName);
        if (value != null) {
            if (this.mColumn == null) {
                String chartType = (String)chartHash.get("charttype");
                if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                    toReturn = categoryName + " " + seriesName + " :  " + yLabel + "   " + value;
                    title = title + " : <b>" + categoryName + "</b>";
                } else {
                    toReturn = categoryName + " : " + yLabel + "  " + value;
                }
            } else {
                toReturn = seriesName + " :  " + yLabel + "   " + value;
                title = title + " : <b>" + categoryName + "</b>";
            }
        }
        return toReturn;
    }

    public String generateToolTip(XYDataset data, int series, int item, HashMap chartHash) {
        String xLabel = (String)chartHash.get("xlabel");
        String yLabel = (String)chartHash.get("ylabel");
        String result = " ";
        Double x = data.getXValue(series, item);
        try {
            Double y = data.getYValue(series, item);
            if (y != null) {
                if (xLabel.equalsIgnoreCase("hour")) {
                    Date date = new Date(((Number)x).longValue());
                    int hour = date.getHours();
                    result = result + hour + " hours : " + yLabel + " = " + ((Number)y).intValue();
                } else {
                    Timestamp timestamp = new Timestamp(((Number)x).longValue());
                    Date date = new Date(timestamp.getTime());
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM");
                    result = result + dateFormat.format(date) + " : " + yLabel + " = " + ((Number)y).intValue();
                }
            } else {
                result = rb.handleGetObject("adap.DefaultToolTipGenerator.result__yLabel__Unavailable", new String[]{yLabel});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

