/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.support;

import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.support.UploadAction;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.swing.JFileChooser;

public class CompressLogFiles {
    private static String fs = File.separator;
    private static Logger logger = Logger.getLogger(CompressLogFiles.class.getName());
    private static ZipOutputStream zipOut = null;
    private static GZIPOutputStream gzipOut = null;
    private static File zipFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSupportFile(String fileName, HttpServletRequest request) throws Exception {
        FileInputStream in = null;
        String outFilename = null;
        String s = ".." + fs + "logs";
        try {
            File logsDir = new File(s);
            File supportDir = new File(s + fs + "support");
            File tempDir = new File(s + fs + "support" + fs);
            CompressLogFiles.copyDirectory(logsDir, supportDir, request);
            String srdir = System.getProperty("server.home");
            outFilename = fileName + ".zip.gz";
            fileName = fileName + ".zip";
            String zipDir = tempDir.getCanonicalPath();
            zipOut = new ZipOutputStream(new FileOutputStream(fileName));
            CompressLogFiles.zipRecursively(zipOut, zipDir);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in zipping");
            e.printStackTrace();
            outFilename = null;
        }
        finally {
            try {
                zipOut.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (outFilename == null) {
            return null;
        }
        try {
            int len;
            String gzFile = s + fs + "support" + fs + outFilename;
            gzipOut = new GZIPOutputStream(new FileOutputStream(gzFile));
            in = new FileInputStream(fileName);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                gzipOut.write(buf, 0, len);
            }
            zipFile = new File(".." + fs + fileName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in zipping");
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                gzipOut.finish();
                gzipOut.close();
                zipFile.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            String supportFile = ".." + File.separator + "logs" + File.separator + "support" + File.separator + outFilename;
            boolean uploadStatus = UploadAction.checkUploadAccess();
            logger.log(Level.WARNING, " Upload Status : " + uploadStatus);
            outFilename = outFilename + "&" + uploadStatus;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while obtaining Connection" + e.toString(), e);
        }
        return outFilename;
    }

    public static void copyDirectory(File srcDir, File dstDir, HttpServletRequest request) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File currentDir, String name) {
                    return name.endsWith(".txt") || name.endsWith(".log");
                }
            };
            String[] subdirectory = srcDir.list(filter);
            for (int i = 0; i < subdirectory.length; ++i) {
                if (subdirectory[i].equalsIgnoreCase("support")) continue;
                CompressLogFiles.copyDirectory(new File(srcDir, subdirectory[i]), new File(dstDir, subdirectory[i]), request);
            }
        } else {
            CompressLogFiles.copyFile(srcDir, dstDir, request);
        }
    }

    public static void copyFile(File src, File dst, HttpServletRequest request) throws IOException {
        JFileChooser chooser = new JFileChooser();
        String fileTypeName = chooser.getTypeDescription(src);
        Locale locale = ResourceBundleMgr.getInstance().getClientLocale(request);
        if (locale.equals("en_US")) {
            if (fileTypeName.equals("Text Document") || fileTypeName.equals("Log File")) {
                int len;
                FileInputStream in = new FileInputStream(src);
                FileOutputStream out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void zipRecursively(ZipOutputStream jos, String directory) throws Exception {
        File dir = new File(directory);
        File[] files = dir.listFiles();
        ZipEntry je = null;
        String fi = null;
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            fi = file.getCanonicalPath();
            if (file.isDirectory()) {
                je = new ZipEntry(fi + File.separator);
                try {
                    jos.putNextEntry(je);
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Problem while creating zip ");
                }
                CompressLogFiles.zipRecursively(jos, file.getCanonicalPath());
                continue;
            }
            je = new ZipEntry(fi);
            try {
                jos.putNextEntry(je);
            }
            catch (IOException ioex) {
                logger.log(Level.SEVERE, "Problem while creating zip ");
            }
            try {
                CompressLogFiles.getFileContents(file.getCanonicalPath(), jos);
                continue;
            }
            catch (Exception fe) {
                logger.log(Level.SEVERE, "Problem while creating zip ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getFileContents(String fileName, OutputStream ous) throws Exception {
        File fi = new File(fileName);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(fi);
            bis = new BufferedInputStream(fis);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, "Problem while creating zip ");
            return false;
        }
        try {
            int i;
            while ((i = bis.read()) != -1) {
                ous.write(i);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Problem while creating zip ");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Problem while creating zip ");
            }
        }
        return true;
    }

    public static void cancelOperation() throws Exception {
        if (zipOut != null) {
            zipOut.close();
        }
        if (gzipOut != null) {
            gzipOut.finish();
            gzipOut.close();
        }
        if (zipFile != null) {
            zipFile.delete();
        }
    }
}

