/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.iam.security.SecurityRequestWrapper;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientUtil {
    public static Hashtable getUserGroupList(String[] ar) {
        Hashtable hash = new Hashtable();
        try {
            ArrayList<Object> userList = new ArrayList<Object>();
            ArrayList<Object> groupList = new ArrayList<Object>();
            Criteria crit = null;
            for (int i = 0; ar != null && i < ar.length; ++i) {
                crit = crit == null ? new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"DISTINGUISHED_NAME"), (Object)ar[i], 0) : crit.or(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"DISTINGUISHED_NAME"), (Object)ar[i], 0));
            }
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMMailBoxObjects", crit);
            Iterator it = obj.getRows("ADSMMailBoxObjects");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String objClass = (String)r.get("OBJECT_CLASS");
                if (objClass.equalsIgnoreCase("group")) {
                    groupList.add(r.get("DISTINGUISHED_NAME"));
                    continue;
                }
                userList.add(r.get("DISTINGUISHED_NAME"));
            }
            hash.put("users", userList);
            hash.put("groups", groupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static ArrayList getList(String[] ar) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; ar != null && i < ar.length; ++i) {
            l.add(ar[i]);
        }
        return l;
    }

    public static String getString(String[] ar) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; ar != null && i < ar.length; ++i) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(ar[i]);
        }
        return str.toString();
    }

    public static int indexOf(Long[] ar, Long val) {
        int index = -1;
        if (ar == null || val == null) {
            return index;
        }
        for (int i = 0; i < ar.length; ++i) {
            if (!ar[i].equals(val)) continue;
            index = i;
        }
        return index;
    }

    public static File getFileFromRequest(HttpServletRequest request, String paramName) {
        File file = null;
        try {
            SecurityRequestWrapper secrequest = (SecurityRequestWrapper)request;
            UploadedFileItem item = secrequest.getMultipartParameter(paramName);
            if (item != null) {
                file = item.getUploadedFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static String getOUName(String domainName, ArrayList ouList, String ouDNName) {
        String ouName = "";
        for (int k = 0; k < ouList.size(); ++k) {
            Properties ouProp = (Properties)ouList.get(k);
            String ouDN = ouProp.getProperty("DISTINGUISHED_NAME");
            if (!ouDNName.equalsIgnoreCase(ouDN)) continue;
            String ou = ObjectAttributeHandler.getInstance().getLocation(domainName, ouDNName);
            ouName = ouProp.getProperty("OU_NAME") + "[" + ou + "]";
        }
        return ouName;
    }

    public static String getSplitString(String s, int size) {
        StringBuffer buf = new StringBuffer();
        int len = s.length();
        int l = 0;
        while (len > size) {
            String str = s.substring(l, l + size);
            int index = str.indexOf(" ");
            if (index == -1) {
                buf.append(str + " ");
                len -= size;
                l += size;
                continue;
            }
            buf.append(str.substring(0, index + 1));
            len -= index + 1;
            l += index + 1;
        }
        buf.append(s.substring(l));
        return buf.toString();
    }

    public static void setStatusXMLElement(HttpServletResponse response, String messageType, String message) {
        ClientUtil.setStatusXMLElement(response, messageType, message, null);
    }

    public static void setStatusXMLElement(HttpServletResponse response, String messageType, String message, Hashtable props) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element creationStatusElement = document.createElement("status");
            creationStatusElement.setAttribute("messageType", messageType);
            creationStatusElement.setAttribute("message", message);
            if (props != null) {
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = props.get(key).toString();
                    creationStatusElement.setAttribute(key, val);
                }
            }
            data.appendChild(creationStatusElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setACLXMLElement(HttpServletResponse response, ArrayList acList) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element count = document.createElement("count");
            count.setAttribute("value", Integer.valueOf(acList.size()).toString());
            data.appendChild(count);
            for (Object object : acList) {
                Element aceElement = document.createElement("ACE");
                Properties properties = (Properties)object;
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    aceElement.setAttribute(key, properties.get(key).toString());
                }
                data.appendChild(aceElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setACLROWSXMLElement(HttpServletResponse response, ArrayList acList, int totalsize) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element total = document.createElement("total");
            total.setAttribute("value", Integer.valueOf(totalsize).toString());
            data.appendChild(total);
            Element count = document.createElement("count");
            count.setAttribute("value", Integer.valueOf(acList.size()).toString());
            data.appendChild(count);
            for (Object object : acList) {
                Element aceElement = document.createElement("ACEROWS");
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)((HashMap)object));
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    aceElement.setAttribute(key, properties.get(key).toString());
                }
                data.appendChild(aceElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setFormatXMLElement(HttpServletResponse response, String formatValue) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element format = document.createElement("format");
            format.setAttribute("formatValue", formatValue);
            data.appendChild(format);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkAuthorization(HttpServletRequest request, long id) {
        return ClientUtil.checkAuthorization(request, new long[]{id});
    }

    public static boolean checkAuthorization(HttpServletRequest request, long[] id) {
        HttpSession session = request.getSession();
        Hashtable aaaDetails = (Hashtable)session.getAttribute("ADMP_AAA_DETAILS");
        Long[] ids = (Long[])aaaDetails.get("ACTION_TEXT");
        return ClientUtil.checkAuthorization(ids, id);
    }

    public static boolean checkAuthorization(Long[] ids, long id) {
        return ClientUtil.checkAuthorization(ids, new long[]{id});
    }

    public static boolean checkAuthorization(Long[] ids, long[] id) {
        for (int i = 0; i < id.length; ++i) {
            for (int j = 0; j < ids.length; ++j) {
                if (id[i] != -1L && ids[j] != id[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAuthorization(HttpServletRequest request, Long id) {
        HttpSession session = request.getSession();
        Hashtable aaaDetails = (Hashtable)session.getAttribute("ADMP_AAA_DETAILS");
        Long[] ids = (Long[])aaaDetails.get("ACTION_TEXT");
        for (int i = 0; i < ids.length; ++i) {
            if (!ids[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean getModifyStatus(boolean checkStatus, HttpServletRequest request, long id, String type) {
        boolean b = false;
        HttpSession session = request.getSession();
        Hashtable aaaDetails = (Hashtable)session.getAttribute("ADMP_AAA_DETAILS");
        Long[] ids = (Long[])aaaDetails.get("ACTION_TEXT");
        if (checkStatus && !ClientUtil.checkAuthorization(ids, id)) {
            b = true;
        }
        return b;
    }

    public static boolean getTextBoxStatusString(boolean checkStatus, HttpServletRequest request, long id) {
        boolean b = false;
        HttpSession session = request.getSession();
        Hashtable aaaDetails = (Hashtable)session.getAttribute("ADMP_AAA_DETAILS");
        Long[] ids = (Long[])aaaDetails.get("ACTION_TEXT");
        if (checkStatus && !ClientUtil.checkAuthorization(ids, id)) {
            b = true;
        }
        return b;
    }

    public static String getCheckBoxStatusString(boolean checkStatus, HttpServletRequest request, long id) {
        if (ClientUtil.getTextBoxStatusString(checkStatus, request, id)) {
            return "disabled";
        }
        return "";
    }

    public static String getRoleCheckStatus(DataObject roleObj, String[] actions, Long actionId) {
        String str = "";
        if (roleObj != null) {
            try {
                Row r = roleObj.getRow("ADMPRolePermissions", new Criteria(Column.getColumn((String)"ADMPRolePermissions", (String)"ACTION_ID"), (Object)actionId, 0));
                if (r != null) {
                    str = "checked";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                if (!actions[i].equals(actionId.toString())) continue;
                str = "checked";
            }
        }
        return str;
    }

    public static String scriptEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\\", "\"", "'"};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = s.equalsIgnoreCase("\\") ? ret.replaceAll("\\\\", "\\\\\\\\") : ret.replaceAll(s, "\\\\" + s);
        }
        return ret;
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"&", ">", "<", "\""};
        String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
        for (int i = 0; i < chars.length; ++i) {
            String s = chars[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, vals[i]);
        }
        return str;
    }
}

