/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectoryObjectUtil {
    public static ByteArrayOutputStream getADOXMLElement(DirectoryObject dirObject, String rootPath) {
        return DirectoryObjectUtil.getADOXMLElement(dirObject, rootPath, true);
    }

    public static ByteArrayOutputStream getADOXMLElement(DirectoryObject dirObject, String rootPath, boolean showContainerOnly) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DirectoryObject temp;
            int i;
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            String NodeId = dirObject.getID();
            StringTokenizer tokenizer = new StringTokenizer(NodeId, ",");
            int cnt = tokenizer.countTokens();
            StringTokenizer rootToken = new StringTokenizer(rootPath, ",");
            int rtcnt = rootToken.countTokens();
            Element count = document.createElement("count");
            count.setAttribute("value", new Integer(cnt - rtcnt).toString());
            data.appendChild(count);
            Element parent = document.createElement("parent");
            parent.setAttribute("NodeId", dirObject.getID());
            parent.setAttribute("objectGuid", dirObject.getGuid());
            parent.setAttribute("scriptEscapedNodeId", ClientUtil.scriptEscape(dirObject.getID()));
            parent.setAttribute("htmlEscapedNodeId", ClientUtil.htmlEscape(dirObject.getID()));
            parent.setAttribute("aLink", dirObject.getActionLink());
            parent.setAttribute("displayName", dirObject.getName());
            parent.setAttribute("scriptEscapedDisplayName", ClientUtil.scriptEscape(dirObject.getName()));
            parent.setAttribute("htmlEscapedDisplayName", ClientUtil.htmlEscape(dirObject.getName()));
            String str = ClientUtil.htmlEscape(dirObject.getName());
            str = ClientUtil.scriptEscape(str);
            parent.setAttribute("htmlScriptEscapedDisplayName", str);
            str = ClientUtil.htmlEscape(dirObject.getID());
            str = ClientUtil.scriptEscape(str);
            parent.setAttribute("htmlScriptEscapedNodeId", str);
            parent.setAttribute("imageIcon", dirObject.getImageIcon());
            data.appendChild(parent);
            ArrayList childObjectList = dirObject.getChildObjectList();
            int childCount = childObjectList.size();
            boolean grandChild = true;
            if (showContainerOnly) {
                grandChild = false;
                for (i = 0; i < childCount; ++i) {
                    temp = (DirectoryObject)childObjectList.get(i);
                    String objectClass = temp.getObjectClass();
                    if (temp.isLeaf() && !objectClass.equalsIgnoreCase("organizationalUnit")) continue;
                    grandChild = true;
                }
            }
            if (grandChild) {
                for (i = 0; i < childCount; ++i) {
                    temp = (DirectoryObject)childObjectList.get(i);
                    Element child = document.createElement("child");
                    child.setAttribute("NodeId", temp.getID());
                    child.setAttribute("objectGuid", temp.getGuid());
                    child.setAttribute("scriptEscapedNodeId", ClientUtil.scriptEscape(temp.getID()));
                    child.setAttribute("htmlEscapedNodeId", ClientUtil.htmlEscape(temp.getID()));
                    child.setAttribute("aLink", temp.getActionLink());
                    child.setAttribute("displayName", temp.getName());
                    child.setAttribute("scriptEscapedDisplayName", ClientUtil.scriptEscape(temp.getName()));
                    child.setAttribute("htmlEscapedDisplayName", ClientUtil.htmlEscape(temp.getName()));
                    String str1 = ClientUtil.htmlEscape(temp.getName());
                    str1 = ClientUtil.scriptEscape(str1);
                    child.setAttribute("htmlScriptEscapedDisplayName", str1);
                    str1 = ClientUtil.htmlEscape(temp.getID());
                    str1 = ClientUtil.scriptEscape(str1);
                    child.setAttribute("htmlScriptEscapedNodeId", str1);
                    child.setAttribute("imageIcon", temp.getImageIcon());
                    child.setAttribute("leaf", new Boolean(temp.isLeaf()).toString());
                    data.appendChild(child);
                }
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public static DirectoryObject getDirectoryObject(String nodeClicked, HttpServletRequest request, String attrib) {
        HttpSession session = request.getSession();
        DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(attrib);
        DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
        DirectoryObject obj = DirectoryObjectUtil.getDirectoryObject(nodeClicked, object);
        return obj;
    }

    public static DirectoryObject getDirectoryObject(String nodeClicked, DirectoryObject object) {
        if (object.getID().equals(nodeClicked)) {
            return object;
        }
        ArrayList childList = object.getChildObjectList();
        if (childList.size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                DirectoryObject childObject = (DirectoryObject)childList.get(i);
                DirectoryObject obj = DirectoryObjectUtil.getDirectoryObject(nodeClicked, childObject);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static ArrayList getParentOUs(ArrayList l) {
        ArrayList list = (ArrayList)l.clone();
        block0: for (int i = 0; i < list.size(); ++i) {
            String s1 = ((String)list.get(i)).toLowerCase();
            for (int j = i + 1; j < list.size(); ++j) {
                String s2 = ((String)list.get(j)).toLowerCase();
                if (s1.endsWith(s2)) {
                    list.remove(i);
                    --i;
                    continue block0;
                }
                if (!s2.endsWith(s1)) continue;
                list.remove(j);
                --i;
                continue block0;
            }
        }
        return list;
    }

    public static DirectoryObject getDirectoryObject(String domainName, Long loginId, String rootPath, ArrayList ouList) throws Exception {
        DirectoryObject object = null;
        try {
            if (ouList == null || ouList.size() == 0) {
                object = (DirectoryObject)ADHandler.getDomainObject((String)domainName, (Long)loginId, (String)rootPath);
            } else {
                object = new DirectoryObject();
                ArrayList ous = DirectoryObjectUtil.getParentOUs(ouList);
                ArrayList ouProps = OUUtil.getOUProps((String)domainName, (ArrayList)ouList);
                Properties childs = new Properties();
                for (int i = 0; i < ouProps.size(); ++i) {
                    Properties p = (Properties)ouProps.get(i);
                    DirectoryObject child = new DirectoryObject();
                    child.setName(p.getProperty("OU_NAME"));
                    child.setRelativeName(p.getProperty("DISTINGUISHED_NAME"));
                    child.setGuid(p.getProperty("OBJECT_GUID"));
                    child.setObjectClass("organizationalUnit");
                    child.setIsLeaf(false);
                    child.setIsContainer(true);
                    childs.put(p.getProperty("DISTINGUISHED_NAME"), child);
                }
                object.setName(domainName);
                object.setRelativeName(rootPath);
                object.setObjectClass("domainDNS");
                object.setChildObjects(childs);
                object.setIsLeaf(false);
                object.setIsContainer(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return object;
    }

    public static DirectoryObject getObject(DirectoryObject object, String dn) {
        Properties childObjects = object.getChildObjects();
        DirectoryObject ret = null;
        if (childObjects != null) {
            Enumeration<Object> e = childObjects.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                DirectoryObject obj = (DirectoryObject)childObjects.get(key);
                if (!dn.endsWith(key)) continue;
                if (key.equalsIgnoreCase(dn)) {
                    ret = obj;
                    continue;
                }
                ret = DirectoryObjectUtil.getObject(obj, dn);
            }
        }
        return ret;
    }

    public static void getDirectoryObject(DirectoryObject object, String dn, Properties selectedDomain, Long loginId) {
        try {
            DirectoryObject directoryObject = DirectoryObjectUtil.getObject(object, dn);
            if (directoryObject.getChildObjects() == null) {
                DirectoryObject childObject = (DirectoryObject)ADHandler.getDomainObject((String)selectedDomain.getProperty("DOMAIN_NAME"), (Long)loginId, (String)dn);
                directoryObject.setChildObjects(childObject.getChildObjects());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

