/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.alert;

import com.adventnet.sym.adsm.auditing.server.alert.AlertAPI;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.validator.DynaValidatorForm;

public class AuditAlertBean
extends DynaValidatorForm {
    protected static Logger alertLogger = Logger.getLogger("AuditAlertBean");

    protected void initializeBean(HttpServletRequest request) {
        try {
            String monitor_id = "";
            String alert_profile_id = "";
            String[] hours = new String[]{"12:00AM", "1:00AM", "2:00AM", "3:00AM", "4:00AM", "5:00AM", "6:00AM", "7:00AM", "8:00AM", "9:00AM", "10:00AM", "11:00AM", "12:00PM", "1:00PM", "2:00PM", "3:00PM", "4:00PM", "5:00PM", "6:00PM", "7:00PM", "8:00PM", "9:00PM", "10:00PM", "11:00PM"};
            Integer[] hourValues = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            if (request.getParameter("monitor_id") != null && !"".equals(request.getParameter("monitor_id"))) {
                monitor_id = request.getParameter("monitor_id");
            }
            if (request.getParameter("alert_profile_id") != null && !"".equals(request.getParameter("alert_profile_id"))) {
                alert_profile_id = request.getParameter("alert_profile_id");
            }
            this.set("alert_profile_id", alert_profile_id);
            this.set("monitor_id", monitor_id);
            HashMap timeFilterMap = AlertAPI.getInstance().getTimeFilterMap();
            this.set("timeFiler", timeFilterMap.get("serverValues"));
            this.set("timeFilerText", timeFilterMap.get("clientValues"));
            this.set("TIME_FILTER", "twfourhours");
            this.set("sortColumn", "CREATION_TIME");
            this.set("sortOrder", "DESC");
            this.set("RANGE", 25);
            this.set("startHour", hours);
            this.set("startHourValues", hourValues);
            this.set("endHour", hours);
            this.set("endHourValues", hourValues);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap getInputParamsValues() {
        HashMap inputParamsMap = new HashMap();
        try {
            String timeFilterString = (String)this.get("TIME_FILTER");
            String monitor_id = (String)this.get("monitor_id");
            String alert_profile_id = (String)this.get("alert_profile_id");
            if ((monitor_id == null || monitor_id.equals("")) && (alert_profile_id == null || alert_profile_id.equals(""))) {
                if (timeFilterString == null || timeFilterString.equalsIgnoreCase("All")) {
                    timeFilterString = "All";
                    inputParamsMap.put("allPeriod", "allPeriod");
                }
                if (!timeFilterString.equalsIgnoreCase("All")) {
                    inputParamsMap.put("allPeriod", "");
                    inputParamsMap = this.getCustomPeriodValues(inputParamsMap, timeFilterString);
                }
            } else {
                if (timeFilterString == null || timeFilterString.equalsIgnoreCase("All")) {
                    timeFilterString = "allPeriod";
                    inputParamsMap.put("allPeriod", "allPeriod");
                }
                if (!timeFilterString.equalsIgnoreCase("allPeriod")) {
                    inputParamsMap.put("allPeriod", "monitor_all");
                    inputParamsMap = this.getCustomPeriodValues(inputParamsMap, timeFilterString);
                }
                if (monitor_id != null && !monitor_id.equals("")) {
                    inputParamsMap.put("MONITOR_ID", this.get("monitor_id"));
                } else if (alert_profile_id != null && !alert_profile_id.equals("")) {
                    inputParamsMap.put("ALERT_PROFILE_ID", this.get("alert_profile_id"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return inputParamsMap;
    }

    public HashMap getCustomPeriodValues(HashMap inputParamsMap, String timeFilterString) throws Exception {
        if (timeFilterString.equalsIgnoreCase("customPeriod")) {
            Long from = TimeUtil.getTimePeriod((String)((String)this.get("startTime")), (String)((String)this.get("startHourValue")));
            Long to = TimeUtil.getTimePeriod((String)((String)this.get("endTime")), (String)((String)this.get("endHourValue")));
            inputParamsMap.put("FROM", from.toString());
            inputParamsMap.put("TO", to.toString());
        } else {
            HashMap periodMap = TimeUtil.getTimePeriod((String)timeFilterString);
            inputParamsMap.put("FROM", periodMap.get("FROM").toString());
            inputParamsMap.put("TO", periodMap.get("TO").toString());
        }
        return inputParamsMap;
    }
}

