/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.compliance;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.auditing.server.compliance.TemplateTableHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ComplianceReportHandler {
    public static Logger logger = Logger.getLogger("Logger");

    public static ArrayList getParams(String from, String to, String tableName, Long categoryType, int scheduler) {
        ArrayList paramsList = new ArrayList();
        HashMap<String, String> inputParamsMap = new HashMap<String, String>();
        if (scheduler == 0) {
            if (categoryType == 5L) {
                inputParamsMap.put("tableName", tableName + "1");
            } else {
                inputParamsMap.put("tableName", tableName + scheduler);
            }
        } else {
            inputParamsMap.put("tableName", tableName + scheduler);
        }
        inputParamsMap.put("from", from);
        inputParamsMap.put("to", to);
        paramsList.add(inputParamsMap);
        return paramsList;
    }

    public static ArrayList getLastNMonthParams(Long from, Long to, Long monthlyLastCrunch, Long dailyLastCrunch, String tableName, Long categoryType) {
        ArrayList paramsList = new ArrayList();
        if (monthlyLastCrunch > from) {
            if (monthlyLastCrunch >= to) {
                paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 2));
            } else if (dailyLastCrunch > from) {
                if (dailyLastCrunch > monthlyLastCrunch) {
                    paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(monthlyLastCrunch - 1L).toString(), tableName, categoryType, 2));
                    if (dailyLastCrunch >= to) {
                        paramsList.addAll(ComplianceReportHandler.getParams(monthlyLastCrunch.toString(), to.toString(), tableName, categoryType, 1));
                    } else {
                        paramsList.addAll(ComplianceReportHandler.getParams(monthlyLastCrunch.toString(), Long.valueOf(dailyLastCrunch - 1L).toString(), tableName, categoryType, 1));
                        paramsList.addAll(ComplianceReportHandler.getParams(dailyLastCrunch.toString(), to.toString(), tableName, categoryType, 0));
                    }
                } else {
                    paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(monthlyLastCrunch - 1L).toString(), tableName, categoryType, 2));
                    paramsList.addAll(ComplianceReportHandler.getParams(monthlyLastCrunch.toString(), to.toString(), tableName, categoryType, 0));
                }
            } else {
                paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 0));
            }
        } else if (dailyLastCrunch > from) {
            if (dailyLastCrunch >= to) {
                paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 1));
            } else {
                paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(dailyLastCrunch - 1L).toString(), tableName, categoryType, 1));
                paramsList.addAll(ComplianceReportHandler.getParams(dailyLastCrunch.toString(), to.toString(), tableName, categoryType, 0));
            }
        } else {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 0));
        }
        return paramsList;
    }

    public static ArrayList getLastNYearParams(Long from, Long to, Long yearlyLastCrunch, Long halfyearlyLastCrunch, Long quarterlyLastCrunch, Long monthlyLastCrunch, Long dailyLastCrunch, String tableName, Long categoryType) {
        ArrayList paramsList = new ArrayList();
        Long[] lastCrunch = new Long[]{0L, dailyLastCrunch, monthlyLastCrunch, quarterlyLastCrunch, halfyearlyLastCrunch, yearlyLastCrunch};
        if (yearlyLastCrunch >= to) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 5));
        } else if (halfyearlyLastCrunch >= to) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 4));
        } else if (halfyearlyLastCrunch > from && TimeUtil.getMonthOfYear((Long)halfyearlyLastCrunch) >= 6) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(TimeUtil.getMonthFloor((int)6, (Long)from) - 1L).toString(), tableName, categoryType, 4));
            if (quarterlyLastCrunch >= to) {
                paramsList.addAll(ComplianceReportHandler.getParams(TimeUtil.getMonthFloor((int)6, (Long)from).toString(), to.toString(), tableName, categoryType, 3));
            } else if (quarterlyLastCrunch > from && TimeUtil.getMonthOfYear((Long)quarterlyLastCrunch) >= 9) {
                paramsList.addAll(ComplianceReportHandler.getParams(TimeUtil.getMonthFloor((int)6, (Long)from).toString(), Long.valueOf(TimeUtil.getMonthFloor((int)9, (Long)from) - 1L).toString(), tableName, categoryType, 3));
                paramsList.addAll(ComplianceReportHandler.getLastNMonthParams(TimeUtil.getMonthFloor((int)9, (Long)from), to, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
            } else {
                paramsList.addAll(ComplianceReportHandler.getLastNMonthParams(TimeUtil.getMonthFloor((int)6, (Long)from), to, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
            }
        } else if (quarterlyLastCrunch >= to) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 3));
        } else if (quarterlyLastCrunch > from && TimeUtil.getMonthOfYear((Long)quarterlyLastCrunch) >= 3) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(TimeUtil.getMonthFloor((int)(TimeUtil.getMonthOfYear((Long)quarterlyLastCrunch) / 3 * 3), (Long)from) - 1L).toString(), tableName, categoryType, 3));
            paramsList.addAll(ComplianceReportHandler.getLastNMonthParams(TimeUtil.getMonthFloor((int)(TimeUtil.getMonthOfYear((Long)quarterlyLastCrunch) / 3 * 3), (Long)from), to, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
        } else {
            paramsList.addAll(ComplianceReportHandler.getLastNMonthParams(from, to, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
        }
        return paramsList;
    }

    public static String lastCrunchValue(String lastCrunch) {
        String newValue = lastCrunch;
        if (lastCrunch.contains("CRUNCHING")) {
            newValue = lastCrunch.substring(0, lastCrunch.indexOf("_"));
        }
        return newValue;
    }

    public static ArrayList getInputParamsMap(String domainName, int timePeriod, Long categoryType) {
        String tableName = TemplateTableHandler.getDomainListEntry((String)domainName) + "_";
        Long from = TimeUtil.getFromFloor((Integer)timePeriod);
        Long to = TimeUtil.getToFloor((Integer)timePeriod) - 1L;
        ArrayList paramsList = new ArrayList();
        if (timePeriod == 0) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 0));
        } else if (timePeriod == 1 || timePeriod == 2 || timePeriod == 7) {
            Long dailyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"DAILY_LAST_CRUNCH")));
            if (dailyLastCrunch > from) {
                if (dailyLastCrunch >= to) {
                    paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 1));
                } else {
                    paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(dailyLastCrunch - 1L).toString(), tableName, categoryType, 1));
                    paramsList.addAll(ComplianceReportHandler.getParams(dailyLastCrunch.toString(), to.toString(), tableName, categoryType, 0));
                }
            } else {
                paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 0));
            }
        } else if (timePeriod == 3 || timePeriod == 4 || timePeriod == 8 || timePeriod == 9 || timePeriod > 100 && timePeriod < 300 || timePeriod > 100000000) {
            Long monthlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"MONTHLY_LAST_CRUNCH")));
            Long dailyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"DAILY_LAST_CRUNCH")));
            paramsList.addAll(ComplianceReportHandler.getLastNMonthParams(from, to, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
        } else if (timePeriod == 5 || timePeriod == 6 || timePeriod > 300 && timePeriod < 400) {
            Long yearlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"YEARLY_LAST_CRUNCH")));
            Long halfyearlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"HALFYEARLY_LAST_CRUNCH")));
            Long quarterlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"QUARTERLY_LAST_CRUNCH")));
            Long monthlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"MONTHLY_LAST_CRUNCH")));
            Long dailyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"DAILY_LAST_CRUNCH")));
            paramsList.addAll(ComplianceReportHandler.getLastNYearParams(from, to, yearlyLastCrunch, halfyearlyLastCrunch, quarterlyLastCrunch, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
        }
        return paramsList;
    }

    public static HashMap<String, Object> getParamsMap(String domainName, int timePeriod, Long categoryType, boolean isLimit, Long limit, Long offset) {
        ArrayList paramsList = ComplianceReportHandler.getInputParamsMap(domainName, timePeriod, categoryType);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("isComplianceReport", "yes");
        paramsMap.put("inputParams", paramsList);
        if (isLimit) {
            paramsMap.put("offset", offset.toString());
            paramsMap.put("limit", limit.toString());
            paramsMap.put("orderBy", "ADAPCOUNT DESC");
        }
        logger.log(Level.INFO, "list is = " + paramsList);
        return paramsMap;
    }

    public static HashMap<String, Object> getParamsMap(String domainName, int timePeriod, Long categoryType, boolean isLimit, Long limit, Long offset, String orderBy) {
        ArrayList paramsList = ComplianceReportHandler.getInputParamsMap(domainName, timePeriod, categoryType);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("isComplianceReport", "yes");
        paramsMap.put("inputParams", paramsList);
        if (isLimit) {
            paramsMap.put("offset", offset.toString());
            paramsMap.put("limit", limit.toString());
            if (orderBy != null) {
                paramsMap.put("orderBy", orderBy);
            } else {
                paramsMap.put("orderBy", "ADAPCOUNT DESC");
            }
        }
        logger.log(Level.INFO, "list is = " + paramsList);
        return paramsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getUsersListEmber(String domainName, String searchString, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String sqlString = "SELECT * FROM((SELECT NAME,LOGON_NAME,SAM_ACCOUNT_NAME,DISPLAY_NAME,FIRST_NAME,SID_STRING,1 AS OBJECT_TYPE FROM ADSMUSERGENERALDETAILS WHERE DOMAIN_NAME = '" + domainName + "' AND (NAME LIKE '" + searchString + "' OR SAM_ACCOUNT_NAME LIKE '" + searchString + "' OR LOGON_NAME LIKE '" + searchString + "' OR DISPLAY_NAME LIKE '" + searchString + "' OR FIRST_NAME LIKE '" + searchString + "')) UNION ALL (SELECT NAME,DNS_NAME AS LOGON_NAME,COMMON_NAME AS SAM_ACCOUNT_NAME,ROLE AS DISPLAY_NAME,OPERATING_SYSTEM AS FIRST_NAME,SID_STRING,2 AS OBJECT_TYPE FROM ADSMCOMPUTERGENERALDETAILS WHERE DOMAIN_NAME = '" + domainName + "' AND (NAME LIKE '" + searchString + "' OR COMMON_NAME LIKE '" + searchString + "' OR DNS_NAME LIKE '" + searchString + "' OR ROLE LIKE '" + searchString + "' OR OPERATING_SYSTEM LIKE '" + searchString + "')) UNION ALL (SELECT NAME,COMMON_NAME AS LOGON_NAME,COMMON_NAME AS SAM_ACCOUNT_NAME,GROUP_TYPE AS DISPLAY_NAME,GROUP_SCOPE AS FIRST_NAME,SID_STRING,3 AS OBJECT_TYPE FROM ADSMGROUPGENERALDETAILS WHERE DOMAIN_NAME = '" + domainName + "' AND (NAME LIKE '" + searchString + "' OR COMMON_NAME LIKE '" + searchString + "' OR GROUP_TYPE LIKE '" + searchString + "' OR GROUP_SCOPE LIKE '" + searchString + "')))AS INNERTABLE ORDER BY NAME";
        JSONArray jsonArray = new JSONArray();
        try {
            logger.log(Level.INFO, "searchString = " + searchString);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            while (resultSet.next()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("username", (Object)resultSet.getString("NAME"));
                jsonObject.put("logonname", (Object)resultSet.getString("LOGON_NAME"));
                jsonObject.put("samaccountname", (Object)resultSet.getString("SAM_ACCOUNT_NAME"));
                jsonObject.put("displayname", (Object)resultSet.getString("DISPLAY_NAME"));
                jsonObject.put("firstname", (Object)resultSet.getString("FIRST_NAME"));
                jsonObject.put("usersid", (Object)resultSet.getString("SID_STRING"));
                jsonObject.put("object_type", (Object)resultSet.getLong("OBJECT_TYPE"));
                jsonObject.put("value", (Object)resultSet.getString("NAME"));
                jsonArray.put((Object)jsonObject);
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUsersList(String domainName, String searchString, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String sqlString = "SELECT * FROM((SELECT NAME,LOGON_NAME,SAM_ACCOUNT_NAME,DISPLAY_NAME,FIRST_NAME,SID_STRING,1 AS OBJECT_TYPE FROM ADSMUSERGENERALDETAILS WHERE DOMAIN_NAME = '" + domainName + "' AND (NAME LIKE '" + searchString + "' OR SAM_ACCOUNT_NAME LIKE '" + searchString + "' OR LOGON_NAME LIKE '" + searchString + "' OR DISPLAY_NAME LIKE '" + searchString + "' OR FIRST_NAME LIKE '" + searchString + "')) UNION ALL (SELECT NAME,DNS_NAME AS LOGON_NAME,COMMON_NAME AS SAM_ACCOUNT_NAME,ROLE AS DISPLAY_NAME,OPERATING_SYSTEM AS FIRST_NAME,SID_STRING,2 AS OBJECT_TYPE FROM ADSMCOMPUTERGENERALDETAILS WHERE DOMAIN_NAME = '" + domainName + "' AND (NAME LIKE '" + searchString + "' OR COMMON_NAME LIKE '" + searchString + "' OR DNS_NAME LIKE '" + searchString + "' OR ROLE LIKE '" + searchString + "' OR OPERATING_SYSTEM LIKE '" + searchString + "')) UNION ALL (SELECT NAME,COMMON_NAME AS LOGON_NAME,COMMON_NAME AS SAM_ACCOUNT_NAME,GROUP_TYPE AS DISPLAY_NAME,GROUP_SCOPE AS FIRST_NAME,SID_STRING,3 AS OBJECT_TYPE FROM ADSMGROUPGENERALDETAILS WHERE DOMAIN_NAME = '" + domainName + "' AND (NAME LIKE '" + searchString + "' OR COMMON_NAME LIKE '" + searchString + "' OR GROUP_TYPE LIKE '" + searchString + "' OR GROUP_SCOPE LIKE '" + searchString + "')))AS INNERTABLE ORDER BY NAME";
        JSONArray jsonArray = new JSONArray();
        try {
            logger.log(Level.INFO, "searchString = " + searchString);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            while (resultSet.next()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("username", (Object)resultSet.getString("NAME"));
                jsonObject.put("logonname", (Object)resultSet.getString("LOGON_NAME"));
                jsonObject.put("samaccountname", (Object)resultSet.getString("SAM_ACCOUNT_NAME"));
                jsonObject.put("displayname", (Object)resultSet.getString("DISPLAY_NAME"));
                jsonObject.put("firstname", (Object)resultSet.getString("FIRST_NAME"));
                jsonObject.put("usersid", (Object)resultSet.getString("SID_STRING"));
                jsonObject.put("object_type", (Object)resultSet.getLong("OBJECT_TYPE"));
                jsonObject.put("value", (Object)resultSet.getString("NAME"));
                jsonArray.put((Object)jsonObject);
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return jsonArray.toString();
    }

    public static Long getSum(JSONArray reportDataArray) {
        Long sum = 0L;
        try {
            for (int i = 0; i < reportDataArray.length(); ++i) {
                JSONObject obj = reportDataArray.getJSONObject(i);
                JSONArray sumList = obj.getJSONArray("sumList");
                sum = sum + sumList.getLong(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sum;
    }

    public static ArrayList<HashMap<String, Object>> getFullExportData(String domainName, Long categoryType, HashMap paramsMap, boolean isSearch, HttpServletRequest request) {
        ArrayList<HashMap<String, Object>> exportList = new ArrayList<HashMap<String, Object>>();
        try {
            JSONArray jsonArray = new JSONArray(ComplianceReportHandler.getCategorySum(domainName, categoryType, paramsMap, isSearch, request));
            if (!isSearch) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    HashMap<String, Object> reportMap = new HashMap<String, Object>();
                    ArrayList maps = new ArrayList();
                    JSONObject obj = jsonArray.getJSONObject(i);
                    Long sum = obj.getLong("sum");
                    if (sum <= 0L) continue;
                    JSONArray nameList = obj.getJSONArray("title");
                    JSONArray valueList = obj.getJSONArray("value");
                    for (int j = 0; j < nameList.length(); ++j) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("REPORT_NAME", (String)nameList.get(j));
                        map.put("COUNT", ((Integer)valueList.get(j)).toString());
                        maps.add(map);
                    }
                    reportMap.put("exportMaps", maps);
                    reportMap.put("sum", sum);
                    reportMap.put("reportName", (String)obj.get("categoryName"));
                    exportList.add(reportMap);
                }
            } else {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject obj = jsonArray.getJSONObject(i);
                    Long type = obj.getLong("count");
                    JSONArray categories = obj.getJSONArray("groups");
                    for (int j = 0; j < categories.length(); ++j) {
                        ArrayList maps = new ArrayList();
                        HashMap<String, Object> reportMap = new HashMap<String, Object>();
                        JSONObject categoryObj = categories.getJSONObject(j);
                        reportMap.put("sum", categoryObj.getLong("categorySum"));
                        reportMap.put("reportName", (String)categoryObj.get("categoryName"));
                        JSONArray reports = categoryObj.getJSONArray("reports");
                        for (int k = 0; k < reports.length(); ++k) {
                            JSONObject reportObj = reports.getJSONObject(k);
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("REPORT_NAME", (String)reportObj.get("reportName"));
                            map.put("COUNT", ((Integer)((JSONArray)reportObj.get("sumList")).get(0)).toString());
                            maps.add(map);
                        }
                        reportMap.put("exportMaps", maps);
                        reportMap.put("type", type);
                        exportList.add(reportMap);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exportList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCategorySum(String domainName, Long categoryType, HashMap paramsMap, boolean isSearch, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String sqlString = "";
        if (!isSearch) {
            sqlString = "SELECT REPORT_CATEGORY_ID,NAME FROM AUDREPORTCATEGORIES WHERE REPORT_CATEGORY_ID IN(SELECT DISTINCT(REPORT_CATEGORY_ID) FROM AUDREPORTS WHERE REPORT_CATEGORY_TYPE=" + categoryType + ") ORDER BY PRIORITY";
        }
        JSONArray jsonArray = new JSONArray();
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            if (!isSearch) {
                resultSet = statement.executeQuery(sqlString);
                logger.log(Level.INFO, "sum for category type = " + categoryType);
                while (resultSet.next()) {
                    jsonArray.put((Object)ComplianceReportHandler.getreportsSum(domainName, resultSet.getLong("REPORT_CATEGORY_ID"), rb.getString(resultSet.getString("NAME")), paramsMap));
                }
            } else {
                for (int count = 0; count < 3; ++count) {
                    int category = 5;
                    if (count == 1) {
                        category = 6;
                    }
                    if (count != 2) {
                        request.setAttribute("searchOption", (Object)count);
                    }
                    JSONObject jsonInnerObject = new JSONObject();
                    sqlString = "SELECT TABLE1.REPORT_CATEGORY_ID AS REPORT_CATEGORY_ID,TABLE1.NAME AS NAME,TABLE2.REPORT_CATEGORY_TYPE AS REPORT_CATEGORY_TYPE FROM AUDREPORTCATEGORIES TABLE1 INNER JOIN (SELECT DISTINCT(REPORT_CATEGORY_ID)AS REPORT_CATEGORY_ID,REPORT_CATEGORY_TYPE FROM AUDREPORTS WHERE REPORT_CATEGORY_TYPE=" + category + ")TABLE2 ON(TABLE1.REPORT_CATEGORY_ID=TABLE2.REPORT_CATEGORY_ID)ORDER BY TABLE1.REPORT_CATEGORY_ID";
                    resultSet = statement.executeQuery(sqlString);
                    JSONArray jsonInnerArray = new JSONArray();
                    while (resultSet.next()) {
                        logger.log(Level.INFO, "search for category type = " + resultSet.getLong("REPORT_CATEGORY_TYPE"));
                        HashMap<String, Object> paramsMap1 = ComplianceReportHandler.getParamsMap(domainName, Integer.parseInt(request.getParameter("timePeriod")), resultSet.getLong("REPORT_CATEGORY_TYPE"), false, 0L, 0L);
                        String reportData = ComplianceReportHandler.getCategoryReports(domainName, resultSet.getLong("REPORT_CATEGORY_ID"), resultSet.getLong("REPORT_CATEGORY_TYPE"), paramsMap1, true, isSearch, request);
                        JSONArray reportDataArray = new JSONArray(reportData);
                        if (reportDataArray.length() <= 0) continue;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("categoryName", (Object)rb.getString(resultSet.getString("NAME")));
                        jsonObject.put("reports", (Object)reportDataArray);
                        Long sum = ComplianceReportHandler.getSum(reportDataArray);
                        jsonObject.put("categorySum", (Object)sum);
                        jsonObject.put("categoryType", resultSet.getLong("REPORT_CATEGORY_TYPE"));
                        jsonObject.put("categoryId", resultSet.getLong("REPORT_CATEGORY_ID"));
                        jsonInnerArray.put((Object)jsonObject);
                    }
                    if (jsonInnerArray.length() <= 0) continue;
                    jsonInnerObject.put("count", count);
                    jsonInnerObject.put("groups", (Object)jsonInnerArray);
                    jsonArray.put((Object)jsonInnerObject);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection((Connection)connection, statement, resultSet);
                throw throwable;
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, resultSet);
        }
        DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return jsonArray.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getreportsSum(String domainName, Long categoryId, String categoryName, HashMap paramsMap) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String dbServerName = CommonUtil.getDBServerName();
        String sqlString = null;
        sqlString = dbServerName.equalsIgnoreCase("mysql") ? "SELECT QA.AUDIT_REPORT_ID AS AUDIT_REPORT_ID,QA.AUDIT_REPORT_NAME AS AUDIT_REPORT_NAME,QA.TITLE AS TITLE,SD.CV_ID AS CV_ID FROM AUDREPORTS QA INNER JOIN(SELECT QW.* FROM AUDREPORTCVMAPPING QW INNER JOIN (SELECT TT.REPORT_CV_ID AS REPORT_CV_ID FROM (SELECT REPORT_CV_ID,REPORT_GROUP,OPERATION FROM COMPLIANCEREPORTMAP WHERE REPORT_CV_ID IN(SELECT CV_ID FROM AUDREPORTCVMAPPING WHERE AUDIT_REPORT_ID IN ( SELECT AUDIT_REPORT_ID FROM AUDREPORTS WHERE REPORT_CATEGORY_ID=" + categoryId + ")) AND CV_ID IN(SELECT CV_ID FROM AUDCRUNCHTABLEREFERENCE WHERE DOMAIN_NAME='" + domainName + "' AND IS_ENABLED=TRUE))TT INNER JOIN (SELECT SSD.REPORT_GROUP,MIN(SSD.OPERATION) AS OPERATION FROM (SELECT REPORT_GROUP,OPERATION FROM COMPLIANCEREPORTMAP WHERE REPORT_CV_ID IN(SELECT CV_ID FROM AUDREPORTCVMAPPING WHERE AUDIT_REPORT_ID IN ( SELECT AUDIT_REPORT_ID FROM AUDREPORTS WHERE REPORT_CATEGORY_ID=" + categoryId + ")) AND CV_ID IN(SELECT CV_ID FROM AUDCRUNCHTABLEREFERENCE WHERE DOMAIN_NAME='" + domainName + "' AND IS_ENABLED=TRUE)) SSD GROUP BY REPORT_GROUP) TTD ON TT.REPORT_GROUP=TTD.REPORT_GROUP AND TT.OPERATION=TTD.OPERATION)ZX ON QW.CV_ID=ZX.REPORT_CV_ID)SD ON QA.AUDIT_REPORT_ID=SD.AUDIT_REPORT_ID ORDER BY QA.PRIORITY" : "SELECT QA.AUDIT_REPORT_ID AS AUDIT_REPORT_ID,QA.AUDIT_REPORT_NAME AS AUDIT_REPORT_NAME,QA.TITLE AS TITLE,SD.CV_ID AS CV_ID FROM AUDREPORTS QA INNER JOIN(SELECT QW.* FROM AUDREPORTCVMAPPING QW INNER JOIN (SELECT TT.REPORT_CV_ID AS REPORT_CV_ID FROM (SELECT REPORT_CV_ID,REPORT_GROUP,OPERATION FROM COMPLIANCEREPORTMAP WHERE REPORT_CV_ID IN(SELECT CV_ID FROM AUDREPORTCVMAPPING WHERE AUDIT_REPORT_ID IN ( SELECT AUDIT_REPORT_ID FROM AUDREPORTS WHERE REPORT_CATEGORY_ID=" + categoryId + ")) AND CV_ID IN(SELECT CV_ID FROM AUDCRUNCHTABLEREFERENCE WHERE DOMAIN_NAME='" + domainName + "' AND IS_ENABLED='TRUE'))TT INNER JOIN (SELECT SSD.REPORT_GROUP,MIN(SSD.OPERATION) AS OPERATION FROM (SELECT REPORT_GROUP,OPERATION FROM COMPLIANCEREPORTMAP WHERE REPORT_CV_ID IN(SELECT CV_ID FROM AUDREPORTCVMAPPING WHERE AUDIT_REPORT_ID IN ( SELECT AUDIT_REPORT_ID FROM AUDREPORTS WHERE REPORT_CATEGORY_ID=" + categoryId + ")) AND CV_ID IN(SELECT CV_ID FROM AUDCRUNCHTABLEREFERENCE WHERE DOMAIN_NAME='" + domainName + "' AND IS_ENABLED='TRUE')) SSD GROUP BY REPORT_GROUP) TTD ON TT.REPORT_GROUP=TTD.REPORT_GROUP AND TT.OPERATION=TTD.OPERATION)ZX ON QW.CV_ID=ZX.REPORT_CV_ID)SD ON QA.AUDIT_REPORT_ID=SD.AUDIT_REPORT_ID ORDER BY QA.PRIORITY";
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> titleList = new ArrayList<String>();
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        JSONObject jsonObject = new JSONObject();
        try {
            logger.log(Level.INFO, "sum for category id = " + categoryId);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            int sum = 0;
            int size = 0;
            String charttype = "bar";
            while (resultSet.next()) {
                int count = AuditReportAPI.getInstance().getReportCount(Long.valueOf(resultSet.getLong("CV_ID")), null, paramsMap, null);
                nameList.add(rb.getString(resultSet.getString("AUDIT_REPORT_NAME")));
                titleList.add(rb.getString(resultSet.getString("TITLE")));
                valueList.add(count);
                sum += count;
                ++size;
            }
            charttype = size < 5 ? "bar" : "column";
            try {
                jsonObject.put("title", (Object)new JSONArray(nameList));
                jsonObject.put("displayName", (Object)new JSONArray(titleList));
                jsonObject.put("value", (Object)new JSONArray(valueList));
                jsonObject.put("chart", (Object)charttype);
                jsonObject.put("categoryName", (Object)categoryName);
                jsonObject.put("sum", sum);
                jsonObject.put("category", (Object)categoryId);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ArrayList<Object>> getReportCvIdDetails(String domainName, Long reportId, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ArrayList<ArrayList<Object>> cvidList = new ArrayList<ArrayList<Object>>(4);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            String sqlString = null;
            sqlString = dbServerName.equalsIgnoreCase("mysql") ? "SELECT I1.CV_NAME AS CV_NAME,I2.REPORT_CV_ID AS CV_ID,I2.REFERENCE_CV_ID AS REFERENCE_CV_ID,I2.REF_SEARCH_CRITERIA AS REF_SEARCH_CRITERIA FROM AUDCVCONFIG I1 INNER JOIN (SELECT REPORT_CV_ID,REFERENCE_CV_ID,REF_SEARCH_CRITERIA FROM COMPLIANCEREPORTMAP WHERE REPORT_CV_ID IN(SELECT CV_ID FROM AUDREPORTCVMAPPING WHERE AUDIT_REPORT_ID=" + reportId + ") AND CV_ID IN(SELECT CV_ID FROM AUDCRUNCHTABLEREFERENCE WHERE DOMAIN_NAME='" + domainName + "' AND IS_ENABLED=TRUE)) I2 ON I1.CV_ID=I2.REPORT_CV_ID ORDER BY REPORT_CV_ID" : "SELECT I1.CV_NAME AS CV_NAME,I2.REPORT_CV_ID AS CV_ID,I2.REFERENCE_CV_ID AS REFERENCE_CV_ID,I2.REF_SEARCH_CRITERIA AS REF_SEARCH_CRITERIA FROM AUDCVCONFIG I1 INNER JOIN (SELECT REPORT_CV_ID,REFERENCE_CV_ID,REF_SEARCH_CRITERIA FROM COMPLIANCEREPORTMAP WHERE REPORT_CV_ID IN(SELECT CV_ID FROM AUDREPORTCVMAPPING WHERE AUDIT_REPORT_ID=" + reportId + ") AND CV_ID IN(SELECT CV_ID FROM AUDCRUNCHTABLEREFERENCE WHERE DOMAIN_NAME='" + domainName + "' AND IS_ENABLED='TRUE')) I2 ON I1.CV_ID=I2.REPORT_CV_ID ORDER BY REPORT_CV_ID";
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            for (int i = 0; i < 4; ++i) {
                cvidList.add(new ArrayList());
            }
            while (resultSet.next()) {
                cvidList.get(0).add(rb.getString(resultSet.getString("CV_NAME")));
                cvidList.get(1).add(resultSet.getLong("CV_ID"));
                cvidList.get(2).add(resultSet.getLong("REFERENCE_CV_ID"));
                cvidList.get(3).add(resultSet.getString("REF_SEARCH_CRITERIA"));
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return cvidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCategoryReports(String domainName, Long categoryId, Long categoryType, HashMap paramsMap, boolean allReports, boolean isSearch, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        JSONArray jsonArray = new JSONArray();
        try {
            String sqlString = "SELECT AUDIT_REPORT_ID,AUDIT_REPORT_NAME,PRIORITY FROM AUDREPORTS WHERE REPORT_CATEGORY_ID=" + categoryId + " ORDER BY PRIORITY";
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            while (resultSet.next()) {
                Long reportId = resultSet.getLong("AUDIT_REPORT_ID");
                Long graphType = Long.valueOf(resultSet.getLong("PRIORITY")) % 3L;
                String reportName = rb.getString(resultSet.getString("AUDIT_REPORT_NAME"));
                ArrayList<ArrayList<Object>> cvidList = ComplianceReportHandler.getReportCvIdDetails(domainName, reportId, request);
                if (!isSearch) {
                    if (cvidList.get(1).size() <= 0) continue;
                    Long cvId = (Long)cvidList.get(1).get(0);
                    Long sum = AuditReportAPI.getInstance().getReportCount(cvId, null, paramsMap, null);
                    if (allReports) {
                        Boolean reference = true;
                        ArrayList referenceList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(false));
                        if (referenceList.size() == 0) {
                            reference = false;
                        }
                        JSONObject dataObj = ComplianceReportHandler.getComplianceReportRows(cvId, null, paramsMap, sum);
                        dataObj.put("isReference", (Object)reference);
                        dataObj.put("reportSum", (Object)sum);
                        dataObj.put("cvName", (Object)new JSONArray((Collection)cvidList.get(0)));
                        dataObj.put("cvId", (Object)new JSONArray((Collection)cvidList.get(1)));
                        dataObj.put("cvReference", (Object)new JSONArray((Collection)cvidList.get(2)));
                        dataObj.put("cvAddnReference", (Object)new JSONArray((Collection)cvidList.get(3)));
                        dataObj.put("reportId", (Object)reportId);
                        dataObj.put("reportName", (Object)reportName);
                        dataObj.put("graphType", (Object)graphType);
                        jsonArray.put((Object)dataObj);
                        continue;
                    }
                    if (sum <= 0L) continue;
                    JSONObject dataObj = ComplianceReportHandler.getComplianceReportRows(cvId, null, paramsMap, sum);
                    dataObj.put("cvName", (Object)new JSONArray((Collection)cvidList.get(0)));
                    dataObj.put("cvId", (Object)new JSONArray((Collection)cvidList.get(1)));
                    dataObj.put("cvReference", (Object)new JSONArray((Collection)cvidList.get(2)));
                    dataObj.put("cvAddnReference", (Object)new JSONArray((Collection)cvidList.get(3)));
                    dataObj.put("reportId", (Object)reportId);
                    dataObj.put("reportName", (Object)reportName);
                    dataObj.put("graphType", (Object)graphType);
                    jsonArray.put((Object)dataObj);
                    continue;
                }
                if (cvidList.get(1).size() <= 0) continue;
                int searchOption = (Integer)request.getAttribute("searchOption");
                for (int i = 0; i < cvidList.get(1).size(); ++i) {
                    Long cvId = (Long)cvidList.get(1).get(i);
                    Boolean reference = true;
                    String referenceAlias = null;
                    ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(true));
                    ArrayList referenceList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(false));
                    if (referenceList.size() == 0) {
                        reference = false;
                    } else {
                        referenceAlias = (String)((HashMap)referenceList.get(0)).get("COLUMNALIAS");
                    }
                    ArrayList dataValues = new ArrayList(columnList.size());
                    ArrayList referenceValues = new ArrayList();
                    ArrayList<String> aliasNames = new ArrayList<String>(columnList.size());
                    ArrayList<String> titleNames = new ArrayList<String>(columnList.size());
                    for (int k = 0; k < columnList.size(); ++k) {
                        aliasNames.add((String)((HashMap)columnList.get(k)).get("COLUMNALIAS"));
                        if (k <= 0) continue;
                        titleNames.add(rb.getString((String)((HashMap)columnList.get(k)).get("DISPLAYNAME")));
                    }
                    String optionType = (String)aliasNames.get(0);
                    if ((searchOption != 1 || (categoryType != 5L || !optionType.equalsIgnoreCase("CALLER_USER_NAME") && !optionType.equalsIgnoreCase("CLIENT_USER_NAME")) && (categoryType != 6L || !optionType.equalsIgnoreCase("USERNAME"))) && (searchOption != 0 || !optionType.equalsIgnoreCase("ACCOUNT_NAME"))) continue;
                    ArrayList sumList = new ArrayList(columnList.size() - 1);
                    String searchCriteria = "1=1";
                    if (reference.booleanValue()) {
                        String usersid = request.getParameter("usersid");
                        if (usersid == null) {
                            usersid = (String)request.getAttribute("usersid");
                        }
                        searchCriteria = categoryType == 6L || searchOption == 0 ? referenceAlias + " LIKE '%" + usersid + "}'" : referenceAlias + " LIKE '%" + usersid + "'";
                    } else {
                        String samaccountname = request.getParameter("samaccountname");
                        if (samaccountname == null) {
                            samaccountname = (String)request.getAttribute("samaccountname");
                        }
                        searchCriteria = optionType + " LIKE '" + samaccountname + "'";
                    }
                    String countSqlString = ADAPSQLQueryAPI.getInstance().getSQLCountString(cvId, searchCriteria, paramsMap, null);
                    ComplianceReportHandler.getSumList(sumList, aliasNames, countSqlString);
                    if ((Long)sumList.get(0) > 0L) {
                        JSONObject reportObj = new JSONObject();
                        reportObj.put("sumList", (Object)new JSONArray(sumList));
                        reportObj.put("isReference", (Object)reference);
                        reportObj.put("titles", (Object)new JSONArray(titleNames));
                        reportObj.put("cvId", (Object)cvId);
                        reportObj.put("reportId", (Object)reportId);
                        reportObj.put("reportName", (Object)reportName);
                        if (reference.booleanValue()) {
                            reportObj.put("cvReference", cvidList.get(2).get(i));
                            reportObj.put("cvAddnReference", cvidList.get(3).get(i));
                            reportObj.put("referenceAlias", (Object)referenceAlias);
                        }
                        jsonArray.put((Object)reportObj);
                    }
                    i = cvidList.get(1).size();
                }
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return jsonArray.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSumList(ArrayList sumList, ArrayList aliasNames, String countSqlString) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block5: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(countSqlString);
                if (!resultSet.next()) break block5;
                for (int j = 0; j < aliasNames.size(); ++j) {
                    if (j <= 0) continue;
                    sumList.add(resultSet.getLong((String)aliasNames.get(j)));
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DataCruncher.closeConnection((Connection)connection, statement, resultSet);
                    throw throwable;
                }
                DataCruncher.closeConnection((Connection)connection, (Statement)statement, resultSet);
            }
        }
        DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getComplianceReportRows(Long cvId, String searchCriteria, HashMap inputParamsMap, Long sum) {
        JSONObject reportObj = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Long others = sum;
        try {
            int i = 0;
            Boolean reference = true;
            String referenceAlias = null;
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(true));
            ArrayList referenceList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(false));
            if (referenceList.size() == 0) {
                reference = false;
            } else {
                referenceAlias = (String)((HashMap)referenceList.get(0)).get("COLUMNALIAS");
            }
            ArrayList dataValues = new ArrayList(columnList.size());
            ArrayList<String> referenceValues = new ArrayList<String>();
            ArrayList<String> aliasNames = new ArrayList<String>(columnList.size());
            ArrayList<String> titleNames = new ArrayList<String>(columnList.size());
            for (i = 0; i < columnList.size(); ++i) {
                dataValues.add(new ArrayList());
                aliasNames.add((String)((HashMap)columnList.get(i)).get("COLUMNALIAS"));
                titleNames.add(rb.getString((String)((HashMap)columnList.get(i)).get("DISPLAYNAME")));
            }
            String sqlString = null;
            sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, null, 0);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            reportObj.put("reportSum", (Object)sum);
            while (resultSet.next()) {
                if (reference.booleanValue()) {
                    referenceValues.add(resultSet.getString(referenceAlias));
                }
                for (int j = 0; j < columnList.size(); ++j) {
                    if (j == 0) {
                        ((ArrayList)dataValues.get(j)).add(resultSet.getString((String)aliasNames.get(j)));
                        continue;
                    }
                    if (j == 1) {
                        Long count = resultSet.getLong((String)aliasNames.get(j));
                        ((ArrayList)dataValues.get(j)).add(count);
                        others = others - count;
                        continue;
                    }
                    ((ArrayList)dataValues.get(j)).add(resultSet.getLong((String)aliasNames.get(j)));
                }
            }
            reportObj.put("alias", (Object)new JSONArray(aliasNames));
            reportObj.put("titles", (Object)new JSONArray(titleNames));
            reportObj.put("isReference", (Object)reference);
            if (reference.booleanValue()) {
                reportObj.put("referenceAlias", (Object)referenceAlias);
                reportObj.put("referenceData", (Object)new JSONArray(referenceValues));
            }
            reportObj.put("others", (Object)others);
            ArrayList<JSONArray> dataList = new ArrayList<JSONArray>();
            for (i = 0; i < columnList.size(); ++i) {
                dataList.add(new JSONArray((Collection)dataValues.get(i)));
            }
            reportObj.put("data", (Object)new JSONArray(dataList));
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "could not execute this query :  " + ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, null, 0));
            e.printStackTrace();
        }
        finally {
            DataCruncher.closeConnection(connection, statement, resultSet);
        }
        return reportObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getReportGraphValues(String sqlString, boolean isStacked) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        JSONObject reportObj;
        block12: {
            reportObj = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            connection = null;
            statement = null;
            resultSet = null;
            try {
                int i;
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sqlString);
                if (!isStacked) {
                    ArrayList<String> xlist = new ArrayList<String>();
                    ArrayList<Long> ylist = new ArrayList<Long>();
                    while (resultSet.next()) {
                        xlist.add(resultSet.getString(2));
                        ylist.add(resultSet.getLong(1));
                    }
                    reportObj.put("xList", (Object)new JSONArray(xlist));
                    reportObj.put("yList", (Object)new JSONArray(ylist));
                    break block12;
                }
                ArrayList<Object> xlist = new ArrayList();
                ArrayList<Object> stacklist = new ArrayList();
                ArrayList<String> totalstacklist = new ArrayList<String>();
                ArrayList<HashMap> totalylist = new ArrayList<HashMap>();
                ArrayList<String> totalxlist = new ArrayList<String>();
                while (resultSet.next()) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    totalxlist.add(resultSet.getString(2));
                    totalstacklist.add(resultSet.getString(3));
                    resultMap.put("1", resultSet.getLong(1));
                    resultMap.put("2", resultSet.getString(2));
                    resultMap.put("3", resultSet.getString(3));
                    totalylist.add(resultMap);
                }
                xlist = ComplianceReportHandler.getDistinctElements(totalxlist);
                stacklist = ComplianceReportHandler.getDistinctElements(totalstacklist);
                ArrayList dataValues = new ArrayList(stacklist.size());
                for (i = 0; i < stacklist.size(); ++i) {
                    dataValues.add(new ArrayList());
                }
                for (i = 0; i < stacklist.size(); ++i) {
                    for (int j = 0; j < xlist.size(); ++j) {
                        if (ComplianceReportHandler.isPresentInResultSet(totalylist, (String)xlist.get(j), "2") && ComplianceReportHandler.isPresentInResultSet(totalylist, (String)stacklist.get(i), "3")) {
                            ((ArrayList)dataValues.get(i)).add(ComplianceReportHandler.getPresentYValue(totalylist, (String)xlist.get(j), (String)stacklist.get(i)));
                            continue;
                        }
                        ((ArrayList)dataValues.get(i)).add(0L);
                    }
                }
                ArrayList<JSONArray> dataList = new ArrayList<JSONArray>();
                for (int i2 = 0; i2 < stacklist.size(); ++i2) {
                    dataList.add(new JSONArray((Collection)dataValues.get(i2)));
                }
                reportObj.put("xList", (Object)new JSONArray(xlist));
                reportObj.put("yList", (Object)new JSONArray(dataList));
                reportObj.put("stackList", (Object)new JSONArray(stacklist));
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DataCruncher.closeConnection((Connection)connection, statement, resultSet);
                    throw throwable;
                }
                DataCruncher.closeConnection((Connection)connection, (Statement)statement, resultSet);
            }
        }
        DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return reportObj;
    }

    public static Long getPresentYValue(ArrayList<HashMap> arr, String value, String stack) {
        for (int i = 0; i < arr.size(); ++i) {
            HashMap resultMap = arr.get(i);
            if (!resultMap.get("2").equals(value) || !resultMap.get("3").equals(stack)) continue;
            return (Long)resultMap.get("1");
        }
        return 0L;
    }

    public static boolean isPresentInResultSet(ArrayList<HashMap> arr, String value, String key) {
        for (int i = 0; i < arr.size(); ++i) {
            HashMap resultMap = arr.get(i);
            if (!resultMap.get(key).equals(value)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> getDistinctElements(ArrayList arr) {
        ArrayList<String> croppedArr = new ArrayList<String>();
        for (int i = 0; i < arr.size(); ++i) {
            boolean isDistinct = false;
            for (int j = 0; j < i; ++j) {
                if (!arr.get(i).equals(arr.get(j))) continue;
                isDistinct = true;
                break;
            }
            if (isDistinct) continue;
            croppedArr.add((String)arr.get(i));
        }
        return croppedArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCategorySum(String domainName, Long categoryType, HashMap paramsMap, Long startTime, Long endTime, boolean isSearch, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String sqlString = "";
        if (!isSearch) {
            sqlString = "SELECT REPORT_CATEGORY_ID,NAME FROM AUDREPORTCATEGORIES WHERE REPORT_CATEGORY_ID IN(SELECT DISTINCT(REPORT_CATEGORY_ID) FROM AUDREPORTS WHERE REPORT_CATEGORY_TYPE=" + categoryType + ") ORDER BY PRIORITY";
        }
        JSONArray jsonArray = new JSONArray();
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            if (!isSearch) {
                resultSet = statement.executeQuery(sqlString);
                logger.log(Level.INFO, "sum for category type = " + categoryType);
                while (resultSet.next()) {
                    jsonArray.put((Object)ComplianceReportHandler.getreportsSum(domainName, resultSet.getLong("REPORT_CATEGORY_ID"), rb.getString(resultSet.getString("NAME")), paramsMap));
                }
            } else {
                for (int count = 0; count < 3; ++count) {
                    int category = 5;
                    if (count == 1) {
                        category = 6;
                    }
                    if (count != 2) {
                        request.setAttribute("searchOption", (Object)count);
                    }
                    JSONObject jsonInnerObject = new JSONObject();
                    sqlString = "SELECT TABLE1.REPORT_CATEGORY_ID AS REPORT_CATEGORY_ID,TABLE1.NAME AS NAME,TABLE2.REPORT_CATEGORY_TYPE AS REPORT_CATEGORY_TYPE FROM AUDREPORTCATEGORIES TABLE1 INNER JOIN (SELECT DISTINCT(REPORT_CATEGORY_ID)AS REPORT_CATEGORY_ID,REPORT_CATEGORY_TYPE FROM AUDREPORTS WHERE REPORT_CATEGORY_TYPE=" + category + ")TABLE2 ON(TABLE1.REPORT_CATEGORY_ID=TABLE2.REPORT_CATEGORY_ID)ORDER BY TABLE1.REPORT_CATEGORY_ID";
                    resultSet = statement.executeQuery(sqlString);
                    JSONArray jsonInnerArray = new JSONArray();
                    while (resultSet.next()) {
                        logger.log(Level.INFO, "search for category type = " + resultSet.getLong("REPORT_CATEGORY_TYPE"));
                        HashMap<String, Object> paramsMap1 = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, Integer.parseInt((String)request.getAttribute("timePeriod")), resultSet.getLong("REPORT_CATEGORY_TYPE"), false, 0L, 0L);
                        String reportData = ComplianceReportHandler.getCategoryReports(domainName, resultSet.getLong("REPORT_CATEGORY_ID"), resultSet.getLong("REPORT_CATEGORY_TYPE"), paramsMap1, true, isSearch, request);
                        JSONArray reportDataArray = new JSONArray(reportData);
                        if (reportDataArray.length() <= 0) continue;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("categoryName", (Object)rb.getString(resultSet.getString("NAME")));
                        jsonObject.put("reports", (Object)reportDataArray);
                        Long sum = ComplianceReportHandler.getSum(reportDataArray);
                        jsonObject.put("categorySum", (Object)sum);
                        jsonObject.put("categoryType", resultSet.getLong("REPORT_CATEGORY_TYPE"));
                        jsonObject.put("categoryId", resultSet.getLong("REPORT_CATEGORY_ID"));
                        jsonInnerArray.put((Object)jsonObject);
                    }
                    if (jsonInnerArray.length() <= 0) continue;
                    jsonInnerObject.put("count", count);
                    jsonInnerObject.put("groups", (Object)jsonInnerArray);
                    jsonArray.put((Object)jsonInnerObject);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DataCruncher.closeConnection((Connection)connection, statement, resultSet);
                throw throwable;
            }
            DataCruncher.closeConnection((Connection)connection, (Statement)statement, resultSet);
        }
        DataCruncher.closeConnection((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return jsonArray.toString();
    }

    public static HashMap<String, Object> getParamsMap(String domainName, Long from, Long to, int timePeriod, Long categoryType, boolean isLimit, Long limit, Long offset) {
        ArrayList paramsList = ComplianceReportHandler.getInputParamsMap(domainName, from, to, timePeriod, categoryType);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("isComplianceReport", "yes");
        paramsMap.put("inputParams", paramsList);
        if (isLimit) {
            paramsMap.put("offset", offset.toString());
            paramsMap.put("limit", limit.toString());
            paramsMap.put("orderBy", "ADAPCOUNT DESC");
        }
        logger.log(Level.INFO, "list is = " + paramsList);
        return paramsMap;
    }

    public static HashMap<String, Object> getParamsMap(String domainName, Long from, Long to, int timePeriod, Long categoryType, boolean isLimit, Long limit, Long offset, String orderBy) {
        ArrayList paramsList = ComplianceReportHandler.getInputParamsMap(domainName, from, to, timePeriod, categoryType);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("isComplianceReport", "yes");
        paramsMap.put("inputParams", paramsList);
        if (isLimit) {
            paramsMap.put("offset", offset.toString());
            paramsMap.put("limit", limit.toString());
            if (orderBy != null) {
                paramsMap.put("orderBy", orderBy);
            } else {
                paramsMap.put("orderBy", "ADAPCOUNT DESC");
            }
        }
        logger.log(Level.INFO, "list is = " + paramsList);
        return paramsMap;
    }

    public static ArrayList getInputParamsMap(String domainName, Long from, Long to, int timePeriod, Long categoryType) {
        String tableName = TemplateTableHandler.getDomainListEntry((String)domainName) + "_";
        ArrayList paramsList = new ArrayList();
        if (timePeriod == 0) {
            paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 0));
        } else if (timePeriod == 1 || timePeriod == 2 || timePeriod == 7) {
            Long dailyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"DAILY_LAST_CRUNCH")));
            if (dailyLastCrunch > from) {
                if (dailyLastCrunch >= to) {
                    paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 1));
                } else {
                    paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), Long.valueOf(dailyLastCrunch - 1L).toString(), tableName, categoryType, 1));
                    paramsList.addAll(ComplianceReportHandler.getParams(dailyLastCrunch.toString(), to.toString(), tableName, categoryType, 0));
                }
            } else {
                paramsList.addAll(ComplianceReportHandler.getParams(from.toString(), to.toString(), tableName, categoryType, 0));
            }
        } else if (timePeriod == 3 || timePeriod == 4 || timePeriod == 8 || timePeriod == 9 || timePeriod > 100 && timePeriod < 300 || timePeriod > 100000000) {
            Long monthlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"MONTHLY_LAST_CRUNCH")));
            Long dailyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"DAILY_LAST_CRUNCH")));
            paramsList.addAll(ComplianceReportHandler.getLastNMonthParams(from, to, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
        } else if (timePeriod == 5 || timePeriod == 6 || timePeriod > 300 && timePeriod < 400) {
            Long yearlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"YEARLY_LAST_CRUNCH")));
            Long halfyearlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"HALFYEARLY_LAST_CRUNCH")));
            Long quarterlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"QUARTERLY_LAST_CRUNCH")));
            Long monthlyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"MONTHLY_LAST_CRUNCH")));
            Long dailyLastCrunch = Long.parseLong(ComplianceReportHandler.lastCrunchValue(ADSMPersUtil.getSyMParameter((String)"DAILY_LAST_CRUNCH")));
            paramsList.addAll(ComplianceReportHandler.getLastNYearParams(from, to, yearlyLastCrunch, halfyearlyLastCrunch, quarterlyLastCrunch, monthlyLastCrunch, dailyLastCrunch, tableName, categoryType));
        }
        return paramsList;
    }
}

