/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.AlertSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class AdminAlertsHandler {
    private static volatile AdminAlertsHandler instance = null;
    private static Logger logger = Logger.getLogger(AdminAlertsHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminAlertsHandler getInstance() {
        if (instance != null) return instance;
        Class<AdminAlertsHandler> clazz = AdminAlertsHandler.class;
        synchronized (AdminAlertsHandler.class) {
            if (instance != null) return instance;
            instance = new AdminAlertsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void getData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            HashMap schMap = AlertSchedulerUtil.viewAlertScheduler();
            if (schMap.containsKey("adminStatus") && schMap.get("adminStatus").toString().equals("3")) {
                ret.put("delAlerts", true);
                ret.put("delAlertsValue", schMap.get("alertLife"));
            } else {
                ret.put("delAlerts", false);
                ret.put("delAlertsValue", schMap.get("alertLife"));
            }
            String op = "-1";
            Criteria c1 = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
            DataObject d1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SystemParams", c1);
            if (!d1.isEmpty()) {
                Row r1 = d1.getFirstRow("SystemParams");
                op = (String)r1.get("PARAM_VALUE");
            }
            if (op.equals("-1")) {
                ret.put("delReports", false);
                ret.put("delReportsValue", (Object)op);
            } else {
                ret.put("delReports", true);
                ret.put("delReportsValue", (Object)op);
                ret.put("showRunNow", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void setData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            HashMap<String, Object> schMap2;
            ret.put("message", (Object)rb.getString("adap.admin.DeleteReports.SaveFail"));
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            Boolean delAlerts = data.getBoolean("delAlerts");
            String delAlertsValue = data.optString("delAlertsValue");
            String delReportsValue = data.getString("delReportsValue");
            HashMap schMap = AlertSchedulerUtil.viewAlertScheduler();
            Boolean rowPresent = schMap.containsKey("adminStatus");
            if (delAlerts.booleanValue() && rowPresent.booleanValue()) {
                Long newValue;
                Long oldValue = (Long)schMap.get("alertLife");
                if (!oldValue.equals(newValue = Long.valueOf(Long.parseLong(delAlertsValue)))) {
                    schMap2 = new HashMap();
                    schMap2.put("alertLife", newValue);
                    AlertSchedulerUtil.modifyAlertScheduler(schMap2);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AlertsSettings.audit_entry.Successfully_updated_delete_alerts", new String[]{delAlertsValue}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Enable_Delete_Alerts", "-"}));
                }
            } else if (delAlerts.booleanValue() && !rowPresent.booleanValue()) {
                HashMap idMap = AlertSchedulerUtil.getScheduledId((String)"adap.Schedule.schedule_name.Clear_Alerts");
                Long scheduleId = (Long)idMap.get("scheduleId");
                schMap2 = new HashMap<String, Object>();
                schMap2.put("scheduleId", scheduleId);
                schMap2.put("taskId", idMap.get("taskId"));
                schMap2.put("alertLife", Long.parseLong(delAlertsValue));
                schMap2.put("units", "days");
                AlertSchedulerUtil.createAlertScheduler(schMap2);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AlertsSettings.audit_entry.Successfully_delete_alerts_config", new String[]{delAlertsValue}), 8, 8, "ADAPUserAuditSeverities.audit_name.Save_Delete_Alerts", "-"}));
            } else if (!delAlerts.booleanValue() && rowPresent.booleanValue()) {
                AlertSchedulerUtil.deleteAlertScheduleRow();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.AlertsSettings.audit_entry.Successfully_disabled_delete_alerts"), 8, 8, "ADAPUserAuditSeverities.audit_name.Disable_Delete_Alerts", "-"}));
            }
            Criteria c1 = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
            DataObject d1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SystemParams", c1);
            if (d1.isEmpty()) {
                DataObject schDo = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Row schRow = new Row("SystemParams");
                schRow.set("PARAM_NAME", (Object)"cleanReports");
                schRow.set("PARAM_VALUE", (Object)delReportsValue);
                schDo.addRow(schRow);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(schDo);
                logger.log(Level.INFO, "Delete old schedule reports set");
                String message = rb.handleGetObject("adap.ReportScheduler.audit_entry.Delete_scheduled_Reports_config_successfully", new String[]{delReportsValue});
                if (delReportsValue.equals("-1")) {
                    message = rb.getString("adap.ReportScheduler.audit_entry.Delete_scheduled_reports_config_removed");
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
            } else {
                Row row = d1.getFirstRow("SystemParams");
                String oldValue = (String)row.get("PARAM_VALUE");
                if (!oldValue.equals(delReportsValue)) {
                    UpdateQueryImpl u = new UpdateQueryImpl("SystemParams");
                    Criteria c = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"cleanReports", 0);
                    u.setCriteria(c);
                    u.setUpdateColumn("PARAM_NAME", (Object)"cleanReports");
                    u.setUpdateColumn("PARAM_VALUE", (Object)delReportsValue);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)u);
                    logger.log(Level.INFO, "Delete old schedule reports value updated");
                    String message = rb.handleGetObject("adap.ReportScheduler.audit_entry.Delete_scheduled_Reports_config_successfully", new String[]{delReportsValue});
                    if (delReportsValue.equals("-1")) {
                        message = rb.getString("adap.ReportScheduler.audit_entry.Delete_scheduled_reports_config_removed");
                    }
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
                }
            }
            ret.put("message", (Object)rb.getString("adap.admin.DeleteReports.SaveSuccess"));
            ret.put("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void delSchReportsRunNow(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            String status = ReportSchedulerUtil.delReports((String)"Manual");
            logger.log(Level.INFO, "Deleting old schedule report files " + status);
            if (status.equals("true")) {
                ret.put("success", true);
                ret.put("message", (Object)rb.getString("adap.admin.DeleteReports.Success"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ReportScheduler.audit_entry.Success_run_for_delete_schedule_reports"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
            } else {
                ret.put("message", (Object)rb.getString("adap.admin.DeleteReports.Fail"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ReportScheduler.audit_entry.failed_to_run_delete_schedule_Reprots"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports_audit_entries", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

