/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class BusinessHourSettingsHandler {
    private static volatile BusinessHourSettingsHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BusinessHourSettingsHandler getInstance() {
        if (instance != null) return instance;
        Class<BusinessHourSettingsHandler> clazz = BusinessHourSettingsHandler.class;
        synchronized (BusinessHourSettingsHandler.class) {
            if (instance != null) return instance;
            instance = new BusinessHourSettingsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object message = null;
        JSONObject resultantJson = new JSONObject();
        try {
            String requestString = request.getParameter("bussinessHoursDetails");
            JSONObject requestJson = new JSONObject(requestString);
            String action = requestJson.getString("action");
            HashMap settingsMap = BusinessServerSettings.getBusinessHourSettings();
            if (settingsMap.isEmpty()) {
                settingsMap.put("FromTime", "");
                settingsMap.put("ToTime", "");
                settingsMap.put("Days", "");
            }
            resultantJson.put("toAddressSettings", (Object)APIUtil.getInstance().mapToJSONObject(settingsMap));
            resultantJson.put("message", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void saveAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = null;
        JSONObject resultantJson = new JSONObject();
        try {
            String requestString = request.getParameter("bussinessHoursDetails");
            JSONObject requestJson = new JSONObject(requestString);
            String action = requestJson.getString("action");
            String toTime = requestJson.getString("toTime");
            String fromTime = requestJson.getString("fromTime");
            String days = requestJson.getString("days");
            BusinessServerSettings.saveBusinessHourSettings((String)fromTime, (String)toTime, (String)days);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.BusinessHourSettings.audit_entry.Saved_Successfully", new String[]{days, fromTime, toTime}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.business_hr_changed", "-"}));
            message = rb.getString("adap.common.text.status_msg.success_saved_configuration");
            HashMap settingsMap = BusinessServerSettings.getBusinessHourSettings();
            if (settingsMap.isEmpty()) {
                settingsMap.put("FromTime", "");
                settingsMap.put("ToTime", "");
                settingsMap.put("Days", "");
            }
            resultantJson.put("toAddressSettings", (Object)APIUtil.getInstance().mapToJSONObject(settingsMap));
            resultantJson.put("message", (Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }
}

