/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.PasswordException;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.start.StartupUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChangePasswordActionHandler {
    private static Logger logger = Logger.getLogger(ChangePasswordActionHandler.class.getName());
    private static volatile ChangePasswordActionHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChangePasswordActionHandler getInstance() {
        if (instance != null) return instance;
        Class<ChangePasswordActionHandler> clazz = ChangePasswordActionHandler.class;
        synchronized (ChangePasswordActionHandler.class) {
            if (instance != null) return instance;
            instance = new ChangePasswordActionHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void showPersonalisePage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String option = request.getParameter("selectedTile");
        JSONObject resultantJson = new JSONObject();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        try {
            SimpleDateFormat sdf;
            int i;
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            resultantJson.put("DATE_FORMAT", (Object)ADSMPersUtil.getSyMParameter((String)"DATE_FORMAT"));
            resultantJson.put("TIME_FORMAT", (Object)ADSMPersUtil.getSyMParameter((String)"TIME_FORMAT"));
            ArrayList<String> dateFormatList = new ArrayList<String>(Arrays.asList("MMM dd,yyyy", "EEE, MMM d, yyyy", "EEEE, MMMM dd, yyyy", "MMMM dd, yyyy", "M/d/yy", "dd/MM/yyyy", "dd-MMM-yyyy", "MM/dd/yyyy", "yyyy/MM/dd (E)", "yyyy-MM-dd"));
            ArrayList<String> timeFormatList = new ArrayList<String>(Arrays.asList("hh:mm:ss a z", "hh:mm:ss a", "h:mm:ss a", "h:mm:ss", "HH:mm:ss z", "HH:mm:ss", "hh:mm a", "h:mm a", "h:mm", "HH:mm"));
            JSONArray dateFormatArray = new JSONArray();
            JSONArray timeFormatArray = new JSONArray();
            Date date = new Date();
            for (i = 0; i < dateFormatList.size(); ++i) {
                JSONObject dateObject = new JSONObject();
                String dateFormatValue = dateFormatList.get(i);
                sdf = new SimpleDateFormat(dateFormatValue);
                dateObject.put("name", (Object)dateFormatValue);
                dateObject.put("subText", (Object)(" - " + sdf.format(date)));
                dateObject.put("value", (Object)dateFormatValue);
                dateFormatArray.put((Object)dateObject);
            }
            for (i = 0; i < timeFormatList.size(); ++i) {
                JSONObject timeObject = new JSONObject();
                String timeFormatValue = timeFormatList.get(i);
                timeObject.put("value", (Object)timeFormatValue);
                sdf = new SimpleDateFormat(timeFormatValue);
                timeObject.put("subText", (Object)(" - " + sdf.format(date)));
                timeObject.put("name", (Object)timeFormatValue);
                timeFormatArray.put((Object)timeObject);
            }
            resultantJson.put("dateFormatArray", (Object)dateFormatArray);
            resultantJson.put("timeFormatArray", (Object)timeFormatArray);
            Properties prop = ADSMPersUtil.getLocaleSettings();
            ArrayList labelList = (ArrayList)prop.get("labelList");
            ArrayList valueList = (ArrayList)prop.get("valueList");
            JSONArray localeIdArray = new JSONArray();
            for (int z = 0; z < labelList.size(); ++z) {
                String localeName = rb.getString((String)labelList.get(z));
                JSONObject localeObject = new JSONObject();
                localeObject.put("name", (Object)localeName);
                localeObject.put("value", valueList.get(z));
                localeIdArray.put((Object)localeObject);
            }
            resultantJson.put("localeIdArray", (Object)localeIdArray);
            ResourceBundleMgr.getInstance();
            Long localeId = ResourceBundleMgr.getUserLocaleId((Long)loginId);
            if (localeId == -1L) {
                localeId = 0L;
            }
            resultantJson.put("localeId", (Object)localeId);
            String[] allTimeZones = TimeZone.getAvailableIDs();
            JSONArray timeZoneArray = new JSONArray();
            for (int z = 0; z < allTimeZones.length; ++z) {
                JSONObject timeZoneObject = new JSONObject();
                timeZoneObject.put("value", (Object)allTimeZones[z]);
                TimeZone tt = TimeZone.getTimeZone(allTimeZones[z]);
                int offset = tt.getOffset(new Date().getTime()) / 1000 / 60;
                String displayName = "( UTC " + offset / 60 + ":" + Math.abs(offset % 60) + ") " + tt.getDisplayName() + " (" + tt.getID() + ") ";
                timeZoneObject.put("name", (Object)displayName);
                timeZoneArray.put((Object)timeZoneObject);
            }
            resultantJson.put("timeZoneArray", (Object)timeZoneArray);
            String timeZoneId = " ";
            if (ADSMPersUtil.getSyMParameter((String)"TIMEZONE_ID").equals("-")) {
                timeZoneId = TimeZone.getDefault().getID();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.timezone_successfully_updated", new String[]{timeZoneId}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.time_zone_updated", "-"}));
                ADSMPersUtil.updateSyMParameter((String)"TIMEZONE_ID", (String)TimeZone.getDefault().getID());
            } else {
                timeZoneId = ADSMPersUtil.getSyMParameter((String)"TIMEZONE_ID");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.personalize_settings_Viewd"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.personalize_page_viewed", "-"}));
            resultantJson.put("timeZoneId", (Object)timeZoneId);
            boolean showPassword = TechnicianHandler.personalizeCheck((String)loginName, (Long)loggedOnUserId);
            if (CommonUtil.isDemo()) {
                showPassword = false;
            }
            resultantJson.put("showPassword", showPassword);
            ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
            JSONArray domainListArray = new JSONArray();
            if (domainList != null && domainList.size() > 0) {
                for (int i2 = 0; i2 < domainList.size(); ++i2) {
                    JSONObject domainObject = new JSONObject();
                    Properties domainProp = (Properties)domainList.get(i2);
                    String domainName = domainProp.getProperty("DOMAIN_FLAT_NAME");
                    String dom = domainProp.getProperty("DOMAIN_NAME");
                    boolean opt = DomainHandler.getDomainOption((String)dom);
                    domainObject.put("domainName", (Object)domainName);
                    domainObject.put("opt", opt);
                    domainListArray.put((Object)domainObject);
                }
            }
            resultantJson.put("domainListArray", (Object)domainListArray);
            resultantJson.put("isOldUIEnabled", AdminHandler.isOldUIEnabled());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading personalise page", e);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.Exception_loading_personalize_page"), 4, 16, "adap.ADAPUserAuditSeverities.audit_name.personalize_page_viewed", "-"}));
            throw new Exception("Exception while loading personalise page");
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void enableDisableOldUI(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("message", (Object)"Failure Occured");
            ret.put("autoClose", false);
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            boolean enableOldUI = data.getBoolean("enableOldUI");
            if (AdminHandler.enableDisableOldUI((boolean)enableOldUI)) {
                if (enableOldUI) {
                    ret.put("message", (Object)rb.getString("adap.admin.general.personalize.enabledoldui.success"));
                } else {
                    ret.put("message", (Object)rb.getString("adap.admin.general.personalize.disableoldui.success"));
                }
            }
            ret.put("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void showConnectionPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String option = request.getParameter("selectedTile");
        JSONObject resultantJson = new JSONObject();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        try {
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            resultantJson.put("PORT_NUMBER", (Object)SDInstallUtil.getWebServerPort());
            Row row = ADSMPersUtil.getUserAccountSettings((Long)accountId);
            if (row != null) {
                Integer timeout = (Integer)row.get("SESSION_EXPIRY_TIME");
                int time = timeout / 60;
                if (time > 0) {
                    resultantJson.put("SESSION_EXPIRY_TIME", (Object)time);
                } else {
                    resultantJson.put("SESSION_EXPIRY_TIME", (Object)rb.getString("adap.LicenseUpgradeAction.Never"));
                }
            } else if (row == null) {
                resultantJson.put("SESSION_EXPIRY_TIME", (Object)rb.getString("adap.LicenseUpgradeAction.Never"));
            }
            String[] times = new String[]{rb.getString("adap.LicenseUpgradeAction.Never"), "10", "15", "20", "25", "30", "45", "60"};
            JSONArray timesArray = new JSONArray();
            for (int i = 0; i < times.length; ++i) {
                JSONObject timesObject = new JSONObject();
                timesObject.put("name", (Object)times[i]);
                timesObject.put("value", (Object)times[i]);
                timesArray.put((Object)timesObject);
            }
            resultantJson.put("times", (Object)timesArray);
            boolean enableSSL = ADSMPersUtil.checkSSL();
            resultantJson.put("enableSSL", enableSSL);
            Integer sslPort = SDInstallUtil.getSSLPort();
            if (sslPort != -1) {
                resultantJson.put("SSLPortNo", (Object)sslPort);
            } else if (sslPort == -1) {
                sslPort = SDInstallUtil.getSSLPortForWebServerPort((int)SDInstallUtil.getWebServerPort());
                resultantJson.put("SSLPortNo", (Object)sslPort);
            }
            ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
            JSONArray domainListArray = new JSONArray();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMDomainConfiguration"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (domainList != null && domainList.size() > 0) {
                for (int i = 0; i < domainList.size(); ++i) {
                    JSONObject domainObject = new JSONObject();
                    Properties domainProp = (Properties)domainList.get(i);
                    String domainName = domainProp.getProperty("DOMAIN_FLAT_NAME");
                    String dom = domainProp.getProperty("DOMAIN_NAME");
                    boolean opt = DomainHandler.getDomainOptionSSL((DataObject)obj, (String)dom);
                    domainObject.put("name", (Object)domainName);
                    domainObject.put("value", opt);
                    domainListArray.put((Object)domainObject);
                }
            }
            resultantJson.put("domainListArray", (Object)domainListArray);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.connection_settings_Viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.connection_settings_Viewd", "-"}));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading personalise page", e);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.Exception_loading_personalize_page"), 4, 16, "adap.ADAPUserAuditSeverities.audit_name.personalize_page_viewed", "-"}));
            throw new Exception("Exception while loading personalise page");
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void showServerSettingsPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String option = request.getParameter("selectedTile");
        JSONObject resultantJson = new JSONObject();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        try {
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            resultantJson.put("LAUNCH_DEFAULT_BROWSER", (Object)this.getDefaultClientSettings());
            resultantJson.put("START_SERVER_ON_BOOTUP", (Object)this.isStartServerOnBootup());
            String usageStatistics = ADSMPersUtil.getSyMParameter((String)"USAGE_STATISTICS");
            if (usageStatistics == null) {
                usageStatistics = "ENABLE";
            }
            resultantJson.put("USAGE_STATISTICS", (Object)usageStatistics);
            resultantJson.put("LOG_LEVEL", (Object)ADSMPersUtil.getCurrentLogLevel());
            ArrayList langlabel = new ArrayList();
            ArrayList langValue = new ArrayList();
            Properties prop = ADSMPersUtil.getLanguageList();
            resultantJson.put("Countries", prop.get("label"));
            resultantJson.put("ExportReport", (Object)(ADSMPersUtil.graphValue ? "Graph" : "NoGraph"));
            resultantJson.put("Countries_value", prop.get("value"));
            Properties language = ADSMPersUtil.getLanguageSettings();
            resultantJson.put("COUNTRY", language.get("language"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.server_settings_viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.server_settings_viewed", "-"}));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading personalise page", e);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.Exception_loading_personalize_page"), 4, 16, "adap.ADAPUserAuditSeverities.audit_name.personalize_page_viewed", "-"}));
            throw new Exception("Exception while loading personalise page");
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void personalise(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String settingsDetails = request.getParameter("settingsDetails");
        JSONObject settingsDetailsObject = new JSONObject(settingsDetails);
        String option = settingsDetailsObject.getString("selectedTile");
        StringBuffer buf = new StringBuffer();
        String tile = "";
        JSONObject resultantJson = new JSONObject();
        try {
            String dbTimeFormat;
            String timeFormat;
            String dbDateFormat;
            String dateFormat;
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            boolean update = false;
            Row userSettingsRow = null;
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            userSettingsRow = ADSMPersUtil.getUserAccountSettings((Long)accountId);
            if (userSettingsRow == null) {
                userSettingsRow = new Row("UserSettings");
                userSettingsRow.set("USER_ACCOUNT_ID", (Object)accountId);
            }
            String oldpass = settingsDetailsObject.getString("OLD_PASSWORD");
            String newpass = settingsDetailsObject.getString("NEW_PASSWORD");
            if (oldpass != null && !oldpass.equals("") && newpass != null && !newpass.equals("")) {
                try {
                    this.changePassword(loginName, oldpass, newpass, request);
                    String isPasswordChanged = ADSMPersUtil.getSyMParameter((String)"IS_PASSWORD_CHANGED");
                    logger.log(Level.FINE, "is pass changed" + isPasswordChanged);
                    if (isPasswordChanged.equals("false")) {
                        ADSMPersUtil.updateSyMParameter((String)"IS_PASSWORD_CHANGED", (String)"true");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.TechnicianConfiguration.Successfully_updated_the_password"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.pwd_updated", "-"}));
                    }
                }
                catch (Exception ex) {
                    String message = ex.getMessage();
                    if (message.contains("Old password specified does not match")) {
                        message = rb.getString("adap.admin.ChangePasswordAction.Old_password_specified_does_not_match");
                    } else if (message.contains("Length of the new password is smaller than expected value")) {
                        message = rb.getString("adap.admin.ChangePasswordAction.Length_of_the_new_password_is_smaller_than_expected_value");
                    }
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.pwd_updated", "-"}));
                    resultantJson.put("message", (Object)message);
                    resultantJson.put("failure", true);
                    logger.log(Level.WARNING, "Exception while changing the password", ex);
                }
            }
            ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
            Boolean[] dboptions = new Boolean[domainList.size()];
            JSONArray options = settingsDetailsObject.getJSONArray("selectedDomains");
            if (domainList != null && domainList.size() > 0) {
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties prop = (Properties)domainList.get(i);
                    String domainName = prop.getProperty("DOMAIN_FLAT_NAME");
                    String dom = prop.getProperty("DOMAIN_NAME");
                    dboptions[i] = DomainHandler.getDomainOption((String)dom);
                    if ((Boolean)options.get(i) == dboptions[i]) continue;
                    DomainHandler.setDomainOption((String)dom, (boolean)((Boolean)options.get(i)));
                }
            }
            if (!(dateFormat = settingsDetailsObject.getString("DATE_FORMAT")).equals(dbDateFormat = ADSMPersUtil.getSyMParameter((String)"DATE_FORMAT"))) {
                ADSMPersUtil.updateSyMParameter((String)"DATE_FORMAT", (String)dateFormat);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.date_format_updated", new String[]{dateFormat}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.date_format_updated", "-"}));
                TimeUtil.setDate((String)dateFormat);
            }
            if (!(timeFormat = settingsDetailsObject.getString("TIME_FORMAT")).equals(dbTimeFormat = ADSMPersUtil.getSyMParameter((String)"TIME_FORMAT"))) {
                ADSMPersUtil.updateSyMParameter((String)"TIME_FORMAT", (String)timeFormat);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.time_format_updated", new String[]{timeFormat}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.time_format_updatd", "-"}));
                TimeUtil.setTime((String)timeFormat);
            }
            String timeZoneId = settingsDetailsObject.getString("timeZoneId");
            if (!ADSMPersUtil.getSyMParameter((String)"TIMEZONE_ID").equals(timeZoneId)) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.timezone_successfully_updated", new String[]{timeZoneId}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.time_zone_updated", "-"}));
                ADSMPersUtil.updateSyMParameter((String)"TIMEZONE_ID", (String)timeZoneId);
                TimeUtil.setTimeZoneId((String)timeZoneId);
            }
            Long localeId = settingsDetailsObject.getLong("localeId");
            Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
            if (localeId != null) {
                try {
                    ResourceBundleMgr.getInstance().setUserLocale(loginId, localeId, request);
                    rb = ResourceBundleMgr.getInstance().getBundle(request);
                    if (localeId == 0L) {
                        Locale locale = request.getLocale();
                        ResourceBundleMgr.getInstance().updateLocaleDetails(localeId, locale.getLanguage(), locale.getCountry());
                    }
                    Row row = ReportUtil.getFirstRow((String)"LocaleDetails", (String)"LOCALE_ID", (Object)localeId, (int)0);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.locale_updated", new String[]{rb.getString((String)row.get("LOCALE_DISPLAY"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.locale_updated", "-"}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while personalising ", e);
            throw new Exception("Exception while personalising");
        }
        if (!resultantJson.has("message")) {
            resultantJson.put("message", (Object)rb.getString("adap.common.text.status_msg.success"));
            resultantJson.put("success", true);
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void saveConnection(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String settingsDetails = request.getParameter("settingsDetails");
        JSONObject settingsDetailsObject = new JSONObject(settingsDetails);
        String option = settingsDetailsObject.getString("selectedTile");
        StringBuffer buf = new StringBuffer();
        String tile = "";
        JSONObject resultantJson = new JSONObject();
        try {
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            boolean update = false;
            Row userSettingsRow = null;
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            userSettingsRow = ADSMPersUtil.getUserAccountSettings((Long)accountId);
            if (userSettingsRow == null) {
                userSettingsRow = new Row("UserSettings");
                userSettingsRow.set("USER_ACCOUNT_ID", (Object)accountId);
            }
            ArrayList domainList = DomainHandler.getConfiguredList((Long)new Long(1L));
            JSONArray selectedSSL = settingsDetailsObject.getJSONArray("selectedSSLDomains");
            ArrayList<String> selectedSSLList = new ArrayList<String>();
            for (int i = 0; i < selectedSSL.length(); ++i) {
                selectedSSLList.add(selectedSSL.getString(i));
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMDomainConfiguration"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (domainList != null && domainList.size() > 0) {
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties prop = (Properties)domainList.get(i);
                    String domainName = prop.getProperty("DOMAIN_FLAT_NAME");
                    String dom = prop.getProperty("DOMAIN_NAME");
                    if (selectedSSLList.contains(domainName)) {
                        DomainHandler.setDomainOptionSSL((DataObject)obj, (String)dom, (boolean)true);
                        continue;
                    }
                    DomainHandler.setDomainOptionSSL((DataObject)obj, (String)dom, (boolean)false);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(obj);
            }
            tile = "ConnectionSettings";
            try {
                int currentPort = SDInstallUtil.getWebServerPort();
                int newPort = Integer.parseInt(settingsDetailsObject.getString("PORT_NUMBER"));
                logger.log(Level.FINE, "New port value: " + newPort + "  currPort: " + currentPort);
                String message = "Successfully updated the Port";
                if (currentPort != newPort) {
                    int result = SDInstallUtil.changeWebServerPort((int)newPort);
                    if (result == 0) {
                        resultantJson.put("portsettingsmessage", (Object)"0");
                    } else if (result == 1) {
                        resultantJson.put("portsettingsmessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_already_in_use_Please_try_some_other_port_number"));
                        message = rb.getString("adap.Admin.Change_port_values.Port_number_already_in_use_Please_try_some_other_port_number");
                    } else if (result == 3) {
                        resultantJson.put("portsettingsmessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_out_of_range_Please_provide_a_valid_port_number"));
                        message = rb.getString("adap.Admin.Change_port_values.Port_number_out_of_range_Please_provide_a_valid_port_number");
                    }
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message + "\n" + rb.handleGetObject("adap.ChangePasswordAction.audit_entry.oldAndNewPort", new String[]{String.valueOf(currentPort), String.valueOf(newPort)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.ADAP_Port_updated", "-"}));
                }
            }
            catch (Exception ep) {
                String portsetmessage = ep.getMessage();
                resultantJson.put("portsettingsmessage", (Object)portsetmessage);
            }
            int time = 0;
            int timeout = 0;
            try {
                String sessionExpiryTime = settingsDetailsObject.get("SESSION_EXPIRY_TIME").toString();
                time = Integer.parseInt(sessionExpiryTime);
            }
            catch (Exception e) {
                time = 0;
            }
            if (time > 0) {
                timeout = time * 60;
            } else {
                time = -1;
                timeout = -1;
            }
            try {
                Integer expiryTime = (Integer)userSettingsRow.get("SESSION_EXPIRY_TIME");
                if (expiryTime == null || expiryTime != timeout) {
                    userSettingsRow.set("SESSION_EXPIRY_TIME", (Object)timeout);
                    ADSMPersUtil.setSessionExpiry((String)"..\\conf\\web.xml", (String)"..\\conf\\web.dtd", (String)String.valueOf(time));
                    request.getSession().setMaxInactiveInterval(timeout);
                    if (expiryTime != null && expiryTime != timeout) {
                        resultantJson.put("sessionexpirymessage", (Object)"0");
                    }
                    update = true;
                }
                if (update) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.session_Expiry_time_set", new String[]{String.valueOf(expiryTime)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.session_expirty_time_set", "-"}));
                    ADSMPersUtil.addOrUpdateUserAccountSettings((Row)userSettingsRow);
                }
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                resultantJson.put("sessionexpirymessage", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.session_expirty_time_set", "-"}));
                logger.log(Level.WARNING, "Exception while setting the session expiry time ", ex);
            }
            try {
                int newSSLPort;
                int currentSSLPort;
                boolean dbSSL = ADSMPersUtil.checkSSL();
                boolean formSSL = settingsDetailsObject.getBoolean("enableSSL");
                if (dbSSL != formSSL) {
                    if (formSSL) {
                        int sslPortNo = settingsDetailsObject.getInt("SSLPortNo");
                        ADSMPersUtil.updateSyMParameter((String)"SSL", (String)"true");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.Enabled_SSL_Port", new String[]{String.valueOf(sslPortNo)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.ssl_enabled", "-"}));
                        ADSMPersUtil.enableSSLPort((int)sslPortNo);
                    } else {
                        ADSMPersUtil.updateSyMParameter((String)"SSL", (String)"false");
                        ADSMPersUtil.disableSSLPort();
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ChangePasswordAction.audit_entry.Disabled_SSL_Port"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.ssl_disabled", "-"}));
                    }
                    resultantJson.put("Securitymessage", (Object)"0");
                } else if (dbSSL && formSSL && (currentSSLPort = SDInstallUtil.getSSLPort()) != (newSSLPort = Integer.valueOf(settingsDetailsObject.getInt("SSLPortNo")).intValue())) {
                    int result = SDInstallUtil.changeSSLPort((int)newSSLPort);
                    if (result == 0) {
                        resultantJson.put("Securitymessage", (Object)"0");
                    } else if (result == 1) {
                        resultantJson.put("Securitymessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_already_in_use_Please_try_some_other_port_number"));
                    } else if (result == 3) {
                        resultantJson.put("Securitymessage", (Object)rb.getString("adap.Admin.Change_port_values.Port_number_out_of_range_Please_provide_a_valid_port_number"));
                    }
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", resultantJson.getString("Securitymessage") + rb.handleGetObject("adap.ChangePasswordAction.audit_entry.oldAndNewPort", new String[]{String.valueOf(currentSSLPort), String.valueOf(newSSLPort)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.port_changed", "-"}));
                }
            }
            catch (Exception se) {
                String sslMessage = se.getMessage();
                resultantJson.put("Securitymessage", (Object)sslMessage);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", sslMessage, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.port_changed", "-"}));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while personalising ", e);
            throw new Exception("Exception while personalising");
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void saveServerSettings(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String settingsDetails = request.getParameter("settingsDetails");
        JSONObject settingsDetailsObject = new JSONObject(settingsDetails);
        String option = settingsDetailsObject.getString("selectedTile");
        StringBuffer buf = new StringBuffer();
        String tile = "";
        JSONObject resultantJson = new JSONObject();
        try {
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            boolean update = false;
            Row userSettingsRow = null;
            String loginName = request.getUserPrincipal().getName();
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            Long accountId = cred.getAccountId();
            userSettingsRow = ADSMPersUtil.getUserAccountSettings((Long)accountId);
            if (userSettingsRow == null) {
                userSettingsRow = new Row("UserSettings");
                userSettingsRow.set("USER_ACCOUNT_ID", (Object)accountId);
            }
            tile = "ServerSettings";
            try {
                boolean clientSetting = this.getDefaultClientSettings();
                logger.log(Level.FINE, "Current clientSetting : " + clientSetting);
                logger.log(Level.FINE, "UI clientSetting : " + settingsDetailsObject.getBoolean("LAUNCH_DEFAULT_BROWSER"));
                if (clientSetting != settingsDetailsObject.getBoolean("LAUNCH_DEFAULT_BROWSER")) {
                    this.clientSettings(settingsDetailsObject.getBoolean("LAUNCH_DEFAULT_BROWSER"));
                    buf.append(rb.getString("adap.ChangePasswordAction.General"));
                    resultantJson.put("generalsettingsmessage", (Object)"Successfully updated your general settings");
                }
                ADSMPersUtil.setGraphValue((String)settingsDetailsObject.getString("ExportReport"));
                boolean startServerCurrVal = this.isStartServerOnBootup();
                boolean startServerNewVal = settingsDetailsObject.getBoolean("START_SERVER_ON_BOOTUP");
                logger.log(Level.FINE, "Curr val Server start : " + startServerCurrVal + " & New value : " + startServerNewVal);
                if (startServerCurrVal != startServerNewVal) {
                    this.setServerStartOnBootup(startServerNewVal, request);
                    resultantJson.put("generalsettingsmessage", (Object)"Successfully updated your general settings");
                    if (buf.length() == 0) {
                        buf.append(rb.getString("adap.ChangePasswordAction.General"));
                    }
                }
                String usageStatistics = settingsDetailsObject.getString("USAGE_STATISTICS");
                ADSMPersUtil.updateSyMParameter((String)"USAGE_STATISTICS", (String)usageStatistics);
                String oldLogLevel = ADSMPersUtil.getCurrentLogLevel();
                String newLogLevel = settingsDetailsObject.getString("LOG_LEVEL");
                if (!oldLogLevel.equalsIgnoreCase(newLogLevel)) {
                    ADSMPersUtil.changeLogLevel((String)newLogLevel);
                    resultantJson.put("loglevelmessage", (Object)"Successfully updated your log level settings");
                    if (buf.length() == 0) {
                        buf.append(rb.getString("adap.ChangePasswordAction.Log_Level"));
                    } else {
                        buf.append(", " + rb.getString("adap.ChangePasswordAction.Log_Level"));
                    }
                }
                if (buf.length() != 0) {
                    buf.append(".");
                    buf.insert(0, rb.getString("adap.ChangePasswordAction.Successfully_updated_the_following_settings"));
                    resultantJson.put("errorMessage", (Object)buf.toString());
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", buf.toString(), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.server_settings_viewed", "-"}));
                }
            }
            catch (Exception e) {
                resultantJson.put("errorMessage", (Object)e.getMessage());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", e.getMessage(), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.server_settings_viewed", "-"}));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while personalising ", e);
            throw new Exception("Exception while personalising");
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    private void changePassword(String loginName, String oldPasswd, String newPasswd, HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            logger.log(Level.INFO, " ADAudit Plus Authentication Parameter included");
            AuthUtil.changePassword((String)loginName, (String)serviceName, (String)oldPasswd, (String)newPasswd, (String)"ADAuditPlus Authentication");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.pwd_changed", new String[]{loginName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.change_pwd_failed", "-"}));
        }
        catch (PasswordException ex) {
            logger.log(Level.WARNING, "Exception while changing password ", ex);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.problem_changed_pwd", new String[]{loginName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.change_pwd_failed", "-"}));
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception while changing password ", ex);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.problem_changed_pwd", new String[]{loginName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.change_pwd_failed", "-"}));
            throw ex;
        }
    }

    private boolean getDefaultClientSettings() throws Exception {
        String confFile = "../conf/client_params.conf";
        try {
            Properties props = StartupUtil.getProperties((String)confFile);
            logger.log(Level.FINE, "client settings prop : " + props);
            String launchBrowser = props.getProperty("LAUNCH_BROWSER_CLIENT");
            logger.log(Level.FINE, "Launch Browser value in Conf File: " + launchBrowser);
            return launchBrowser == null || !launchBrowser.equalsIgnoreCase("false");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while getting client startup settings from conf file: " + confFile, e);
            throw new Exception("Exception while getting startup settings");
        }
    }

    private boolean isStartServerOnBootup() throws Exception {
        String startServerOnBootup = null;
        try {
            String startupType = ADHandler.getServiceStartupType((String)"ADAudit Plus");
            logger.log(Level.FINE, "Service startup type retrieved using native call is: " + startupType);
            startServerOnBootup = startupType != null && startupType.equalsIgnoreCase("Manual") ? "false" : "true";
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while getting service startup type from the native.", ex);
        }
        String startUpTypeFromDB = ADSMPersUtil.getSyMParameter((String)"START_SERVER_ON_BOOTUP");
        if (startServerOnBootup == null && startUpTypeFromDB != null) {
            startServerOnBootup = startUpTypeFromDB;
        }
        if (startServerOnBootup == null) {
            startServerOnBootup = "true";
        }
        if (startUpTypeFromDB == null || !startUpTypeFromDB.equalsIgnoreCase(startServerOnBootup)) {
            startUpTypeFromDB = startServerOnBootup;
            ADSMPersUtil.updateSyMParameter((String)"START_SERVER_ON_BOOTUP", (String)startServerOnBootup);
        }
        return Boolean.valueOf(startServerOnBootup);
    }

    private void setServerStartOnBootup(boolean bool, HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String startupType = "Automatic";
        if (!bool) {
            startupType = "Manual";
        }
        logger.log(Level.FINE, "Going to change the startup type of service: ADAudit Plus to: " + startupType);
        ADHandler.setServiceStartupType((String)"ADAudit Plus", (boolean)bool);
        ADSMPersUtil.updateSyMParameter((String)"START_SERVER_ON_BOOTUP", (String)String.valueOf(bool));
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ChangePasswordAction.audit_entry.server_Startup_on_bootup", new String[]{startupType}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.server_seting_changed", "-"}));
    }

    private void clientSettings(Boolean launchDefaultBrowser) throws Exception {
        String confFile = "../conf/client_params.conf";
        try {
            logger.log(Level.FINE, "Launch Browser value from client: " + launchDefaultBrowser);
            Properties props = new Properties();
            props.setProperty("LAUNCH_BROWSER_CLIENT", launchDefaultBrowser.toString());
            logger.log(Level.FINE, "Launch Browser value from client: " + props + " & FILE " + confFile);
            StartupUtil.storeProperties((Properties)props, (String)confFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while updating launch browser client flag in conf file: " + confFile, e);
            throw new Exception("Exception while updating launch browser client");
        }
    }
}

