/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFileAPI;
import com.adventnet.sym.adsm.auditing.server.archive.DataArchiver;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogFileUtil;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogListener;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImportLogFileActionHandler {
    private static String event_task_name = "ImportLogSchedule";
    private static volatile ImportLogFileActionHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImportLogFileActionHandler getInstance() {
        if (instance != null) return instance;
        Class<ImportLogFileActionHandler> clazz = ImportLogFileActionHandler.class;
        synchronized (ImportLogFileActionHandler.class) {
            if (instance != null) return instance;
            instance = new ImportLogFileActionHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void viewImportLog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            StringBuffer buff = null;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String requestString = request.getParameter("viewLogDetails");
            JSONObject requestJson = new JSONObject(requestString);
            String sortColumn = requestJson.optString("sortColumn");
            String sortOrder = requestJson.optString("sortOrder");
            String pageNumber = requestJson.optString("PAGE_NUMBER");
            Integer fromIndex = requestJson.optInt("FROM_INDEX");
            Integer range = requestJson.optInt("RANGE");
            String b = requestJson.optString("deleteImportLog");
            HashMap<String, String> tableDetails = EmberTableConfig.getInstance().getTableDetails("16025");
            if (sortColumn == "") {
                sortColumn = tableDetails.get("SORTCOLUMN");
            }
            if (sortOrder == "") {
                sortOrder = tableDetails.get("SORTORDER");
            }
            if (fromIndex == 0) {
                fromIndex = 1;
            }
            if (range == 0) {
                range = Integer.parseInt(tableDetails.get("PAGELENGTH").toString());
            }
            if (pageNumber == "") {
                pageNumber = "1";
            }
            if (b != null && b.equalsIgnoreCase("true")) {
                buff = new StringBuffer(rb.getString("adap.AdminHandler.Successfully_Deleted"));
            } else if (b != null && b.equalsIgnoreCase("false")) {
                buff = new StringBuffer(rb.getString("adap.ModifyReportScheduler.Error_Occurred_while_Deleting_the"));
            }
            this.setAttribute(response, buff, "AudImportLogPathConfig-MODIFICATION_TIME", sortOrder, pageNumber, fromIndex, range, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createImportLog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject ret = new JSONObject();
        try {
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            String action = data.getString("action");
            Integer pathId = 0;
            if (action.equals("save")) {
                String reportType = data.getString("reportType");
                String importLogPath = data.getString("fileLocation");
                HashMap map = new HashMap();
                if (reportType.equalsIgnoreCase("once")) {
                    map = ImportLogFileUtil.getInstance().checkFolderPermission(importLogPath);
                } else {
                    importLogPath = importLogPath + File.separator + "*";
                    map = ImportLogFileUtil.getInstance().checkFolderPermission(importLogPath);
                }
                if (map != null && map.containsKey("errorMessage")) {
                    ret.put("message", map.get("errorMessage"));
                } else {
                    if (reportType.equalsIgnoreCase("once")) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(importLogPath);
                        ImportLogFileUtil.getInstance().addFileInDB(list, Integer.valueOf(0), reportType);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ImportLogFileAction.audit_entry.Successfully_Started_fetching_Event_Data_from_file", new String[]{importLogPath, reportType}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.fetched_event_data_from_evt", "-"}));
                        ret.put("message", (Object)rb.getString("adap.ImportLogFileAction.Successfully_Started_fetching_Event_Data_from_file"));
                        ret.put("success", true);
                    } else {
                        DataObject importLogDO = this.getImportLogDO(action, data);
                        Row row = importLogDO.getRow("AudImportLogPathConfig");
                        DataAccess.generateValues((Row)row);
                        pathId = (Integer)row.get("PATH_ID");
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(importLogDO);
                        ImportLogListener.getInstance().addArchiveFileInDB(pathId, reportType);
                        ret.put("message", (Object)rb.getString("adap.CreateImportLogFile.event_fetch_happened_while_schedule_run"));
                        ret.put("success", true);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.event_fetch_happened_while_schedule_run", new String[]{(String)row.get("EVENT_LOG_PATH"), reportType}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.fetched_event_data_from_evt", "-"}));
                    }
                    ImportLogFileUtil.getInstance().enableMetaTableEntry();
                }
            } else if (action.equals("update")) {
                DataObject dataObject = this.getImportLogDO(action, data);
                ImportLogFileUtil.getInstance().updateImportLog(dataObject, Long.valueOf(data.getLong("scheduleId")));
                ret.put("message", (Object)rb.getString("adap.ImportLogFileAction.Successfully_updated"));
                ret.put("success", true);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ImportLogFileAction.Successfully_updated"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_import_log", "-"}));
            }
        }
        catch (Exception ex) {
            ret.put("message", (Object)("Operation Failed " + ex.getMessage()));
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.CreateImportLogFile.audit_entry.Error_in_configuring_Import_Logs"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.fetched_event_data_from_evt", ex.getMessage()}));
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public DataObject getImportLogDO(String action, JSONObject createData) throws Exception {
        Integer timePeriod = 0;
        DataObject importLogDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row scheduleRow = new Row("Schedule");
        if (action.equalsIgnoreCase("update")) {
            scheduleRow.set("SCHEDULE_ID", (Object)createData.getLong("scheduleId"));
        }
        scheduleRow.set("SCHEDULE_NAME", createData.get("fileLocation"));
        scheduleRow.set("DESCRIPTION", createData.get("fileLocation"));
        importLogDO.addRow(scheduleRow);
        if (createData.get("reportType").toString().equalsIgnoreCase("hourly") || createData.get("reportType").toString().equalsIgnoreCase("once")) {
            Row periodicRow = new Row("Periodic");
            periodicRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            periodicRow.set("TIME_PERIOD", (Object)1L);
            periodicRow.set("UNIT_OF_TIME", (Object)"Hours");
            Date dateObj = new Date();
            dateObj.setHours(createData.getInt("selectedHour"));
            dateObj.setMinutes(createData.getInt("selectedMinute"));
            dateObj.setSeconds(0);
            periodicRow.set("START_DATE", (Object)new Timestamp(dateObj.getTime()));
            importLogDO.addRow(periodicRow);
        } else {
            Row calendarRow = new Row("Calendar");
            calendarRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            if (((String)createData.get("reportType")).equalsIgnoreCase("daily")) {
                timePeriod = Integer.valueOf(createData.getInt("selectedHour")) * 60 + Integer.valueOf(createData.getInt("selectedMinute"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
            } else if (((String)createData.get("reportType")).equalsIgnoreCase("weekly")) {
                timePeriod = Integer.valueOf(createData.getInt("selectedHour")) * 60 + Integer.valueOf(createData.getInt("selectedMinute"));
                calendarRow.set("DAY_OF_WEEK", (Object)createData.getInt("dayOfWeek"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
            }
            importLogDO.addRow(calendarRow);
        }
        Row taskInputRow = new Row("Task_Input");
        taskInputRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskInputRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)event_task_name));
        Long time = ScheduleUtil.calculateNextScheduleTime((DataObject)importLogDO, (Long)-1L, (boolean)false);
        taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(time));
        importLogDO.addRow(taskInputRow);
        Row taskRow = new Row("Scheduled_Task");
        taskRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskRow.set("AUDIT_FLAG", (Object)true);
        taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)event_task_name));
        taskRow.set("TRANSACTION_TIME", (Object)-1);
        taskRow.set("SKIP_MISSED_SCHEDULE", (Object)true);
        importLogDO.addRow(taskRow);
        if (action.equalsIgnoreCase("update")) {
            Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogPathConfig", (String)"SCHEDULE_ID"), createData.get("scheduleId"), 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AudImportLogPathConfig", crit);
            Row pathRow = dataObject.getRow("AudImportLogPathConfig");
            pathRow.set("PATH_ID", pathRow.get("PATH_ID"));
            pathRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            pathRow.set("REPORT_TYPE", createData.get("reportType"));
            importLogDO.addRow(pathRow);
        } else {
            Row pathRow = new Row("AudImportLogPathConfig");
            pathRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            pathRow.set("REPORT_TYPE", createData.get("reportType"));
            pathRow.set("EVENT_LOG_PATH", (Object)((String)createData.get("fileLocation")));
            importLogDO.addRow(pathRow);
        }
        return importLogDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAdminStatus(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        StringBuffer buff = new StringBuffer();
        try {
            String requestString = request.getParameter("adminStatus");
            JSONObject requestJson = new JSONObject(requestString);
            Long scheduleId = requestJson.getLong("scheduleId");
            Integer adminStatus = requestJson.getInt("ADMIN_STATUS");
            ImportLogFileUtil.getInstance().changeAdminStatus(scheduleId, adminStatus);
            Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
            if ((long)adminStatus.intValue() == 3L) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_enabled_import_log_schedule", new String[]{(String)row.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                buff.append(rb.getString("adap.NetlogonLogAction.Successfully_enabled"));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_disabled_import_log_schedule", new String[]{(String)row.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                buff.append(rb.getString("adap.NetlogonLogAction.Successfully_disabled"));
            }
        }
        catch (Exception ex) {
            buff = new StringBuffer();
            buff.append(ex.getMessage());
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Problem_enabling_Disabling_import_log_schedule", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
        }
        finally {
            this.setAttribute(response, buff, "AudImportLogPathConfig-MODIFICATION_TIME", "desc", "1", 1, 25, rb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteScheduler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        StringBuffer buff = new StringBuffer();
        try {
            Long scheduleId = new Long(request.getParameter("scheduleId"));
            Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
            ImportLogFileUtil.getInstance().deleteScheduler(scheduleId);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.successfully_deleted_import_log_scheduler", new String[]{(String)row.get("SCHEDULE_NAME")}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_import_log", "-"}));
            buff.append(rb.getString("adap.AdminHandler.Successfully_Deleted"));
        }
        catch (Exception ex) {
            buff = new StringBuffer();
            buff.append(ex.getMessage());
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.probllem_while_deleting_import_log_scheduler", new String[]{ex.getMessage()}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_import_log", "-"}));
        }
        finally {
            this.setAttribute(response, buff, "AudImportLogPathConfig-MODIFICATION_TIME", "desc", "1", 1, 25, rb);
        }
    }

    public void setAttribute(HttpServletResponse response, StringBuffer buff, String sortColumn, String sortOrder, String pageNumber, Integer fromIndex, Integer range, AdventNetResourceBundle rb) {
        try {
            String noOfDays;
            JSONObject responseJson = new JSONObject();
            int count = ImportLogFileUtil.getInstance().getPathCount();
            ArrayList list = new ArrayList();
            JSONObject tableInputParams = new JSONObject();
            JSONObject tableData = new JSONObject();
            tableInputParams.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
            if (count > 0) {
                list = ImportLogFileUtil.getInstance().getImportLogList(sortColumn, sortOrder, Integer.valueOf(count), fromIndex, range);
                String cvid = "16025";
                JSONObject ret = EmberTableConfig.getInstance().getEmberTableData(cvid, list, new JSONObject(), rb);
                tableInputParams = ret.getJSONObject("tableInputParams");
                tableInputParams.put("startValue", (Object)fromIndex);
                tableInputParams.put("totalCount", count);
                JSONArray rangeList = new JSONArray();
                for (int i = 0; i < 4; ++i) {
                    JSONObject rangeItem = new JSONObject();
                    rangeItem.put("value", (i + 1) * 25);
                    rangeList.put((Object)rangeItem);
                }
                tableInputParams.put("rangeList", (Object)rangeList);
                tableInputParams.put("rangeValue", (Object)range);
                tableData = ret.getJSONObject("tableData");
            }
            Row row = ArchiveFileAPI.getInstance().getArchiveConfig();
            DataArchiver.getInstance();
            String baseArchiveDir = DataArchiver.getBaseArchiveDirectory();
            if (row != null) {
                baseArchiveDir = (String)row.get("BASE_ARCHIVE_DIRECTORY");
            }
            if ((noOfDays = ADSMPersUtil.getSyMParameter((String)"IMPORT_LOG_ARCHIVE_DAYS")) == "0") {
                noOfDays = "";
            }
            responseJson.put("localWinVer", (Object)System.getProperty("os.version"));
            responseJson.put("noOfDays", (Object)noOfDays);
            responseJson.put("baseArchiveDir", (Object)baseArchiveDir);
            responseJson.put("tableData", (Object)tableData);
            responseJson.put("tableInputParams", (Object)tableInputParams);
            responseJson.put("RANGE", (Object)range);
            responseJson.put("list", (Object)list);
            responseJson.put("count", count);
            responseJson.put("PAGE_NUMBER", (Object)pageNumber);
            if (buff != null) {
                responseJson.put("message", (Object)buff.toString());
            }
            responseJson.put("configData", (Object)this.getImportLogConfigData(rb));
            JSONObject createData = new JSONObject();
            createData.put("reportType", (Object)"hourly");
            createData.put("selectedHour", (Object)"1");
            createData.put("selectedMinute", (Object)"10");
            createData.put("dayOfWeek", (Object)"3");
            responseJson.put("createData", (Object)createData);
            JsonResponse.getInstance().sendResponse(response, responseJson.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JSONObject getImportLogConfigData(AdventNetResourceBundle rb) {
        JSONObject ret = new JSONObject();
        try {
            Integer[] hourOfDay = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            Integer[] minutes = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
            String[] daysOfWeek = new String[]{rb.getString("adap.ReportSchedulerBean.Sunday"), rb.getString("adap.ReportSchedulerBean.Monday"), rb.getString("adap.ReportSchedulerBean.Tuesday"), rb.getString("adap.ReportSchedulerBean.Wednesday"), rb.getString("adap.ReportSchedulerBean.Thursday"), rb.getString("adap.ReportSchedulerBean.Friday"), rb.getString("adap.ReportSchedulerBean.Saturday")};
            Integer[] daysOfWeekValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            JSONArray hourOfDayArray = new JSONArray();
            for (int i = 0; i < hourOfDay.length; ++i) {
                JSONObject hourObject = new JSONObject();
                hourObject.put("name", (Object)hourOfDay[i]);
                hourObject.put("value", (Object)hourOfDay[i]);
                hourOfDayArray.put((Object)hourObject);
            }
            JSONArray minutesArray = new JSONArray();
            for (int i = 0; i < minutes.length; ++i) {
                JSONObject minObject = new JSONObject();
                minObject.put("name", (Object)minutes[i]);
                minObject.put("value", (Object)minutes[i]);
                minutesArray.put((Object)minObject);
            }
            JSONArray daysArray = new JSONArray();
            for (int i = 0; i < daysOfWeek.length; ++i) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)rb.getString(daysOfWeek[i]));
                onObject.put("value", (Object)daysOfWeekValues[i]);
                daysArray.put((Object)onObject);
            }
            ret.put("hoursArray", (Object)hourOfDayArray);
            ret.put("minutesArray", (Object)minutesArray);
            ret.put("daysArray", (Object)daysArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void viewArchiveFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        StringBuffer buff = new StringBuffer();
        try {
            String requestString = request.getParameter("logHistoryDetails");
            JSONObject requestJson = new JSONObject(requestString);
            Integer pathId = requestJson.getInt("PATH_ID");
            Integer fromIndex = requestJson.optInt("FROM_INDEX");
            String pageNumber = requestJson.optString("PAGE_NUMBER");
            Integer range = requestJson.optInt("RANGE");
            if (fromIndex == 0) {
                fromIndex = 1;
            }
            if (range == 0) {
                HashMap<String, String> tableDetails = EmberTableConfig.getInstance().getTableDetails("16025");
                range = Integer.parseInt(tableDetails.get("PAGELENGTH").toString());
            }
            if (pageNumber == "") {
                pageNumber = "1";
            }
            this.setArchiveFiles(response, pathId, fromIndex, pageNumber, range, rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setArchiveFiles(HttpServletResponse response, Integer pathId, Integer fromIndex, String pageNumber, Integer range, AdventNetResourceBundle rb) throws Exception {
        int count = ImportLogFileUtil.getInstance().getArchiveFileCount(pathId);
        ArrayList list = new ArrayList();
        JSONObject responseJson = new JSONObject();
        JSONObject tableInputParams = new JSONObject();
        JSONObject tableData = new JSONObject();
        tableInputParams.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
        if (count > 0) {
            list = ImportLogFileUtil.getInstance().getArchiveFileList(pathId, Integer.valueOf(count), fromIndex, range);
            String cvid = "16026";
            JSONObject ret = EmberTableConfig.getInstance().getEmberTableData(cvid, list, new JSONObject(), rb);
            tableInputParams = ret.getJSONObject("tableInputParams");
            tableInputParams.put("startValue", (Object)fromIndex);
            tableInputParams.put("totalCount", count);
            JSONArray rangeList = new JSONArray();
            for (int i = 0; i < 4; ++i) {
                JSONObject rangeItem = new JSONObject();
                rangeItem.put("value", (i + 1) * 25);
                rangeList.put((Object)rangeItem);
            }
            tableInputParams.put("rangeList", (Object)rangeList);
            tableInputParams.put("rangeValue", (Object)range);
            tableData = ret.getJSONObject("tableData");
        }
        responseJson.put("tableData", (Object)tableData);
        responseJson.put("tableInputParams", (Object)tableInputParams);
        responseJson.put("RANGE", (Object)range);
        responseJson.put("list", (Object)list);
        responseJson.put("count", count);
        responseJson.put("PATH_ID", (Object)pathId);
        responseJson.put("PAGE_NUMBER", (Object)pageNumber);
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void changeArchiveStatus(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject responseJson = new JSONObject();
        try {
            String noOfDays = request.getParameter("noOfDays");
            Integer val = 3;
            if (noOfDays.equals("0")) {
                val = 4;
            }
            String scheduleIdUVH = "Schedule:schedule_id:UVH@5001";
            Long scheduleId = DBObjectUtil.getUVHValues((String)"Schedule", (String)scheduleIdUVH);
            ImportLogFileUtil.getInstance().changeAdminStatus(scheduleId, val);
            if (!noOfDays.equals("0")) {
                ImportLogFileUtil.getInstance().updateTaskInput(scheduleId, noOfDays);
                ImportLogFileUtil.getInstance().updatePeriodic(scheduleId, noOfDays);
            }
            ADSMPersUtil.updateSyMParameter((String)"IMPORT_LOG_ARCHIVE_DAYS", (String)noOfDays);
            if (noOfDays.equals("0")) {
                responseJson.put("message", (Object)rb.getString("adap.ObjectDetails.view_props.user.common.statmsg.disabled"));
                Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_disabled_import_log_schedule", new String[]{(String)row.get("SCHEDULE_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Successfully_updated_imported_log_archive_days", new String[]{noOfDays}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
                responseJson.put("message", (Object)rb.getString("adap.AuditReportAction.Successfully_Saved"));
            }
        }
        catch (Exception ex) {
            responseJson.put("message", (Object)ex.getMessage());
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Problem_updating_import_log_file", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_import_log", "-"}));
            ex.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }

    public void runArchiveFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject responseJson = new JSONObject();
        try {
            Integer fileId = new Integer(request.getParameter("FILE_ID"));
            Row row = ImportLogFileUtil.getInstance().getImportFileRow("FILE_ID", (Object)fileId);
            Integer pathId = (Integer)row.get("PATH_ID");
            HashMap<String, Object> map = new HashMap<String, Object>();
            String filePath = (String)row.get("FILE_NAME");
            if (pathId == 0) {
                map.put("FILE_ID", fileId);
            } else {
                Row pathRow = ImportLogFileUtil.getInstance().getLogPathRow("PATH_ID", (Object)pathId);
                filePath = (String)pathRow.get("EVENT_LOG_PATH") + File.separator + row.get("FILE_NAME").toString();
                map.put("FILE_ID", fileId);
            }
            map.put("FILE_NAME", filePath);
            ImportLogListener.getInstance().readArchiveLog(map);
            responseJson.put("message", (Object)rb.handleGetObject("adap.DomainAction.Successfully_scheduled_the_event_collection_file", new String[]{filePath}));
            responseJson.put("messageType", (Object)"SUCCESS");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.DomainAction.Successfully_scheduled_the_event_collection_file", new String[]{filePath}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.evt_collection_scheduled", "-"}));
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                responseJson.put("message", (Object)ex.getMessage());
                responseJson.put("messageType", (Object)"ERROR");
            } else {
                responseJson.put("message", (Object)rb.getString("adap.admin.importlog_path_Exception_text"));
                responseJson.put("messageType", (Object)"ERROR");
            }
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.CreateImportLogFile.audit_entry.Problem_running_import_log_file", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.evt_collection_scheduled", "-"}));
        }
        JsonResponse.getInstance().sendResponse(response, responseJson.toString());
    }
}

