/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventCollectionUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RunQueryHandler {
    private static volatile RunQueryHandler instance = null;
    private static Logger logger = Logger.getLogger(RunQueryHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RunQueryHandler getInstance() {
        if (instance != null) return instance;
        Class<RunQueryHandler> clazz = RunQueryHandler.class;
        synchronized (RunQueryHandler.class) {
            if (instance != null) return instance;
            instance = new RunQueryHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void executeQuery(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String data = request.getParameter("data");
            JSONObject jo = new JSONObject(data);
            String query = jo.getString("query");
            ret.put("errorMessage", (Object)rb.getString("adap.RunQuery.Error_in_query"));
            if (query.length() > 6) {
                ret = RunQueryHandler.executeQuery(query, request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static JSONObject executeQuery(String query, HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            logger.log(Level.INFO, "Going to executeQuery : " + query);
            String task = query.substring(0, 6);
            if (task.equalsIgnoreCase("select") || task.substring(0, 4).equalsIgnoreCase("desc") || task.substring(0, 4).equalsIgnoreCase("show")) {
                ret = QueryUtil.executeEmberQuery((String)query);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.handleGetObject("adap.RunQuery.The_Query_is", new String[]{query, ret.opt("errorMessage") != null ? "Failure" : "Success"}), 4, ret.opt("errorMessage") != null ? 16 : 8, "adap.ADAPUserAuditSeverities.audit_name.data_viewed", "-"}));
            } else if (task.equalsIgnoreCase("update") || task.equalsIgnoreCase("insert") || task.equalsIgnoreCase("delete")) {
                int rowsAffected = QueryUtil.executeUpdate((String)query);
                ret.put("message", (Object)("Query successfully executed. " + rowsAffected + " rows affected."));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.handleGetObject("adap.RunQuery.The_updated_Query_is", new String[]{query, "Success"}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
            }
        }
        catch (Exception exp1) {
            exp1.printStackTrace();
            try {
                ret.put("errorMessage", (Object)(rb.getString("adap.RunQuery.Error_executing_query") + " " + exp1.getMessage()));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.handleGetObject("adap.RunQuery.The_failed_updated_Query_is", new String[]{query, "Failure", exp1.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static void ntlmConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String data = request.getParameter("data");
            JSONObject jo = new JSONObject(data);
            String action = jo.getString("action");
            if (action.equals("disable")) {
                boolean disableStatus = AuditEventAPI.deleteNTLMEventsForAudit();
                if (disableStatus) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.getString("adap.RunQuery.Successfully_disabled_NTLM_for_Auditing"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                    logger.log(Level.INFO, rb.getString("adap.RunQuery.Successfully_disabled_NTLM_for_Auditing"));
                    ret.put("message", (Object)rb.getString("adap.RunQuery.Successfully_disabled_NTLM_for_Auditing"));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.getString("adap.RunQuery.Failed_to_disable_NTLM_for_Auditing"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                    logger.log(Level.INFO, rb.getString("adap.RunQuery.Failed_to_disable_NTLM_for_Auditing"));
                    ret.put("message", (Object)rb.getString("adap.RunQuery.Failed_to_disable_NTLM_for_Auditing"));
                }
            } else if (action.equals("enable")) {
                boolean enableStatus = AuditEventAPI.addNTLMEventsForAudit();
                if (enableStatus) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.getString("adap.RunQuery.Successfully_enabled_NTLM_for_Auditing"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                    logger.log(Level.INFO, rb.getString("adap.RunQuery.Successfully_enabled_NTLM_for_Auditing"));
                    ret.put("message", (Object)rb.getString("adap.RunQuery.Successfully_enabled_NTLM_for_Auditing"));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Run Query", rb.getString("adap.RunQuery.Failed_to_enable_NTLM_for_Auditing"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                    logger.log(Level.INFO, rb.getString("adap.RunQuery.Failed_to_enable_NTLM_for_Auditing"));
                    ret.put("message", (Object)rb.getString("adap.RunQuery.Failed_to_enable_NTLM_for_Auditing"));
                }
            }
            boolean isEnabled = AuditEventAPI.isNTLMEnabled();
            if (isEnabled) {
                ret.put("isEnabled", true);
                if (action.equals("check")) {
                    ret.put("message", (Object)rb.getString("adap.RunQuery.ntlm_enabled"));
                }
            } else {
                ret.put("isDisabled", true);
                if (action.equals("check")) {
                    ret.put("message", (Object)rb.getString("adap.RunQuery.ntlm_disabled"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void rmConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            String message;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String data = request.getParameter("data");
            JSONObject jo = new JSONObject(data);
            String action = jo.getString("action");
            if (action.equals("local")) {
                message = EventCollectionUtil.useOwnMsgDll();
                logger.log(Level.INFO, "Updating Message Resource :: " + message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Run Query", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                ret.put("message", (Object)message);
            } else if (action.equals("remote")) {
                message = EventCollectionUtil.useRemoteMessageDLL();
                logger.log(Level.INFO, "Updating Message Resource :: " + message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Run Query", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                ret.put("message", (Object)message);
            }
            boolean isLocalMessage = EventCollectionUtil.useLocalMessageDLL();
            if (isLocalMessage) {
                ret.put("isLocal", true);
                if (action.equals("check")) {
                    ret.put("message", (Object)rb.getString("adap.RunQuery.resource_message_local"));
                }
            } else {
                ret.put("isRemote", true);
                if (action.equals("check")) {
                    ret.put("message", (Object)rb.getString("adap.RunQuery.resource_message_remote"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void ipConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String data = request.getParameter("data");
            JSONObject jo = new JSONObject(data);
            String action = jo.getString("action");
            if (action.equals("get")) {
                ret.put("resolverType", (Object)DNSResolver.getResolverType());
            } else if (action.equals("set")) {
                DNSResolver.setResolverType((String)jo.getString("type"));
                logger.log(Level.INFO, "Setting IP Resolver Type : " + jo.getString("type"));
                String type = DNSResolver.getResolverType();
                ret.put("message", (Object)rb.handleGetObject("adap.RunQuery.ipresolver_set", new String[]{type.toUpperCase()}));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Run Query", rb.handleGetObject("adap.RunQuery.ipresolver_set", new String[]{jo.getString("type")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.data_updated", "-"}));
                ret.put("resolverType", (Object)type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void fetchModeConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String data = request.getParameter("data");
            JSONObject jo = new JSONObject(data);
            String action = jo.getString("action");
            if (action.equals("getMachinesList")) {
                JSONArray machinesArray = new JSONArray();
                ArrayList machinesList = null;
                String type = jo.getString("type");
                machinesList = type.equals("AUDDcEventRead") ? CommonUtil.getDCEventFetchMode((String)"ADSMDCConfiguration", (String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID", (String)"DOMAIN_CONTROLLER_ID", (String)"DOMAIN_CONTROLLER_NAME") : CommonUtil.getComputersAndEventFetchMode((String)"ADSMComputerGeneralDetails", (String)"AUDComputerEventRead", (String)"OBJECT_GUID", (String)"COMPUTER_ID", (String)"NAME");
                for (int i = 0; i < machinesList.size(); ++i) {
                    Hashtable computerInfo = (Hashtable)machinesList.get(i);
                    JSONObject machine = new JSONObject();
                    String name = (String)computerInfo.get("Name");
                    Long fetchMode = Long.valueOf((String)computerInfo.get("FetchMode"));
                    name = fetchMode == 0L ? name + " : WMI" : (fetchMode == 1L ? name + " : Native" : (fetchMode == 2L ? name + " : EvtQuery" : name + " : RealTime"));
                    machine.put("name", (Object)name);
                    machine.put("value", computerInfo.get("Id"));
                    machine.put("fetchMode", (Object)fetchMode);
                    machinesArray.put((Object)machine);
                }
                ret.put("machinesArray", (Object)machinesArray);
                JSONArray fetchModes = new JSONArray();
                fetchModes.put((Object)new JSONObject("{name:'WMI',value:'0'}"));
                fetchModes.put((Object)new JSONObject("{name:'Native',value:'1'}"));
                String localWinVersion = System.getProperty("os.version");
                if (localWinVersion.startsWith("6.")) {
                    fetchModes.put((Object)new JSONObject("{name:'EvtQuery',value:'2'}"));
                    if (type.equals("AUDDcEventRead")) {
                        fetchModes.put((Object)new JSONObject("{name:'RealTime',value:'3'}"));
                    }
                }
                ret.put("fetchModes", (Object)fetchModes);
            } else if (action.equals("setFetchMode")) {
                String query = "update " + jo.getString("machineType") + " set EVENT_FETCH_MODE = " + jo.getString("fetchMode") + " where ";
                query = jo.getString("machineType").equals("AUDDcEventRead") ? query + "DOMAIN_CONTROLLER_ID in (" : query + "COMPUTER_ID in (";
                JSONArray machineIds = jo.getJSONArray("machineIds");
                for (int i = 0; i < machineIds.length(); ++i) {
                    query = query + machineIds.getString(i) + ",";
                }
                query = query.substring(0, query.length() - 1);
                query = query + ")";
                ret = RunQueryHandler.executeQuery(query, request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)("Failed : " + e.getMessage()));
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getMachineDetails(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            JSONArray rows = new JSONArray();
            Properties system = System.getProperties();
            String[] key = new String[]{"os.name", "os.arch", "os.version", "user.name", "user.dir", "user.language"};
            for (int i = 0; i < key.length; ++i) {
                JSONObject row = new JSONObject();
                row.put("key", (Object)key[i]);
                row.put("val", system.get(key[i]));
                rows.put((Object)row);
            }
            JSONObject hostName = new JSONObject();
            hostName.put("key", (Object)"Host Name");
            hostName.put("val", (Object)InetAddress.getLocalHost().getHostName());
            rows.put((Object)hostName);
            JSONObject buildNo = new JSONObject();
            buildNo.put("key", (Object)"Build Number");
            buildNo.put("val", (Object)CommonUtil.getBuildNumber());
            rows.put((Object)buildNo);
            JSONObject db = new JSONObject();
            db.put("key", (Object)"Database");
            db.put("val", (Object)CommonUtil.getDBServerName());
            rows.put((Object)db);
            ret.put("rows", (Object)rows);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

