/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.auditing.webclient.reports.scheduler.SchedulerBeanUtil;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScheduleReportsHandler {
    private static volatile ScheduleReportsHandler instance = null;
    private static Logger logger = Logger.getLogger(ScheduleReportsHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduleReportsHandler getInstance() {
        if (instance != null) return instance;
        Class<ScheduleReportsHandler> clazz = ScheduleReportsHandler.class;
        synchronized (ScheduleReportsHandler.class) {
            if (instance != null) return instance;
            instance = new ScheduleReportsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getList(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String cvid = "15010";
            String sortColumn = request.getParameter("sortColumn");
            String sortOrder = request.getParameter("sortOrder");
            HashMap<String, String> tableDetails = EmberTableConfig.getInstance().getTableDetails(cvid);
            if (sortColumn == null) {
                sortColumn = tableDetails.get("SORTCOLUMN");
            }
            if (sortOrder == null) {
                sortOrder = tableDetails.get("SORTORDER");
            }
            JSONObject addnParamsMap = new JSONObject();
            addnParamsMap.put("sortColumn", (Object)sortColumn);
            addnParamsMap.put("sortOrder", (Object)sortOrder);
            addnParamsMap.put("readOnly", request.getAttribute("readOnly"));
            ArrayList<HashMap<String, String>> columnsList = EmberTableConfig.getInstance().getColumnsList(cvid, rb);
            for (int i = 0; i < columnsList.size(); ++i) {
                HashMap<String, String> columnMap = columnsList.get(i);
                String columnAlias = columnMap.get("columnalias");
                if (!columnAlias.equals(sortColumn)) continue;
                String tableAlias = columnMap.get("tablealias");
                sortColumn = tableAlias + "-" + sortColumn;
            }
            ArrayList schedulerReportsList = ReportSchedulerUtil.getSchedulersList((String)sortColumn, (String)sortOrder);
            ret = EmberTableConfig.getInstance().getEmberTableData(cvid, schedulerReportsList, addnParamsMap, rb);
            JSONObject tableInputParams = ret.getJSONObject("tableInputParams");
            tableInputParams.put("isHideOverFlowX", true);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.ViewReportScheduler.Schedule_Report_page_viewed"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.report_scheduler_viewed", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void viewReportsHistory(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String data = request.getParameter("data");
            JSONObject data2 = new JSONObject(data);
            Long scheduleId = data2.getLong("scheduleId");
            JSONArray historyList = ReportSchedulerUtil.getReportSchedulerHistory2((Long)scheduleId);
            ret.put("reportsList", (Object)historyList);
            Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.ViewReportScheduler.Schedule_Report_hist_Viewed", new String[]{(String)row.get("SCHEDULE_NAME")}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.report_scheduler_history_viewed", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void enableDisableScheduleReport(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String data = request.getParameter("data");
            JSONObject data2 = new JSONObject(data);
            Long scheduleId = data2.getLong("scheduleId");
            String status = data2.getString("status");
            ret.put("message", (Object)rb.getString("adap.ReportScheduler.audit_entry.Problem_while_enabling_disabling_schedule_reports"));
            String retStatus = rb.getString("adap.common.text.manage_link.disable");
            if (status.equalsIgnoreCase("Enable")) {
                retStatus = rb.getString("adap.common.text.manage_link.enable");
            }
            SchedulerUtil.enableDisableScheduler((Long)scheduleId, (String)status);
            ret.put("success", true);
            ret.put("message", (Object)rb.handleGetObject("adap.ReportScheduler.Successfully_requestgetParameterstatusd_the_scheduled_report", new String[]{retStatus}));
            Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ReportScheduler.Successfully_requestgetParameterstatusd_the_scheduled_report", new String[]{retStatus}) + (String)row.get("SCHEDULE_NAME"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)e.getMessage());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ReportScheduler.audit_entry.Problem_while_enabling_disabling_schedule_reports"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void deleteScheduleReport(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String data = request.getParameter("data");
            JSONObject data2 = new JSONObject(data);
            Long scheduleId = data2.getLong("scheduleId");
            Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)scheduleId, (int)0);
            ReportSchedulerUtil.deleteScheduler((Long)scheduleId);
            ret.put("success", true);
            ret.put("message", (Object)rb.getString("adap.DeleteReportScheduler.Successfully_Deleted_the_Scheduler_Report"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteReportScheduler.audit_entry.Successfully_deleted", new String[]{(String)row.get("SCHEDULE_NAME")}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)e.getMessage());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteReportScheduler.audit_entry.Failed_to_delete", new String[]{e.getMessage()}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getAvailableReports(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            String domainName = request.getParameter("domainName");
            JSONObject result = ScheduleReportsHandler.getReportProfiles(request, domainName, new HashMap());
            ret.put("reportCategories", (Object)result.getJSONArray("reportCategories"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void getScheduleReportConfig(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String domainName = request.getParameter("domainName");
            JSONObject configData = new JSONObject();
            JSONObject reportData = new JSONObject();
            configData = this.getConfigData(rb);
            String fileStoragePath = ReportSchedulerUtil.getFileStoragePath();
            reportData.put("fileStoragePath", (Object)fileStoragePath);
            reportData.put("hoursValue", 0);
            reportData.put("minsValue", 0);
            reportData.put("forValue", (Object)"Yesterday");
            reportData.put("onValue", (Object)"");
            reportData.put("selectedFreq", (Object)"daily");
            reportData.put("formatValue", (Object)"pdf");
            reportData.put("isMailNotify", false);
            reportData.put("mailAddress", (Object)"");
            reportData.put("mailContent", (Object)"Content");
            reportData.put("mailSubject", (Object)"ADAudit Plus - Schedule Reports");
            reportData.put("sendingOptions", (Object)"ATTACHMENT");
            reportData.put("isZipFile", true);
            reportData.put("BUSINESS_HOUR", (Object)"false");
            reportData.put("isReportsEmpty", true);
            reportData.put("isSingleFolder", false);
            String scheduleIdStr = request.getParameter("scheduleId");
            HashMap reportInputs = new HashMap();
            if (scheduleIdStr != null) {
                Long scheduleId = Long.parseLong(scheduleIdStr);
                reportData = this.getReportData(scheduleId, reportInputs);
            }
            JSONObject result = ScheduleReportsHandler.getReportProfiles(request, domainName, reportInputs);
            configData.put("reportCategories", (Object)result.getJSONArray("reportCategories"));
            reportData.put("selectedReportCategories", (Object)result.getJSONArray("selectedReportCategories"));
            ret.put("configData", (Object)configData);
            ret.put("reportData", (Object)reportData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static JSONObject getReportProfiles(HttpServletRequest request, String domainName, HashMap reportInputs) {
        JSONObject result = new JSONObject();
        try {
            JSONArray reportCategories = new JSONArray();
            JSONArray selectedReportCategories = new JSONArray();
            request.getSession().setAttribute("ADAP_SESSION_LOGIN_ID", (Object)1L);
            LinkedHashMap reportMap = AuditReportCategoryHandler.getReportCategories((String)domainName, null, (HttpServletRequest)request, (boolean)true);
            if (!reportMap.isEmpty()) {
                Set keys = reportMap.keySet();
                for (Object object : keys) {
                    HashMap reportCategoryMap = (HashMap)reportMap.get(object);
                    ArrayList reportCategoryList = (ArrayList)reportCategoryMap.get("CATEGORY_REPORTS");
                    Long divId = (Long)reportCategoryMap.get("REPORT_CATEGORY_ID");
                    JSONObject reportCategoryObject = new JSONObject();
                    reportCategoryObject.put("categoryId", (Object)divId);
                    reportCategoryObject.put("categoryName", reportCategoryMap.get("SR_NAME"));
                    JSONArray reportsArray = new JSONArray();
                    JSONArray selectedReportsArray = new JSONArray();
                    if (reportCategoryList.isEmpty()) continue;
                    if ((Long)reportCategoryMap.get("REPORT_CATEGORY_ID") != 1L) {
                        for (int j = 0; j < reportCategoryList.size(); ++j) {
                            HashMap reportDetailsMap = (HashMap)reportCategoryList.get(j);
                            Long reportId = (Long)reportDetailsMap.get("AUDIT_REPORT_ID");
                            String reportName = (String)reportDetailsMap.get("AUDIT_REPORT_NAME");
                            JSONObject report = new JSONObject();
                            ArrayList formElement = AuditReportParamsAPI.getReportFormElements((Long)reportId, (boolean)true);
                            Long elementId = -1L;
                            String className = "";
                            JSONArray tabsArray = new JSONArray();
                            if (formElement.size() > 0) {
                                report.put("inputNeeded", true);
                                HashMap eleMap = (HashMap)formElement.get(0);
                                elementId = (Long)eleMap.get("elementId");
                                Properties attrProps = (Properties)eleMap.get("attributeProps");
                                String onClickStr = (String)attrProps.get("onclick");
                                onClickStr = onClickStr.substring(onClickStr.indexOf("(this"));
                                String cvidStr = onClickStr.split(",")[1];
                                String objClassStr = onClickStr.split(",")[2];
                                cvidStr = cvidStr.replaceAll("\\s", "").replaceAll("&#34", "");
                                objClassStr = objClassStr.replaceAll("\\s", "").replaceAll("&#34", "");
                                String[] cvid = cvidStr.split(";");
                                String[] objClass = objClassStr.split(";");
                                for (int c = 0; c < cvid.length; ++c) {
                                    if (!cvid[c].equals("")) {
                                        ObjectClass objectClass;
                                        String objectClassStr;
                                        JSONObject tab = new JSONObject();
                                        tab.put("cv_id", (Object)cvid[c]);
                                        if (objClass.length > c) {
                                            objectClassStr = objClass[c].replaceAll("'", "");
                                            tab.put("objectClass", (Object)objectClassStr);
                                            objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClassStr);
                                            tab.put("displayText", (Object)objectClass.getDisplayText());
                                        } else {
                                            objectClassStr = objClass[0].replaceAll("'", "");
                                            tab.put("objectClass", (Object)objectClassStr);
                                            objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClassStr);
                                            tab.put("displayText", (Object)objectClass.getDisplayText());
                                        }
                                        tabsArray.put((Object)tab);
                                    }
                                    if (c != 0) continue;
                                    String resObjectClass = objClass[0];
                                    if (resObjectClass.equals("")) {
                                        resObjectClass = objClass[1];
                                    }
                                    if (resObjectClass.contains("'user'") || resObjectClass.contains("user")) {
                                        className = "adap-icon icn-users";
                                        continue;
                                    }
                                    if (resObjectClass.contains("'computer'") || resObjectClass.contains("computer")) {
                                        className = "adap-icon icn-computer";
                                        continue;
                                    }
                                    if (resObjectClass.contains("'share'") || resObjectClass.contains("share")) {
                                        className = "adap-icon icn-share-plus";
                                        continue;
                                    }
                                    if (resObjectClass.contains("'printer'") || resObjectClass.contains("printer")) {
                                        className = "adap-icon icn-printer";
                                        continue;
                                    }
                                    if (resObjectClass.contains("'organizationalUnit'") || resObjectClass.contains("organizationalUnit")) {
                                        className = "adap-icon icn-ou";
                                        continue;
                                    }
                                    if (resObjectClass.contains("'groupPolicyContainer'") || resObjectClass.contains("groupPolicyContainer")) {
                                        className = "adap-icon icn-gpo";
                                        continue;
                                    }
                                    if (!resObjectClass.contains("'group'") && !resObjectClass.contains("group")) continue;
                                    className = "adap-icon icn-group";
                                }
                            }
                            if (reportDetailsMap.get("FAVOURITE_ID") != null) continue;
                            int ijk = 100;
                            report.put("AUDIT_REPORT_ID", (Object)reportId);
                            report.put("ELEMENT_ID", (Object)elementId);
                            report.put("AUDIT_REPORT_NAME", (Object)reportName);
                            report.put("class", (Object)className);
                            report.put("tabsArray", (Object)tabsArray);
                            if (reportInputs.containsKey(reportId)) {
                                report.put("state", (Object)"added");
                                JSONObject selectedReport = new JSONObject();
                                selectedReport.put("AUDIT_REPORT_ID", (Object)reportId);
                                selectedReport.put("AUDIT_REPORT_NAME", (Object)reportName);
                                selectedReport.put("class", (Object)className);
                                selectedReport.put("tabsArray", (Object)tabsArray);
                                JSONArray objectsArray = new JSONArray();
                                ArrayList objectsList = (ArrayList)reportInputs.get(reportId);
                                for (int oc = 0; oc < objectsList.size(); ++oc) {
                                    HashMap objMap = (HashMap)objectsList.get(oc);
                                    JSONObject obj = new JSONObject();
                                    obj.put("name", objMap.get("selectedObjectNames"));
                                    obj.put("objectClass", objMap.get("objectClass"));
                                    obj.put("guidName", objMap.get("guidName"));
                                    obj.put("id", objMap.get("selectedObjects"));
                                    objectsArray.put((Object)obj);
                                }
                                selectedReport.put("selectedObjectsArray", (Object)objectsArray);
                                selectedReportsArray.put((Object)selectedReport);
                            } else {
                                report.put("state", (Object)"add");
                            }
                            reportsArray.put((Object)report);
                        }
                    } else {
                        HashMap monitorsMap = (HashMap)reportCategoryList.get(0);
                        if (!monitorsMap.isEmpty()) {
                            HashMap categoryMap = (HashMap)monitorsMap.get(domainName);
                            Set cateKey = categoryMap.keySet();
                            for (String cateName : cateKey) {
                                ArrayList monitorsList = (ArrayList)categoryMap.get(cateName);
                                for (int len = 0; len < monitorsList.size(); ++len) {
                                    HashMap detailsMap = (HashMap)monitorsList.get(len);
                                    ArrayList formElement = (ArrayList)detailsMap.get("INPUT_PARAMS");
                                    Long rId = (Long)detailsMap.get("AUDIT_REPORT_ID");
                                    JSONObject report = new JSONObject();
                                    report.put("AUDIT_REPORT_ID", (Object)rId);
                                    report.put("AUDIT_REPORT_NAME", detailsMap.get("AUDIT_REPORT_NAME"));
                                    if (reportInputs.containsKey(rId)) {
                                        report.put("state", (Object)"added");
                                        JSONObject selectedReport = new JSONObject();
                                        selectedReport.put("AUDIT_REPORT_ID", (Object)rId);
                                        selectedReport.put("AUDIT_REPORT_NAME", detailsMap.get("AUDIT_REPORT_NAME"));
                                        selectedReportsArray.put((Object)selectedReport);
                                    } else {
                                        report.put("state", (Object)"add");
                                    }
                                    reportsArray.put((Object)report);
                                }
                            }
                        }
                    }
                    reportCategoryObject.put("reports", (Object)reportsArray);
                    reportCategories.put((Object)reportCategoryObject);
                    if (selectedReportsArray.length() <= 0) continue;
                    JSONObject selectedReportCategoryObject = new JSONObject();
                    selectedReportCategoryObject.put("categoryId", (Object)divId);
                    selectedReportCategoryObject.put("categoryName", reportCategoryMap.get("SR_NAME"));
                    selectedReportCategoryObject.put("reports", (Object)selectedReportsArray);
                    selectedReportCategories.put((Object)selectedReportCategoryObject);
                }
            }
            result.put("reportCategories", (Object)reportCategories);
            result.put("selectedReportCategories", (Object)selectedReportCategories);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public JSONObject getConfigData(AdventNetResourceBundle rb) {
        JSONObject configData = new JSONObject();
        try {
            String fromTime;
            int i;
            int i2;
            Integer[] hourOfDay = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            Integer[] minutes = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
            JSONArray hourOfDayArray = new JSONArray();
            for (int i3 = 0; i3 < hourOfDay.length; ++i3) {
                JSONObject hourObject = new JSONObject();
                hourObject.put("name", (Object)hourOfDay[i3]);
                hourObject.put("value", (Object)hourOfDay[i3]);
                hourOfDayArray.put((Object)hourObject);
            }
            JSONArray minutesArray = new JSONArray();
            for (int i4 = 0; i4 < minutes.length; ++i4) {
                JSONObject minObject = new JSONObject();
                minObject.put("name", (Object)minutes[i4]);
                minObject.put("value", (Object)minutes[i4]);
                minutesArray.put((Object)minObject);
            }
            configData.put("freqHours", (Object)hourOfDayArray);
            configData.put("freqMins", (Object)minutesArray);
            JSONArray hourlyForArray = new JSONArray();
            String[] hourlyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Hour"), rb.getString("adap.ReportSchedulerBean.Last_60_Minutes")};
            String[] hourlyPeriodValues = new String[]{"lastHour", "onehour"};
            for (int i5 = 0; i5 < hourlyPeriods.length; ++i5) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)rb.getString(hourlyPeriods[i5]));
                forObject.put("value", (Object)hourlyPeriodValues[i5]);
                hourlyForArray.put((Object)forObject);
            }
            JSONObject hourlyData = new JSONObject();
            hourlyData.put("for", (Object)hourlyForArray);
            configData.put("freqHourlyData", (Object)hourlyData);
            JSONArray dailyForArray = new JSONArray();
            String[] dailyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Day00002359"), rb.getString("adap.ReportSchedulerBean.Last_24_Hours"), rb.getString("adap.AudSelectElementAttr.Last_12_Hours"), rb.getString("adap.AudSelectElementAttr.Last_6_Hours")};
            String[] dailyPeriodValues = new String[]{"Yesterday", "twfourhours", "twelvehours", "sixhours"};
            for (int i6 = 0; i6 < dailyPeriods.length; ++i6) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)rb.getString(dailyPeriods[i6]));
                forObject.put("value", (Object)dailyPeriodValues[i6]);
                dailyForArray.put((Object)forObject);
            }
            JSONObject dailyData = new JSONObject();
            dailyData.put("for", (Object)dailyForArray);
            configData.put("freqDailyData", (Object)dailyData);
            JSONArray weeklyForArray = new JSONArray();
            JSONArray weeklyOnArray = new JSONArray();
            String[] daysOfWeek = new String[]{rb.getString("adap.ReportSchedulerBean.Sunday"), rb.getString("adap.ReportSchedulerBean.Monday"), rb.getString("adap.ReportSchedulerBean.Tuesday"), rb.getString("adap.ReportSchedulerBean.Wednesday"), rb.getString("adap.ReportSchedulerBean.Thursday"), rb.getString("adap.ReportSchedulerBean.Friday"), rb.getString("adap.ReportSchedulerBean.Saturday")};
            Integer[] daysOfWeekValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            String[] weeklyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_WeekSun_0000__Sat"), rb.getString("adap.ReportSchedulerBean.Last_7_Days")};
            String[] weeklyPeriodValues = new String[]{"lastWeek", "Last_7_Days"};
            String su = rb.getString("adap.ReportSchedulerBean.Sunday");
            for (i2 = 0; i2 < daysOfWeek.length; ++i2) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)rb.getString(daysOfWeek[i2]));
                onObject.put("value", (Object)daysOfWeekValues[i2]);
                weeklyOnArray.put((Object)onObject);
            }
            for (i2 = 0; i2 < weeklyPeriods.length; ++i2) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)rb.getString(weeklyPeriods[i2]));
                forObject.put("value", (Object)weeklyPeriodValues[i2]);
                weeklyForArray.put((Object)forObject);
            }
            JSONObject weeklyData = new JSONObject();
            weeklyData.put("for", (Object)weeklyForArray);
            weeklyData.put("on", (Object)weeklyOnArray);
            configData.put("freqWeeklyData", (Object)weeklyData);
            JSONArray monthlyForArray = new JSONArray();
            JSONArray monthlyOnArray = new JSONArray();
            Integer[] datesOfMonth = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
            String[] monthlyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Month"), rb.getString("adap.ReportSchedulerBean.Last_30_Days")};
            String[] monthlyPeriodValues = new String[]{"Last_Month", "Last_30_Days"};
            for (i = 0; i < datesOfMonth.length; ++i) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)datesOfMonth[i]);
                onObject.put("value", (Object)datesOfMonth[i]);
                monthlyOnArray.put((Object)onObject);
            }
            for (i = 0; i < monthlyPeriods.length; ++i) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)monthlyPeriods[i]);
                forObject.put("value", (Object)monthlyPeriodValues[i]);
                monthlyForArray.put((Object)forObject);
            }
            JSONObject monthlyData = new JSONObject();
            monthlyData.put("for", (Object)monthlyForArray);
            monthlyData.put("on", (Object)monthlyOnArray);
            configData.put("freqMonthlyData", (Object)monthlyData);
            JSONObject defhourly = new JSONObject();
            defhourly.put("hoursValue", (Object)"0");
            defhourly.put("minsValue", (Object)"0");
            defhourly.put("onValue", (Object)"");
            defhourly.put("forValue", (Object)"lastHour");
            JSONObject defdaily = new JSONObject();
            defdaily.put("hoursValue", (Object)"0");
            defdaily.put("minsValue", (Object)"0");
            defdaily.put("onValue", (Object)"");
            defdaily.put("forValue", (Object)"Yesterday");
            JSONObject defWeekly = new JSONObject();
            defWeekly.put("hoursValue", (Object)"0");
            defWeekly.put("minsValue", (Object)"0");
            defWeekly.put("onValue", (Object)"1");
            defWeekly.put("forValue", (Object)"lastWeek");
            JSONObject defMonthly = new JSONObject();
            defMonthly.put("hoursValue", (Object)"0");
            defMonthly.put("minsValue", (Object)"0");
            defMonthly.put("onValue", (Object)"1");
            defMonthly.put("forValue", (Object)"Last_Month");
            JSONObject defValues = new JSONObject();
            defValues.put("hourly", (Object)defhourly);
            defValues.put("daily", (Object)defdaily);
            defValues.put("weekly", (Object)defWeekly);
            defValues.put("monthly", (Object)defMonthly);
            configData.put("freqDefaultValues", (Object)defValues);
            JSONArray bussinessHoursArray = new JSONArray();
            String[] bussinessHours = new String[]{rb.getString("adap.BusinessReports.ReportsAllHours"), rb.getString("adap.BusinessReports.ReportsBusiness"), rb.getString("adap.BusinessReports.ReportsNonBusiness")};
            String[] bussinessHoursValues = new String[]{"false", "Business", "NonBusiness"};
            for (int i7 = 0; i7 < bussinessHours.length; ++i7) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)bussinessHours[i7]);
                onObject.put("value", (Object)bussinessHoursValues[i7]);
                bussinessHoursArray.put((Object)onObject);
            }
            configData.put("bussinessHours", (Object)bussinessHoursArray);
            JSONArray fileFormatsArray = new JSONArray();
            String[] fileFormats = new String[]{"pdf", "xls", "csv", "html"};
            for (int i8 = 0; i8 < fileFormats.length; ++i8) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)fileFormats[i8]);
                onObject.put("value", (Object)fileFormats[i8]);
                fileFormatsArray.put((Object)onObject);
            }
            configData.put("fileFormats", (Object)fileFormatsArray);
            boolean mailConficCheck = MailServerUtil.mailServerConfig();
            HashMap settingsMap = BusinessServerSettings.getBusinessHourSettings();
            String string = fromTime = settingsMap.isEmpty() ? "" : (String)settingsMap.get("FromTime");
            if (fromTime.equals("")) {
                configData.put("bussinessHourConfigured", false);
            } else {
                configData.put("bussinessHourConfigured", true);
            }
            configData.put("mailServerNotConfigured", !mailConficCheck);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public JSONObject getReportData(Long scheduleId, HashMap reportInputs) {
        JSONObject reportData = new JSONObject();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject schedulerDO = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("ScheduledReports", crit);
            Row scheduleRow = schedulerDO.getRow("Schedule");
            reportData.put("scheduleId", (Object)scheduleId);
            reportData.put("scheduleName", (Object)((String)scheduleRow.get("SCHEDULE_NAME")));
            reportData.put("description", (Object)((String)scheduleRow.get("DESCRIPTION")));
            Row audSchedulerRow = schedulerDO.getRow("AUDScheduler");
            JSONObject domainData = new JSONObject();
            JSONArray retArray = new JSONArray();
            JSONObject jo = new JSONObject();
            jo.put("name", (Object)((String)audSchedulerRow.get("DOMAIN_NAME")));
            jo.put("value", (Object)((String)audSchedulerRow.get("DOMAIN_NAME")));
            retArray.put((Object)jo);
            domainData.put("domainsList", (Object)retArray);
            domainData.put("selectedDomain", (Object)((String)audSchedulerRow.get("DOMAIN_NAME")));
            reportData.put("domainData", (Object)domainData);
            reportData.put("fileStoragePath", (Object)((String)audSchedulerRow.get("FILE_STORAGE_PATH")));
            reportData.put("formatValue", (Object)((String)audSchedulerRow.get("FILE_FORMAT")));
            reportData.put("isMailNotify", (Object)((Boolean)audSchedulerRow.get("IS_NOTIFICATION_ENABLED")));
            reportData.put("mailAddress", (Object)((String)audSchedulerRow.get("TO_MAIL_ADDRESS")));
            reportData.put("mailContent", (Object)((String)audSchedulerRow.get("MAIL_CONTENT")));
            reportData.put("mailSubject", (Object)((String)audSchedulerRow.get("MAIL_SUBJECT")));
            reportData.put("sendingOptions", (Object)((String)audSchedulerRow.get("SENDING_OPTIONS")));
            reportData.put("isZipFile", (Object)((Boolean)audSchedulerRow.get("IS_ZIP_FILE")));
            String businessHour = (String)audSchedulerRow.get("BUSINESS_HOUR");
            if (businessHour.equalsIgnoreCase("nonbussiness")) {
                businessHour = "NonBusiness";
            }
            if (businessHour.equalsIgnoreCase("bussiness")) {
                businessHour = "Business";
            }
            reportData.put("BUSINESS_HOUR", (Object)businessHour);
            reportData.put("isReportsEmpty", (Boolean)audSchedulerRow.get("IS_REPORTS_EMPTY") == false);
            reportData.put("isSingleFolder", (Object)((Boolean)audSchedulerRow.get("IS_SINGLE_FOLDER")));
            String timePeriod = (String)audSchedulerRow.get("REPORT_PERIOD");
            if (schedulerDO.size("Periodic") > 0) {
                Row periodicRow = schedulerDO.getRow("Periodic");
                Date dateObj = (Date)periodicRow.get("START_DATE");
                reportData.put("hoursValue", dateObj.getHours());
                reportData.put("minsValue", dateObj.getMinutes());
                reportData.put("forValue", (Object)timePeriod);
                reportData.put("selectedFreq", (Object)"hourly");
            } else {
                Row calendarRow = schedulerDO.getRow("Calendar");
                if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("daily")) {
                    reportData.put("hoursValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                    reportData.put("minsValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                    reportData.put("forValue", (Object)timePeriod);
                    reportData.put("selectedFreq", (Object)"daily");
                } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("weekly")) {
                    reportData.put("onValue", (Object)((Integer)calendarRow.get("DAY_OF_WEEK")));
                    reportData.put("hoursValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                    reportData.put("minsValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                    reportData.put("forValue", (Object)timePeriod);
                    reportData.put("selectedFreq", (Object)"weekly");
                } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("monthly")) {
                    reportData.put("onValue", (Object)((Integer)calendarRow.get("DATE_OF_MONTH")));
                    reportData.put("hoursValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                    reportData.put("minsValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                    reportData.put("forValue", (Object)timePeriod);
                    reportData.put("selectedFreq", (Object)"monthly");
                }
            }
            HashMap categoryMap = new HashMap();
            Iterator iter = schedulerDO.getRows("AUDReportSchedulerMap");
            while (iter.hasNext()) {
                ArrayList reportList = new ArrayList();
                Row auditRow = (Row)iter.next();
                Long reportId = (Long)auditRow.get("AUDIT_REPORT_ID");
                SchedulerBeanUtil.getReportDetails(categoryMap, reportId);
                Criteria inputMapCrit = new Criteria(Column.getColumn((String)"AUDSchedulerInputMap", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
                Iterator iterator = schedulerDO.getRows("AUDSchedulerInputMap", inputMapCrit);
                while (iterator.hasNext()) {
                    Row inputRow = (Row)iterator.next();
                    HashMap<String, String> inputMap = new HashMap<String, String>();
                    String objectClass = (String)inputRow.get("OBJECT_CLASS");
                    inputMap.put("objectClass", objectClass);
                    inputMap.put("guidName", (String)inputRow.get("INPUT_PARAM"));
                    inputMap.put("selectedObjects", (String)inputRow.get("INPUT_PARAM_VALUE"));
                    Row objectRow = DirectoryObjectAPI.getInstance().getObjectRow(null, (String)inputRow.get("INPUT_PARAM_VALUE"), objectClass);
                    if (objectRow != null) {
                        if (((String)inputRow.get("INPUT_PARAM_VALUE")).equals("allobjects")) {
                            inputMap.put("selectedObjectNames", "allobjects");
                        } else if (objectClass.equalsIgnoreCase("share")) {
                            inputMap.put("selectedObjectNames", (String)objectRow.get("LOCATION"));
                        } else if (objectClass.equalsIgnoreCase("printer")) {
                            inputMap.put("selectedObjectNames", (String)objectRow.get("PRINTER_NAME"));
                        } else {
                            inputMap.put("selectedObjectNames", (String)objectRow.get("NAME"));
                        }
                    } else {
                        inputMap.put("selectedObjectNames", (String)inputRow.get("INPUT_PARAM_VALUE"));
                    }
                    reportList.add(inputMap);
                }
                reportInputs.put(reportId, reportList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportData;
    }

    public void saveScheduleReport(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        String scheduleName = "";
        Boolean isSave = false;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String strData = request.getParameter("data");
            JSONObject data1 = new JSONObject(strData);
            JSONObject data = data1.optJSONObject("createScheduleReportJSON");
            ret.put("success", true);
            Integer timePeriod = 0;
            String reportPeriod = null;
            DataObject scheduleDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row scheduleRow = new Row("Schedule");
            isSave = data.getBoolean("isSave");
            if (!isSave.booleanValue()) {
                scheduleRow.set("SCHEDULE_ID", (Object)Long.parseLong(String.valueOf(data.get("scheduleId"))));
            }
            scheduleRow.set("SCHEDULE_NAME", data.get("scheduleName"));
            scheduleName = data.getString("scheduleName");
            scheduleRow.set("DESCRIPTION", data.get("description"));
            scheduleDO.addRow(scheduleRow);
            if (((String)data.get("reportType")).equalsIgnoreCase("hourly")) {
                reportPeriod = (String)data.get("forValue");
                Row periodicRow = new Row("Periodic");
                periodicRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
                periodicRow.set("TIME_PERIOD", (Object)1L);
                periodicRow.set("UNIT_OF_TIME", (Object)"Hours");
                Date dateObj = new Date();
                dateObj.setHours(Integer.parseInt(data.getString("hoursValue")));
                dateObj.setMinutes(Integer.parseInt(data.getString("minsValue")));
                dateObj.setSeconds(0);
                periodicRow.set("START_DATE", (Object)new Timestamp(dateObj.getTime()));
                scheduleDO.addRow(periodicRow);
            } else {
                Row calendarRow = new Row("Calendar");
                calendarRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
                if (((String)data.get("reportType")).equalsIgnoreCase("daily")) {
                    reportPeriod = (String)data.get("forValue");
                    timePeriod = Integer.parseInt(data.getString("hoursValue")) * 60 + Integer.parseInt(data.getString("minsValue"));
                    calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                    calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
                } else if (((String)data.get("reportType")).equalsIgnoreCase("weekly")) {
                    reportPeriod = (String)data.get("forValue");
                    timePeriod = Integer.parseInt(data.getString("hoursValue")) * 60 + Integer.parseInt(data.getString("minsValue"));
                    calendarRow.set("DAY_OF_WEEK", (Object)Integer.parseInt(data.getString("onValue")));
                    calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                    calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
                } else if (((String)data.get("reportType")).equalsIgnoreCase("monthly")) {
                    reportPeriod = (String)data.get("forValue");
                    timePeriod = Integer.parseInt(data.getString("hoursValue")) * 60 + Integer.parseInt(data.getString("minsValue"));
                    calendarRow.set("DATE_OF_MONTH", (Object)Integer.parseInt(data.getString("onValue")));
                    calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                    calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
                }
                scheduleDO.addRow(calendarRow);
            }
            Row taskInputRow = new Row("Task_Input");
            taskInputRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            taskInputRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)"ReportScheduler"));
            Long time = System.currentTimeMillis() + 120000L;
            if (data.has("testNow") && !data.getBoolean("testNow")) {
                time = ScheduleUtil.calculateNextScheduleTime((DataObject)scheduleDO, (Long)-1L, (boolean)false);
            }
            taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(time));
            scheduleDO.addRow(taskInputRow);
            Row taskRow = new Row("Scheduled_Task");
            taskRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            taskRow.set("AUDIT_FLAG", (Object)true);
            taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)"ReportScheduler"));
            taskRow.set("TRANSACTION_TIME", (Object)-1);
            taskRow.set("SKIP_MISSED_SCHEDULE", (Object)true);
            scheduleDO.addRow(taskRow);
            Row schedulerRow = new Row("AUDScheduler");
            schedulerRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            schedulerRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            schedulerRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            schedulerRow.set("DOMAIN_NAME", (Object)((String)data.get("domainName")));
            schedulerRow.set("REPORT_PERIOD", (Object)reportPeriod);
            schedulerRow.set("FILE_FORMAT", (Object)((String)data.get("formatValue")));
            schedulerRow.set("FILE_STORAGE_PATH", (Object)((String)data.get("fileStoragePath")));
            schedulerRow.set("IS_NOTIFICATION_ENABLED", (Object)((Boolean)data.get("isMailNotify")));
            schedulerRow.set("TO_MAIL_ADDRESS", (Object)((String)data.get("mailAddress")));
            schedulerRow.set("MAIL_SUBJECT", (Object)((String)data.get("mailSubject")));
            schedulerRow.set("MAIL_CONTENT", (Object)((String)data.get("mailContent")));
            schedulerRow.set("SENDING_OPTIONS", (Object)((String)data.get("sendingOptions")));
            schedulerRow.set("IS_ZIP_FILE", (Object)((Boolean)data.get("isZipFile")));
            schedulerRow.set("IS_REPORTS_EMPTY", (Object)((Boolean)data.get("isReportsEmpty") == false ? 1 : 0));
            schedulerRow.set("BUSINESS_HOUR", (Object)((String)data.get("BUSINESS_HOUR")));
            schedulerRow.set("IS_SINGLE_FOLDER", (Object)((Boolean)data.get("isSingleFolder")));
            scheduleDO.addRow(schedulerRow);
            JSONArray selectedReportCategories = data.getJSONArray("selectedReportCategories");
            for (int c = 0; c < selectedReportCategories.length(); ++c) {
                JSONArray reports = selectedReportCategories.getJSONObject(c).getJSONArray("reports");
                for (int j = 0; j < reports.length(); ++j) {
                    JSONObject report = reports.getJSONObject(j);
                    Row reportMapRow = new Row("AUDReportSchedulerMap");
                    reportMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
                    reportMapRow.set("AUDIT_REPORT_ID", (Object)report.getLong("AUDIT_REPORT_ID"));
                    scheduleDO.addRow(reportMapRow);
                    JSONArray list = report.optJSONArray("selectedObjectsArray");
                    if (list == null || list.length() <= 0) continue;
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject inputMap = list.getJSONObject(i);
                        Row inputRow = new Row("AUDSchedulerInputMap");
                        inputRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
                        inputRow.set("AUDIT_REPORT_ID", (Object)report.getLong("AUDIT_REPORT_ID"));
                        inputRow.set("INPUT_PARAM", inputMap.get("guidName"));
                        inputRow.set("INPUT_PARAM_VALUE", inputMap.get("id"));
                        inputRow.set("OBJECT_CLASS", inputMap.get("objectClass"));
                        scheduleDO.addRow(inputRow);
                    }
                }
            }
            if (isSave.booleanValue()) {
                ReportSchedulerUtil.createScheduler((DataObject)scheduleDO);
                String message = "";
                message = data.has("testNow") && !data.getBoolean("testNow") ? rb.getString("adap.CreateReportScheduler.Successfully_created_the_scheduled_Report") : rb.getString("adap.CreateReportScheduler.created_test_now");
                ret.put("message", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message + " , Schedule Name is " + scheduleName, 512, 8, "adap.ADAPUserAuditSeverities.audit_name.schedule_report_created", "-"}));
            } else {
                ReportSchedulerUtil.updateScheduler((DataObject)scheduleDO, (Long)Long.parseLong(String.valueOf(data.get("scheduleId"))), (String)((String)data.get("reportType")));
                String message = "";
                message = data.has("testNow") && !data.getBoolean("testNow") ? (String)rb.handleGetObject("adap.ModifyReportScheduler.Successfully_updated_the_scheduled_report") : rb.getString("adap.ModifyReportScheduler.update_test_now");
                ret.put("message", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ModifyReportScheduler.audit_entry.Successfully_updated", new String[]{scheduleName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            }
        }
        catch (DataAccessException ex) {
            logger.log(Level.INFO, "Exception while adding the scheduler");
            ex.printStackTrace();
            String message = ex.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stktrc = sw.toString();
            if (message.indexOf("Duplicate entry") != -1 || stktrc.indexOf("duplicate key") != -1) {
                message = rb.getString("adap.CreateReportScheduler.The_Schedule_Name_Already_Configured");
            }
            try {
                ret.put("success", false);
                ret.put("message", (Object)message);
                if (isSave.booleanValue()) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateReportScheduler.audit_entry.Problem_crating_schedule_name", new String[]{message, scheduleName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.failed_to_create_report_scheduler", "-"}));
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Schedule_Report_name", new String[]{scheduleName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                ret.put("success", false);
                String message = rb.getString("adap.CreateReportScheduler.Failure_occurred");
                ret.put("message", (Object)message);
                if (isSave.booleanValue()) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateReportScheduler.audit_entry.Problem_crating_schedule_name", new String[]{message, scheduleName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.failed_to_create_report_scheduler", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Schedule_Report_name", new String[]{scheduleName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.modify_report_scheduler", "-"}));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

