/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchEmberUtil;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchExportUtil;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchGlobalSearchHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchParams;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchReportManager;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchArchivedEventsHandler {
    private static volatile SearchArchivedEventsHandler instance = null;
    private static Logger logger = Logger.getLogger(SearchArchivedEventsHandler.class.getName());

    private SearchArchivedEventsHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchArchivedEventsHandler getInstance() {
        if (instance != null) return instance;
        Class<SearchArchivedEventsHandler> clazz = SearchArchivedEventsHandler.class;
        synchronized (SearchArchivedEventsHandler.class) {
            if (instance != null) return instance;
            instance = new SearchArchivedEventsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getArchLeftTreeList(HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList actionList = authObject.getUserActins();
            JsonResponse.getInstance().sendResponse(response, ArchReportManager.getInstance().fetchReportList(actionList).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchIndexFileListCount(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            Integer logCategoryId = null;
            Long fromTime = null;
            Long toTime = null;
            Integer loadType = null;
            if (jRequestParams.has("logCategoryId")) {
                logCategoryId = jRequestParams.getInt("logCategoryId");
            }
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("loadType")) {
                loadType = jRequestParams.getInt("loadType");
            }
            JSONObject fileListCount = ArchFileIndexHandler.fetchArchFileListCount((Integer)logCategoryId, (Long)fromTime, toTime, (Integer)loadType);
            JsonResponse.getInstance().sendResponse(response, fileListCount.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchIndexFileList(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            Integer logCategoryId = null;
            Long fromTime = null;
            Long toTime = null;
            String sortColumn = null;
            String sortOrder = null;
            Integer fromIndex = null;
            Integer range = null;
            Integer loadType = null;
            if (jRequestParams.has("logCategoryId")) {
                logCategoryId = jRequestParams.getInt("logCategoryId");
            }
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("sortColumn")) {
                sortColumn = jRequestParams.getString("sortColumn");
            }
            if (jRequestParams.has("sortOrder")) {
                sortOrder = jRequestParams.getString("sortOrder");
            }
            if (jRequestParams.has("FROM_INDEX")) {
                fromIndex = jRequestParams.getInt("FROM_INDEX");
            }
            if (jRequestParams.has("RANGE")) {
                range = jRequestParams.getInt("RANGE");
            }
            if (jRequestParams.has("loadType")) {
                loadType = jRequestParams.getInt("loadType");
            }
            JSONObject jFileList = new JSONObject();
            JSONObject jFileListCount = ArchFileIndexHandler.fetchArchFileListCount((Integer)logCategoryId, (Long)fromTime, (Long)toTime, (Integer)loadType);
            jFileList = ArchFileIndexHandler.fetchArchFileList((Integer)logCategoryId, (Long)fromTime, (Long)toTime, (String)sortColumn, (String)sortOrder, (Integer)fromIndex, (Integer)range, (Integer)loadType);
            jFileList.put("archIndexFileCount", (Object)jFileListCount.getJSONObject("archIndexFileCount"));
            jFileList.put("totalCount", jFileListCount.getJSONObject("archIndexFileCount").getInt("archTotalFileCount"));
            jFileList.put("startValue", (Object)fromIndex);
            jFileList.put("rangeValue", (Object)range);
            JSONObject jEmberTable = ArchEmberUtil.getArchIndexFileTableData((JSONObject)jFileList, (AdventNetResourceBundle)rb);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.AuditReportAction.audit_entry.archive_file_list_viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_file_list_viewed", "-"}));
            JsonResponse.getInstance().sendResponse(response, jEmberTable.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchFileMinMaxTime(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            int logCategoryId = 0;
            if (jRequestParams.has("logCategoryId")) {
                logCategoryId = Integer.parseInt(jRequestParams.getString("logCategoryId"));
            }
            JSONObject jo = ArchFileIndexHandler.fetchArchFileMinMaxTime((int)logCategoryId);
            JsonResponse.getInstance().sendResponse(response, jo.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getLogCategories(HttpServletRequest request, HttpServletResponse response) {
        try {
            String appendAllStr = request.getParameter("appendAll");
            boolean appendAll = false;
            if (appendAllStr != null) {
                appendAll = Boolean.parseBoolean(appendAllStr);
            }
            JSONArray jArr = ArchReportManager.getInstance().fetchArchLogCategories(appendAll);
            JsonResponse.getInstance().sendResponse(response, jArr.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void indexArchiveFiles(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultObj = new JSONObject();
            JSONObject indexFileList = new JSONObject(request.getParameter("indexFileList"));
            String resultStr = ArchFileIndexHandler.indexArchFiles((JSONObject)indexFileList, (AdventNetResourceBundle)rb);
            if (resultStr.isEmpty()) {
                resultObj.put("success", true);
                resultObj.put("text", (Object)rb.getString("adap.archive.indexing_scheduled"));
            } else {
                resultObj.put("failure", true);
                resultObj.put("text", (Object)resultStr);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.AuditReportAction.audit_entry.index_archive_file"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.index_archive_file", "-"}));
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getArchIndexSettings(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject resultObj = ArchFileIndexHandler.getArchIndexSettings();
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateArchIndexSettings(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject newSettingsObj = new JSONObject(request.getParameter("settings"));
            JSONObject resultObj = new JSONObject();
            resultObj = ArchFileIndexHandler.updateArchIndexSettings((JSONObject)newSettingsObj);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.AuditReportAction.audit_entry.changed_archive_index_setting"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_archive_index_setting", "-"}));
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getGlobalSearchSummary(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            JSONObject jResponse = new JSONObject();
            String searchQueryStr = null;
            Long fromTime = null;
            Long toTime = null;
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                fromTime = jRequestParams.getLong("fromTime");
                toTime = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("searchQueryStr")) {
                searchQueryStr = jRequestParams.getString("searchQueryStr");
            }
            if ((jResponse = ArchGlobalSearchHandler.fetchReportSummary((String)searchQueryStr, fromTime, toTime)) != null && !jResponse.has("failure")) {
                jResponse = ArchEmberUtil.parseGSResultsIntoCols((JSONObject)jResponse);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.getString("adap.AuditReportAction.audit_entry.globally_searched_archive"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.globally_searched_archive", "-"}));
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReport(HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject jResponse = new JSONObject();
        ArchParams rParams = new ArchParams();
        Credential cred = AuthUtil.getUserCredential();
        Long loggedOnUserId = cred.getUserId();
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            rParams.report_id = jRequestParams.getInt("reportId");
            rParams.logged_on_user_id = loggedOnUserId;
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                rParams.report_from_time = jRequestParams.getLong("fromTime");
                rParams.report_to_time = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("searchQuery")) {
                rParams.report_search_query_str = jRequestParams.getString("searchQuery");
            }
            if (jRequestParams.has("facetList")) {
                rParams.report_facet_list = jRequestParams.getJSONObject("facetList");
            }
            if (jRequestParams.has("reportFromIndex") && jRequestParams.has("reportToIndex")) {
                rParams.report_from_index = jRequestParams.getInt("reportFromIndex");
                rParams.report_to_index = jRequestParams.getInt("reportToIndex");
            }
            if (jRequestParams.has("isGlobalSearchPage")) {
                rParams.is_global_search_page = jRequestParams.getBoolean("isGlobalSearchPage");
            }
            if (rParams.is_global_search_page) {
                jResponse = ArchGlobalSearchHandler.fetchReport((ArchParams)rParams);
                if (!jResponse.has("failure")) {
                    jResponse = ArchEmberUtil.getArchReportTableData((JSONObject)jResponse, (AdventNetResourceBundle)rb);
                    jResponse.put("reportName", (Object)ArchReportManager.getInstance().getGSReportName(rParams.report_id));
                }
            } else {
                jResponse = ArchReportManager.getInstance().getReport(rParams);
                if (!jResponse.has("failure")) {
                    jResponse = ArchEmberUtil.getArchReportTableData((JSONObject)jResponse, (AdventNetResourceBundle)rb);
                    jResponse.put("reportName", (Object)ArchReportManager.getInstance().getReportName(rParams.report_id));
                    jResponse.put("logCategoryId", ArchReportManager.getInstance().getReportArchCategoryId(rParams.report_id));
                }
            }
            jResponse.put("reportId", rParams.report_id);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.AuditReportAction.audit_entry.archive_report_viewed", new String[]{ArchReportManager.getInstance().getReportName(rParams.report_id)}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_report_viewed", "-"}));
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                jResponse = new JSONObject();
                jResponse.put("failure", true);
                jResponse.put("text", (Object)rb.getString("adap.archive.report_fetch_error"));
                jResponse.put("reportId", rParams.report_id);
                JsonResponse.getInstance().sendResponse(response, jResponse.toString());
            }
            catch (Exception je) {
                je.printStackTrace();
            }
        }
    }

    public void getFacets(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jResponse = new JSONObject();
            JSONObject jFacetObj = new JSONObject();
            ArchParams rParams = new ArchParams();
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            rParams.report_id = jRequestParams.getInt("reportId");
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                rParams.report_from_time = jRequestParams.getLong("fromTime");
                rParams.report_to_time = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("isGlobalSearchPage")) {
                rParams.is_global_search_page = jRequestParams.getBoolean("isGlobalSearchPage");
            }
            if (jRequestParams.has("searchQuery")) {
                rParams.report_search_query_str = jRequestParams.getString("searchQuery");
            }
            if (!(jFacetObj = rParams.is_global_search_page ? ArchGlobalSearchHandler.fetchFacets((ArchParams)rParams) : ArchReportManager.getInstance().getFacets(rParams)).has("failure")) {
                jResponse.put("facetsInfo", (Object)jFacetObj);
                jResponse.put("searchQuery", (Object)rParams.report_search_query_str);
            } else {
                jResponse = jFacetObj;
            }
            jResponse.put("reportId", rParams.report_id);
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportMinMaxTime(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jResponse = null;
        try {
            jResponse = new JSONObject();
            boolean isGlobalSearchPage = false;
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            if (jRequestParams.has("isGlobalSearchPage")) {
                isGlobalSearchPage = jRequestParams.getBoolean("isGlobalSearchPage");
            }
            if (isGlobalSearchPage) {
                jResponse = ArchGlobalSearchHandler.getMinMaxTime();
            } else if (jRequestParams.has("reportId")) {
                int reportId = jRequestParams.getInt("reportId");
                ArchLogCategoryHandler handler = ArchReportManager.getInstance().getArchCategoryHandler(reportId);
                JSONObject jTimeRange = handler.getMinMaxTime();
                jResponse.put("startDate", jTimeRange.get("minTime"));
                jResponse.put("endDate", jTimeRange.get("maxTime"));
                jResponse.put("reportId", reportId);
            } else {
                logger.log(Level.SEVERE, "SearchArchivedEventsHandler.fetchReportMinMaxTime :: reportId null!!");
            }
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSearchableFields(HttpServletRequest request, HttpServletResponse response) {
        JSONArray jFieldList = null;
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            if (jRequestParams.has("reportId")) {
                int reportId = jRequestParams.getInt("reportId");
                jFieldList = ArchReportManager.getInstance().getSearchableFields(reportId);
            } else {
                logger.log(Level.SEVERE, "SearchArchivedEventsHandler.fetchSearchFields :: reportId null!!");
            }
            JsonResponse.getInstance().sendResponse(response, jFieldList.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSearchBoxSuggestions(HttpServletRequest request, HttpServletResponse response) {
        try {
            String fieldsStr = request.getParameter("sugFields");
            String sugKey = request.getParameter("sugKey");
            int reportId = Integer.parseInt(request.getParameter("reportId"));
            String result = ArchReportManager.getInstance().getSuggestions(reportId, fieldsStr, sugKey).getString("suggestions").toString();
            JsonResponse.getInstance().sendResponse(response, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOrRemoveTableCols(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject resultObj = new JSONObject();
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            int tableId = jRequestParams.getInt("tableId");
            int reportId = jRequestParams.getInt("reportId");
            JSONArray jSelColIds = jRequestParams.getJSONArray("selColIds");
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            if (ArchReportManager.getInstance().updateTableColumnList(loggedOnUserId, tableId, jSelColIds)) {
                resultObj.put("success", true);
                resultObj.put("text", (Object)rb.getString("adap.archive.table_columns_success"));
            } else {
                resultObj.put("failure", true);
                resultObj.put("text", (Object)rb.getString("adap.archive.table_columns_error"));
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AuditReportAction.audit_entry.changed_archive_table_column", new String[]{ArchReportManager.getInstance().getReportName(reportId)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_archive_table_column", "-"}));
            JsonResponse.getInstance().sendResponse(response, resultObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportReport(HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject jResponse = new JSONObject();
        ArchParams inputParams = new ArchParams();
        try {
            JSONObject jRequestParams = new JSONObject(request.getParameter("requestParams"));
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred.getUserId();
            inputParams.report_id = jRequestParams.getInt("reportId");
            inputParams.export_file_format = jRequestParams.getString("exportFileFormat");
            if (jRequestParams.has("fromTime") && jRequestParams.has("toTime")) {
                inputParams.report_from_time = jRequestParams.getLong("fromTime");
                inputParams.report_to_time = jRequestParams.getLong("toTime");
            }
            if (jRequestParams.has("searchQuery")) {
                inputParams.report_search_query_str = jRequestParams.getString("searchQuery");
                inputParams.report_search_query_display_str = jRequestParams.getString("searchQueryDisplayStr");
            }
            if (jRequestParams.has("facetList")) {
                inputParams.report_facet_list = jRequestParams.getJSONObject("facetList");
                inputParams.report_facet_list_display_str = jRequestParams.getString("facetListDisplayStr");
            }
            if (jRequestParams.has("reportFromIndex") && jRequestParams.has("reportToIndex")) {
                inputParams.report_from_index = jRequestParams.getInt("reportFromIndex");
                inputParams.report_to_index = jRequestParams.getInt("reportToIndex");
            }
            if (jRequestParams.has("isGlobalSearchPage")) {
                inputParams.is_global_search_page = jRequestParams.getBoolean("isGlobalSearchPage");
            }
            inputParams.report_name = ArchReportManager.getInstance().getReportName(inputParams.report_id);
            inputParams.logged_on_user_id = loggedOnUserId;
            inputParams.http_response = response;
            if (inputParams.is_global_search_page) {
                ArchGlobalSearchHandler.exportReport((ArchParams)inputParams);
            } else {
                new ArchExportUtil(inputParams).exportReportAsBgTask();
            }
            jResponse.put("success", true);
            jResponse.put("text", (Object)"export started");
            jResponse.put("reportId", inputParams.report_id);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Admin", rb.handleGetObject("adap.AuditReportAction.audit_entry.archive_report_exported", new String[]{ArchReportManager.getInstance().getReportName(inputParams.report_id)}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_report_viewed", "-"}));
            JsonResponse.getInstance().sendResponse(response, jResponse.toString());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                jResponse = new JSONObject();
                jResponse.put("failure", true);
                jResponse.put("text", (Object)rb.getString("adap.archive.report_fetch_error"));
                jResponse.put("reportId", inputParams.report_id);
                JsonResponse.getInstance().sendResponse(response, jResponse.toString());
            }
            catch (Exception je) {
                je.printStackTrace();
            }
        }
    }
}

