/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.admin.domainsettings;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DCHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.SchemaUpdate;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.validation.NonConfiguredDCDetails;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class DomainActionHandler
extends DispatchAction {
    protected static Logger logger = Logger.getLogger("ReportLogger");
    private static volatile DomainActionHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainActionHandler getInstance() {
        if (instance != null) return instance;
        Class<DomainActionHandler> clazz = DomainActionHandler.class;
        synchronized (DomainActionHandler.class) {
            if (instance != null) return instance;
            instance = new DomainActionHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DomainActionHandler() {
    }

    public void addDomainDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject resultantJson = new JSONObject();
        if (DomainHandler.startDomainDiscovery()) {
            String message = rb.getString("adap.DomainAction.Domain_discovery_is_in_progress");
            resultantJson.put("message", (Object)message);
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void EventLogProps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject resultantJson = new JSONObject();
        String eventDCProperty = request.getParameter("eventDCProperty");
        JSONObject eventDCPropertyObj = new JSONObject(eventDCProperty);
        String domainName = eventDCPropertyObj.getString("DOMAIN_NAME");
        String mcName = eventDCPropertyObj.getString("COMPUTER_NAME");
        boolean refresh = eventDCPropertyObj.getBoolean("REFRESH");
        int mcType = eventDCPropertyObj.getInt("MACHINE_TYPE");
        Properties eventProps = new Properties();
        if (refresh) {
            try {
                PolicyHandler.addEventLogPropsToDB((String)domainName, (String)mcName, (int)mcType);
                refresh = false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DomainHandler.getEventLogProps((String)domainName, (String)mcName, (Properties)eventProps, (int)mcType);
        JSONObject policyStatusJson = APIUtil.getInstance().mapToJSONObject(eventProps);
        resultantJson.put("eventProps", (Object)policyStatusJson);
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void save(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName;
        String operation;
        String message;
        JSONObject resultantJson;
        JSONObject saveDomainDetailsObj;
        HttpSession session;
        block19: {
            String params;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
            String saveDomainDetails = request.getParameter("saveDomainDetails");
            saveDomainDetailsObj = new JSONObject(saveDomainDetails);
            resultantJson = new JSONObject();
            JSONObject messageJson = new JSONObject();
            message = null;
            if (DomainHandler.startDomainDiscovery()) {
                message = rb.getString("adap.DomainAction.Domain_discovery_is_in_progress");
            }
            operation = saveDomainDetailsObj.has("operation") ? saveDomainDetailsObj.getString("operation") : "init";
            domainName = saveDomainDetailsObj.getString("DOMAIN_NAME");
            if (saveDomainDetailsObj.has("save")) {
                params = "add";
                messageJson = this.save(saveDomainDetailsObj, request, params);
                message = messageJson.getString("message");
                resultantJson.put("showDetailsPage", (Object)messageJson.getString("showDetailsPage"));
                resultantJson.put("errHandler", (Object)messageJson.getString("errHandler"));
                logger.log(Level.INFO, "DOMAIN ADDED SUCCESSFULLY");
            } else if (saveDomainDetailsObj.has("update")) {
                params = "update";
                messageJson = this.save(saveDomainDetailsObj, request, params);
                message = messageJson.getString("message");
                resultantJson.put("showDetailsPage", (Object)messageJson.getString("showDetailsPage"));
                resultantJson.put("errHandler", (Object)messageJson.getString("errHandler"));
                logger.log(Level.INFO, "DOMAIN UPDATED SUCCESSFULLY");
            } else if (operation.equals("delete")) {
                try {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.start_to_Delete_domain", new String[]{domainName}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", "-"}));
                    if (DomainHandler.deleteDomain((String)domainName)) {
                        message = rb.getString("adap.AdminHandler.Successfully_Deleted");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.getString("adap.AdminHandler.Successfully_Deleted"), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName})}));
                        logger.log(Level.INFO, "DOMAIN DELETED SUCCESSFULLY");
                        domainName = DomainDetailsAPI.getDefaultDomainName();
                        break block19;
                    }
                    message = rb.getString("adap.DomainAction.Problem_in_deleting_the_Domain");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_deleting_Domain", new String[]{domainName}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", "-"}));
                    request.setAttribute("errHandler", (Object)"1");
                }
                catch (Exception e) {
                    message = e.getMessage();
                    request.setAttribute("errHandler", (Object)"1");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_deleting_Domain", new String[]{domainName}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", "-"}));
                }
            } else if (operation.equals("connect")) {
                this.connect(domainName, request);
            } else if (operation.equals("updateDomainData")) {
                JSONArray selectedUpdatesJsonArray = saveDomainDetailsObj.getJSONArray("updates");
                String[] selectedUpdates = new String[selectedUpdatesJsonArray.length()];
                for (int i = 0; i < selectedUpdatesJsonArray.length(); ++i) {
                    selectedUpdates[i] = selectedUpdatesJsonArray.get(i).toString();
                }
                message = rb.getString("adap.DomainAction.Refresh_request_is_being_processed");
                try {
                    DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
                    logger.log(Level.INFO, "DOMAIN OBJECT UPDATES - UPDATED SUCCESSFULLY");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.Successfully_updated_the_domain_objecst", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_object_updated", "-"}));
                }
                catch (Exception e) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_updated_domain_objects", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_object_updated", "-"}));
                    message = e.getMessage();
                }
            }
        }
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
        if (!saveDomainDetailsObj.has("save")) {
            resultantJson = this.getDomainTableData(request, resultantJson);
        }
        if (message != null) {
            resultantJson.put("message", (Object)message);
        }
        if (!saveDomainDetailsObj.has("save")) {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        resultantJson.put("operation", (Object)operation);
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void view(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        JSONObject domainConfigurationModel = new JSONObject();
        JSONObject messageParams = new JSONObject();
        if (DomainHandler.startDomainDiscovery()) {
            messageParams.put("message", (Object)rb.getString("adap.DomainAction.Domain_discovery_is_in_progress"));
            messageParams.put("type", (Object)"info");
            domainConfigurationModel.put("messageParams", (Object)messageParams);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Domain Settings", rb.getString(messageParams.getString("message")), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Domain_settings_viewed", "-"}));
        }
        domainConfigurationModel.put("operation", (Object)"view");
        domainConfigurationModel = this.getDomainTableData(request, domainConfigurationModel);
        JsonResponse.getInstance().sendResponse(response, domainConfigurationModel.toString());
    }

    private JSONObject getDomainTableData(HttpServletRequest request, JSONObject resultantJson) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
        ArrayList list = authObj.getConfiguredDomainList();
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Domain Settings", rb.getString("adap.DomainAction.Refresh_domain_Settings_page"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Domain_settings_viewed", "-"}));
        JSONArray domainSettingsArray = new JSONArray();
        domainSettingsArray = APIUtil.getInstance().listToJSONArray(list);
        JSONObject policyStatusJson = APIUtil.getInstance().mapToJSONObject(this.getPolicyStatus(list, rb));
        resultantJson.put("policyStatusMap", (Object)policyStatusJson);
        for (int i = 0; i < domainSettingsArray.length(); ++i) {
            JSONObject inputParamsDetails = new JSONObject();
            JSONArray tableColumnList = new JSONArray();
            JSONArray tableDataList = new JSONArray();
            JSONObject tableData = new JSONObject();
            String cvid = "15024";
            JSONObject addnParamsMap = new JSONObject();
            addnParamsMap.put("readOnly", request.getAttribute("readOnly"));
            JSONObject ret = EmberTableConfig.getInstance().getEmberTableData(cvid, (ArrayList)((Properties)list.get(i)).get("DOMAINCONTROLLERS"), addnParamsMap, rb);
            inputParamsDetails = ret.getJSONObject("tableInputParams");
            inputParamsDetails.put("isSearch", true);
            inputParamsDetails.put("eventfetchmodes", (Object)new JSONArray("[{\"name\":\"Realtime\",\"value\":3}, {\"name\":\"Schedule\",\"value\":1}]"));
            inputParamsDetails.put("hoursoption", (Object)new JSONArray("[{\"name\":\"0\",\"value\":\"0\"},{\"name\":\"1\",\"value\":\"1\"},{\"name\":\"2\",\"value\":\"2\"} ,{\"name\":\"3\",\"value\":\"3\"} ,{\"name\":\"4\",\"value\":\"4\"} ,{\"name\":\"5\",\"value\":\"5\"} ,{\"name\":\"6\",\"value\":\"6\"} ,{\"name\":\"7\",\"value\":\"7\"} ,{\"name\":\"8\",\"value\":\"8\"} ,{\"name\":\"9\",\"value\":\"9\"} ,{\"name\":\"10\",\"value\":\"10\"} ,{\"name\":\"11\",\"value\":\"11\"} ,{\"name\":\"12\",\"value\":\"12\"} ,{\"name\":\"13\",\"value\":\"13\"} ,{\"name\":\"14\",\"value\":\"14\"} ,{\"name\":\"15\",\"value\":\"15\"} ,{\"name\":\"16\",\"value\":\"16\"} ,{\"name\":\"17\",\"value\":\"17\"} ,{\"name\":\"18\",\"value\":\"18\"} ,{\"name\":\"19\",\"value\":\"19\"} ,{\"name\":\"20\",\"value\":\"20\"} ,{\"name\":\"21\",\"value\":\"21\"},{\"name\":\"22\",\"value\":\"22\"} ,{\"name\":\"23\",\"value\":\"23\"}]"));
            inputParamsDetails.put("minutesoption", (Object)new JSONArray("[{\"name\":\"0\",\"value\":\"0\"},{\"name\":\"5\",\"value\":\"5\"} ,{\"name\":\"10\",\"value\":\"10\"} ,{\"name\":\"15\",\"value\":\"15\"} ,{\"name\":\"20\",\"value\":\"20\"} ,{\"name\":\"25\",\"value\":\"25\"} ,{\"name\":\"30\",\"value\":\"30\"} ,{\"name\":\"35\",\"value\":\"35\"} ,{\"name\":\"40\",\"value\":\"40\"} ,{\"name\":\"45\",\"value\":\"45\"} ,{\"name\":\"50\",\"value\":\"50\"} ,{\"name\":\"55\",\"value\":\"55\"}]"));
            JSONObject temp = ret.getJSONObject("tableData");
            tableColumnList = temp.getJSONArray("tableColumnList");
            tableDataList = temp.getJSONArray("tableDataList");
            domainSettingsArray.getJSONObject(i).put("inputParamsDetails", (Object)inputParamsDetails);
            tableData.put("tableColumnList", (Object)tableColumnList);
            tableData.put("tableDataList", (Object)tableDataList);
            domainSettingsArray.getJSONObject(i).put("tableData", (Object)tableData);
        }
        resultantJson.put("list", (Object)domainSettingsArray);
        resultantJson.put("demo", CommonUtil.isDemo());
        return resultantJson;
    }

    private JSONArray getAddDcColumnList() throws Exception {
        return new JSONArray("[{visible:true,sortenabled:false,searchenabled:false,isCheckBox:true},{visible:true,sortenabled:false,searchenabled:true,isCheckBox:false,displayname:\"DOMAIN CONTROLLER NAME\",columnalias:DCS}]");
    }

    private JSONArray getAddDcDataList(JSONArray dcList, HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONArray tableDataList = new JSONArray();
        for (int i = 0; i < dcList.length(); ++i) {
            JSONArray columnvalues = new JSONArray();
            JSONObject tableDataListObject = new JSONObject();
            tableDataListObject.put("isCheckBox", true);
            tableDataListObject.put("visible", true);
            tableDataListObject.put("columnValue", (Object)dcList.getString(i));
            columnvalues.put((Object)tableDataListObject);
            tableDataListObject = new JSONObject();
            tableDataListObject.put("isData", true);
            tableDataListObject.put("visible", true);
            tableDataListObject.put("columnValue", (Object)dcList.getString(i));
            columnvalues.put((Object)tableDataListObject);
            JSONObject columnvaluesObject = new JSONObject();
            columnvaluesObject.put("columnValues", (Object)columnvalues);
            columnvaluesObject.put("rowId", (Object)dcList.getString(i));
            tableDataList.put((Object)columnvaluesObject);
        }
        return tableDataList;
    }

    private void setTimePeriodMap(Properties properties) {
        String[] hours = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
        ArrayList<String> hourList = new ArrayList<String>();
        for (String string : hours) {
            hourList.add(string);
        }
        properties.put("HOUR_PERIOD_VALUES", hourList);
        properties.put("HOUR_PERIOD_DISPLAY", hourList);
        String[] minutes = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
        ArrayList<String> minuteList = new ArrayList<String>();
        for (String string : minutes) {
            minuteList.add(string);
        }
        properties.put("MINUTE_PERIOD_VALUES", minuteList);
        properties.put("MINUTE_PERIOD_DISPLAY", minuteList);
    }

    public void addDCDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject resultantJson = new JSONObject();
        try {
            String dcDetails = request.getParameter("dcDetails");
            JSONObject dcDetailsObj = new JSONObject(dcDetails);
            String domainName = dcDetailsObj.getString("domainName");
            HttpSession session = request.getSession();
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
            JSONArray dcIdArray = dcDetailsObj.getJSONArray("DOMAIN_CONTROLLER_ID");
            ArrayList<String> dcList = new ArrayList<String>();
            String dcNames = "";
            for (int i = 0; i < dcIdArray.length(); ++i) {
                dcList.add(dcIdArray.get(i).toString().toLowerCase());
                dcNames = dcNames == "" ? dcIdArray.get(i).toString() : dcNames + "," + dcIdArray.get(i).toString();
            }
            Properties domainProperties = DomainHandler.getConfiguredValuesForModify((String)domainName);
            domainProperties.put("DOMAIN_CONTROLLER_LIST", dcList);
            DomainHandler.getDomainDetails((Properties)domainProperties, (boolean)true);
            DomainHandler.addDomainControllers((Properties)domainProperties);
            EventDataUtil.getComputerDetails((String)domainName, null);
            String message = null;
            if (DomainHandler.startDomainDiscovery()) {
                message = rb.getString("adap.DomainAction.Domain_discovery_is_in_progress");
            }
            if (message == null) {
                message = rb.getString("adap.DomainAction.Successfully_added_domain_controllers_Event");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.added_dc_for_domain", new String[]{dcNames, domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.dc_added", "-"}));
            resultantJson.put("message", (Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultantJson.put("message", (Object)(rb.getString("adap.Home.Domain_Settings.Add_domain_controllers.Error_while_adding_domain_controller") + e.getMessage()));
            resultantJson.put("errHandler", (Object)"1");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.getString("adap.Home.Domain_Settings.Add_domain_controllers.Error_while_adding_domain_controller") + e.getMessage(), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.dc_added", "-"}));
        }
        resultantJson = this.getDomainTableData(request, resultantJson);
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    private void modifyDetails(DynaActionForm domainDetails, HttpServletRequest request, ActionMapping mapping) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String display = request.getParameter("display");
            if (display == null || display.equals("")) {
                logger.log(Level.INFO, "do nothing");
            } else {
                domainDetails.initialize(mapping);
                String domainName = request.getParameter("DOMAIN_NAME");
                Properties p = DomainHandler.getConfiguredValuesForModify((String)domainName);
                logger.log(Level.INFO, "getting configured values : " + p);
                this.setValues(domainDetails, p);
                domainDetails.set("DOMAIN_NAME", (Object)domainName);
                domainDetails.set("PASSWORD", (Object)"");
                request.setAttribute("showDetailsPage", (Object)"true");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.getString("adap.DomainAction.Modify_Domain_Successfully") + "\n" + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Domain_settings_changed", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void connect(String domainName, HttpServletRequest request) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            DomainHandler.setDefaultDomain((String)domainName, (boolean[])new boolean[0]);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.set_as_Default_Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.default_dommain_set", "-"}));
            logger.log(Level.INFO, "DEFAULT DOMAIN SET SUCCESSFULLY: domain name is " + domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONObject save(JSONObject saveDomainDetailsObj, HttpServletRequest request, String params) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = 1L;
        String errHandler = "0";
        String showDetailsPage = "false";
        String userName = "";
        String userPwd = "";
        if (saveDomainDetailsObj.has("USER_DISTINGUISHED_NAME")) {
            userName = saveDomainDetailsObj.getString("USER_DISTINGUISHED_NAME");
        }
        if (saveDomainDetailsObj.has("PASSWORD")) {
            userPwd = saveDomainDetailsObj.getString("PASSWORD");
        }
        ArrayList dcDetails = new ArrayList();
        String message = null;
        String domainName = saveDomainDetailsObj.getString("DOMAIN_NAME");
        Properties prop = new Properties();
        prop.put("DOMAIN_NAME", saveDomainDetailsObj.getString("DOMAIN_NAME"));
        prop.put("USER_DISTINGUISHED_NAME", userName);
        prop.put("PASSWORD", userPwd);
        prop.put("IS_AUTHENTICATION_REQUIRED", saveDomainDetailsObj.getString("IS_AUTHENTICATION_REQUIRED"));
        Properties selectedDomain = DomainHandler.getSelectedDomain((Long)1L);
        if (selectedDomain.getProperty("IS_DEFAULT_DOMAIN") == null || selectedDomain.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("false")) {
            prop.put("IS_DEFAULT_DOMAIN", "true");
        } else {
            prop.put("IS_DEFAULT_DOMAIN", "false");
        }
        JSONArray dcPropertiesJsonArray = saveDomainDetailsObj.getJSONArray("DC_PROPERTIES_LIST");
        ArrayList<JSONObject> dcPropertiesList = new ArrayList<JSONObject>();
        for (int i = 0; i < dcPropertiesJsonArray.length(); ++i) {
            dcPropertiesList.add(dcPropertiesJsonArray.getJSONObject(i));
        }
        ArrayList<String> dcList = new ArrayList<String>();
        HashMap<String, Properties> dcPropsMap = new HashMap<String, Properties>();
        logger.log(Level.INFO, "DC_PROPERTIES_LIST :" + dcPropertiesList);
        for (Object e : dcPropertiesList) {
            JSONObject dcPropertiesObj = new JSONObject(e.toString());
            Properties dcProperties = this.parseJsonToProperties(dcPropertiesObj);
            try {
                String hour = dcProperties.getProperty("HOUR_PERIOD");
                String minute = dcProperties.getProperty("MINUTE_PERIOD");
                Long timePeriod = Long.parseLong(hour) * 60L + Long.parseLong(minute);
                dcProperties.setProperty("TIME_PERIOD", timePeriod.toString());
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
            String domainControllerName = dcProperties.getProperty("DOMAIN_CONTROLLER_NAME");
            dcList.add(domainControllerName.toLowerCase());
            dcPropsMap.put(domainControllerName, dcProperties);
        }
        logger.log(Level.INFO, "DC_PROPERTIES_LIST 2:" + dcPropertiesList);
        prop.put("DOMAIN_CONTROLLER_LIST", dcList);
        prop.put("DC_PROP_MAP", dcPropsMap);
        prop.put("ldapSSL", "false");
        ArrayList beanPropList = (ArrayList)dcPropertiesList.clone();
        for (Object object2 : beanPropList) {
            JSONObject dcPropertiesObjClone = new JSONObject(object2.toString());
            Properties properties = this.parseJsonToProperties(dcPropertiesObjClone);
            this.setTimePeriodMap(properties);
        }
        try {
            if (params == "add") {
                if (DomainHandler.addDomainDetails((Properties)prop, (boolean[])new boolean[0])) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.new_Domain_Added", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.New_domain_added", rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()})}));
                    message = rb.getString("adap.DomainAction.Domain_added_successfully");
                    new SchemaUpdate(domainName).start();
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_adding_new_domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.New_domain_added", rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()})}));
                    message = rb.getString("adap.DomainAction.Problem_in_Adding_the_Domain");
                    showDetailsPage = "true";
                }
            } else {
                Properties properties = DomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                prop.put("IS_DEFAULT_DOMAIN", (String)properties.get("IS_DEFAULT_DOMAIN"));
                if (DomainHandler.updateDomainDetails((Properties)prop, (boolean[])new boolean[0])) {
                    String[] selectedUpdates = new String[]{"Exchange", "Policy"};
                    DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
                    message = rb.getString("adap.DomainAction.Successfully_Updated_the_Values");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.domain_values_updated", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()})}));
                } else {
                    message = rb.getString("adap.DomainAction.Problem_in_Updating_the_Domain");
                    showDetailsPage = "true";
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.domain_values_updated_failed", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message = exception.getMessage();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.domain_values_updated_failed", new String[]{domainName}) + "\n " + message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            showDetailsPage = "true";
            errHandler = "1";
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("showDetailsPage", (Object)showDetailsPage);
        jSONObject.put("errHandler", (Object)errHandler);
        jSONObject.put("message", (Object)message);
        return jSONObject;
    }

    public void schedulerUpdation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String schedulerData = request.getParameter("schedulerData");
        JSONObject schedulerObj = new JSONObject(schedulerData);
        HttpSession session = request.getSession();
        if (schedulerObj.has("domainName")) {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)schedulerObj.getString("domainName"));
        }
        JSONArray scheduleIdArray = schedulerObj.getJSONArray("scheduleId");
        String action = schedulerObj.getString("action");
        ArrayList<Long> selectedSchedulers = new ArrayList<Long>();
        for (int i = 0; i < scheduleIdArray.length(); ++i) {
            selectedSchedulers.add(Long.parseLong(scheduleIdArray.get(i).toString()));
        }
        ArrayList dcList = ReportUtil.getDCFromScheduleId(selectedSchedulers);
        String message = null;
        if (action.equalsIgnoreCase("Disable")) {
            message = rb.getString("adap.DomainAction.The_event_collection_from_the");
            logger.log(Level.INFO, "Disabling Scheduler ..");
            for (int i = 0; i < selectedSchedulers.size(); ++i) {
                EventSchedulerUtil.enableDisableScheduler((Long)((Long)selectedSchedulers.get(i)), (String)"Disable");
            }
            logger.log(Level.INFO, "DC SCHEDULER DISABLED SUCCESSFULLY");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.disabled_DCS", new String[]{String.valueOf(selectedSchedulers.size()), schedulerObj.getString("domainName")}) + "\n" + rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
        } else if (action.equalsIgnoreCase("Enable")) {
            message = rb.getString("adap.DomainAction.Successfully_scheduled_the_event_collection");
            for (int i = 0; i < selectedSchedulers.size(); ++i) {
                logger.log(Level.INFO, "id is " + (Long)selectedSchedulers.get(i));
                int enabledSchedulerCount = EventSchedulerUtil.getEnabledEventSchedulerCount();
                String domainControllers = LicenseUtil.getLicenseProperty((String)"DomainController", (String)"NumberOfDomainControllers");
                int domainControllersCount = Integer.parseInt(domainControllers);
                if (enabledSchedulerCount < domainControllersCount) {
                    EventSchedulerUtil.enableDisableScheduler((Long)((Long)selectedSchedulers.get(i)), (String)"Enable");
                    continue;
                }
                message = rb.getString("adap.DomainAction.License_Level_Exceed");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.enabled_dcs", new String[]{String.valueOf(selectedSchedulers.size()), schedulerObj.getString("domainName")}) + "\n " + rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
            logger.log(Level.INFO, "DC SCHEDULER ENABLED SUCCESSFULLY");
        } else if (action.equalsIgnoreCase("modifyPeriod")) {
            Long dcId = schedulerObj.getLong("dcId");
            Row row = ReportUtil.getFirstRow((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID", (Object)dcId, (int)0);
            String osVersion = schedulerObj.getString("osVersion");
            Integer fetchMode = schedulerObj.getInt("fetchMode");
            Integer version = null;
            if (osVersion != null) {
                Integer n = osVersion.indexOf(".");
                version = Integer.parseInt(osVersion.substring(0, n));
            }
            try {
                boolean changeMode;
                if (fetchMode == 1) {
                    DomainActionHandler.updateScheduleTime(selectedSchedulers, schedulerObj);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.event_fetch_interval_changed", new String[]{(String)row.get("DOMAIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                }
                if (null != version && version >= 6 && (changeMode = DCHandler.isEventFetchChange((Long)dcId, (Integer)fetchMode))) {
                    RealTimeEventUtil.getInstance().changeDcFetchMode(dcId, fetchMode);
                    RealTimeEventUtil.getInstance().checkAndUpdate(dcId, fetchMode);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.event_fetch_interval_to_real_Time", new String[]{(String)row.get("DOMAIN_CONTROLLER_NAME"), (String)row.get("DOMAIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                }
                message = rb.getString("adap.ImportLogFileAction.Successfully_updated");
            }
            catch (Exception ex) {
                message = rb.getString("adap.DomainConfiguration.Error_While_updating_time");
                ex.printStackTrace();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.failed_to_change_real_time", new String[]{(String)row.get("DOMAIN_CONTROLLER_NAME"), schedulerObj.getString("domainName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
            }
            logger.log(Level.INFO, "DC SCHEDULER TIME CHANGED SUCCESSFULLY");
        } else if (action.equalsIgnoreCase("modifySelectedPeriods")) {
            try {
                DomainActionHandler.updateScheduleTime(selectedSchedulers, schedulerObj);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.event_fetch_interval_changed", new String[]{schedulerObj.getString("domainName")}) + "\n" + rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                message = rb.getString("adap.DomainAction.Successfully_Updated_the_Event_Fetch");
                logger.log(Level.INFO, "DC SCHEDULER TIME CHANGED SUCCESSFULLY modifySelectedPeriods");
            }
            catch (Exception ex) {
                message = ex.getMessage();
                ex.printStackTrace();
            }
        }
        JSONObject updatedDetails = new JSONObject();
        updatedDetails.put("message", (Object)message);
        updatedDetails = this.getDomainTableData(request, updatedDetails);
        JsonResponse.getInstance().sendResponse(response, updatedDetails.toString());
    }

    public void updateDomainDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String modifyDomainDetails = request.getParameter("modifyDomainDetails");
        JSONObject modifyDomainDetailsObj = new JSONObject(modifyDomainDetails);
        String operation = modifyDomainDetailsObj.getString("operation");
        JSONObject resultantJson = new JSONObject();
        if (operation.equalsIgnoreCase("modifyCredentials")) {
            String domainName = modifyDomainDetailsObj.getString("domainName");
            try {
                logger.log(Level.INFO, "Into Modify Credentials");
                String authChecked = modifyDomainDetailsObj.getString("authChecked");
                HttpSession session = request.getSession();
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)modifyDomainDetailsObj.getString("domainName"));
                String userName = "";
                String password = "";
                Properties domainDetails = DomainHandler.getConfiguredValuesForModify((String)domainName);
                domainDetails.setProperty("IS_AUTHENTICATION_REQUIRED", authChecked);
                if (authChecked.equalsIgnoreCase("true")) {
                    userName = modifyDomainDetailsObj.getString("userName");
                    password = modifyDomainDetailsObj.getString("password");
                    domainDetails.setProperty("USER_DISTINGUISHED_NAME", userName);
                    domainDetails.setProperty("PASSWORD", password);
                }
                Properties properties = DomainHandler.getDomainDetails((Properties)domainDetails, (boolean)true);
                properties.remove("ldapSSL");
                boolean status = DomainHandler.updateCredentials((Properties)properties);
                if (status) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.credential_updated", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.cred_updated", "-"}));
                    resultantJson.put("messageStatus", (Object)"success");
                    resultantJson.put("message", (Object)rb.handleGetObject("adap.DomainAction.Successfully_updated_the_Credentails", new String[]{domainName}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.failed_to_update_credential", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.cred_updated", "-"}));
                    resultantJson.put("messageStatus", (Object)"failure");
                    resultantJson.put("message", (Object)rb.handleGetObject("adap.DomainAction.Error_in_Updating_Credentails", new String[]{domainName}));
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, e.getMessage());
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.Error_in_Updating_Credentails", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.cred_updated", e.getMessage()}));
                resultantJson.put("messageStatus", (Object)"failure");
                resultantJson.put("message", (Object)(rb.handleGetObject("adap.DomainAction.Error_in_Updating_Credentails", new String[]{domainName}) + e.getMessage()));
            }
        }
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    public void updateDomainControllers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String dcToDelete = request.getParameter("dcToDeleteData");
        JSONObject dcToDeleteObj = new JSONObject(dcToDelete);
        String operation = dcToDeleteObj.getString("operation");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        session.setAttribute("MONITOR_DOMAIN_NAME", (Object)dcToDeleteObj.getString("domainName"));
        String message = rb.getString("adap.MSHandler.Successfully_deleted");
        if (operation.equalsIgnoreCase("delete")) {
            JSONArray dcIdArray = dcToDeleteObj.getJSONArray("DOMAIN_CONTROLLER_ID");
            for (int i = 0; i < dcIdArray.length(); ++i) {
                Long dcId = dcIdArray.getLong(i);
                Row row = ReportUtil.getFirstRow((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID", (Object)dcId, (int)0);
                DomainHandler.deleteDomainController((Long)dcId);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.deleted_dcs", new String[]{(String)row.get("DOMAIN_CONTROLLER_NAME"), (String)session.getAttribute("MONITOR_DOMAIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_dcs", "-"}));
            }
            logger.log(Level.INFO, "DC DELETED SUCCESSFULLY");
        }
        JSONObject deleteResult = new JSONObject();
        deleteResult.put("message", (Object)message);
        deleteResult = this.getDomainTableData(request, deleteResult);
        JsonResponse.getInstance().sendResponse(response, deleteResult.toString());
    }

    public void runDCEventScheduler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject resultantJson = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        String runScheduleData = request.getParameter("runScheduleData");
        JSONObject runScheduleDataObj = new JSONObject(runScheduleData);
        String dcIdStr = runScheduleDataObj.getString("dcId");
        String scheduleIdStr = runScheduleDataObj.getString("scheduleId");
        Long scheduleId = Long.parseLong(scheduleIdStr);
        String message = "";
        String messageType = "success";
        if (dcIdStr != null) {
            Long dcId = Long.parseLong(dcIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMDCConfiguration", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMDCConfiguration");
                String domainName = (String)row.get("DOMAIN_NAME");
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
                String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                try {
                    EventDataHandler.getInstance().fillEventData(domainName, dcName, scheduleId, 1, null);
                    message = rb.handleGetObject("adap.DomainAction.Started_fetching_Event_Data_from", new String[]{dcName});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.run_now_dc", new String[]{dcName, domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manual_dc_run", "-"}));
                }
                catch (Exception e) {
                    messageType = "failure";
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.runnow_dc_failed", new String[]{dcName, e.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.manual_dc_run", "-"}));
                }
            }
        }
        resultantJson.put("message", (Object)message);
        resultantJson.put("messageType", (Object)messageType);
        JsonResponse.getInstance().sendResponse(response, resultantJson.toString());
    }

    private void setValues(DynaActionForm form, Properties p) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            try {
                if (form.get(key) == null) continue;
                form.set(key, p.get(key));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void checkBoxValues(DynaActionForm domainDetails, JSONObject saveDomainDetailsObj) throws Exception {
        String[] arr = new String[]{"IS_AUTHENTICATION_REQUIRED"};
        if (saveDomainDetailsObj.get(arr[0]) == null) {
            domainDetails.set(arr[0], (Object)"false");
        } else {
            domainDetails.set(arr[0], (Object)"true");
        }
    }

    private HashMap getPolicyStatus(ArrayList list, AdventNetResourceBundle rb) throws Exception {
        HashMap<String, Properties> domainMap = new HashMap<String, Properties>();
        PolicyHandler polHandler = new PolicyHandler();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Properties prop = (Properties)list.get(i);
                String gpoGuids = "";
                String policyStatus = "";
                String domainName = prop.getProperty("DOMAIN_NAME");
                boolean auditDDCPolicyState = polHandler.getAuditPolicy(domainName, "{6AC1786C-016F-11D2-945F-00C04fB984F9}", false);
                boolean gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)4);
                if (gpoStatus && auditDDCPolicyState) {
                    policyStatus = rb.getString("adap.DomainAction.Success");
                } else if (!auditDDCPolicyState && !gpoStatus) {
                    policyStatus = rb.getString("adap.DomainAction.Configure_Default_Domain_Controllers_Policy_Member_Servers");
                    gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                    gpoGuids = gpoGuids + ",";
                    gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
                } else if (!gpoStatus) {
                    policyStatus = rb.getString("adap.DomainAction.Configure_Default_Domain_Policy");
                    gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
                } else if (!auditDDCPolicyState) {
                    gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                    policyStatus = rb.getString("adap.DomainAction.Configure_Default_Domain_Controllers_Policy");
                }
                Properties props = new Properties();
                props.put("gpoGuids", gpoGuids);
                props.put("policyStatus", policyStatus);
                domainMap.put(domainName, props);
            }
        }
        return domainMap;
    }

    public void getDomainScope(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        logger.log(Level.INFO, "*************Inside getDomainScope*********************");
        String domainName = request.getParameter("domainName");
        String messageType = "Success";
        String message = "false";
        HttpSession session = request.getSession();
        session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        try {
            String domainFlatName = DomainDetailsAPI.getDomainFlatName((String)domainName, (boolean)false);
            logger.log(Level.INFO, "DomainFlat Name is: " + domainFlatName);
            boolean domainScope = false;
            if (domainFlatName == null) {
                String msg = rb.getString("adap.PolicyHandler.Domain_Flat_name_returns_empty");
                domainScope = true;
            } else {
                boolean bl = domainScope = ADHandler.IsLocalDomain((String)domainFlatName) || ADHandler.isTrustedDomain((String)domainName);
            }
            message = domainScope ? "true" : "false";
        }
        catch (Exception e) {
            messageType = "failure";
            message = "true";
            e.printStackTrace();
        }
        logger.log(Level.INFO, "***************Leaving getDomainScope***********************");
        JSONObject messageJson = new JSONObject();
        messageJson.put("response", (Object)response);
        messageJson.put("messageType", (Object)messageType);
        messageJson.put("message", (Object)message);
        JsonResponse.getInstance().sendResponse(response, messageJson.toString());
    }

    public static void updateScheduleTime(ArrayList selectedSchedulers, JSONObject schedulerObj) {
        try {
            if (!selectedSchedulers.isEmpty()) {
                Long[] scheduleIds = new Long[selectedSchedulers.size()];
                for (int i = 0; i < selectedSchedulers.size(); ++i) {
                    scheduleIds[i] = (Long)selectedSchedulers.get(i);
                }
                HashMap<String, Object> schedulerPropsMap = new HashMap<String, Object>();
                String timePeriod = schedulerObj.getString("timePeriod");
                String unitOfTime = schedulerObj.getString("unitOfTime");
                schedulerPropsMap.put("SCHEDULE_ID", scheduleIds);
                schedulerPropsMap.put("TIME_PERIOD", Long.parseLong(timePeriod));
                schedulerPropsMap.put("UNIT_OF_TIME", unitOfTime);
                SchedulerUtil.updatePeriodicScheduler(schedulerPropsMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addDcList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        ArrayList dcList = new ArrayList();
        boolean resolveSuccess = false;
        JSONObject dcListDetails = new JSONObject();
        ArrayList domainlist = new ArrayList();
        domainlist = DomainDetailsAPI.getConfiguredDomainList();
        if (domainlist.contains(domainName)) {
            Hashtable map = NonConfiguredDCDetails.domainControllerList((String)domainName);
            if (map != null) {
                dcList = (ArrayList)map.get("validDCNames");
            }
        } else {
            dcList = ADHandler.GetDCName((String)domainName);
        }
        if (dcList != null && !dcList.isEmpty()) {
            resolveSuccess = true;
            JSONArray dcListArray = new JSONArray();
            dcListArray = APIUtil.getInstance().listToJSONArray(dcList);
            JSONArray tableColumnList = new JSONArray();
            JSONArray tableDataList = new JSONArray();
            JSONObject tableData = new JSONObject();
            tableColumnList = this.getAddDcColumnList();
            tableDataList = this.getAddDcDataList(dcListArray, request);
            tableData.put("tableColumnList", (Object)tableColumnList);
            tableData.put("tableDataList", (Object)tableDataList);
            dcListDetails.put("tableData", (Object)tableData);
        }
        JSONObject dcListObject = new JSONObject();
        dcListObject.put("dcList", (Object)dcListDetails);
        JSONObject tableInputParams = new JSONObject();
        dcListObject.put("tableInputParams", (Object)tableInputParams);
        dcListObject.put("resolveSuccess", resolveSuccess);
        JsonResponse.getInstance().sendResponse(response, dcListObject.toString());
    }

    public Properties parseJsonToProperties(JSONObject json) throws Exception {
        Iterator keys = json.keys();
        Properties p = new Properties();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            p.setProperty(key, json.get(key).toString());
        }
        return p;
    }
}

