/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.alerts;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPSettingsHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlertsHandler {
    private static volatile AlertsHandler instance = null;
    private static Logger logger = Logger.getLogger(AlertsHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertsHandler getInstance() {
        if (instance != null) return instance;
        Class<AlertsHandler> clazz = AlertsHandler.class;
        synchronized (AlertsHandler.class) {
            if (instance != null) return instance;
            instance = new AlertsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void getAlertDetails(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long alert_id = Long.parseLong(request.getParameter("alertid"));
            HashMap detailsMap = AlertAPI.getInstance().showAlertDetails(alert_id);
            String tableName = (String)detailsMap.get("tableName");
            Long uniqueId = (Long)detailsMap.get("uniqueId");
            if (tableName.equalsIgnoreCase("AUDPrintjobsinqueue")) {
                ArrayList rowList = PrintHandler.getRows((Long)uniqueId);
                Properties list = (Properties)rowList.get(0);
                JSONArray retArray = new JSONArray();
                Enumeration<?> e = list.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    JSONObject jo = new JSONObject();
                    jo.put("rowKey", (Object)key);
                    jo.put("rowValue", (Object)list.getProperty(key));
                    retArray.put((Object)jo);
                }
                ret.put("alertDetailsArray", (Object)retArray);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Printers_Alert_Viewed"), 4, 8, "ADAPUserAuditSeverities.audit_name.Printer_Alert_Viewed", "-"}));
            } else if (tableName.equalsIgnoreCase("AudGPOAuditInfo")) {
                JSONArray categories = new JSONArray();
                HashMap settingsMap = GPSettingsHandler.getSettingsChangeRow((String)"UNIQUE_ID", (String)uniqueId.toString());
                Set keySet = settingsMap.keySet();
                for (Object object : keySet) {
                    JSONObject category = new JSONObject();
                    category.put("name", object);
                    JSONArray rows = new JSONArray();
                    ArrayList settingsList = (ArrayList)settingsMap.get(object);
                    boolean isAdmTemplate = false;
                    if (!settingsList.isEmpty()) {
                        HashMap detailMap = (HashMap)settingsList.get(0);
                        isAdmTemplate = (Boolean)detailMap.get("IS_ADM_TEMPLATE");
                    }
                    if (isAdmTemplate) {
                        category.put("IS_ADM_TEMPLATE", true);
                    }
                    for (int i = 0; i < settingsList.size(); ++i) {
                        JSONObject row = new JSONObject();
                        HashMap detailValueMap = (HashMap)settingsList.get(i);
                        Integer changeType = (Integer)detailValueMap.get("CHANGE_TYPE");
                        row.put("SETTING_NAME", detailValueMap.get("SETTING_NAME"));
                        row.put("CHANGE_TYPE_TEXT", detailValueMap.get("CHANGE_TYPE_TEXT"));
                        row.put("SETTING_OLD_VALUE", detailValueMap.get("SETTING_OLD_VALUE"));
                        row.put("SETTING_NEW_VALUE", detailValueMap.get("SETTING_NEW_VALUE"));
                        row.put("COMMENT_OLD_VALUE", detailValueMap.get("COMMENT_OLD_VALUE"));
                        row.put("COMMENT_NEW_VALUE", detailValueMap.get("COMMENT_NEW_VALUE"));
                        if (changeType == 1) {
                            row.put("rowClass", (Object)"primary-color");
                        } else if (changeType == 2) {
                            row.put("rowClass", (Object)"");
                        } else {
                            row.put("rowClass", (Object)"text-danger");
                        }
                        rows.put((Object)row);
                    }
                    category.put("rows", (Object)rows);
                    categories.put((Object)category);
                }
                ret.put("categories", (Object)categories);
                ret.put("isGPO", true);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.GPO_Alert_Viewed"), 4, 8, "ADAPUserAuditSeverities.audit_name.GPO_Alert_Viewed", "-"}));
            } else {
                HashMap columnDetailsMap;
                String uniqueIdStr = request.getParameter("uid");
                Long cvID = AUDCustomViewAPI.getInstance().getReportCVId((Long)detailsMap.get("reportID"));
                if (uniqueIdStr != null) {
                    uniqueId = Long.parseLong(request.getParameter("uid"));
                }
                ArrayList columnList = AUDCustomViewAPI.getInstance().getColumnList(cvID);
                if (tableName.equals("AUDLogonLogoffInfo") && (columnDetailsMap = (HashMap)columnList.get(0)).get("TABLEALIAS").equals("AUDNPSAuditInfo")) {
                    tableName = "AUDNPSAuditInfo";
                }
                String queryString = "SELECT * FROM " + tableName + " WHERE UNIQUE_ID = " + uniqueId;
                ArrayList rowList = QueryUtil.getRows((String)queryString, (ArrayList)columnList, new HashMap(), (Boolean)false);
                ArrayList reportsList = AlertAPI.getInstance().getRowList(alert_id, tableName);
                if (reportsList != null && uniqueIdStr == null) {
                    JSONArray rowArray = new JSONArray();
                    JSONArray headingArray = new JSONArray();
                    for (int i = 0; i < reportsList.size(); ++i) {
                        JSONObject rowObject = new JSONObject();
                        JSONArray colArray = new JSONArray();
                        ArrayList rowListt = (ArrayList)reportsList.get(i);
                        for (int j = 0; j < rowListt.size(); ++j) {
                            HashMap col = (HashMap)rowListt.get(j);
                            JSONObject colObj = new JSONObject();
                            colObj.put("columnValue", col.get("COLUMN_VALUE"));
                            colArray.put((Object)colObj);
                            if (i == 0) {
                                JSONObject headingObj = new JSONObject();
                                headingObj.put("headingvalue", (Object)rb.getString((String)col.get("DISPLAYNAME")));
                                headingArray.put((Object)headingObj);
                            }
                            if (j != 0) continue;
                            rowObject.put("tableName", col.get("tableName"));
                            rowObject.put("uid", col.get("UNIQUE_ID"));
                            rowObject.put("alertid", (Object)alert_id);
                        }
                        rowObject.put("colArray", (Object)colArray);
                        rowArray.put((Object)rowObject);
                    }
                    ret.put("rowArray", (Object)rowArray);
                    ret.put("headingArray", (Object)headingArray);
                    ret.put("isThresholdBased", true);
                    ret.put("thresholdCount", reportsList.size());
                } else {
                    ArrayList list = (ArrayList)rowList.get(0);
                    JSONArray retArray = new JSONArray();
                    for (int i = 0; i < list.size(); ++i) {
                        JSONObject jo = new JSONObject();
                        jo.put("rowKey", (Object)rb.getString((String)((HashMap)list.get(i)).get("DISPLAYNAME")));
                        jo.put("rowValue", ((HashMap)list.get(i)).get("COLUMN_VALUE"));
                        retArray.put((Object)jo);
                    }
                    ret.put("alertDetailsArray", (Object)retArray);
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Alert_details_viewed"), 4, 8, "ADAPUserAuditSeverities.audit_name.Alert_Details_viewed", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void getAlertData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            HttpSession session;
            ADAPAuthObject authObject;
            HashMap loginUserDetails;
            String domainName;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String alertid = request.getParameter("alertid");
            if (alertid.equals("All")) {
                alertid = "";
            }
            String chosenServerValue = request.getParameter("chosenServerValue");
            String fromTime = request.getParameter("fromTime");
            String toTime = request.getParameter("toTime");
            String alertType = request.getParameter("alertType");
            String alertSeverity = request.getParameter("alertSeverity");
            String searchCriteriaObject = request.getParameter("searchData");
            String searchCriteria = null;
            JSONObject searchData = null;
            if (searchCriteriaObject != null) {
                searchData = new JSONObject(searchCriteriaObject);
                Iterator searchIter = searchData.keys();
                while (searchIter.hasNext()) {
                    searchCriteria = searchCriteria == null ? "" : searchCriteria + " AND ";
                    String key = (String)searchIter.next();
                    searchCriteria = searchCriteria + key + " LIKE '%" + searchData.get(key) + "%' ";
                }
            }
            if (!((domainName = (String)(loginUserDetails = (authObject = (ADAPAuthObject)(session = request.getSession()).getAttribute("ADAP_AUTH_OBJ")).getLoginUserDetails()).get("DELEGATED_DOMAIN")).equalsIgnoreCase(rb.getString("adap.common.text.All_Domains")) || domainName.equalsIgnoreCase("All Domains") || domainName.equalsIgnoreCase("adap.common.text.All_Domains"))) {
                searchCriteria = searchCriteria != null ? searchCriteria + " AND DOMAIN_NAME IN (" + ReportUtil.strToStrWithQuote((String)domainName, (String)",") + ")" : " DOMAIN_NAME IN (" + ReportUtil.strToStrWithQuote((String)domainName, (String)",") + ")";
            }
            String sortColumn = request.getParameter("sortColumn");
            String sortOrder = request.getParameter("sortOrder");
            String perPage = request.getParameter("rangeValue");
            String fromIndex = request.getParameter("fromIndex");
            String cvid = "15011";
            HashMap<String, String> tableDetails = EmberTableConfig.getInstance().getTableDetails(cvid);
            if (sortColumn == null) {
                sortColumn = tableDetails.get("SORTCOLUMN");
            }
            if (sortOrder == null) {
                sortOrder = tableDetails.get("SORTORDER");
            }
            if (perPage == null) {
                perPage = tableDetails.get("PAGELENGTH");
            }
            if (alertType == null) {
                alertType = "0";
            }
            if (alertSeverity == null || alertSeverity.equals("false")) {
                alertSeverity = null;
            }
            if (fromIndex == null) {
                fromIndex = "1";
            }
            int fromIndexInt = Integer.parseInt(fromIndex);
            int range = Integer.parseInt(perPage);
            JSONObject addnParamsMap = new JSONObject();
            addnParamsMap.put("sortColumn", (Object)sortColumn);
            addnParamsMap.put("sortOrder", (Object)sortOrder);
            addnParamsMap.put("searchData", (Object)searchData);
            addnParamsMap.put("rangeValue", (Object)perPage);
            JSONObject emberTableConfig = EmberTableConfig.getInstance().getEmberTableData(cvid, new ArrayList(), addnParamsMap, rb);
            JSONObject emberTableData = emberTableConfig.getJSONObject("tableData");
            JSONObject emberInputParams = emberTableConfig.getJSONObject("tableInputParams");
            JSONArray tableColumnList = emberTableData.getJSONArray("tableColumnList");
            ret.put("periodValues", (Object)AlertAPI.getInstance().getTimeFilterMap2());
            if (chosenServerValue == null || chosenServerValue.equals("")) {
                chosenServerValue = "twfourhours";
            }
            if (!chosenServerValue.equalsIgnoreCase("customPeriod")) {
                HashMap periodMap = TimeUtil.getTimePeriod((String)chosenServerValue);
                fromTime = periodMap.get("FROM").toString();
                toTime = periodMap.get("TO").toString();
            }
            ret.put("chosenServerValue", (Object)chosenServerValue);
            HashMap<String, String> inputParamsMap = new HashMap<String, String>();
            inputParamsMap.put("TO", toTime);
            inputParamsMap.put("FROM", fromTime);
            inputParamsMap.put("SEVERITY", alertType);
            inputParamsMap.put("allPeriod", "0");
            String sCr4Graph = null;
            if (!(domainName.equalsIgnoreCase(rb.getString("adap.common.text.All_Domains")) || domainName.equalsIgnoreCase("All Domains") || domainName.equalsIgnoreCase("adap.common.text.All_Domains"))) {
                sCr4Graph = " DOMAIN_NAME IN (" + ReportUtil.strToStrWithQuote((String)domainName, (String)",") + ")";
            }
            String countStr1 = AlertAPI.getInstance().getAlertsCount(sCr4Graph, inputParamsMap);
            String countStr2 = countStr1.substring(1, countStr1.length() - 1);
            countStr2 = countStr2.replace("COUNT(*)", "COUNT(*) as adapcount,SEVERITY") + " GROUP BY SEVERITY";
            countStr2 = countStr2.replace("AND SEVERITY=${SEVERITYID}", "");
            if (alertid != null && !alertid.equals("")) {
                inputParamsMap.put("ALERT_PROFILE_ID", alertid);
                countStr2 = countStr2.replace("1=1", "ALERT_PROFILE_ID = " + alertid);
            }
            JSONObject graphData = ReportHandlerUtil.getInstance().getReportGraphValues(countStr2, false, "pie", "test", new HashMap());
            int[] graphCount = new int[]{0, 0, 0, 0};
            JSONArray xList = graphData.optJSONArray("xList");
            JSONArray yList = graphData.optJSONArray("yList");
            if (xList != null) {
                for (int i = 0; i < xList.length(); ++i) {
                    graphCount[Integer.parseInt((String)String.valueOf((Object)xList.get((int)i)))] = Integer.parseInt(String.valueOf(yList.get(i)));
                }
            }
            ret.put("clearCount", graphCount[0]);
            ret.put("attentionCount", graphCount[1]);
            ret.put("troubleCount", graphCount[2]);
            ret.put("criticalCount", graphCount[3]);
            ret.put("seriesData", (Object)AlertsHandler.getAlertGraphData(!alertType.equals("0"), graphCount, request));
            ret.put("chartTitle", (Object)rb.getString("adap.alerts.audit.view_alert.graph_title.severity_based_alerts"));
            if (alertSeverity != null) {
                inputParamsMap.put("SEVERITYID", alertSeverity);
            } else {
                inputParamsMap.remove("SEVERITYID");
            }
            String countStr = AlertAPI.getInstance().getAlertsCount(searchCriteria, inputParamsMap);
            countStr = countStr.replace("AND SEVERITY=${SEVERITYID}", "");
            countStr = countStr.replace("${ALERTCOLUMNS}", "");
            countStr = countStr.replace("${ALERT_GROUP_BY}", "");
            int count = QueryUtil.getRowsCount((String)countStr);
            ArrayList alertList = AlertAPI.getInstance().getAlertRows(searchCriteria, inputParamsMap, sortColumn, sortOrder, fromIndexInt, range, alertSeverity, Integer.valueOf(count));
            HashMap thresholdMap = AlertAPI.getInstance().getThresholdCountMap(alertList);
            String dateFormat = CommonUtil.getSysParams((String)"DATE_FORMAT");
            dateFormat = dateFormat + " " + CommonUtil.getSysParams((String)"TIME_FORMAT");
            SimpleDateFormat sdfDate = new SimpleDateFormat(dateFormat);
            sdfDate.setTimeZone(TimeZone.getTimeZone(CommonUtil.getSysParams((String)"TIMEZONE_ID")));
            String[] severity = new String[]{"Clear", "Attention", "Trouble", "Critical"};
            ret.put("timeString", (Object)("(" + rb.getString("adap.common.text.from") + " " + sdfDate.format(new Date(Long.parseLong((String)inputParamsMap.get("FROM")) * 1000L)) + " " + rb.getString("adap.common.text.to") + " " + sdfDate.format(new Date(Long.parseLong((String)inputParamsMap.get("TO")) * 1000L)) + ")"));
            ret.put("alertSeverity", alertSeverity == null ? null : severity[Integer.parseInt(alertSeverity)]);
            if (alertType.equals("0")) {
                ret.put("activeAlerts", true);
            } else {
                ret.put("activeAlerts", false);
            }
            JSONArray perPageItems = new JSONArray();
            for (int i = 0; i < 4; ++i) {
                JSONObject job = new JSONObject();
                job.put("value", 25 * (i + 1));
                perPageItems.put((Object)job);
            }
            emberInputParams.put("startValue", fromIndexInt);
            emberInputParams.put("totalCount", count);
            emberInputParams.put("rangeList", (Object)perPageItems);
            if (searchCriteria != null) {
                emberInputParams.put("isSearch", true);
            }
            JSONArray tableDataList = new JSONArray();
            int len = alertList.size();
            for (int i = 0; i < len; ++i) {
                JSONObject col;
                JSONObject jo = new JSONObject();
                ArrayList alert = (ArrayList)alertList.get(i);
                Long alertId = null;
                JSONArray colValues = new JSONArray();
                for (int j = 0; j < alert.size(); ++j) {
                    JSONObject col2 = new JSONObject();
                    HashMap alertCol = (HashMap)alert.get(j);
                    col2.put("visible", alertCol.get("VISIBLE"));
                    col2.put("bgcolumn", alertCol.get("BGCOLUMN"));
                    col2.put("columnalias", alertCol.get("COLUMNALIAS"));
                    col2.put("escapehtml", alertCol.get("ESCAPE_HTML"));
                    col2.put("columnValue", alertCol.get("COLUMN_VALUE"));
                    col2.put("isData", true);
                    if (j == 0) {
                        alertId = (Long)alertCol.get("COLUMN_VALUE");
                        col2.put("isCheckBox", true);
                        col2.put("isData", false);
                    } else if (j == 6) {
                        String val = "";
                        val = thresholdMap.get(alertId) != null ? rb.getString("adap.common.text.Click_here_to_view_the_last") + " " + thresholdMap.get(alertId) + " " + rb.getString("adap.common.text.events") : "-";
                        col2.put("columnValue", (Object)val);
                    } else if (j == 3) {
                        int val = (Integer)alertCol.get("COLUMN_VALUE");
                        if (val == 1) {
                            col2.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-table-attention col'></i><span class='col'>" + rb.getString("adap.common.text.attention") + "</span></div>"));
                        } else if (val == 2) {
                            col2.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-table-trouble col'></i><span class='col'>" + rb.getString("adap.common.text.trouble") + "</span></div>"));
                        } else if (val == 3) {
                            col2.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-table-critical col'></i><span class='col'>" + rb.getString("adap.common.text.critical") + "</span></div>"));
                        } else {
                            col2.put("columnValue", (Object)("<div class='row'><i class='adap-icon icn-ok col'></i><span class='col'>" + rb.getString("adap.common.text.clear") + "</span></div>"));
                        }
                        col2.put("escapehtml", false);
                    }
                    colValues.put((Object)col2);
                }
                if (thresholdMap.get(alertId) != null) {
                    col = new JSONObject();
                    String val = rb.getString("adap.common.text.Click_here_to_view_the_last") + " " + thresholdMap.get(alertId) + " " + rb.getString("adap.common.text.events");
                    col.put("columnValue", (Object)val);
                    col.put("visible", true);
                    col.put("bgcolumn", false);
                    col.put("escapehtml", true);
                    col.put("isData", true);
                    colValues.put((Object)col);
                } else {
                    col = new JSONObject();
                    col.put("columnValue", (Object)"-");
                    col.put("visible", true);
                    col.put("bgcolumn", false);
                    col.put("escapehtml", false);
                    col.put("isData", true);
                    colValues.put((Object)col);
                }
                jo.put("rowId", ((HashMap)alert.get(0)).get("COLUMN_VALUE"));
                jo.put("rowClass", (Object)"cur-pointer");
                jo.put("columnValues", (Object)colValues);
                tableDataList.put((Object)jo);
            }
            JSONObject alertTableData = new JSONObject();
            alertTableData.put("tableDataList", (Object)tableDataList);
            alertTableData.put("tableColumnList", (Object)tableColumnList);
            if (alertid != null && !alertid.equals("")) {
                String filterText = rb.getString("adap.alerts.audit.view_alerts.tab_text.alert_for_report_profile") + " : ";
                Criteria c = new Criteria(Column.getColumn((String)"AUDAlertProfile", (String)"ALERT_PROFILE_ID"), (Object)Integer.parseInt(alertid), 0);
                DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDAlertProfile", c);
                Row r = dob.getFirstRow("AUDAlertProfile");
                String name = (String)r.get("ALERT_PROFILE_NAME");
                filterText = filterText + rb.getString(name);
                if (alertSeverity != null) {
                    filterText = filterText + " (" + ret.get("alertSeverity") + ")";
                } else {
                    emberInputParams.put("hideFilterTextClose", true);
                }
                emberInputParams.put("filterText", (Object)filterText);
            } else if (alertSeverity != null) {
                Boolean activeAlerts = (Boolean)ret.get("activeAlerts");
                String filterText = "";
                filterText = activeAlerts != false ? filterText + rb.getString("adap.alerts.audit.view_alerts.show_alert_status_text.active_alerts_text") : filterText + rb.getString("adap.alerts.audit.view_alerts.show_alert_status_text.all_alerts_text");
                filterText = filterText + " (" + ret.get("alertSeverity") + ")";
                emberInputParams.put("filterText", (Object)filterText);
            }
            ret.put("alertTableData", (Object)alertTableData);
            ret.put("tableInputParams", (Object)emberInputParams);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.alert_was_generated"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Alerts_generated", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static JSONArray getAlertGraphData(Boolean allAlerts, int[] graphCount, HttpServletRequest request) {
        JSONArray seriesData = new JSONArray();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject att = new JSONObject();
            att.put("name", (Object)rb.getString("adap.common.text.attention"));
            att.put("y", graphCount[1]);
            att.put("color", (Object)"#edc921");
            seriesData.put((Object)att);
            JSONObject tro = new JSONObject();
            tro.put("name", (Object)rb.getString("adap.common.text.trouble"));
            tro.put("y", graphCount[2]);
            tro.put("color", (Object)"#fa9050");
            seriesData.put((Object)tro);
            JSONObject crit = new JSONObject();
            crit.put("name", (Object)rb.getString("adap.common.text.critical"));
            crit.put("y", graphCount[3]);
            crit.put("color", (Object)"#dc3e3e");
            seriesData.put((Object)crit);
            if (allAlerts.booleanValue()) {
                JSONObject clear = new JSONObject();
                clear.put("name", (Object)rb.getString("adap.common.text.clear"));
                clear.put("y", graphCount[0]);
                clear.put("color", (Object)"#07C400");
                seriesData.put((Object)clear);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seriesData;
    }

    public static void getHomePageAlerts(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            HashMap loginUserDetails = authObject.getLoginUserDetails();
            String domainName = (String)loginUserDetails.get("DELEGATED_DOMAIN");
            String fromTime = String.valueOf(System.currentTimeMillis() / 1000L - 86400L);
            String toTime = String.valueOf(System.currentTimeMillis() / 1000L);
            String alertSeverity = null;
            String searchCriteria = null;
            String sortColumn = "CREATION_TIME";
            String sortOrder = "DESC";
            HashMap<String, String> inputParamsMap = new HashMap<String, String>();
            inputParamsMap.put("TO", toTime);
            inputParamsMap.put("FROM", fromTime);
            inputParamsMap.put("SEVERITY", "0");
            inputParamsMap.put("allPeriod", "0");
            String sCr4Graph = null;
            if (!(domainName.equalsIgnoreCase(rb.getString("adap.common.text.All_Domains")) || domainName.equalsIgnoreCase("All Domains") || domainName.equalsIgnoreCase("adap.common.text.All_Domains"))) {
                searchCriteria = sCr4Graph = " DOMAIN_NAME IN (" + ReportUtil.strToStrWithQuote((String)domainName, (String)",") + ")";
            }
            String countStr1 = AlertAPI.getInstance().getAlertsCount(sCr4Graph, inputParamsMap);
            String countStr2 = countStr1.substring(1, countStr1.length() - 1);
            countStr2 = countStr2.replace("COUNT(*)", "COUNT(*) as adapcount,SEVERITY") + " GROUP BY SEVERITY";
            countStr2 = countStr2.replace("AND SEVERITY=${SEVERITYID}", "");
            JSONObject graphData = ReportHandlerUtil.getInstance().getReportGraphValues(countStr2, false, "pie", "test", new HashMap());
            int[] graphCount = new int[]{0, 0, 0, 0};
            JSONArray xList = graphData.optJSONArray("xList");
            JSONArray yList = graphData.optJSONArray("yList");
            if (xList != null) {
                for (int i = 0; i < xList.length(); ++i) {
                    graphCount[Integer.parseInt((String)String.valueOf((Object)xList.get((int)i)))] = Integer.parseInt(String.valueOf(yList.get(i)));
                }
            }
            inputParamsMap.remove("SEVERITYID");
            int count = 25;
            int fromIndexInt = 0;
            int range = 25;
            ArrayList alertList = AlertAPI.getInstance().getAlertRows(searchCriteria, inputParamsMap, sortColumn, sortOrder, fromIndexInt, range, alertSeverity, Integer.valueOf(count));
            JSONObject cobj = new JSONObject();
            cobj.put("count", graphCount[1]);
            JSONObject mobj = new JSONObject();
            mobj.put("itemId", (Object)"All");
            mobj.put("alertSeverity", (Object)"1");
            cobj.put("model", (Object)mobj);
            ret.put("attentionAlert", (Object)cobj);
            cobj = new JSONObject();
            cobj.put("count", graphCount[2]);
            mobj = new JSONObject();
            mobj.put("itemId", (Object)"All");
            mobj.put("alertSeverity", (Object)"2");
            cobj.put("model", (Object)mobj);
            ret.put("troubleAlert", (Object)cobj);
            cobj = new JSONObject();
            cobj.put("count", graphCount[3]);
            mobj = new JSONObject();
            mobj.put("itemId", (Object)"All");
            mobj.put("alertSeverity", (Object)"3");
            cobj.put("model", (Object)mobj);
            ret.put("criticalAlert", (Object)cobj);
            JSONArray tableDataList = new JSONArray();
            for (int i = 0; i < alertList.size(); ++i) {
                JSONObject jo = new JSONObject();
                ArrayList alert = (ArrayList)alertList.get(i);
                Long alertId = (Long)((HashMap)alert.get(0)).get("COLUMN_VALUE");
                String alertMsg = String.valueOf(((HashMap)alert.get(5)).get("COLUMN_VALUE"));
                String timeString = (String)((HashMap)alert.get(4)).get("COLUMN_VALUE");
                Integer severity = (Integer)((HashMap)alert.get(3)).get("COLUMN_VALUE");
                jo.put("alertId", (Object)alertId);
                jo.put("alertMsg", (Object)alertMsg);
                jo.put("timeString", (Object)timeString);
                if (severity == 1) {
                    jo.put("alertClass", (Object)"attention-alert");
                } else if (severity == 2) {
                    jo.put("alertClass", (Object)"trouble-alert");
                } else if (severity == 3) {
                    jo.put("alertClass", (Object)"critical-alert");
                } else {
                    jo.put("alertClass", (Object)"");
                }
                tableDataList.put((Object)jo);
            }
            ret.put("homepageAlerts", (Object)tableDataList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void clearAlerts(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String ids = request.getParameter("data");
            JSONObject ids1 = new JSONObject(ids);
            JSONArray ids2 = ids1.optJSONArray("ids");
            Long[] ids3 = new Long[ids2.length()];
            for (int i = 0; i < ids2.length(); ++i) {
                ids3[i] = ids2.getLong(i);
            }
            if (AlertAPI.getInstance().clearAlerts(ids3, "clear").booleanValue()) {
                ret.put("success", true);
                ret.put("message", (Object)rb.handleGetObject("adap.alerts.clearedalerts", new String[]{String.valueOf(ids3.length)}));
            } else {
                ret.put("message", (Object)rb.getString("adap.alerts.clearalertsfailed "));
            }
            String message = ids3.length + " alerts were cleared";
            logger.log(Level.INFO, message);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Alerts", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Alert_cleared", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Failed_to_clear_alert"), 8, 16, "ADAPUserAuditSeverities.audit_name.Failed_to_clear_alerts", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public static void deleteAlerts(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String ids = request.getParameter("data");
            JSONObject ids1 = new JSONObject(ids);
            JSONArray ids2 = ids1.optJSONArray("ids");
            Long[] ids3 = new Long[ids2.length()];
            for (int i = 0; i < ids2.length(); ++i) {
                ids3[i] = ids2.getLong(i);
            }
            if (AlertAPI.getInstance().clearAlerts(ids3, "delete").booleanValue()) {
                ret.put("success", true);
                ret.put("message", (Object)rb.handleGetObject("adap.alerts.deletedalerts", new String[]{String.valueOf(ids3.length)}));
            } else {
                ret.put("message", (Object)rb.getString("adap.alerts.deletealertsfailed "));
            }
            String message = ids3.length + " alerts were deleted";
            logger.log(Level.INFO, message);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 16, "Alerts", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Alert_cleared", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Failed_to_clear_alert"), 8, 16, "ADAPUserAuditSeverities.audit_name.Failed_to_clear_alerts", "-"}));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

