/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.fileaudit;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.ExcludeFilesHandler;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileAuditExcludeHandler {
    private static volatile FileAuditExcludeHandler instance = null;
    private static Logger logger = Logger.getLogger(FileAuditExcludeHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileAuditExcludeHandler getInstance() {
        if (instance != null) return instance;
        Class<FileAuditExcludeHandler> clazz = FileAuditExcludeHandler.class;
        synchronized (FileAuditExcludeHandler.class) {
            if (instance != null) return instance;
            instance = new FileAuditExcludeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getExcludeData(HttpServletRequest request, HttpServletResponse response) {
        String ret = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String domainName = request.getParameter("domain");
            ArrayList excludeFileTypesList = ExcludeFilesHandler.getExcludeFileTypeList();
            ArrayList excludeProcessNamesList = ExcludeFilesHandler.getExcludeProcessList();
            ArrayList excludeUsersList = ExcludeFilesHandler.getExcludeUserList();
            ArrayList excludeUsersDetails = new ArrayList();
            for (String user : excludeUsersList) {
                String domain;
                HashMap<String, Object> userDetails = new HashMap<String, Object>();
                userDetails.put("OBJECT_GUID", user);
                Row r = DirectoryObjectAPI.getInstance().getObjectRow(null, user, "user");
                if (r == null || !(domain = (String)r.get("DOMAIN_NAME")).equals(domainName)) continue;
                userDetails.put("NAME", r.get("NAME"));
                userDetails.put("DOMAIN_NAME", r.get("DOMAIN_NAME"));
                excludeUsersDetails.add(userDetails);
            }
            HashMap<Object, Object> excludeInfo = new HashMap<Object, Object>();
            excludeInfo.put("excludeFileTypesList", excludeFileTypesList);
            excludeInfo.put("excludeProcessNamesList", excludeProcessNamesList);
            excludeInfo.put("excludeUsersDetails", excludeUsersDetails);
            ret = APIUtil.getInstance().mapToJSONString(excludeInfo);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.getString("adap.IgnoreFilesAction.audit_entry.page_viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.exclude_file_config_viewed", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void setExcludeData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            ret.put("message", (Object)rb.getString("adap.common.failureoccured"));
            String strData = request.getParameter("data");
            JSONObject data = new JSONObject(strData);
            JSONArray excludeFileTypesList = data.optJSONArray("excludeFileTypesList");
            String temp = JSONUtil.JSONArrayToString((JSONArray)excludeFileTypesList);
            ExcludeFilesHandler.getInstance().saveExcludeList("File Type", temp);
            JSONArray excludeProcessNamesList = data.optJSONArray("excludeProcessNamesList");
            String temp2 = JSONUtil.JSONArrayToString((JSONArray)excludeProcessNamesList);
            ExcludeFilesHandler.getInstance().saveExcludeList("Process Name", temp2);
            JSONArray excludeUsersDetails = data.optJSONArray("excludeUsersDetails");
            String userString = "";
            String domainName = data.getString("selectedDomain");
            for (int i = 0; i < excludeUsersDetails.length(); ++i) {
                JSONObject user = excludeUsersDetails.getJSONObject(i);
                domainName = user.getString("DOMAIN_NAME");
                userString = userString + user.getString("OBJECT_GUID") + ",";
            }
            if (excludeUsersDetails.length() > 0) {
                userString = userString.substring(0, userString.length() - 1);
            }
            ExcludeFilesHandler.getInstance().saveExcludeUserList("User Name", userString, domainName);
            ret.put("message", (Object)rb.getString("adap.AlertsSettings.Successfully_saved_the_settings"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", rb.getString("adap.IgnoreFilesAction.audit_entry.Successfully_excluded"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.successfully_excluded_file", rb.handleGetObject("adap.IgnoreFilesAction.audit_entry.addn.details", new String[]{domainName, temp, temp2, userString})}));
            ret.put("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ret.put("message", (Object)e.getMessage());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }
}

