/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.fileaudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.fileaudit.emc.EMCHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserver;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppVserverDBHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaProtocolException;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileServerConfigHandler {
    private static volatile FileServerConfigHandler instance = null;
    private static Logger logger = Logger.getLogger(FileServerConfigHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileServerConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<FileServerConfigHandler> clazz = FileServerConfigHandler.class;
        synchronized (FileServerConfigHandler.class) {
            if (instance != null) return instance;
            instance = new FileServerConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FileServerConfigHandler() {
    }

    public void listFileServers(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.getFileServers(request, response, null, null, null, null, null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getFileServers(HttpServletRequest request, HttpServletResponse response, String message, String linkMessage, String actionName, String msgType, String selectedServerName, String selectedServerGuid) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            JSONObject fileSummaryInputParams = null;
            if (reportReqData.has("fileSummaryInputParams")) {
                fileSummaryInputParams = reportReqData.getJSONObject("fileSummaryInputParams");
            }
            String domainName = serverInputParams.getString("domainName");
            int[] machineTypes = null;
            String uvhString = "AUDCVConfig:cv_id:10003";
            Long machineType = serverInputParams.getLong("machineType");
            String licenseMsg = null;
            if (machineType == 4L) {
                serverInputParams.put("serverType", (Object)"fs");
                machineTypes = new int[]{4, 8};
                uvhString = "AUDCVConfig:cv_id:15021";
                licenseMsg = "adap.ConfiguredFileServer.You_need_to_purchase_the_File_Server_pack";
            } else if (machineType == 256L) {
                serverInputParams.put("serverType", (Object)"netapp");
                if (fileSummaryInputParams != null) {
                    if (fileSummaryInputParams.has("isNetAppCifsVserver")) {
                        serverInputParams.put("isNetAppCifsVserver", fileSummaryInputParams.getBoolean("isNetAppCifsVserver"));
                    } else {
                        serverInputParams.put("isNetAppCifsVserver", false);
                    }
                }
                machineTypes = new int[]{256, 512, 524288, 0x100000};
                uvhString = "AUDCVConfig:cv_id:15022";
                licenseMsg = "adap.ConfiguredFileServer.You_need_to_purchase_the_NetApp_Filer_pack";
            } else if (machineType == 131072L) {
                serverInputParams.put("serverType", (Object)"emc");
                machineTypes = new int[]{131072, 262144};
                uvhString = "AUDCVConfig:cv_id:15023";
                licenseMsg = "adap.ConfiguredFileServer.You_need_to_purchase_the_NetApp_Filer_pack";
            }
            Integer licenseCount = MSHandler.getLicenseCount((Integer)new Integer(machineType.toString()));
            String licenseType = LicenseUtil.getLicenseType();
            JSONObject alertInputParams = new JSONObject();
            if ((licenseType != null && (licenseType.equals("F") || licenseType.equals("T")) || licenseCount == 0) && machineType != 1024L) {
                alertInputParams.put("message", (Object)rb.getString(licenseMsg));
                alertInputParams.put("type", (Object)"info");
                alertInputParams.put("linkMessage", (Object)rb.getString("adap.configuratoin.view_servers.view_member_servers.learn_more.button_text"));
                alertInputParams.put("actionName", (Object)"openFreeLicenseHelp");
            }
            serverInputParams.put("alertInputParams", (Object)alertInputParams);
            serverInputParams.put("readOnly", request.getAttribute("readOnly"));
            JSONArray ho = new JSONArray(ServerConfigHandler.getInstance().hours);
            JSONArray mi = new JSONArray(ServerConfigHandler.getInstance().minutes);
            serverInputParams.put("hours", (Object)ho);
            serverInputParams.put("minutes", (Object)mi);
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            String searchCriteria = null;
            if (!serverInputParams.has("sortColumn")) {
                serverInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                serverInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                serverInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            JSONArray a = new JSONArray();
            JSONArray b = new JSONArray();
            serverInputParams.put("selectedObjectIdList", (Object)a);
            serverInputParams.put("selectedObjectNameList", (Object)b);
            serverInputParams.put("selObjNameIndex", (Object)"2");
            serverInputParams.put("isHideOverFlowX", true);
            serverInputParams.put("addServerTxt", (Object)rb.getString("adap.SelectFileServer.Add_Server"));
            if (selectedServerGuid != null) {
                serverInputParams.put("selectedServerGuid", (Object)selectedServerGuid);
            }
            if (selectedServerName != null) {
                serverInputParams.put("selectedServerName", (Object)selectedServerName);
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, serverInputParams.getString("sortColumn"), serverInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            searchCriteria = ServerConfigHandler.getInstance().getSearchCriteria(serverInputParams, tableAllColumnList, true, false);
            if (searchCriteria != null) {
                isSearch = true;
            }
            ServerConfigHandler.getInstance().getRangeList(serverInputParams);
            HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
            addnParamsMap.put("sortColumn", serverInputParams.get("sortColumn"));
            addnParamsMap.put("sortOrder", (String)serverInputParams.get("sortOrder"));
            addnParamsMap.put("tableName", serverInputParams.get("sortTableName"));
            addnParamsMap.put("noOfObjects", serverInputParams.get("rangeValue"));
            addnParamsMap.put("startIndex", serverInputParams.get("startValue"));
            String action = serverInputParams.optString("filterAction");
            if (action == null) {
                action = "All";
            }
            Boolean readOnly = serverInputParams.optBoolean("readOnly");
            Boolean gpoStatus = null;
            if (!((machineTypes[0] & 4) != 4 && (machineTypes[0] & 0x20000) != 131072 || readOnly != null && readOnly.booleanValue())) {
                gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineTypes[0]);
            }
            serverInputParams.put("gpoStatus", gpoStatus);
            int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, (String)searchCriteria, null, (int[])machineTypes, null);
            serverInputParams.put("totalCount", count);
            serverInputParams.put("isSearch", (Object)isSearch);
            if (serverInputParams.getString("machineType").equalsIgnoreCase("4")) {
                serverInputParams.put("showDomainFilter", true);
                if (!(readOnly != null && readOnly.booleanValue() || count <= 0)) {
                    serverInputParams.put("showAuditPolicyFilter", true);
                }
                serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.fileserver_configuration"));
                serverInputParams.put("tabHeaderText", (Object)rb.getString("adap.Configuration.ConfiguredFileServer.Heading.Configured_File_Server"));
            } else if (serverInputParams.getString("machineType").equalsIgnoreCase("256")) {
                serverInputParams.put("showDomainFilter", true);
                serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.netapp_configuration"));
                serverInputParams.put("tabHeaderText", (Object)rb.getString("adap_ServerConfig.configured_netApp_filers"));
            } else if (serverInputParams.getString("machineType").equalsIgnoreCase("131072")) {
                serverInputParams.put("showDomainFilter", true);
                if (!(readOnly != null && readOnly.booleanValue() || count <= 0)) {
                    serverInputParams.put("showAuditPolicyFilter", true);
                }
                serverInputParams.put("pageHeaderText", (Object)rb.getString("adap_ServerConfig.emc_server_configuration"));
                serverInputParams.put("tabHeaderText", (Object)rb.getString("adap_ServerConfig.configured_emc_servers"));
            }
            ArrayList reportsList = new ArrayList();
            if (count > 0) {
                reportsList = ServerConfigAPI.getConfiguredServersEmber((String)domainName, addnParamsMap, (String)searchCriteria, null, null, (int[])machineTypes, (Integer)count);
            }
            if (count == 0) {
                serverInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                serverInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                serverInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_configure"));
            }
            if (message != null) {
                serverInputParams.put("message", (Object)message);
                serverInputParams.put("type", (Object)msgType);
                serverInputParams.put("linkMessage", (Object)linkMessage);
                serverInputParams.put("actionName", (Object)actionName);
            }
            serverInputParams.put("readOnly", request.getAttribute("readOnly"));
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, reportsList, tableAllColumnList, serverInputParams, rb);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ViewFileServers.audit_entry.file_server_viewed", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.file_server_Viewed", "-"}));
            JSONObject tableData = resultObj.getJSONObject("tableData");
            if (machineType == 4L) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ViewFileServers.audit_entry.file_server_viewed", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.file_server_Viewed", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ViewNetAppFilers.audit_entry.Netapp_filer_viewd_for_doamin", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.netapp_filer_Viewed", "-"}));
            }
            returnListMap.put("serverData", tableData.get("tableDataList"));
            returnListMap.put("serverColumnList", tableAllColumnList);
            returnListMap.put("inputParams", serverInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateFileServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        String msgType = "success";
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject serverInputParams = null;
        serverInputParams = reportReqData.getJSONObject("inputParams");
        String domainName = serverInputParams.getString("domainName");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String manageAction = serverInputParams.getString("manageAction");
            String timePeriod = serverInputParams.optString("timePeriod");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            ArrayList<Long> guidList = new ArrayList<Long>();
            for (int i = 0; i < objectGuidList.size(); ++i) {
                guidList.add(Long.parseLong(objectGuidList.get(i).toString()));
            }
            if (serverInputParams.getString("machineType").equals("4")) {
                message = FileServerHandler.updateFileServers((String)domainName, (String)manageAction, guidList, (String)timePeriod);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_File_Server", "-"}));
            } else if (serverInputParams.getString("machineType").equals("256")) {
                message = NetAppHandler.updateNetAppFilers((String)domainName, (String)manageAction, guidList, (String)timePeriod);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_Netapp", "-"}));
            } else if (serverInputParams.getString("machineType").equals("131072")) {
                message = EMCHandler.updateEMCServers((String)domainName, (String)manageAction, guidList, (String)timePeriod);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Update_EMC", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = "failure";
            message = rb.getString("adap_ServerConfig.error_while_updating_servers");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", ex.getMessage() + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Update_File_Server", "-"}));
        }
        this.getFileServers(request, response, message, null, null, msgType, null, null);
    }

    public void getFileShares(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String isRefresh;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject pageInputParams = null;
            pageInputParams = reportReqData.getJSONObject("pageInputParams");
            String domainName = pageInputParams.getString("domainName");
            String hostName = pageInputParams.getString("hostName");
            String hostGuid = pageInputParams.getString("hostGuid");
            Integer machineType = pageInputParams.getInt("machineType");
            JSONArray pageList = this.getSharePageInputParams(machineType, pageInputParams, rb);
            String searchCriteria = null;
            if (!pageInputParams.has("sortColumn")) {
                pageInputParams.put("sortColumn", (Object)"NAME");
                pageInputParams.put("sortOrder", (Object)"ASC");
                pageInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            pageInputParams.put("selObjNameIndex", (Object)"2");
            String uvhString = "AUDCVConfig:cv_id:15027";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, pageInputParams.getString("sortColumn"), pageInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            searchCriteria = ServerConfigHandler.getInstance().getSearchCriteria(pageInputParams, tableAllColumnList, false, false);
            if (searchCriteria != null) {
                isSearch = true;
            }
            ServerConfigHandler.getInstance().getRangeList(pageInputParams);
            HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
            addnParamsMap.put("sortColumn", pageInputParams.get("sortColumn"));
            addnParamsMap.put("sortOrder", (String)pageInputParams.get("sortOrder"));
            addnParamsMap.put("sortTableName", pageInputParams.get("sortTableName"));
            addnParamsMap.put("noOfObjects", pageInputParams.get("rangeValue"));
            addnParamsMap.put("startIndex", pageInputParams.get("startValue"));
            String action = pageInputParams.optString("action");
            if (action == null) {
                action = "new";
            }
            if ((isRefresh = pageInputParams.optString("isRefresh")) == null) {
                isRefresh = "false";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("FROM_INDEX", pageInputParams.get("startValue"));
            params.put("RANGE", pageInputParams.get("rangeValue"));
            HashMap<String, String> shareMap = new HashMap<String, String>();
            shareMap.put("HOST_NAME", hostName);
            shareMap.put("REFRESH", isRefresh);
            shareMap.put("DOMAIN_NAME", domainName);
            shareMap.put("SHARE_ACTION", action);
            shareMap.put("HOST_GUID", hostGuid);
            Hashtable shareTable = FileSystemAPI.getInstance().getSharesForServerEmber(new HashMap(), shareMap, searchCriteria, Integer.valueOf(0));
            ArrayList shareList = (ArrayList)shareTable.get("fileShares");
            int count = shareList.size();
            pageInputParams.put("totalCount", count);
            pageInputParams.put("isSearch", (Object)isSearch);
            if (count > 0) {
                shareTable = FileSystemAPI.getInstance().getSharesForServerEmber(params, shareMap, searchCriteria, Integer.valueOf(count));
                shareList = (ArrayList)shareTable.get("fileShares");
                if (shareTable.get("message") != null) {
                    pageInputParams.put("showFilterText", true);
                    pageInputParams.put("filterText", shareTable.get("message"));
                }
            }
            if (count == 0) {
                if (shareTable.get("message") != null) {
                    pageInputParams.put("emptyTableMessage", shareTable.get("message"));
                } else {
                    pageInputParams.put("emptyTableMessage", (Object)rb.getString((String)tableDetails.get("EMPTY_TABLE_MESSAGE")));
                }
                if (isSearch.booleanValue()) {
                    pageInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    pageInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else {
                    pageInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    pageInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, shareList, tableAllColumnList, pageInputParams, rb);
            pageInputParams.put("isRefresh", false);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("tableDataList", tableData.get("tableDataList"));
            returnListMap.put("tableColumnList", tableAllColumnList);
            returnListMap.put("pageInputParams", pageInputParams);
            returnListMap.put("pageList", pageList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONArray getSharePageInputParams(Integer machineType, JSONObject pageInputParams, AdventNetResourceBundle rb) throws Exception {
        JSONArray pageList = new JSONArray();
        if (machineType.equals(4) || machineType.equals(256) || machineType.equals(131072)) {
            String action = pageInputParams.getString("action");
            if (action.equals("new")) {
                JSONObject page1 = new JSONObject();
                page1.put("displayName", (Object)rb.getString("adap_ServerConfig.select_server"));
                page1.put("pageNo", (Object)"1");
                page1.put("headingClass", (Object)"completed");
                JSONObject page2 = new JSONObject();
                page2.put("displayName", (Object)rb.getString("adap_ServerConfig.select_shares"));
                page2.put("pageNo", (Object)"<i class=\"inline-icon icn-tick\"></i>");
                page2.put("headingClass", (Object)"active");
                JSONObject page3 = new JSONObject();
                page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
                page3.put("pageNo", (Object)"3");
                pageList.put((Object)page1);
                pageList.put((Object)page2);
                pageList.put((Object)page3);
            } else if (action.equals("addshare")) {
                JSONObject page2 = new JSONObject();
                page2.put("displayName", (Object)rb.getString("adap_ServerConfig.select_shares"));
                page2.put("pageNo", (Object)"<i class=\"inline-icon icn-tick\"></i>");
                page2.put("headingClass", (Object)"active");
                JSONObject page3 = new JSONObject();
                page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
                page3.put("pageNo", (Object)"2");
                pageList.put((Object)page2);
                pageList.put((Object)page3);
            }
            JSONArray buttonList = new JSONArray();
            JSONObject button1 = new JSONObject();
            JSONObject button2 = new JSONObject();
            JSONObject button3 = new JSONObject();
            button1.put("displayName", (Object)rb.getString("adap.NetAppDetails.Quit"));
            button1.put("actionName", (Object)"cancelAction");
            button1.put("controllerAction", (Object)"quitFSModal");
            button2.put("displayName", (Object)rb.getString("adap.common.button.Next"));
            button2.put("actionName", (Object)"nextAction");
            if (machineType.equals(4)) {
                if (action.equals("new")) {
                    button2.put("controllerAction", (Object)"showFSSummary");
                    pageInputParams.put("nextAction", (Object)"showFSSummary");
                    button3.put("displayName", (Object)rb.getString("adap.common.button.Back"));
                    button3.put("actionName", (Object)"backAction");
                    button3.put("controllerAction", (Object)"getADFileServers");
                    buttonList.put((Object)button3);
                } else {
                    button2.put("controllerAction", (Object)"showFSSummary");
                    pageInputParams.put("nextAction", (Object)"showFSSummary");
                }
            } else if (machineType.equals(256)) {
                if (action.equals("new")) {
                    button2.put("controllerAction", (Object)"showNetAppSummary");
                    pageInputParams.put("nextAction", (Object)"showNetAppSummary");
                    button3.put("displayName", (Object)rb.getString("adap.common.button.Back"));
                    button3.put("actionName", (Object)"backAction");
                    button3.put("controllerAction", (Object)"getADFileServers");
                    buttonList.put((Object)button3);
                } else if (action.equals("addshare")) {
                    button2.put("controllerAction", (Object)"showFSSummary");
                    pageInputParams.put("nextAction", (Object)"showFSSummary");
                }
            } else if (machineType.equals(131072)) {
                if (action.equals("new")) {
                    button2.put("controllerAction", (Object)"showEMCSummary");
                    pageInputParams.put("nextAction", (Object)"showEMCSummary");
                    button3.put("displayName", (Object)rb.getString("adap.common.button.Back"));
                    button3.put("actionName", (Object)"backAction");
                    button3.put("controllerAction", (Object)"getADFileServers");
                    buttonList.put((Object)button3);
                } else if (action.equals("addshare")) {
                    button2.put("controllerAction", (Object)"showFSSummary");
                    pageInputParams.put("nextAction", (Object)"showFSSummary");
                }
            }
            buttonList.put((Object)button1);
            buttonList.put((Object)button2);
            pageInputParams.put("buttonList", (Object)buttonList);
            pageInputParams.put("pageList", (Object)pageList);
            pageInputParams.put("modalName", (Object)"fileServerWizard");
            pageInputParams.put("changeAction", (Object)"getFileSharesData");
            pageInputParams.put("refreshAction", (Object)"refreshFileShares");
            pageInputParams.put("emptyTableAction", (Object)"getFileSharesData");
            pageInputParams.put("cancelAction", (Object)"quitFSModal");
            pageInputParams.put("backAction", (Object)"getADFileServers");
        }
        return pageList;
    }

    private JSONArray getServerPageInputParams(Integer machineType, JSONObject pageInputParams, AdventNetResourceBundle rb) throws Exception {
        JSONArray pageList = new JSONArray();
        if (machineType.equals(4) || machineType.equals(256) || machineType.equals(131072)) {
            Long cvId = pageInputParams.optLong("cvId");
            if (cvId == null || cvId == 0L) {
                if (machineType.equals(4)) {
                    cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15026");
                } else if (machineType.equals(256)) {
                    cvId = 100003L;
                } else if (machineType.equals(131072)) {
                    cvId = 100004L;
                }
            }
            JSONObject page1 = new JSONObject();
            page1.put("displayName", (Object)rb.getString("adap_ServerConfig.select_server"));
            page1.put("pageNo", (Object)"<i class=\"inline-icon icn-tick\"></i>");
            page1.put("headingClass", (Object)"active");
            JSONObject page2 = new JSONObject();
            page2.put("displayName", (Object)rb.getString("adap_ServerConfig.select_shares"));
            page2.put("pageNo", (Object)"2");
            JSONObject page3 = new JSONObject();
            page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
            page3.put("pageNo", (Object)"3");
            pageList.put((Object)page1);
            pageList.put((Object)page2);
            pageList.put((Object)page3);
            JSONArray buttonList = new JSONArray();
            JSONObject button1 = new JSONObject();
            JSONObject button2 = new JSONObject();
            button1.put("displayName", (Object)rb.getString("adap.NetAppDetails.Quit"));
            button1.put("actionName", (Object)"cancelAction");
            button1.put("controllerAction", (Object)"quitFSModal");
            button2.put("displayName", (Object)rb.getString("adap.common.button.Next"));
            button2.put("actionName", (Object)"nextAction");
            button2.put("controllerAction", (Object)"getFileShares");
            buttonList.put((Object)button1);
            buttonList.put((Object)button2);
            pageInputParams.put("buttonList", (Object)buttonList);
            pageInputParams.put("pageList", (Object)pageList);
            pageInputParams.put("cvId", (Object)cvId.toString());
            pageInputParams.put("modalName", (Object)"fileServerWizard");
            pageInputParams.put("changeAction", (Object)"getADFileServersData");
            pageInputParams.put("refreshAction", (Object)"refreshADFileServers");
            pageInputParams.put("emptyTableAction", (Object)"getADFileServersData");
            pageInputParams.put("nextAction", (Object)"getFileShares");
            pageInputParams.put("cancelAction", (Object)"quitFSModal");
        }
        return pageList;
    }

    private JSONArray getSummaryPageInputParams(Integer machineType, JSONObject pageInputParams, AdventNetResourceBundle rb) throws Exception {
        JSONArray pageList = new JSONArray();
        if (machineType.equals(4) || machineType.equals(256) || machineType.equals(131072)) {
            String action = pageInputParams.getString("action");
            if (action.equals("new")) {
                JSONObject page1 = new JSONObject();
                page1.put("displayName", (Object)rb.getString("adap_ServerConfig.select_server"));
                page1.put("pageNo", (Object)"1");
                page1.put("headingClass", (Object)"completed");
                JSONObject page2 = new JSONObject();
                page2.put("displayName", (Object)rb.getString("adap_ServerConfig.select_shares"));
                page2.put("pageNo", (Object)"2");
                page2.put("headingClass", (Object)"completed");
                JSONObject page3 = new JSONObject();
                page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
                page3.put("pageNo", (Object)"<i class=\"inline-icon icn-tick\"></i>");
                page3.put("headingClass", (Object)"active");
                pageList.put((Object)page1);
                pageList.put((Object)page2);
                pageList.put((Object)page3);
            } else if (action.equals("addshare")) {
                JSONObject page2 = new JSONObject();
                page2.put("displayName", (Object)rb.getString("adap_ServerConfig.select_shares"));
                page2.put("pageNo", (Object)"1");
                page2.put("headingClass", (Object)"completed");
                JSONObject page3 = new JSONObject();
                page3.put("displayName", (Object)rb.getString("adap_ServerConfig.review_summary"));
                page3.put("pageNo", (Object)"<i class=\"inline-icon icn-tick\"></i>");
                page3.put("headingClass", (Object)"active");
                pageList.put((Object)page2);
                pageList.put((Object)page3);
            }
            JSONArray buttonList = new JSONArray();
            JSONObject button1 = new JSONObject();
            JSONObject button3 = new JSONObject();
            JSONObject button2 = new JSONObject();
            button1.put("displayName", (Object)rb.getString("adap.NetAppDetails.Quit"));
            button1.put("actionName", (Object)"cancelAction");
            button1.put("controllerAction", (Object)"quitFSModal");
            button3.put("displayName", (Object)rb.getString("adap.common.button.Back"));
            button3.put("actionName", (Object)"backAction");
            button3.put("controllerAction", (Object)"getFileShares");
            button2.put("displayName", (Object)rb.getString("adap.common.button.ok"));
            button2.put("actionName", (Object)"okAction");
            button2.put("controllerAction", (Object)"addFileServer");
            buttonList.put((Object)button3);
            buttonList.put((Object)button1);
            buttonList.put((Object)button2);
            pageInputParams.put("buttonList", (Object)buttonList);
            pageInputParams.put("pageList", (Object)pageList);
            pageInputParams.put("modalName", (Object)"fileServerWizard");
            if (machineType.equals(4)) {
                pageInputParams.put("changeAction", (Object)"showFSSummary");
                pageInputParams.put("refreshAction", (Object)"showFSSummary");
                pageInputParams.put("emptyTableAction", (Object)"showFSSummary");
                pageInputParams.put("okAction", (Object)"addFileServer");
            } else if (machineType.equals(256)) {
                if (action.equals("new")) {
                    pageInputParams.put("changeAction", (Object)"showNetAppSummary");
                    pageInputParams.put("refreshAction", (Object)"showNetAppSummary");
                    pageInputParams.put("emptyTableAction", (Object)"showNetAppSummary");
                    pageInputParams.put("okAction", (Object)"addFileServer");
                    pageInputParams.put("isNetApp", true);
                } else if (action.equals("addshare")) {
                    pageInputParams.put("changeAction", (Object)"showFSSummary");
                    pageInputParams.put("refreshAction", (Object)"showFSSummary");
                    pageInputParams.put("emptyTableAction", (Object)"showFSSummary");
                    pageInputParams.put("okAction", (Object)"addFileServer");
                    pageInputParams.put("isNetApp", true);
                }
                pageInputParams.put("naVserverDefRotType", NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_TYPE"));
                pageInputParams.put("naVserverDefFileCnt", NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_LIMIT"));
                pageInputParams.put("naVserverDefFileSize", NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_SIZE_STR"));
                pageInputParams.put("naVserverDefFilePath", NetAppHandler.getNaVserverDefaultAuditConfig().get("EVT_FILE_JUNCTION_PATH"));
            } else if (machineType.equals(131072)) {
                if (action.equals("new")) {
                    pageInputParams.put("changeAction", (Object)"showEMCSummary");
                    pageInputParams.put("refreshAction", (Object)"showEMCSummary");
                    pageInputParams.put("emptyTableAction", (Object)"showEMCSummary");
                    pageInputParams.put("okAction", (Object)"addFileServer");
                    pageInputParams.put("isEMC", true);
                } else if (action.equals("addshare")) {
                    pageInputParams.put("changeAction", (Object)"showFSSummary");
                    pageInputParams.put("refreshAction", (Object)"showFSSummary");
                    pageInputParams.put("emptyTableAction", (Object)"showFSSummary");
                    pageInputParams.put("okAction", (Object)"addFileServer");
                    pageInputParams.put("isEMC", true);
                }
            }
            pageInputParams.put("cancelAction", (Object)"quitFSModal");
            pageInputParams.put("backAction", (Object)"getFileShares");
        }
        return pageList;
    }

    public void getFSSummary(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject pageInputParams = null;
            pageInputParams = reportReqData.getJSONObject("pageInputParams");
            Integer machineType = pageInputParams.getInt("machineType");
            JSONArray pageList = this.getSummaryPageInputParams(machineType, pageInputParams, rb);
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            returnListMap.put("pageInputParams", pageInputParams);
            returnListMap.put("pageList", pageList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getNetappSummary(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject pageInputParams = null;
            pageInputParams = reportReqData.getJSONObject("pageInputParams");
            Integer machineType = pageInputParams.getInt("machineType");
            JSONArray pageList = this.getSummaryPageInputParams(machineType, pageInputParams, rb);
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            returnListMap.put("pageInputParams", pageInputParams);
            returnListMap.put("pageList", pageList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addFileServer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        String msgType = "success";
        String linkMsg = null;
        String hostName = null;
        String hostGuid = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("fileSummaryInputParams");
            String domainName = serverInputParams.getString("domainName");
            ArrayList hostNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectNameList"));
            ArrayList hostGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectIdList"));
            hostName = hostNameList.get(0).toString();
            hostGuid = hostGuidList.get(0).toString();
            String shareAction = serverInputParams.getString("action");
            ArrayList shareLocations = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedShares"));
            Integer machineType = serverInputParams.getInt("machineType");
            Boolean isNetAppCifsVserver = false;
            if (serverInputParams.has("isNetAppCifsVserver")) {
                isNetAppCifsVserver = serverInputParams.getBoolean("isNetAppCifsVserver");
            }
            Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
            fsDetails.put("OBJECT_GUID", hostGuid);
            fsDetails.put("serverName", hostName);
            fsDetails.put("domainName", domainName);
            fsDetails.put("SHARE_ACTION", shareAction);
            fsDetails.put("MACHINE_TYPE", machineType);
            if (!shareAction.equalsIgnoreCase("SACL")) {
                fsDetails.put("LOCATIONS", shareLocations);
            }
            if (shareAction.equalsIgnoreCase("new")) {
                if (machineType.equals(4)) {
                    Boolean isSACL = serverInputParams.getBoolean("isSACL");
                    Boolean isAuditPolicy = serverInputParams.getBoolean("isAuditPolicy");
                    HashMap retMap = FileServerHandler.addFileServerEmber(fsDetails, (Boolean)isSACL, (Boolean)isAuditPolicy);
                    message = (String)retMap.get("msgTxt");
                    msgType = (String)retMap.get("msgType");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.added_file_shares", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                } else if (machineType.equals(256)) {
                    String isVFiler = serverInputParams.getString("isVfiler");
                    String isHttp = serverInputParams.getString("protocol");
                    fsDetails.put("USER_NAME", serverInputParams.getString("userName"));
                    fsDetails.put("PASSWORD", serverInputParams.getString("password"));
                    fsDetails.put("PORT_NO", serverInputParams.getInt("portNo"));
                    if (isHttp.equals("http")) {
                        fsDetails.put("IS_HTTP", true);
                    } else {
                        fsDetails.put("IS_HTTP", false);
                    }
                    fsDetails.put("IS_POLICY", serverInputParams.getString("isAuditPolicy"));
                    fsDetails.put("IS_SACL", serverInputParams.getString("isSACL"));
                    if (isNetAppCifsVserver.booleanValue()) {
                        HashMap retMap = NetAppHandler.addNetAppVserverEmber((NetAppVserver)new NetAppVserver(serverInputParams, hostGuid, hostName, domainName, shareAction));
                        message = (String)retMap.get("msgTxt");
                        msgType = (String)retMap.get("msgType");
                        if (retMap.get("linkMsg") != null) {
                            linkMsg = (String)retMap.get("linkMsg");
                        }
                    } else {
                        if (isVFiler.equals("true")) {
                            fsDetails.put("IS_VFILER", true);
                            fsDetails.put("VFILER_NAME", serverInputParams.getString("vFilerName"));
                        } else {
                            fsDetails.put("IS_VFILER", false);
                        }
                        fsDetails.put("PFILER_NAME", serverInputParams.getString("pFilerName"));
                        String evtFileSharePath = "\\\\" + hostName + "\\etc$\\log\\";
                        String msgDllPath = "\\\\" + hostName + "\\etc$\\OnTapAuditE.dll";
                        fsDetails.put("EVT_FILE_SHARE_PATH", evtFileSharePath);
                        fsDetails.put("EVT_FILE_NAME", "adtlog.evt");
                        fsDetails.put("MSG_DLL_SHARE_PATH", msgDllPath);
                        fsDetails.put("MSG_DLL_NAME", "OnTapAuditE.dll");
                        HashMap retMap = NetAppHandler.addNetAppFilerEmber(fsDetails);
                        message = (String)retMap.get("msgTxt");
                        msgType = (String)retMap.get("msgType");
                        if (retMap.get("linkMsg") != null) {
                            linkMsg = (String)retMap.get("linkMsg");
                        }
                    }
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.add_netapp_filer", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
                } else if (machineType.equals(131072)) {
                    fsDetails.put("USER_NAME", serverInputParams.getString("userName"));
                    fsDetails.put("PASSWORD", serverInputParams.getString("password"));
                    fsDetails.put("EMC_CONTROL_STATION_IP", serverInputParams.getString("pFilerName"));
                    fsDetails.put("PORT_NO", serverInputParams.getInt("portNo"));
                    fsDetails.put("IS_POLICY", serverInputParams.getString("isAuditPolicy"));
                    fsDetails.put("IS_SACL", serverInputParams.getString("isSACL"));
                    message = EMCHandler.addEMCServer(fsDetails);
                    if (!message.contains("Successfully")) {
                        msgType = "failure";
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = "failure";
            message = rb.getString("adap_ServerConfig.error_while_adding_file_server");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 16, 16, "adap.ADAPUserAuditSeverities.audit_name.Error_Adding_FS", "-"}));
        }
        this.getFileServers(request, response, message, linkMsg, "netappConfigErrorAction", msgType, hostName, hostGuid);
    }

    public void addFileShares(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        String msgType = "info";
        String linkMessage = null;
        String actionName = "openHelp";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("fileSummaryInputParams");
            String domainName = serverInputParams.getString("domainName");
            ArrayList hostNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectNameList"));
            ArrayList hostGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectIdList"));
            String hostName = hostNameList.get(0).toString();
            String hostGuid = hostGuidList.get(0).toString();
            String shareAction = serverInputParams.getString("action");
            ArrayList shareLocations = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedShares"));
            Boolean isSACL = serverInputParams.getBoolean("isSACL");
            Integer machineType = serverInputParams.getInt("machineType");
            Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
            fsDetails.put("OBJECT_GUID", hostGuid);
            fsDetails.put("serverName", hostName);
            fsDetails.put("domainName", domainName);
            fsDetails.put("SHARE_ACTION", shareAction);
            fsDetails.put("MACHINE_TYPE", machineType);
            fsDetails.put("LOCATIONS", shareLocations);
            AudFileMonitorCriteriaHandler.addFileServersShares((String)((String)fsDetails.get("domainName")), (String)((String)fsDetails.get("serverName")), (ArrayList)((ArrayList)fsDetails.get("LOCATIONS")));
            message = rb.getString("adap.ConfigureFileServerAction.Successfully_added_File_Shares_for_auditng");
            if (isSACL != null) {
                if (isSACL.booleanValue()) {
                    new ModifySaclThread(fsDetails);
                    message = message + " " + rb.getString("adap.ConfiguredFileServerAction.configuring_audit_permission_on_file_shares_is_started_successfully");
                } else {
                    msgType = "info";
                    message = message + rb.getString("adap.ConfiguredFileServerAction.note_sacl_permissions");
                }
            }
            FileServerHandler.addFileUpdateDetails(fsDetails, (boolean)false);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.added_file_shares", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{fsDetails.toString()})}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap_ServerConfig.error_while_adding_file_shares");
            msgType = "failure";
        }
        this.getFileServers(request, response, message, linkMessage, actionName, msgType, null, null);
    }

    public void removeFileShares(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msgTxt = null;
        String msgType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String hostName = serverInputParams.getString("hostName");
            ArrayList shareLocations = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedShares"));
            FileServerHandler.deleteConfiguredShares((ArrayList)shareLocations, (String)hostName, (String)domainName);
            msgTxt = rb.getString("adap.ConfigureFileServerAction.Successfully_removed_File_Shares_for_auditng");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "File Audit", msgTxt, 16, 8, "adap.ADAPUserAuditSeverities.audit_name.remove_fs_Shares", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{shareLocations.toString()})}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgTxt = rb.getString("adap_ServerConfig.error_while_removing_file_shares_from_auditing");
            msgType = "failure";
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void applySACL(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String msgTxt = null;
        String msgType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = serverInputParams.getString("domainName");
            String hostName = serverInputParams.getString("hostName");
            Integer machineType = serverInputParams.getInt("machineType");
            Hashtable<String, Object> fsDetails = new Hashtable<String, Object>();
            fsDetails.put("serverName", hostName);
            fsDetails.put("domainName", domainName);
            fsDetails.put("MACHINE_TYPE", machineType);
            ArrayList conShareList = FileServerHandler.getConfiguredShares((String)((String)fsDetails.get("serverName")), (String)((String)fsDetails.get("domainName")));
            fsDetails.put("LOCATIONS", conShareList);
            new ModifySaclThread(fsDetails);
            msgTxt = rb.handleGetObject("adap.ConfigureFileServerAction.Configuring_audit_settings_(SACL)_for_File_Shares", new String[]{(String)fsDetails.get("serverName")});
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", msgTxt, 16, 8, "adap.ADAPUserAuditSeverities.audit_name.configured_FS_SACL", rb.handleGetObject("adap.audit_entry_addn.Details", new String[]{conShareList.toString()})}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = "failure";
            msgTxt = rb.getString("adap_ServerConfig.error_while_applying_sacl_for_shares");
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void getNetAppDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            ArrayList hostNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectNameList"));
            String hostName = hostNameList.get(0).toString();
            String guid = null;
            guid = CommonUtil.isGUID((String)objectGuidList.get(0).toString()) != false ? objectGuidList.get(0).toString() : this.getServerGuid((Integer)objectGuidList.get(0));
            serverInputParams.put("selectedServerGuid", (Object)guid);
            serverInputParams.put("selectedServerName", (Object)hostName);
            JSONObject netApp = null;
            if (serverInputParams.has("isNetAppCifsVserver") && serverInputParams.getBoolean("isNetAppCifsVserver")) {
                netApp = NetAppVserverDBHandler.getPropertiesEmber((String)guid);
            } else {
                serverInputParams.put("isNetAppCifsVserver", false);
                netApp = NetAppHandler.getNetAppDetailsEmber((String)guid);
            }
            JSONObject returnListMap = new JSONObject();
            returnListMap.put("netappData", (Object)netApp);
            returnListMap.put("isNetAppCifsVserver", serverInputParams.getBoolean("isNetAppCifsVserver"));
            JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getServerGuid(Integer computerId) throws Exception {
        String guid = null;
        Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)computerId, 0);
        DataObject nfObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDComputerEventRead", criteria2);
        if (!nfObj.isEmpty()) {
            Row row = nfObj.getFirstRow("AUDComputerEventRead");
            guid = (String)row.get("OBJECT_GUID");
        }
        return guid;
    }

    public void getNetAppAuditSettings(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            String objectGuid = this.getServerGuid((Integer)objectGuidList.get(0));
            ArrayList objectNameList = null;
            objectNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectNameList"));
            String objectName = objectNameList.get(0).toString();
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15028");
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            if (!serverInputParams.has("sortColumn")) {
                serverInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                serverInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                serverInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, serverInputParams.getString("sortColumn"), serverInputParams.getString("sortOrder"), rb);
            ArrayList rowList = null;
            if (serverInputParams.getLong("machineType") == 256L) {
                if (serverInputParams.has("isNetAppCifsVserver") && serverInputParams.getBoolean("isNetAppCifsVserver")) {
                    rowList = NetAppVserverDBHandler.getNetAppAuditSettings((String)objectGuid);
                    serverInputParams.put("showRefresh", true);
                } else {
                    rowList = NetAppHandler.getNetAppAuditSettings((String)objectGuid);
                }
                serverInputParams.put("tabDisplayName", (Object)rb.getString("adap_ServerConfig.netapp_audit_settings"));
            } else if (serverInputParams.getLong("machineType") == 131072L) {
                Hashtable cifsTable = EMCHandler.getCifsDetails((String)objectGuid, (String)objectName, (String)serverInputParams.getString("domainName"));
                rowList = EMCHandler.getCifsDMDetailsEmber((Hashtable)cifsTable);
                serverInputParams.put("tabDisplayName", (Object)rb.getString("adap_ServerConfig.emc_audit_settings"));
            }
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, rowList, tableAllColumnList, serverInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            returnListMap.put("tableDataList", tableData.get("tableDataList"));
            returnListMap.put("tableColumnList", tableAllColumnList);
            serverInputParams.put("cvId", 1);
            serverInputParams.put("tabId", (Object)"tabId_1");
            serverInputParams.put("tabName", (Object)"tabName_1");
            ArrayList tabList = new ArrayList();
            HashMap<String, HashMap<String, Object>> tabMap = new HashMap<String, HashMap<String, Object>>();
            tabMap.put("tabData", returnListMap);
            tabMap.put("tabInputParams", (HashMap<String, Object>)serverInputParams);
            tabList.add(tabMap);
            HashMap<String, Object> subReportListMap = new HashMap<String, Object>();
            subReportListMap.put("netappAuditSettingsList", tabList);
            subReportListMap.put("message", rb.getString("adap.NetAppVserver.Success_Sync_Device"));
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(subReportListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateNetAppDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject serverInputParams;
        String message;
        String linkMsg;
        String msgType;
        AdventNetResourceBundle rb;
        block37: {
            rb = ResourceBundleMgr.getInstance().getBundle(request);
            msgType = "success";
            linkMsg = null;
            message = rb.getString("adap.ConfiguredNetAppFilers.Successfully_updated_NetApp_Filer_Auditing_Details");
            String netappAuditMsg = rb.getString("adap.NetAppHandler.Error_while_enabling_netapp_audit_options");
            Hashtable<String, Object> netApp = new Hashtable<String, Object>();
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            serverInputParams = null;
            try {
                ArrayList hostNameList;
                serverInputParams = reportReqData.getJSONObject("inputParams");
                JSONObject netappConfig = reportReqData.getJSONObject("netappConfigData");
                String fileServerType = serverInputParams.getString("machineType");
                ArrayList objectGuidList = null;
                objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
                if (objectGuidList.size() == 0) {
                    objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)netappConfig.optJSONArray("selectedObjectIdList"));
                }
                if ((hostNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.getJSONArray("selectedObjectNameList"))).size() == 0) {
                    hostNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)netappConfig.optJSONArray("selectedObjectNameList"));
                }
                String guid = null;
                guid = CommonUtil.isGUID((String)objectGuidList.get(0).toString()) != false ? objectGuidList.get(0).toString() : this.getServerGuid((Integer)objectGuidList.get(0));
                Boolean isNetAppCifsVserver = false;
                if (netappConfig.has("isNetAppCifsVserver")) {
                    isNetAppCifsVserver = netappConfig.getBoolean("isNetAppCifsVserver");
                }
                if (!serverInputParams.has("isNetAppCifsVserver")) {
                    serverInputParams.put("isNetAppCifsVserver", (Object)isNetAppCifsVserver);
                }
                String hostName = hostNameList.get(0).toString();
                serverInputParams.put("selectedServerGuid", (Object)guid);
                serverInputParams.put("selectedServerName", (Object)hostName);
                if (fileServerType.equals("256")) {
                    String hostGuid = guid;
                    if (isNetAppCifsVserver.booleanValue()) {
                        NetAppVserver naVserver;
                        if (netappConfig.getBoolean("isSyncNetApp")) {
                            naVserver = new NetAppVserver(hostGuid, null, hostName);
                            if (naVserver.syncAuditPolicyWithDevice(true)) {
                                message = naVserver.getJSONString();
                                this.getNetAppAuditSettings(request, response);
                                return;
                            }
                            message = naVserver.errMessage;
                            msgType = "Error";
                        }
                        if (netappConfig.has("isUpdateNetApp") && netappConfig.getBoolean("isUpdateNetApp")) {
                            boolean isApplyDefaultPolicy = netappConfig.getBoolean("isAuditPolicy");
                            netApp.put("USER_NAME", netappConfig.getString("userName"));
                            netApp.put("PASSWORD", netappConfig.getString("password"));
                            netApp.put("PORT_NO", Integer.parseInt(netappConfig.getString("portNo")));
                            netApp.put("IS_HTTP", netappConfig.getString("protocol"));
                            naVserver = new NetAppVserver(netappConfig, hostGuid, hostName, serverInputParams.getString("domainName"), serverInputParams.getString("action"));
                            boolean isSuccess = naVserver.updateEntryInDB();
                            if (isSuccess) {
                                if (isApplyDefaultPolicy) {
                                    isSuccess = naVserver.applyAuditPolicyInDevice(true, true);
                                }
                                if (isSuccess) {
                                    isSuccess = naVserver.syncAuditPolicyWithDevice(true);
                                }
                            }
                            if (!isSuccess) {
                                msgType = "Error";
                                message = netappAuditMsg + naVserver.errMessage;
                            } else {
                                message = naVserver.errMessage;
                            }
                        }
                        break block37;
                    }
                    String evtFileSharePath = netappConfig.getString("evtFileSharePath");
                    String msgDllSharePath = netappConfig.getString("msgDllPath");
                    int lastIndex = evtFileSharePath.lastIndexOf("\\");
                    String evtLocation = evtFileSharePath.substring(0, lastIndex + 1);
                    String evtFileName = evtFileSharePath.substring(lastIndex + 1, evtFileSharePath.length());
                    int lastIndex1 = msgDllSharePath.lastIndexOf("\\");
                    String msgDllName = msgDllSharePath.substring(lastIndex1 + 1, msgDllSharePath.length());
                    netApp.put("USER_NAME", netappConfig.getString("userName"));
                    netApp.put("PASSWORD", netappConfig.getString("password"));
                    netApp.put("PORT_NO", Integer.parseInt(netappConfig.getString("portNo")));
                    String isHttp = netappConfig.getString("protocol");
                    if (isHttp.equals("http")) {
                        netApp.put("IS_HTTP", true);
                    } else {
                        netApp.put("IS_HTTP", false);
                    }
                    netApp.put("OBJECT_GUID", hostGuid);
                    netApp.put("EVT_FILE_SHARE_PATH", evtLocation);
                    netApp.put("EVT_FILE_NAME", evtFileName);
                    netApp.put("MSG_DLL_SHARE_PATH", msgDllSharePath);
                    netApp.put("MSG_DLL_NAME", msgDllName);
                    netApp.put("PFILER_NAME", netappConfig.getString("pFilerName"));
                    netApp.put("IS_VFILER", netappConfig.getBoolean("isVfiler"));
                    if (netappConfig.getBoolean("isVfiler")) {
                        netApp.put("VFILER_NAME", netappConfig.optString("vFilerName"));
                    }
                    NetAppHandler.addNetAppDetails(netApp);
                    if (netappConfig.getBoolean("isConfigAudit")) {
                        try {
                            NetAppHandler.SetAuditSettings((String)((String)netApp.get("PFILER_NAME")), (String)((String)netApp.get("VFILER_NAME")), (String)((String)netApp.get("USER_NAME")), (String)((String)netApp.get("PASSWORD")), (Boolean)((Boolean)netApp.get("IS_VFILER")), (Boolean)((Boolean)netApp.get("IS_HTTP")), (Integer)((Integer)netApp.get("PORT_NO")));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfiguredNetAppFilers.audit_entry.Audit_settings_successfully_configured", new String[]{hostName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.config_audit_SACL_for_Netapp", "-"}));
                        }
                        catch (NaAuthenticationException na) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Bad_username_or_password") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, rb, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                            throw new Exception(rb.getString("adap.NetAppHandler.Bad_username_or_password"));
                        }
                        catch (SocketException se) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                            throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                        }
                        catch (NaProtocolException nap) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, rb, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                            throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                        }
                        catch (Throwable ex) {
                            throw ex;
                        }
                    }
                    if (!netappConfig.getBoolean("isSyncNetApp") && !netappConfig.getBoolean("isConfigAudit")) break block37;
                    HashMap auditOptions = null;
                    try {
                        auditOptions = NetAppHandler.getAuditSettings((String)((String)netApp.get("OBJECT_GUID")), (String)((String)netApp.get("PFILER_NAME")), (String)((String)netApp.get("VFILER_NAME")), (String)((String)netApp.get("USER_NAME")), (String)((String)netApp.get("PASSWORD")), (Boolean)((Boolean)netApp.get("IS_VFILER")), (Boolean)((Boolean)netApp.get("IS_HTTP")), (Integer)((Integer)netApp.get("PORT_NO")));
                    }
                    catch (NaAuthenticationException na) {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Bad_username_or_password") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                        throw new Exception(rb.getString("adap.NetAppHandler.Bad_username_or_password"));
                    }
                    catch (SocketException se) {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Bad_username_or_password") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                        throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                    }
                    catch (NaProtocolException nap) {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Updating_netapp_failed", "-"}));
                        throw new Exception(rb.getString("adap.NetAppHandler.Unable_to_connect_the_netapp_filer_through_mentioned_port_protocol"));
                    }
                    catch (Throwable ex) {
                        throw ex;
                    }
                    if (auditOptions != null) {
                        NetAppHandler.updateAuditOptions((String)((String)netApp.get("OBJECT_GUID")), (HashMap)auditOptions);
                    }
                    break block37;
                }
                message = rb.getString(rb.getString("adap.ConfiguredNetAppFilers.Successfully_updated_EMC_Details"));
                netappAuditMsg = "";
                String hostGuid = guid;
                String isSync = netappConfig.getString("isSyncNetApp");
                netApp.put("OBJECT_GUID", hostGuid);
                EMCHandler.addEMCCIFSDetails((String)hostGuid, (String)netappConfig.getString("hostName"), (String)serverInputParams.getString("domainName"), (String)netappConfig.getString("pFilerName"), (String)netappConfig.getString("userName"), (String)netappConfig.getString("password"), (String)netappConfig.getString("portNo"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfiguredNetAppFilers.audit_entry.DMDetails_Config_successfully_for_netapp", new String[]{hostName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.DM_Details_Configured", "-"}));
                if (!isSync.equals("true")) break block37;
                try {
                    EMCHandler.addDMDetails((String)hostGuid, (String)netappConfig.getString("hostName"), (String)serverInputParams.getString("domainName"), (String)netappConfig.getString("pFilerName"), (String)netappConfig.getString("userName"), (String)netappConfig.getString("password"), (String)netappConfig.getString("portNo"));
                }
                catch (ConnectException ex) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_contact_EMC_Control_Station_Connection_Refused") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.EMC_Ctrl_station_refused", "-"}));
                    throw new Exception(rb.getString("adap.EMCHandler.Unable_to_contact_EMC_Control_Station_Connection_Refused"));
                }
                catch (UnknownHostException ex) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.NetAppHandler.Unable_to_contact_EMC_Control_Station_Incorrect_EMC_IP") + "\n " + rb.handleGetObject("adap.audit_entry_addn.Host_name", new String[]{hostName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.EMC_Ctrl_station_refused", "-"}));
                    throw new Exception(rb.getString("adap.ConfiguredNetAppFilers.Unable_to_contact_EMC_Control_Station_Incorrect_EMC_IP"));
                }
                catch (Throwable ex) {
                    throw ex;
                }
                EMCHandler.getDMAuditSettings((String)hostGuid, (String)netappConfig.getString("hostName"), (String)serverInputParams.getString("domainName"), (boolean)true);
            }
            catch (Throwable e) {
                e.printStackTrace();
                msgType = "failure";
                if (e.getMessage() != null) {
                    netappAuditMsg = netappAuditMsg + e.getMessage();
                }
                message = message + " " + netappAuditMsg;
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", netappAuditMsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Failed_To_configure_EMC", "-"}));
            }
        }
        if (message.contains("Error")) {
            msgType = "failure";
            linkMsg = rb.getString("adap.common.text.policy_update_link.click_here");
            serverInputParams.put("actionName", (Object)"netappConfigErrorAction");
        }
        serverInputParams.put("message", (Object)message);
        serverInputParams.put("type", (Object)msgType);
        serverInputParams.put("linkMessage", (Object)linkMsg);
        HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
        returnListMap.put("inputParams", serverInputParams);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    public void getEMCDetails(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject serverInputParams = null;
            serverInputParams = reportReqData.getJSONObject("inputParams");
            ArrayList objectGuidList = null;
            objectGuidList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectIdList"));
            String objectGuid = this.getServerGuid((Integer)objectGuidList.get(0));
            ArrayList objectNameList = null;
            objectNameList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)serverInputParams.optJSONArray("selectedObjectNameList"));
            String objectName = objectNameList.get(0).toString();
            JSONObject netApp = EMCHandler.getCifsDetailsEmber((String)objectGuid, (String)objectName, (String)serverInputParams.getString("domainName"));
            JSONObject returnListMap = new JSONObject();
            returnListMap.put("netappData", (Object)netApp);
            JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getADFileServers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject pageInputParams = null;
            pageInputParams = reportReqData.getJSONObject("pageInputParams");
            Integer machineType = pageInputParams.getInt("machineType");
            String objectClass = pageInputParams.getString("objectClass");
            String domainName = pageInputParams.getString("domainName");
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            JSONArray pageList = this.getServerPageInputParams(machineType, pageInputParams, rb);
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)("AUDCVConfig:cv_id:" + pageInputParams.getString("cvId")));
            cvId = cvId != null ? cvId : Long.parseLong(pageInputParams.getString("cvId"));
            String searchCriteria = null;
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = ServerConfigHandler.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            Boolean isSearch = false;
            searchCriteria = ServerConfigHandler.getInstance().getSearchCriteria(pageInputParams, tableAllColumnList, false, true);
            if (searchCriteria != null) {
                isSearch = true;
            }
            Long count = DirectoryObjectAPI.getInstance().getObjectsCount(defaultNamingContext, objectClass, searchCriteria, cvId);
            if (!pageInputParams.has("sortColumn")) {
                pageInputParams.put("sortColumn", tableDetails.get("SORTCOLUMN"));
                pageInputParams.put("sortOrder", tableDetails.get("SORTORDER"));
                pageInputParams.put("sortTableName", (Object)"ADSMComputerGeneralDetails");
            }
            pageInputParams.put("selObjNameIndex", (Object)"1");
            ServerConfigHandler.getInstance().getRangeList(pageInputParams);
            pageInputParams.put("totalCount", (Object)count);
            pageInputParams.put("isSearch", (Object)isSearch);
            ArrayList reportsList = new ArrayList();
            if (count > 0L) {
                reportsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, objectClass, searchCriteria, Integer.parseInt(pageInputParams.getString("startValue")), Integer.parseInt(pageInputParams.getString("rangeValue")), cvId, count);
            }
            if (count == 0L) {
                pageInputParams.put("emptyTableMessage", (Object)rb.getString("adap_common.no_ad_objects_available"));
                if (isSearch.booleanValue()) {
                    pageInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    pageInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.common.text.policy_update_link.click_here"));
                } else {
                    pageInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                    pageInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_refresh"));
                }
            }
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, reportsList, tableAllColumnList, pageInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            returnListMap.put("tableData", tableData.get("tableDataList"));
            returnListMap.put("tableColumnList", tableAllColumnList);
            returnListMap.put("pageInputParams", pageInputParams);
            returnListMap.put("pageList", pageList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateADObjects(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject pageInputParams = null;
        pageInputParams = reportReqData.getJSONObject("pageInputParams");
        String objectClass = pageInputParams.getString("objectClass");
        String domainName = pageInputParams.getString("domainName");
        String message = "";
        String argObjectVal = "";
        String statusVal = "";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (objectClass != null) {
            if (objectClass.equalsIgnoreCase("user")) {
                argObjectVal = "Users";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.users");
            } else if (objectClass.equalsIgnoreCase("group")) {
                argObjectVal = "Group";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.groups");
            } else if (objectClass.equalsIgnoreCase("computer")) {
                argObjectVal = "Computers";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.computers");
            } else if (objectClass.equalsIgnoreCase("organizationalUnit")) {
                argObjectVal = "OU";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.organizational_units");
            } else if (objectClass.equalsIgnoreCase("share")) {
                argObjectVal = "Share";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.shares");
            } else {
                argObjectVal = "GPO";
                statusVal = rb.getString("adap.domain_settings.update_domain_details.actionname.group_policy_objects");
            }
        }
        String[] selectedUpdates = new String[]{argObjectVal};
        message = rb.handleGetObject("adap.ViewObjects.Reload_page_after_sometime_to", new String[]{statusVal});
        try {
            DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message + "\n" + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Objects_updated_manually", "-"}));
        }
        catch (Exception ex) {
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ViewObjects.audit_entry.problem_updating_domain_objects", new String[]{domainName}), 8, 16, message, "adap.ADAPUserAuditSeverities.audit_name.Objects_updated_manually", "-"}));
            ex.printStackTrace();
        }
        pageInputParams.put("filterText", (Object)message);
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("pageInputParams", (Object)pageInputParams);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }
}

