/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.home;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDSummaryReports;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.GraphGenerator;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.GraphUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.common.server.wengine.GraphSchedulerTask;
import com.adventnet.taskengine.internal.SchedulerBean;
import com.manageengine.ads.fw.layout.LayoutBean;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class HomeConfigHandler {
    private static volatile HomeConfigHandler instance = null;
    private static String resultantTableName = "AUDSummaryReports";
    private static String mappingTableName = "AUDSummaryReportMapping";
    private static String categoryTableName = "AUDSummaryReportCategories";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HomeConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<HomeConfigHandler> clazz = HomeConfigHandler.class;
        synchronized (HomeConfigHandler.class) {
            if (instance != null) return instance;
            instance = new HomeConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HomeConfigHandler() {
    }

    public void getMyReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject returnListMap = new JSONObject();
            JSONArray myReports = this.getHomeMyReports(request, response);
            returnListMap.put("myReports", (Object)myReports);
            JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getChartInputList(JSONObject homeInputParams, AdventNetResourceBundle rb) throws Exception {
        JSONArray l = new JSONArray();
        String[] chartInputNames = new String[]{rb.getString("adap.ReportGraphs.oneday_twoday"), rb.getString("adap.ReportGraphs.oneday_oneweek")};
        String[] chartInputValues = new String[]{"1;;;2", "1;;;7"};
        for (int i = 0; i < chartInputNames.length; ++i) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)chartInputNames[i]);
            obj.put("value", (Object)chartInputValues[i]);
            l.put((Object)obj);
        }
        homeInputParams.put("chartInputList", (Object)l);
    }

    public void getDashBoard(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, ArrayList<ArrayList<Object>>> returnListMap = new HashMap<String, ArrayList<ArrayList<Object>>>();
        try {
            Long userAccessId;
            HttpSession session;
            ADAPAuthObject authObject;
            HashMap actionAccesses;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject homeReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject homeInputParams = null;
            homeInputParams = homeReqData.getJSONObject("homeInputParams");
            String layoutName = null;
            Long tabId = homeInputParams.getLong("tabId");
            Long requiredAccessId = 2001L;
            if (tabId == 3L) {
                layoutName = "admp.home.layout.name.file_audit_layout";
                requiredAccessId = 102L;
            }
            if (!(actionAccesses = (authObject = (ADAPAuthObject)(session = request.getSession()).getAttribute("ADAP_AUTH_OBJ")).getAccesses()).containsKey(userAccessId = DBObjectUtil.getUVHValues((String)"ADAPUserRoleActions", (String)("ADAPUserRoleActions:action_id:" + requiredAccessId)))) {
                response.sendError(401);
                throw new Exception("ACCESS DENIED");
            }
            Credential userCredential = AuthUtil.getUserCredential();
            Long userId = userCredential.getUserId();
            JSONObject layoutDataModel = new LayoutBean(request).getLayout(userId, layoutName);
            Long layoutId = layoutDataModel.getLong("LAYOUT_ID");
            JSONObject tabDataModel = new LayoutBean(request).getTabs(layoutId);
            for (int priorityId = 1; priorityId <= tabDataModel.length(); ++priorityId) {
                JSONObject tabProps = tabDataModel.getJSONObject(Integer.toString(priorityId));
                Long dashBoardTabId = tabProps.getLong("TAB_ID");
                if (dashBoardTabId == 1L || dashBoardTabId == 3L) {
                    ArrayList<ArrayList<JSONObject>> homeChartList = this.getGraphicalData(request, homeInputParams, dashBoardTabId);
                    returnListMap.put("homeChartList", homeChartList);
                    continue;
                }
                if (dashBoardTabId != 2L && dashBoardTabId != 4L) continue;
                JSONObject summaryMap = this.getHomeSummaryData(homeInputParams, rb);
                returnListMap.put("summaryData", (ArrayList<ArrayList<Object>>)summaryMap);
            }
            this.getChartInputList(homeInputParams, rb);
            String lastScheduleRunAt = null;
            Criteria criteria = new Criteria(Column.getColumn((String)"SCHEDULE_AUDIT", (String)"TASK_NAME"), (Object)"GraphSchedulerTask", 0);
            DataObject d = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SCHEDULE_AUDIT", criteria);
            if (!d.isEmpty()) {
                SortColumn sortCol = new SortColumn("SCHEDULE_AUDIT", "SCHEDULE_START_TIME", false);
                d.sortRows("SCHEDULE_AUDIT", new SortColumn[]{sortCol});
                Row r = d.getFirstRow("SCHEDULE_AUDIT");
                Timestamp timestamp = (Timestamp)r.get("SCHEDULE_START_TIME");
                lastScheduleRunAt = timestamp.toLocaleString();
            }
            homeInputParams.put("lastScheduleRunAt", lastScheduleRunAt);
            homeInputParams.put("nextScheduleRunAt", (Object)rb.getString("adap.home_graph_run_now_tool_tip"));
            homeInputParams.put("isHomeGraphRefreshRunning", GraphSchedulerTask.isHomeGraphRefreshRunning);
            returnListMap.put("homeInputParams", (ArrayList<ArrayList<Object>>)homeInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ArrayList<ArrayList<JSONObject>> getGraphicalData(HttpServletRequest request, JSONObject homeInputParams, Long dashBoardTabId) {
        ArrayList<ArrayList<JSONObject>> homeChartList = new ArrayList<ArrayList<JSONObject>>();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String domainName = homeInputParams.getString("domainName");
            Long tabId = homeInputParams.getLong("tabId");
            if (tabId == 1L) {
                homeInputParams.put("showRightPane", true);
                homeInputParams.put("bodyPaneClass", (Object)"right-pane-active");
            }
            JSONObject tabContainersDataModel = new LayoutBean(request).getTabContainers(dashBoardTabId);
            ArrayList<String> list = new ArrayList<String>();
            Iterator iterator = tabContainersDataModel.keys();
            while (iterator.hasNext()) {
                list.add((String)iterator.next());
            }
            Collections.sort(list);
            iterator = list.iterator();
            ArrayList<JSONObject> l1 = new ArrayList<JSONObject>();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                JSONObject tabContainerDataModel = tabContainersDataModel.getJSONObject(key);
                Long conId = tabContainerDataModel.getLong("CONTAINER_ID");
                JSONObject componentDataModel = new LayoutBean(request).getContainerComponent(conId);
                Long componentId = componentDataModel.getLong("COMPONENT_ID");
                HashMap detailsMap = GraphUtil.getHomeGraphModel((AdventNetResourceBundle)rb, (Long)componentId);
                if (detailsMap.isEmpty()) continue;
                Long graphOptId = (Long)detailsMap.get("GRAPH_OPT_ID");
                JSONObject chartMap = new JSONObject();
                for (int i = 0; i < 2; ++i) {
                    Long days;
                    JSONObject reportObj = new JSONObject();
                    JSONObject graphData = new JSONObject();
                    if (i == 0) {
                        chartMap.put("firstGraph", (Object)graphData);
                        days = (Long)detailsMap.get("FIRST_GRAPH_DURATION");
                    } else {
                        chartMap.put("secondGraph", (Object)graphData);
                        days = (Long)detailsMap.get("SECOND_GRAPH_DURATION");
                    }
                    Criteria optIdCrit = new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
                    optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DAYS"), (Object)days, 0));
                    optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDHomeGraphsData", optIdCrit);
                    graphData.put("isEmpty", (Object)"load");
                    if (!dataObj.isEmpty()) {
                        Row graphRow = dataObj.getFirstRow("AUDHomeGraphsData");
                        if (!dataObj.isEmpty() && graphRow.get("JSON_VALUE") != null && !graphRow.get("JSON_VALUE").toString().equals("")) {
                            reportObj = new JSONObject((String)graphRow.get("JSON_VALUE"));
                        } else {
                            reportObj = new JSONObject();
                            graphData.put("isEmpty", true);
                        }
                    } else {
                        reportObj = new JSONObject();
                        graphData.put("isEmpty", true);
                    }
                    graphData.put("chartObject", new HashMap());
                    graphData.put("graphDataValue", (Object)reportObj);
                    reportObj = new JSONObject();
                    graphData.put("graphData", (Object)reportObj);
                    graphData.put("xlabel", detailsMap.get("XLABEL"));
                    graphData.put("ylabel", detailsMap.get("YLABEL"));
                    if (detailsMap.get("GRAPH_TITLE").toString().length() > 28) {
                        graphData.put("graphTitleTrimTxt", (Object)(detailsMap.get("GRAPH_TITLE").toString().substring(0, 28) + "..."));
                    } else {
                        graphData.put("graphTitleTrimTxt", detailsMap.get("GRAPH_TITLE"));
                    }
                    graphData.put("graphTitle", detailsMap.get("GRAPH_TITLE"));
                    graphData.put("graphOptId", detailsMap.get("GRAPH_OPT_ID"));
                    graphData.put("chartType", detailsMap.get("GRAPH_TYPE"));
                    graphData.put("cvId", detailsMap.get("CV_ID"));
                    graphData.put("days", (Object)days);
                    graphData.put("graphId", (Object)("graphId_" + detailsMap.get("GRAPH_OPT_ID") + "_" + days + "_day"));
                    graphData.put("graphName", (Object)("graphName_" + detailsMap.get("GRAPH_OPT_ID") + "_" + days + "_day"));
                    graphData.put("graphClassId", (Object)("graphClass_" + detailsMap.get("GRAPH_OPT_ID") + "_day"));
                    graphData.put("chartLoaderId", (Object)("chartLoader_" + detailsMap.get("GRAPH_OPT_ID") + "_day"));
                    graphData.put("isHomeGraph", true);
                    graphData.put("height", 250);
                    graphData.put("conId", (Object)conId);
                }
                l1.add(chartMap);
            }
            int N = l1.size();
            int L = 3;
            for (int k = 0; k < N; k += 3) {
                homeChartList.add(new ArrayList(l1.subList(k, Math.min(N, k + 3))));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return homeChartList;
    }

    public void getIsHomeGraphRefreshRunning(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("isHomeGraphRefreshRunning", GraphSchedulerTask.isHomeGraphRefreshRunning);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void runHomeGraphUpdateScheduler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (!GraphSchedulerTask.isHomeGraphRefreshRunning) {
            GraphSchedulerTask.isHomeGraphRefreshRunning = true;
            SchedulerBean scheduler = new SchedulerBean();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"TASK_INPUT"));
            query.addSelectColumn(Column.getColumn((String)"TASK_INPUT", (String)"*"));
            query.addJoin(new Join("TASK_INPUT", "TASKENGINE_TASK", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"TASKENGINE_TASK", (String)"TASK_NAME"), (Object)"GraphSchedulerTask", 0);
            query.setCriteria(criteria);
            DataObject d = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Row r = d.getFirstRow("TASK_INPUT");
            scheduler.preponeTask((Long)r.get("INSTANCE_ID"));
        }
        String msgType = "info";
        String msgTxt = (String)rb.handleGetObject("adap.updating_home_graph");
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        returnListMap.put("isHomeGraphRefreshRunning", GraphSchedulerTask.isHomeGraphRefreshRunning);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public JSONArray getHomeMyReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray myReports = new JSONArray();
        HttpSession session = request.getSession();
        JSONObject jsonObj = MyFavRepHandler.getDataSource();
        ArrayList list = (ArrayList)jsonObj.get("repObj");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList userActions = authObject.getUserActins();
        if (list.size() > 0 && userActions.contains(TDConstants.MY_REPORTS)) {
            HashMap details = authObject.getLoginUserDetails();
            String delegetedDomain = (String)details.get("DELEGATED_DOMAIN");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject reportObj = (JSONObject)list.get(i);
                int productId = reportObj.getInt("PRODUCT_ID");
                if (productId != 3) continue;
                JSONObject params = (JSONObject)reportObj.get("param");
                String domainName = params.getString("domainName");
                if (!delegetedDomain.equals("All Domains") && !delegetedDomain.equals(domainName)) continue;
                JSONObject myReport = new JSONObject();
                myReport.put("reportName", (Object)reportObj.getString("DISPLAY_NAME"));
                myReport.put("modelId", params.getLong("reportId"));
                myReport.put("favRepId", params.getLong("favRepId"));
                if (params.getString("selectedTab").equals("reports")) {
                    myReport.put("routeName", (Object)"reports.report");
                } else if (params.getString("selectedTab").equals("fileAudit")) {
                    myReport.put("routeName", (Object)"fileaudit.report");
                } else {
                    myReport.put("routeName", (Object)"serveraudit.report");
                }
                myReports.put((Object)myReport);
            }
        }
        return myReports;
    }

    private JSONObject getHomeSummaryData(JSONObject homeInputParams, AdventNetResourceBundle rb) throws Exception {
        JSONObject summaryMap = new JSONObject();
        try {
            String domainName = homeInputParams.getString("domainName");
            Long tabId = homeInputParams.getLong("tabId");
            int reportCategoryType = 1;
            if (tabId == 3L) {
                reportCategoryType = 2;
            }
            JSONArray list = this.getSummaryReports(reportCategoryType, null, domainName, rb);
            JSONObject summaryInputParams = new JSONObject();
            String timeInterval = (String)AUDSummaryReports.getParameter((String)"TIME_INTERVAL");
            HashMap timeMap = TimeUtil.getTimePeriod((String)timeInterval);
            String fromTime = TimeUtil.getSimpleDateFormat((Date)new Date((Long)timeMap.get("FROM") * 1000L));
            String toTime = TimeUtil.getSimpleDateFormat((Date)new Date((Long)timeMap.get("TO") * 1000L));
            String timeStr = rb.getString("adap.AudSelectElementAttr.Yesterday");
            if (timeInterval.equals("twfourhours")) {
                timeStr = rb.getString("adap.AudSelectElementAttr.Last_24_Hours");
            }
            summaryInputParams.put("timeIntervalString", (Object)timeStr);
            summaryInputParams.put("timeInterval", (Object)timeInterval);
            summaryInputParams.put("fromTime", (Object)fromTime);
            summaryInputParams.put("toTime", (Object)toTime);
            boolean mailConficCheck = MailServerUtil.mailServerConfig();
            summaryInputParams.put("isMailServerConfigured", mailConficCheck);
            Long time = (Long)AUDSummaryReports.getParameter((String)"LAST_SCHEDULE_AT");
            String lastScheduleTime = " - ";
            if (time > 0L) {
                lastScheduleTime = TimeUtil.getSimpleDateFormat((Date)new Date(time * 1000L));
            }
            String timeOfNextSchedule = new SimpleDateFormat("HH:mm:ss a").format(AUDSummaryReports.getScheduleTime());
            String configureMail = rb.getString("adap.SummaryView.configure_mail_tooltip") + " " + timeOfNextSchedule;
            summaryInputParams.put("lastScheduleRunAt", (Object)lastScheduleTime);
            summaryInputParams.put("configureMail", (Object)configureMail);
            summaryInputParams.put("nextScheduleRunAt", (Object)(rb.getString("adap.summary_graph_run_now_tool_tip") + " " + timeOfNextSchedule));
            if (list.length() > 0 && (time > (Long)timeMap.get("TO") && timeInterval.equals("Yesterday") || timeInterval.equals("twfourhours"))) {
                summaryInputParams.put("summaryMailConfigured", false);
            } else {
                list = new JSONArray();
                summaryInputParams.put("type", (Object)"emptyTable");
                summaryInputParams.put("boldMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
            }
            String summaryMailId = (String)AUDSummaryReports.getParameter((String)"MAIL_ADDRESS");
            if (!summaryMailId.equals("no")) {
                summaryInputParams.put("summaryMailConfigured", true);
                summaryInputParams.put("summaryMailId", (Object)summaryMailId);
            } else {
                summaryInputParams.put("summaryMailConfigured", false);
            }
            summaryMap.put("summaryInputParams", (Object)summaryInputParams);
            summaryMap.put("summaryDataList", (Object)list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return summaryMap;
    }

    private JSONArray getSummaryReports(int reportCategoryType, Long summaryCategoryId, String domainName, AdventNetResourceBundle rb) {
        JSONArray mainList = new JSONArray();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)mappingTableName));
            Join leftJoin = new Join(Table.getTable((String)mappingTableName), Table.getTable((String)resultantTableName), new String[]{"SUMMARY_REPORT_ID"}, new String[]{"SUMMARY_REPORT_ID"}, 2);
            query.addJoin(leftJoin);
            Join cateJoin = new Join(Table.getTable((String)mappingTableName), Table.getTable((String)categoryTableName), new String[]{"SUMMARY_CATEGORY_ID"}, new String[]{"SUMMARY_CATEGORY_ID"}, 2);
            query.addJoin(cateJoin);
            int domainQC = domainName != null ? 0 : 1;
            int sumCatIdQC = summaryCategoryId != null ? 0 : 1;
            Criteria criteria = new Criteria(Column.getColumn((String)resultantTableName, (String)"DOMAIN_NAME"), (Object)domainName, domainQC);
            criteria = criteria.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"IS_ENABLED"), (Object)true, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), (Object)summaryCategoryId, sumCatIdQC));
            if (reportCategoryType != 0) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"REPORT_CATEGORY_TYPE"), (Object)reportCategoryType, 0));
            }
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)resultantTableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)mappingTableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)categoryTableName, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), true));
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dObj.isEmpty()) {
                Criteria crit = new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), null, 1);
                int count = 0;
                int height = 0;
                JSONArray catList = null;
                Iterator iterator = dObj.getRows(categoryTableName, crit);
                while (iterator.hasNext()) {
                    if (count == 0) {
                        catList = new JSONArray();
                        mainList.put((Object)catList);
                    }
                    ++count;
                    Row categoryRow = (Row)iterator.next();
                    summaryCategoryId = (Long)categoryRow.get("SUMMARY_CATEGORY_ID");
                    Criteria crit1 = new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), (Object)summaryCategoryId, 0);
                    JSONArray reportList = new JSONArray();
                    JSONObject catMap = new JSONObject();
                    catMap.put("categoryName", (Object)rb.getString((String)categoryRow.get("SUMMARY_CATEGORY_NAME")));
                    if (summaryCategoryId == 1L) {
                        catMap.put("iconClass", (Object)"icn-lock");
                        catMap.put("isLogon", true);
                    } else if (summaryCategoryId == 2L) {
                        catMap.put("iconClass", (Object)"icn-settings");
                    } else if (summaryCategoryId == 3L) {
                        catMap.put("iconClass", (Object)"icn-group");
                    } else if (summaryCategoryId == 4L) {
                        catMap.put("iconClass", (Object)"icn-computer");
                    } else if (summaryCategoryId == 5L) {
                        catMap.put("iconClass", (Object)"icn-ou");
                    } else if (summaryCategoryId == 6L) {
                        catMap.put("iconClass", (Object)"icn-gpo");
                    } else if (summaryCategoryId == 7L) {
                        catMap.put("iconClass", (Object)"icn-domain");
                    } else if (summaryCategoryId == 8L) {
                        catMap.put("iconClass", (Object)"icn-lock");
                    } else if (summaryCategoryId == 9L) {
                        catMap.put("iconClass", (Object)"icn-lock");
                    }
                    Boolean isMultipleRow = false;
                    Iterator iter = dObj.getRows(mappingTableName, crit1);
                    while (iter.hasNext()) {
                        Row row1 = (Row)iter.next();
                        Long summaryReportId = (Long)row1.get("SUMMARY_REPORT_ID");
                        isMultipleRow = (Boolean)row1.get("IS_MULTI_LINE_OUTPUT");
                        Criteria crit2 = new Criteria(Column.getColumn((String)resultantTableName, (String)"SUMMARY_REPORT_ID"), (Object)summaryReportId, 0);
                        crit2 = crit2.and(new Criteria(Column.getColumn((String)resultantTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                        JSONObject m3 = new JSONObject();
                        if (isMultipleRow.booleanValue()) {
                            JSONArray list1 = new JSONArray();
                            Iterator iter1 = dObj.getRows(resultantTableName, crit2);
                            while (iter1.hasNext()) {
                                Row row2 = (Row)iter1.next();
                                if (row2 == null) continue;
                                JSONObject map3 = new JSONObject();
                                map3.put("dataName", row2.get("REMARKS"));
                                map3.put("dataValue", row2.get("SUMMARY_RESULT_COUNT"));
                                if (row2.get("REMARKS").toString().equals("Success") || row2.get("REMARKS").toString().equalsIgnoreCase(rb.getString("adap.DefaultCategoryListener.Success"))) {
                                    map3.put("dataIconClass", (Object)"success");
                                    map3.put("dataSymbolClass", (Object)"status-failure");
                                } else if (row2.get("REMARKS").toString().equals("Failure") || row2.get("REMARKS").toString().equalsIgnoreCase(rb.getString("adap.DefaultCategoryListener.Failure"))) {
                                    map3.put("dataIconClass", (Object)"failure");
                                    map3.put("dataSymbolClass", (Object)"status-failure");
                                }
                                list1.put((Object)map3);
                            }
                            m3.put("dataList", (Object)list1);
                            m3.put("isDataList", true);
                            m3.put("reportName", (Object)rb.getString((String)row1.get("SUMMARY_REPORT_NAME")));
                            if (summaryReportId == 1L) {
                                JSONArray sectionArray = new JSONArray();
                                JSONArray splitArray = new JSONArray();
                                for (int k = 1; k <= list1.length(); ++k) {
                                    splitArray.put(list1.get(k - 1));
                                    if (k % 2 == 0) {
                                        sectionArray.put((Object)splitArray);
                                        splitArray = new JSONArray();
                                        continue;
                                    }
                                    if (k != list1.length()) continue;
                                    sectionArray.put((Object)splitArray);
                                }
                                m3.put("isLogonActivity", true);
                                m3.put("dataList", (Object)sectionArray);
                            }
                        } else {
                            Row row2 = dObj.getRow(resultantTableName, crit2);
                            if (row2 != null) {
                                m3.put("reportName", row2.get("REMARKS"));
                                m3.put("reportValue", row2.get("SUMMARY_RESULT_COUNT"));
                                m3.put("routeName", (Object)"reports.report");
                                m3.put("modelId", row1.get("AUDIT_REPORT_ID"));
                            }
                            m3.put("isDataList", false);
                        }
                        reportList.put((Object)m3);
                    }
                    if (isMultipleRow.booleanValue()) {
                        catMap.put("isMultipleRow", (Object)isMultipleRow);
                    }
                    catMap.put("reportList", (Object)reportList);
                    catMap.put("divHeightClass", (Object)("r1_" + height));
                    if (count == 2) {
                        count = 0;
                        ++height;
                    }
                    catList.put((Object)catMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mainList;
    }

    public void refreshHomeGraph(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject chartReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject chartInputParams = chartReqData.getJSONObject("chartInputParams");
            JSONObject chartData = chartInputParams.getJSONObject("chartData");
            String domainName = chartInputParams.getString("domainName");
            Long graphOptId = chartData.getLong("graphOptId");
            Long duration = chartData.getLong("days");
            Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.schedule.DefaultGraphGenerator");
            GraphGenerator generator = (GraphGenerator)classToInvoke.newInstance();
            HashMap graphDataMap = generator.generateHighCharts(graphOptId, domainName, duration, new ArrayList());
            graphDataMap.put("conId", chartData.getLong("conId"));
            HashMap<String, HashMap> returnListMap = new HashMap<String, HashMap>();
            returnListMap.put("chartData", graphDataMap);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void refreshSummaryReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String message = rb.getString("adap.HomeGraphAction.Please_wait_for_a_while");
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject homeInputParams = null;
            homeInputParams = reportReqData.getJSONObject("homeInputParams");
            JSONObject summaryInputParams = reportReqData.getJSONObject("summaryInputParams");
            String domainName = homeInputParams.getString("domainName");
            int isSummaryRunning = (Integer)AUDSummaryReports.getParameter((String)"RUNNING_STATUS");
            if (isSummaryRunning == 0) {
                AUDSummaryReports.truncateOldData();
                AUDSummaryReports.fillSummaryReports((String)"twfourhours");
                AUDSummaryReports.setTimeToSay();
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.HomeGraphAction.audit_entry.Manually_Summary_Reports_runnow"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manually_summary_run", "-"}));
            } else {
                message = rb.getString("adap.HomeGraphAction.Summary_reports_is_already_running");
                summaryInputParams.put("boldMessage", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manually_summary_run", "-"}));
            }
            Long tabId = homeInputParams.getLong("tabId");
            int reportCategoryType = 1;
            if (tabId == 3L) {
                reportCategoryType = 2;
            }
            JSONArray list = this.getSummaryReports(reportCategoryType, null, domainName, rb);
            if (isSummaryRunning == 0) {
                String timeInterval = (String)AUDSummaryReports.getParameter((String)"TIME_INTERVAL");
                HashMap timeMap = TimeUtil.getTimePeriod((String)timeInterval);
                String fromTime = TimeUtil.getSimpleDateFormat((Date)new Date((Long)timeMap.get("FROM") * 1000L));
                String toTime = TimeUtil.getSimpleDateFormat((Date)new Date((Long)timeMap.get("TO") * 1000L));
                String timeStr = rb.getString("adap.AudSelectElementAttr.Yesterday");
                if (timeInterval.equals("twfourhours")) {
                    timeStr = rb.getString("adap.AudSelectElementAttr.Last_24_Hours");
                }
                summaryInputParams.put("timeInterval", (Object)timeStr);
                summaryInputParams.put("fromTime", (Object)fromTime);
                summaryInputParams.put("toTime", (Object)toTime);
                boolean mailConficCheck = MailServerUtil.mailServerConfig();
                summaryInputParams.put("isMailServerConfigured", mailConficCheck);
                Long time = (Long)AUDSummaryReports.getParameter((String)"LAST_SCHEDULE_AT");
                String lastScheduleTime = " - ";
                if (time > 0L) {
                    lastScheduleTime = TimeUtil.getSimpleDateFormat((Date)new Date(time * 1000L));
                }
                String timeOfNextSchedule = new SimpleDateFormat("HH:mm:ss a").format(AUDSummaryReports.getScheduleTime());
                String configureMail = rb.getString("adap.SummaryView.configure_mail_tooltip") + " " + timeOfNextSchedule;
                summaryInputParams.put("lastScheduleRunAt", (Object)lastScheduleTime);
                summaryInputParams.put("configureMail", (Object)configureMail);
                summaryInputParams.put("nextScheduleRunAt", (Object)(rb.getString("adap.summary_graph_run_now_tool_tip") + " " + timeOfNextSchedule));
                if (list.length() <= 0 || (time <= (Long)timeMap.get("TO") || !timeInterval.equals("Yesterday")) && !timeInterval.equals("twfourhours")) {
                    list = new JSONArray();
                    summaryInputParams.put("type", (Object)"emptyTable");
                    summaryInputParams.put("boldMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                }
            }
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            returnListMap.put("summaryList", list);
            returnListMap.put("domainName", domainName);
            returnListMap.put("summaryInputParams", summaryInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.HomeGraphAction.audit_entry.Problem_starting_summary_now"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manually_summary_run", ex.getMessage()}));
        }
    }

    public void homeGraphData(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ArrayList<Object> columnList = new ArrayList();
            ArrayList reportsList = new ArrayList();
            HashMap<String, Object> reportInputMap = new HashMap<String, Object>();
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = reportInputParams.getString("domainName");
            Long graphOptId = reportInputParams.getLong("graphOptId");
            Long noofday = reportInputParams.getLong("duration");
            Long cvId = reportInputParams.getLong("cvId");
            String chartType = reportInputParams.getString("graphType");
            String inputElement = reportInputParams.getString("title");
            ServerConfigHandler.getInstance().getRangeList(reportInputParams);
            Integer range = 25;
            request.setAttribute("range", (Object)range);
            reportInputMap.put("cvID", cvId);
            reportInputMap.put("graphOptId", graphOptId);
            reportInputMap.put("domainName", domainName);
            reportInputMap.put("inputElement", inputElement);
            reportInputMap.put("graphType", chartType);
            int count = 0;
            boolean visible = true;
            if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                count = AuditReportAPI.getInstance().getGraphUnderlyingDataCount(cvId, graphOptId, domainName, inputElement, noofday, chartType);
                reportsList = AuditReportAPI.getInstance().getGraphUnderlyingData(cvId, graphOptId, domainName, inputElement, Integer.valueOf(Integer.parseInt(reportInputParams.getString("startValue"))), Integer.valueOf(Integer.parseInt(reportInputParams.getString("rangeValue"))), noofday, chartType, Integer.valueOf(count), Boolean.valueOf(true));
            } else {
                if (chartType.equalsIgnoreCase("timeseries")) {
                    // empty if block
                }
                if ((count = AuditReportAPI.getInstance().getGraphUnderlyingDataCount(cvId, graphOptId, domainName, inputElement, noofday, chartType)) > 0) {
                    reportsList = AuditReportAPI.getInstance().getGraphUnderlyingData(cvId, graphOptId, domainName, inputElement, Integer.valueOf(Integer.parseInt(reportInputParams.getString("startValue"))), Integer.valueOf(Integer.parseInt(reportInputParams.getString("rangeValue"))), noofday, chartType, Integer.valueOf(count), Boolean.valueOf(true));
                }
            }
            if (count == 0) {
                reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.Reports.ReportResultRows.Click_here_to_TroubleShoot"));
                reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
            }
            request.setAttribute("count", (Object)count);
            columnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, visible, true, false, null, null, rb);
            reportInputParams.put("totalCount", count);
            reportInputParams.put("tableName", (Object)("objectTabTable_" + cvId));
            reportInputParams.put("tabId", (Object)("tabId_" + cvId));
            reportInputParams.put("tabIdh", (Object)("#tabId_" + cvId));
            reportInputParams.put("tabName", (Object)("tabName_" + cvId));
            HashMap returnListMap = new HashMap();
            returnListMap.put("reportData", reportsList);
            returnListMap.put("reportColumnList", columnList);
            returnListMap.put("inputParams", reportInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addOrUpdateMailAddress(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap_Home.successfully_added_updated_mail_address");
        Boolean msgType = true;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = null;
        reportInputParams = reportReqData.getJSONObject("inputParams");
        String summaryMailId = reportInputParams.getString("summaryMailId");
        try {
            AUDSummaryReports.updateParameter((String)"MAIL_ADDRESS", (Object)summaryMailId);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.HomeGraphAction.Summary_email_updation_successfully", new String[]{summaryMailId}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_summary_mail", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = false;
            msgTxt = rb.getString("adap_Home.error_while_updating_mail_address");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.HomeGraphAction.Summary_email_updation_failed", new String[]{summaryMailId}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_summary_mail", "Reason : " + ex.getMessage()}));
        }
        HashMap<String, Object> returnListMap = new HashMap<String, Object>();
        returnListMap.put("msgTxt", msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }
}

