/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.report;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.DataCruncher;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.webclient.compliance.ComplianceReportHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.serveraudit.ServerConfigHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class AggregateReportHandler {
    private static volatile AggregateReportHandler instance = null;
    String[] categoryTypes = new String[]{"adap.AUDReportCategories.sr_name.Logon_Events", "adap.AUDReportCategories.sr_name.Account_Management"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AggregateReportHandler getInstance() {
        if (instance != null) return instance;
        Class<AggregateReportHandler> clazz = AggregateReportHandler.class;
        synchronized (AggregateReportHandler.class) {
            if (instance != null) return instance;
            instance = new AggregateReportHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AggregateReportHandler() {
    }

    public HashMap<String, Long> getTimePeriod(int timePeriod) {
        HashMap<String, Long> periodMap = new HashMap<String, Long>();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(11, 0);
        cal2.set(12, 0);
        cal2.set(13, 0);
        cal2.set(14, 0);
        Long startTime = 0L;
        Long endTime = 0L;
        if (timePeriod == 0) {
            cal.add(5, -1);
        } else if (timePeriod == 1) {
            cal.add(5, -7);
        } else if (timePeriod == 2) {
            cal.set(7, 1);
            cal.add(3, -1);
            cal2.set(7, 1);
        } else if (timePeriod == 3) {
            cal.set(5, 1);
        } else if (timePeriod == 4) {
            cal.set(5, 1);
            cal.add(2, -1);
            cal2.set(5, 1);
        } else if (timePeriod == 5) {
            cal.set(5, 1);
            cal.set(2, 0);
        } else if (timePeriod == 6) {
            cal.set(5, 1);
            cal.set(2, 0);
            cal.add(1, -1);
            cal2.set(5, 1);
            cal2.set(2, 0);
        } else if (timePeriod == 7) {
            cal.set(7, 1);
        } else if (timePeriod == 8) {
            int month = cal.get(2);
            int quarter = month - month % 3;
            cal.set(5, 1);
            cal.set(2, quarter);
        } else if (timePeriod == 9) {
            int month = cal.get(2);
            int quarter = month - month % 3;
            cal.set(5, 1);
            cal.set(2, quarter);
            cal.add(2, -3);
            int month2 = cal2.get(2);
            int quarter2 = month2 - month2 % 3;
            cal2.set(5, 1);
            cal2.set(2, quarter2);
        }
        startTime = cal.getTimeInMillis() / 1000L;
        endTime = cal2.getTimeInMillis() / 1000L;
        periodMap.put("startTime", startTime);
        periodMap.put("endTime", endTime - 1L);
        return periodMap;
    }

    public JSONArray getTimeList(AdventNetResourceBundle rb) throws Exception {
        String[] rangeValues = new String[]{rb.getString("adap.AudSelectElementAttr.Yesterday"), rb.getString("adap.AudSelectElementAttr.Last_7_Days"), rb.getString("adap.AudSelectElementAttr.Last_Week"), rb.getString("adap.AudSelectElementAttr.This_Week"), rb.getString("adap.AudSelectElementAttr.This_Month"), rb.getString("adap.AudSelectElementAttr.Last_Month"), rb.getString("adap.AudSelectElementAttr.This_Year"), rb.getString("adap.AudSelectElementAttr.Last_Year"), rb.getString("adap.AudSelectElementAttr.This_Quarter"), rb.getString("adap.AudSelectElementAttr.Last_Quarter"), rb.getString("adap.AudSelectElementAttr.Last_N_Period"), rb.getString("adap.AudSelectElementAttr.Custom_Period")};
        String[] rangePriority = new String[]{"0", "1", "2", "7", "3", "4", "5", "6", "8", "9", "10", "11"};
        JSONArray timeList = new JSONArray();
        for (int i = 0; i < rangeValues.length; ++i) {
            if (rangePriority[i].equals("10") || rangePriority[i].equals("11")) continue;
            JSONObject obj = new JSONObject();
            HashMap<String, Long> periodMap = this.getTimePeriod(Integer.parseInt(rangePriority[i]));
            obj.put("name", (Object)rangeValues[i]);
            obj.put("start", (Object)periodMap.get("startTime"));
            obj.put("end", (Object)periodMap.get("endTime"));
            obj.put("serverValue", (Object)rangePriority[i]);
            timeList.put((Object)obj);
        }
        return timeList;
    }

    public Long getAggregateTime(String chosenServerValue, Long time, Boolean isStartTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time * 1000L);
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        if (chosenServerValue.equals("customPeriod")) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (isStartTime.booleanValue()) {
                cal.set(5, 1);
            } else {
                cal.set(5, cal.getActualMaximum(5));
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                return cal.getTimeInMillis() / 1000L;
            }
        }
        return cal.getTimeInMillis() / 1000L;
    }

    public void getCategoriesSum(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject aggrInputParams = null;
        aggrInputParams = reportReqData.getJSONObject("aggrInputParams");
        String domainName = aggrInputParams.getString("domainName");
        Long categoryType = aggrInputParams.getLong("categoryType");
        if (!aggrInputParams.has("timePeriod")) {
            aggrInputParams.put("timePeriod", 2);
        }
        if (!aggrInputParams.has("startTime")) {
            HashMap<String, Long> periodMap = this.getTimePeriod(2);
            aggrInputParams.put("startTime", (Object)periodMap.get("startTime"));
            aggrInputParams.put("endTime", (Object)periodMap.get("endTime"));
            aggrInputParams.put("chosenServerValue", (Object)"2");
        }
        if (!aggrInputParams.has("timeList")) {
            aggrInputParams.put("timeList", (Object)this.getTimeList(rb));
        }
        Long startTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("startTime"), true);
        Long endTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("endTime"), false);
        String timeString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDefaultTimeZoneDate((Long)(startTime * 1000L)), TimeUtil.formatDefaultTimeZoneDate((Long)(endTime * 1000L))});
        int timePeriod = aggrInputParams.getInt("timePeriod");
        aggrInputParams.put("timeString", (Object)timeString);
        aggrInputParams.put("startTime", (Object)startTime);
        aggrInputParams.put("endTime", (Object)endTime);
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, false, 0L, 0L);
            String jsonText = ComplianceReportHandler.getCategorySum(domainName, categoryType, paramsMap, false, request);
            JSONArray obj = new JSONArray(jsonText);
            ArrayList<Object> catList = new ArrayList<Object>();
            ArrayList<JSONObject> emptyList = new ArrayList<JSONObject>();
            ArrayList sectionList = new ArrayList();
            JSONArray categoryList = new JSONArray();
            for (int i = 0; i < obj.length(); ++i) {
                JSONObject obj2 = obj.getJSONObject(i);
                JSONObject catData = new JSONObject();
                JSONObject map = new JSONObject();
                map.put("displayName", obj2.get("displayName"));
                map.put("title", obj2.get("title"));
                map.put("value", obj2.get("value"));
                map.put("page", (Object)"page1");
                map.put("chartType", obj2.get("chart"));
                map.put("chartId", (Object)("catSum_" + domainName + "_" + obj2.get("category") + "_" + i));
                map.put("categoryId", obj2.get("category"));
                map.put("categoryName", obj2.get("categoryName"));
                map.put("sum", obj2.get("sum"));
                JSONObject map2 = new JSONObject();
                map2.put("chartType", obj2.get("chart"));
                map2.put("chartId", (Object)("catSum_" + domainName + "_" + obj2.get("category") + "_" + i));
                map2.put("categoryId", obj2.get("category"));
                map2.put("categoryName", obj2.get("categoryName"));
                map2.put("sum", obj2.get("sum"));
                if (obj2.getJSONArray("value").length() == 0) {
                    map2.put("isChartEmpty", true);
                }
                if (obj2.getInt("sum") == 0) {
                    map2.put("isChartEmpty", true);
                }
                catData.put("chartData", (Object)map);
                catData.put("categoryInputParams", (Object)map2);
                if (map2.has("isChartEmpty") && map2.get("isChartEmpty") != null && map2.getBoolean("isChartEmpty")) {
                    emptyList.add(catData);
                } else {
                    catList.add(catData);
                }
                JSONObject categories = new JSONObject();
                categories.put("categoryName", obj2.get("categoryName"));
                categories.put("categoryId", obj2.get("category"));
                categories.put("categoryType", (Object)categoryType);
                categoryList.put((Object)categories);
            }
            catList.addAll(emptyList);
            int N = catList.size();
            int L = 3;
            int q = 0;
            for (int k = 0; k < N; k += 3) {
                List subList = catList.subList(k, Math.min(N, k + 3));
                for (int m = 0; m < subList.size(); ++m) {
                    JSONObject map3 = (JSONObject)subList.get(m);
                    map3.put("divHeightClass", (Object)("aggr_page1_" + q));
                }
                sectionList.add(new ArrayList(subList));
                ++q;
            }
            JSONObject catType = new JSONObject();
            catType.put("name", (Object)rb.getString(this.categoryTypes[1]));
            catType.put("type", (Object)"6");
            JSONObject catType2 = new JSONObject();
            catType2.put("name", (Object)rb.getString(this.categoryTypes[0]));
            catType2.put("type", (Object)"5");
            JSONArray catTypeList = new JSONArray();
            catTypeList.put((Object)catType);
            catTypeList.put((Object)catType2);
            JSONObject breadCrumps = new JSONObject();
            breadCrumps.put("categoryTypes", (Object)catTypeList);
            breadCrumps.put("categories", (Object)categoryList);
            aggrInputParams.put("breadCrumps", (Object)breadCrumps);
            if (categoryType == 5L) {
                aggrInputParams.put("categoryTypeName", (Object)rb.getString(this.categoryTypes[1]));
            } else if (categoryType == 6L) {
                aggrInputParams.put("categoryTypeName", (Object)rb.getString(this.categoryTypes[0]));
            }
            aggrInputParams.put("activePage", (Object)"page1");
            JSONObject refreshParams = new JSONObject();
            boolean firstRefreshCrunch = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter((String)"firstRefreshCrunch"));
            boolean refreshCrunch = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter((String)"refreshCrunch"));
            String resetCrunch = ADSMPersUtil.getSyMParameter((String)"isCrunchReset");
            String crunchMsg = null;
            if (firstRefreshCrunch) {
                if (!refreshCrunch) {
                    crunchMsg = rb.getString("adap.common.text.firstCrunch");
                } else if (!resetCrunch.equalsIgnoreCase("false")) {
                    crunchMsg = rb.getString("adap.common.text.firstCrunchRunning");
                }
                refreshParams.put("type", (Object)"info");
            }
            refreshParams.put("message", crunchMsg);
            HashMap returnListMap = new HashMap();
            returnListMap.put("pageOneList", sectionList);
            returnListMap.put("aggrInputParams", aggrInputParams);
            returnListMap.put("refreshParams", refreshParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getCategoriesReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject aggrInputParams = null;
        aggrInputParams = reportReqData.getJSONObject("aggrInputParams");
        String domainName = aggrInputParams.getString("domainName");
        int timePeriod = aggrInputParams.getInt("timePeriod");
        Long categoryType = aggrInputParams.getLong("categoryType");
        Long categoryId = aggrInputParams.getLong("categoryId");
        boolean allReports = true;
        Long startTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("startTime"), true);
        Long endTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("endTime"), false);
        String timeString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDefaultTimeZoneDate((Long)(startTime * 1000L)), TimeUtil.formatDefaultTimeZoneDate((Long)(endTime * 1000L))});
        aggrInputParams.put("timeString", (Object)timeString);
        aggrInputParams.put("startTime", (Object)startTime);
        aggrInputParams.put("endTime", (Object)endTime);
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, 5L, 0L);
            String jsonText = ComplianceReportHandler.getCategoryReports(domainName, categoryId, categoryType, paramsMap, allReports, false, request);
            JSONArray obj = new JSONArray(jsonText);
            ArrayList<JSONObject> categories = new ArrayList<JSONObject>();
            ArrayList sectionList = new ArrayList();
            JSONArray catReportsList = new JSONArray();
            for (int i = 0; i < obj.length(); ++i) {
                JSONObject obj2 = obj.getJSONObject(i);
                Long reportSum = obj2.getLong("reportSum");
                if (reportSum > 0L) {
                    JSONObject category = new JSONObject();
                    Boolean isReference = obj2.getBoolean("isReference");
                    JSONArray referenceData = null;
                    String referenceAlias = null;
                    if (isReference.booleanValue()) {
                        referenceData = obj2.getJSONArray("referenceData");
                        referenceAlias = obj2.getString("referenceAlias");
                    }
                    JSONArray cvReferenceList = obj2.getJSONArray("cvReference");
                    JSONArray cvAddnReferenceList = obj2.getJSONArray("cvAddnReference");
                    JSONArray cvName = obj2.getJSONArray("cvName");
                    JSONArray alias = obj2.getJSONArray("alias");
                    JSONArray cvId = obj2.getJSONArray("cvId");
                    JSONArray rowArray = obj2.getJSONArray("data");
                    JSONObject chartData = new JSONObject();
                    chartData.put("data", obj2.get("data"));
                    chartData.put("isReference", obj2.get("isReference"));
                    if (isReference.booleanValue()) {
                        chartData.put("referenceAlias", obj2.get("referenceAlias"));
                        chartData.put("referenceData", obj2.get("referenceData"));
                    }
                    chartData.put("reportName", obj2.get("reportName"));
                    chartData.put("titles", obj2.get("titles"));
                    chartData.put("cvReference", cvReferenceList.get(0));
                    chartData.put("data", obj2.get("data"));
                    chartData.put("chartId", (Object)("catReports_" + domainName + "_" + obj2.get("reportId")));
                    chartData.put("page", (Object)"page2");
                    chartData.put("graphType", obj2.get("graphType"));
                    chartData.put("reportSum", obj2.get("reportSum"));
                    chartData.put("cvAddnReference", cvAddnReferenceList.get(0));
                    JSONObject reportData = new JSONObject();
                    reportData.put("colHeaderList", obj2.get("titles"));
                    int colLength = rowArray.getJSONArray(0).length();
                    int referenceDataCounter = 0;
                    JSONArray rowList = new JSONArray();
                    for (int j = 0; j < colLength; ++j) {
                        JSONArray row = new JSONArray();
                        for (int k = 0; k < rowArray.length(); ++k) {
                            JSONArray colArray = rowArray.getJSONArray(k);
                            Object refColValue = null;
                            if (k == 0) {
                                refColValue = colArray.get(j);
                            }
                            JSONObject column = new JSONObject();
                            column.put("columnValue", colArray.get(j));
                            column.put("columnAlias", alias.get(k));
                            column.put("visible", true);
                            column.put("isData", true);
                            column.put("refColumnValue", refColValue);
                            column.put("cvReference", cvReferenceList.get(0));
                            column.put("cvAddnReference", cvAddnReferenceList.get(0));
                            if (isReference.booleanValue()) {
                                column.put("referenceAlias", (Object)referenceAlias);
                                column.put("referenceData", referenceData.get(referenceDataCounter));
                            }
                            column.put("columnIndex", k);
                            if (isReference.booleanValue() && !colArray.getString(j).equals("0") && k != 0) {
                                column.put("isLink", true);
                            }
                            row.put((Object)column);
                        }
                        ++referenceDataCounter;
                        rowList.put((Object)row);
                    }
                    reportData.put("rowList", (Object)rowList);
                    JSONArray filterData = new JSONArray();
                    for (int l = 0; l < cvName.length(); ++l) {
                        JSONObject filter = new JSONObject();
                        if (l == 0) {
                            filter.put("isActive", true);
                            filter.put("selectedFilter", cvName.get(l));
                        }
                        filter.put("cvName", cvName.get(l));
                        filter.put("graphType", obj2.get("graphType"));
                        filter.put("reportName", obj2.get("reportName"));
                        filter.put("reportId", obj2.get("reportId"));
                        filter.put("cvAddnReference", cvAddnReferenceList.get(l));
                        filter.put("cvReference", cvReferenceList.get(l));
                        filter.put("cvReferenceList", (Object)cvReferenceList);
                        filter.put("cvAddnReferenceList", (Object)cvAddnReferenceList);
                        filter.put("cvId", cvId.get(l));
                        filter.put("cvIdList", (Object)cvId);
                        filter.put("cvNameList", (Object)cvName);
                        filterData.put((Object)filter);
                    }
                    if (filterData.length() == 1) {
                        category.put("isSingleFilter", true);
                    }
                    category.put("reportData", (Object)reportData);
                    category.put("chartData", (Object)chartData);
                    category.put("filterData", (Object)filterData);
                    categories.add(category);
                }
                JSONObject catReports = new JSONObject();
                catReports.put("categoryId", (Object)categoryId);
                catReports.put("categoryType", (Object)categoryType);
                catReports.put("reportName", obj2.get("reportName"));
                catReports.put("reportId", obj2.get("reportId"));
                catReportsList.put((Object)catReports);
            }
            int N = categories.size();
            int L = 2;
            int q = 0;
            for (int k = 0; k < N; k += 2) {
                List subList = categories.subList(k, Math.min(N, k + 2));
                for (int m = 0; m < subList.size(); ++m) {
                    JSONObject map3 = (JSONObject)subList.get(m);
                    map3.put("divHeightClass", (Object)("aggr_page2_" + q));
                }
                ++q;
                sectionList.add(subList);
            }
            JSONObject breadCrumps = (JSONObject)aggrInputParams.get("breadCrumps");
            breadCrumps.put("categoryReports", (Object)catReportsList);
            aggrInputParams.put("breadCrumps", (Object)breadCrumps);
            if (sectionList.size() == 0) {
                aggrInputParams.put("boldMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                aggrInputParams.put("type", (Object)"emptyTable");
                aggrInputParams.put("dataEmptyOnSearch", false);
            }
            aggrInputParams.put("activePage", (Object)"page2");
            HashMap returnListMap = new HashMap();
            returnListMap.put("pageTwoList", sectionList);
            returnListMap.put("aggrInputParams", aggrInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getCvIdColumnData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject aggrInputParams = null;
        aggrInputParams = reportReqData.getJSONObject("aggrInputParams");
        String domainName = aggrInputParams.getString("domainName");
        int timePeriod = aggrInputParams.getInt("timePeriod");
        Long categoryType = aggrInputParams.getLong("categoryType");
        JSONObject filterMapRequest = reportReqData.getJSONObject("filterMapInput");
        Long cvId = filterMapRequest.getLong("cvId");
        Long startTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("startTime"), true);
        Long endTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("endTime"), false);
        String jsonText = null;
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, 5L, 0L);
            Long sum = AuditReportAPI.getInstance().getReportCount(cvId, null, paramsMap, null);
            if (sum > 0L) {
                jsonText = ComplianceReportHandler.getComplianceReportRows(cvId, null, paramsMap, sum).toString();
            }
            JSONObject obj2 = new JSONObject(jsonText);
            JSONObject catData = new JSONObject();
            Long reportSum = obj2.getLong("reportSum");
            if (reportSum > 0L) {
                Boolean isReference = obj2.getBoolean("isReference");
                JSONArray alias = obj2.getJSONArray("alias");
                JSONArray referenceData = null;
                String referenceAlias = null;
                if (isReference.booleanValue()) {
                    referenceData = obj2.getJSONArray("referenceData");
                    referenceAlias = obj2.getString("referenceAlias");
                }
                JSONArray cvNameList = filterMapRequest.getJSONArray("cvNameList");
                JSONArray cvIdList = filterMapRequest.getJSONArray("cvIdList");
                JSONArray cvReferenceList = filterMapRequest.getJSONArray("cvReferenceList");
                JSONArray cvAddnReferenceList = filterMapRequest.getJSONArray("cvAddnReferenceList");
                Object reportName = filterMapRequest.get("reportName");
                Object reportId = filterMapRequest.get("reportId");
                Object graphType = filterMapRequest.get("graphType");
                String cvName = filterMapRequest.getString("cvName");
                JSONObject chartData = new JSONObject();
                chartData.put("data", obj2.get("data"));
                chartData.put("isReference", obj2.get("isReference"));
                chartData.put("reportName", reportName);
                chartData.put("titles", obj2.get("titles"));
                chartData.put("data", obj2.get("data"));
                chartData.put("reportId", reportId);
                chartData.put("chartId", (Object)("catReports_" + domainName + "_" + filterMapRequest.get("reportId")));
                chartData.put("page", (Object)"page2");
                chartData.put("graphType", graphType);
                chartData.put("reportSum", obj2.get("reportSum"));
                if (isReference.booleanValue()) {
                    chartData.put("referenceAlias", obj2.get("referenceAlias"));
                    chartData.put("referenceData", obj2.get("referenceData"));
                }
                chartData.put("cvAddnReference", filterMapRequest.get("cvAddnReference"));
                chartData.put("cvReference", filterMapRequest.get("cvReference"));
                JSONObject reportData = new JSONObject();
                reportData.put("colHeaderList", obj2.get("titles"));
                JSONArray rowArray = obj2.getJSONArray("data");
                int colLength = rowArray.getJSONArray(0).length();
                int referenceDataCounter = 0;
                JSONArray rowList = new JSONArray();
                for (int j = 0; j < colLength; ++j) {
                    JSONArray row = new JSONArray();
                    for (int k = 0; k < rowArray.length(); ++k) {
                        JSONArray colArray = rowArray.getJSONArray(k);
                        Object refColValue = null;
                        if (k == 0) {
                            refColValue = colArray.get(j);
                        }
                        JSONObject column = new JSONObject();
                        column.put("columnValue", colArray.get(j));
                        column.put("columnAlias", alias.get(k));
                        column.put("visible", true);
                        column.put("isData", true);
                        column.put("refColumnValue", refColValue);
                        column.put("cvReference", filterMapRequest.get("cvReference"));
                        column.put("cvAddnReference", filterMapRequest.get("cvAddnReference"));
                        if (isReference.booleanValue()) {
                            column.put("referenceAlias", (Object)referenceAlias);
                            column.put("referenceData", referenceData.get(referenceDataCounter));
                        }
                        column.put("columnIndex", k);
                        if (isReference.booleanValue() && !colArray.getString(j).equals("0") && k != 0) {
                            column.put("isLink", true);
                        }
                        row.put((Object)column);
                    }
                    ++referenceDataCounter;
                    rowList.put((Object)row);
                }
                reportData.put("rowList", (Object)rowList);
                JSONArray filterData = new JSONArray();
                for (int l = 0; l < cvNameList.length(); ++l) {
                    JSONObject filter = new JSONObject();
                    if (cvNameList.get(l).equals(cvName)) {
                        filter.put("isActive", true);
                        filter.put("selectedFilter", cvNameList.get(l));
                    }
                    filter.put("cvName", cvNameList.get(l));
                    filter.put("graphType", graphType);
                    filter.put("reportName", reportName);
                    filter.put("reportId", reportId);
                    filter.put("graphType", graphType);
                    filter.put("cvAddnReference", cvAddnReferenceList.get(l));
                    filter.put("cvReference", cvReferenceList.get(l));
                    filter.put("cvReferenceList", (Object)cvReferenceList);
                    filter.put("cvAddnReferenceList", (Object)cvAddnReferenceList);
                    filter.put("cvIdList", (Object)cvIdList);
                    filter.put("cvNameList", (Object)cvNameList);
                    filter.put("cvId", cvIdList.get(l));
                    filterData.put((Object)filter);
                }
                catData.put("reportData", (Object)reportData);
                catData.put("chartData", (Object)chartData);
                catData.put("filterData", (Object)filterData);
            }
            HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
            returnListMap.put("catData", catData);
            returnListMap.put("aggrInputParams", aggrInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getAggrReportData(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("reportInputParams");
            Long reportId = 1L;
            Long cvId = reportInputParams.getLong("cvId");
            boolean isCompliancePopup = true;
            JSONArray objectGuids = reportInputParams.optJSONArray("object_guid");
            ArrayList objectGuidList = null;
            objectGuidList = objectGuids != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList();
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("objectClass", reportInputParams.optString("objectClass"));
            inputParams.put("object_guid", objectGuidList);
            inputParams.put("domainName", reportInputParams.getString("domainName"));
            inputParams.put("objectName", reportInputParams.optString("objectName"));
            ServerConfigHandler.getInstance().getRangeList(reportInputParams);
            HashMap inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, reportInputParams.getString("domainName"), reportId);
            inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputParams, inputParamsMap, (Long)reportId);
            String searchCriteria = null;
            if (!reportInputParams.has("sortColumn")) {
                reportInputParams.put("sortColumn", (Object)"TIME_GENERATED");
                reportInputParams.put("sortOrder", (Object)"DESC");
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, false, reportInputParams.getString("sortColumn"), reportInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            searchCriteria = ReportHandler.getInstance().getSearchCriteria(reportInputParams, tableAllColumnList, true);
            if (searchCriteria != null) {
                isSearch = true;
            }
            String inputData = reportInputParams.optString("inputData");
            String countSqlString = null;
            String unionSqlString = null;
            int count = 0;
            if (inputData != null && !inputData.equals("")) {
                DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvId);
                Row row = cvDO.getRow("AUDSQLQuery");
                long queryId = (Long)row.get("QUERY_ID");
                countSqlString = ADAPSQLQueryUtil.getUnionQueryStackedBarChart((String)inputData, (String)"countString", (Long)queryId);
                unionSqlString = ADAPSQLQueryUtil.getUnionQueryStackedBarChart((String)inputData, (String)"sqlString", (Long)queryId);
            }
            if (isCompliancePopup) {
                Long startTime = this.getAggregateTime(reportInputParams.getString("chosenServerValue"), reportInputParams.getLong("startTime"), true);
                Long endTime = this.getAggregateTime(reportInputParams.getString("chosenServerValue"), reportInputParams.getLong("endTime"), false);
                inputParamsMap.put("FROM", startTime.toString());
                inputParamsMap.put("TO", endTime.toString());
                searchCriteria = reportInputParams.getString("searchCriteria");
                if (searchCriteria != null) {
                    searchCriteria = searchCriteria + " AND " + reportInputParams.getString("addnsearchCriteria");
                }
            }
            if (countSqlString != null) {
                count = AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, inputParamsMap, countSqlString);
            } else {
                searchCriteria = ReportHandlerUtil.getInstance().getSearchCriteria(reportInputParams, searchCriteria);
                count = AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, inputParamsMap);
            }
            reportInputParams.put("totalCount", count);
            reportInputParams.put("isSearch", (Object)isSearch);
            ArrayList reportsList = new ArrayList();
            if (count > 0) {
                reportsList = AuditReportAPI.getInstance().getReportRows(cvId, searchCriteria, inputParamsMap, reportInputParams.getString("sortColumn"), reportInputParams.getString("sortOrder"), Integer.parseInt(reportInputParams.getString("startValue")), Integer.parseInt(reportInputParams.getString("rangeValue")), unionSqlString, count, Boolean.valueOf(true));
            }
            reportInputParams.put("tabId", (Object)("tabId_" + cvId));
            reportInputParams.put("tabIdh", (Object)("#tabId_" + cvId));
            reportInputParams.put("tabName", (Object)("tabName_" + cvId));
            HashMap<String, ArrayList<HashMap<String, Object>>> returnListMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            returnListMap.put("reportData", reportsList);
            returnListMap.put("reportColumnList", tableAllColumnList);
            returnListMap.put("inputParams", (ArrayList<HashMap<String, Object>>)reportInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getIndividualReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long offset;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject aggrInputParams = null;
        aggrInputParams = reportReqData.getJSONObject("aggrInputParams");
        JSONObject pageThreeInputParams = reportReqData.getJSONObject("pageThreeInputParams");
        String domainName = aggrInputParams.getString("domainName");
        int timePeriod = aggrInputParams.getInt("timePeriod");
        Long categoryType = aggrInputParams.getLong("categoryType");
        Long reportId = aggrInputParams.getLong("reportId");
        String reportName = aggrInputParams.getString("reportName");
        String sortColumn = pageThreeInputParams.optString("sortColumn");
        String sortOrder = pageThreeInputParams.optString("sortOrder");
        String searchString = pageThreeInputParams.optString("searchString");
        String searchValue = pageThreeInputParams.optString("searchValue");
        if (searchString == null || searchString.equals("")) {
            searchString = null;
        }
        if ((offset = Long.valueOf(pageThreeInputParams.optLong("offset"))) == null) {
            offset = 0L;
        }
        Long limit = 25L;
        Boolean initialView = false;
        if ((sortColumn == null || sortColumn.equals("")) && (searchString == null || searchString.equals(""))) {
            initialView = true;
        }
        Long startTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("startTime"), true);
        Long endTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("endTime"), false);
        String timeString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDefaultTimeZoneDate((Long)(startTime * 1000L)), TimeUtil.formatDefaultTimeZoneDate((Long)(endTime * 1000L))});
        aggrInputParams.put("timeString", (Object)timeString);
        aggrInputParams.put("startTime", (Object)startTime);
        aggrInputParams.put("endTime", (Object)endTime);
        try {
            ArrayList<ArrayList<Object>> cvList = ComplianceReportHandler.getReportCvIdDetails(domainName, reportId, request);
            JSONObject cvData1 = new JSONObject();
            if (cvList.get(1).size() > 0) {
                cvData1.put("cvName", (Object)new JSONArray((Collection)cvList.get(0)));
                cvData1.put("cvId", (Object)new JSONArray((Collection)cvList.get(1)));
                cvData1.put("cvReference", (Object)new JSONArray((Collection)cvList.get(2)));
                cvData1.put("cvAddnReference", (Object)new JSONArray((Collection)cvList.get(3)));
                cvData1.put("reportId", (Object)reportId);
            }
            String cvString = cvData1.toString();
            JSONObject cvData = new JSONObject(cvString);
            Long cvId = cvData.getJSONArray("cvId").getLong(0);
            JSONArray jsonArray = new JSONArray();
            JSONObject reportData1 = null;
            String searchCriteria = null;
            HashMap<Object, Object> paramsMap = new HashMap();
            if (initialView.booleanValue()) {
                paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, limit, offset);
            } else {
                searchCriteria = searchString;
                String orderBy = null;
                if (sortColumn != null && !sortColumn.equals("") && sortOrder != null && !sortOrder.equals("")) {
                    orderBy = sortColumn + " " + sortOrder;
                }
                paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, limit, offset, orderBy);
            }
            Long sum = 0L;
            sum = initialView != false ? Long.valueOf(AuditReportAPI.getInstance().getReportCount(cvId, null, paramsMap, null)) : (sum == 0L ? Long.valueOf(AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, paramsMap, null)) : Long.valueOf(Long.parseLong(request.getParameter("others"))));
            if (sum > 0L) {
                reportData1 = ComplianceReportHandler.getComplianceReportRows(cvId, searchCriteria, paramsMap, sum);
            } else {
                JSONObject reportObj = new JSONObject();
                reportObj.put("reportSum", (Object)sum);
                jsonArray.put((Object)reportObj);
            }
            pageThreeInputParams.put("totalSum", (Object)sum);
            JSONObject obj2 = reportData1;
            JSONObject reportData = new JSONObject();
            if (obj2 != null) {
                Long reportSum = obj2.getLong("reportSum");
                if (reportSum > 0L) {
                    JSONObject map1 = new JSONObject();
                    Boolean isReference = obj2.getBoolean("isReference");
                    if (isReference.booleanValue()) {
                        map1.put("referenceAlias", obj2.get("referenceAlias"));
                        map1.put("referenceData", obj2.get("referenceData"));
                    }
                    JSONArray alias = obj2.getJSONArray("alias");
                    JSONArray titles = obj2.getJSONArray("titles");
                    JSONArray referenceData = null;
                    String referenceAlias = null;
                    if (isReference.booleanValue()) {
                        referenceData = obj2.getJSONArray("referenceData");
                        referenceAlias = obj2.getString("referenceAlias");
                    }
                    JSONArray cvNameList = cvData.getJSONArray("cvName");
                    JSONArray cvIdList = cvData.getJSONArray("cvId");
                    JSONArray cvReferenceList = cvData.getJSONArray("cvReference");
                    JSONArray cvAddnReferenceList = cvData.getJSONArray("cvAddnReference");
                    Integer graphType = 2;
                    map1.put("data", obj2.get("data"));
                    map1.put("isReference", obj2.get("isReference"));
                    map1.put("reportName", (Object)reportName);
                    map1.put("titles", obj2.get("titles"));
                    map1.put("data", obj2.get("data"));
                    map1.put("others", obj2.get("others"));
                    map1.put("reportId", (Object)reportId);
                    map1.put("chartId", (Object)("catReports_" + domainName + "_" + reportId));
                    map1.put("page", (Object)"page3");
                    map1.put("graphType", (Object)graphType);
                    map1.put("reportSum", obj2.get("reportSum"));
                    map1.put("cvAddnReference", cvAddnReferenceList.get(0));
                    map1.put("cvReference", cvReferenceList.get(0));
                    if (sortColumn.equals("")) {
                        sortColumn = alias.getString(1);
                        sortOrder = "DESC";
                    }
                    JSONObject map3 = new JSONObject();
                    JSONArray columnHeaderList = new JSONArray();
                    for (int b1 = 0; b1 < alias.length(); ++b1) {
                        String displayName = titles.getString(b1);
                        JSONObject colHeaderMap = new JSONObject();
                        if (b1 != 0 && sortColumn.equals(alias.getString(b1))) {
                            colHeaderMap.put("isSortedColumn", true);
                            if (sortOrder.equals("ASC")) {
                                colHeaderMap.put("isSortASC", true);
                            } else {
                                colHeaderMap.put("isSortASC", false);
                            }
                        }
                        colHeaderMap.put("sortOrder", (Object)sortOrder);
                        if (b1 != 0) {
                            colHeaderMap.put("sortenabled", true);
                        }
                        if (b1 == 0) {
                            colHeaderMap.put("searchenabled", true);
                            colHeaderMap.put("searchValue", (Object)searchValue);
                        }
                        colHeaderMap.put("displayName", (Object)displayName);
                        colHeaderMap.put("columnAlias", alias.get(b1));
                        if (b1 != 0) {
                            colHeaderMap.put("isSortEnabled", true);
                        } else {
                            colHeaderMap.put("isSortEnabled", false);
                        }
                        columnHeaderList.put((Object)colHeaderMap);
                    }
                    map3.put("colHeaderList", (Object)columnHeaderList);
                    JSONArray rowArray = obj2.getJSONArray("data");
                    int colLength = rowArray.getJSONArray(0).length();
                    int referenceDataCounter = 0;
                    JSONArray rowList = new JSONArray();
                    for (int j = 0; j < colLength; ++j) {
                        JSONArray row = new JSONArray();
                        for (int k = 0; k < rowArray.length(); ++k) {
                            JSONArray colArray = rowArray.getJSONArray(k);
                            Object refColValue = null;
                            if (k == 0) {
                                refColValue = colArray.get(j);
                            }
                            JSONObject colMap = new JSONObject();
                            colMap.put("columnValue", colArray.get(j));
                            colMap.put("columnAlias", alias.get(k));
                            colMap.put("visible", true);
                            colMap.put("isData", true);
                            colMap.put("refColumnValue", refColValue);
                            colMap.put("cvReference", cvReferenceList.get(0));
                            colMap.put("cvAddnReference", cvAddnReferenceList.get(0));
                            if (isReference.booleanValue()) {
                                colMap.put("referenceAlias", (Object)referenceAlias);
                                colMap.put("referenceData", referenceData.get(referenceDataCounter));
                            }
                            colMap.put("columnIndex", k);
                            if (isReference.booleanValue() && !colArray.getString(j).equals("0") && k != 0) {
                                colMap.put("isLink", true);
                            }
                            row.put((Object)colMap);
                        }
                        ++referenceDataCounter;
                        rowList.put((Object)row);
                    }
                    JSONArray filterList = new JSONArray();
                    for (int a2 = 0; a2 < cvNameList.length(); ++a2) {
                        JSONObject filterMap = new JSONObject();
                        if (a2 == 0) {
                            filterMap.put("isActive", true);
                            filterMap.put("selectedFilter", cvNameList.get(a2));
                        }
                        filterMap.put("cvName", cvNameList.get(a2));
                        filterMap.put("graphType", (Object)graphType);
                        filterMap.put("reportName", (Object)reportName);
                        filterMap.put("reportId", (Object)reportId);
                        filterMap.put("graphType", (Object)graphType);
                        filterMap.put("cvAddnReference", cvAddnReferenceList.get(a2));
                        filterMap.put("cvReference", cvReferenceList.get(a2));
                        filterMap.put("cvReferenceList", (Object)cvReferenceList);
                        filterMap.put("cvAddnReferenceList", (Object)cvAddnReferenceList);
                        filterMap.put("cvIdList", (Object)cvIdList);
                        filterMap.put("cvNameList", (Object)cvNameList);
                        filterMap.put("cvId", cvIdList.get(a2));
                        filterList.put((Object)filterMap);
                    }
                    map3.put("rowList", (Object)rowList);
                    reportData.put("reportData", (Object)map3);
                    reportData.put("chartData", (Object)map1);
                    reportData.put("filterData", (Object)filterList);
                }
            } else {
                aggrInputParams.put("boldMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                aggrInputParams.put("type", (Object)"emptyTable");
                aggrInputParams.put("dataEmptyOnSearch", false);
                aggrInputParams.put("message", (Object)"");
                if (searchString != null && !searchString.equals("")) {
                    aggrInputParams.put("message", (Object)rb.getString("adap.common.text.clear_search"));
                    aggrInputParams.put("dataEmptyOnSearch", true);
                    aggrInputParams.put("actionName", (Object)"emptyTableAction");
                }
            }
            aggrInputParams.put("activePage", (Object)"page3");
            HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
            returnListMap.put("reportData", reportData);
            returnListMap.put("aggrInputParams", aggrInputParams);
            returnListMap.put("pageThreeInputParams", pageThreeInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getCvIdIndividualReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject aggrInputParams = null;
        aggrInputParams = reportReqData.getJSONObject("aggrInputParams");
        JSONObject pageThreeInputParams = reportReqData.getJSONObject("pageThreeInputParams");
        String domainName = aggrInputParams.getString("domainName");
        int timePeriod = aggrInputParams.getInt("timePeriod");
        Long categoryType = aggrInputParams.getLong("categoryType");
        Long reportId = aggrInputParams.getLong("reportId");
        JSONObject filterMapRequest = reportReqData.getJSONObject("filterMapInput");
        Long cvId = filterMapRequest.getLong("cvId");
        Long offset = 0L;
        Long limit = 25L;
        Boolean isInitial = true;
        boolean initialView = isInitial;
        Long startTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("startTime"), true);
        Long endTime = this.getAggregateTime(aggrInputParams.getString("chosenServerValue"), aggrInputParams.getLong("endTime"), false);
        try {
            JSONArray jsonArray = new JSONArray();
            JSONObject reportData1 = null;
            String searchCriteria = null;
            HashMap<Object, Object> paramsMap = new HashMap();
            if (initialView) {
                paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, limit, offset);
            } else {
                searchCriteria = request.getParameter("searchCriteria");
                String orderBy = request.getParameter("orderBy");
                paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, limit, offset, orderBy);
            }
            Long sum = 0L;
            sum = initialView ? Long.valueOf(AuditReportAPI.getInstance().getReportCount(cvId, null, paramsMap, null)) : (sum == 0L ? Long.valueOf(AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, paramsMap, null)) : Long.valueOf(Long.parseLong(request.getParameter("others"))));
            if (sum > 0L) {
                reportData1 = ComplianceReportHandler.getComplianceReportRows(cvId, searchCriteria, paramsMap, sum);
            } else {
                JSONObject reportObj = new JSONObject();
                reportObj.put("reportSum", (Object)sum);
                jsonArray.put((Object)reportObj);
            }
            JSONObject obj2 = reportData1;
            JSONObject reportData = new JSONObject();
            Long reportSum = obj2.getLong("reportSum");
            if (reportSum > 0L) {
                JSONObject map1 = new JSONObject();
                Boolean isReference = obj2.getBoolean("isReference");
                if (isReference.booleanValue()) {
                    map1.put("referenceAlias", obj2.get("referenceAlias"));
                    map1.put("referenceData", obj2.get("referenceData"));
                }
                JSONArray alias = obj2.getJSONArray("alias");
                JSONArray titles = obj2.getJSONArray("titles");
                JSONArray referenceData = null;
                String referenceAlias = null;
                if (isReference.booleanValue()) {
                    referenceData = obj2.getJSONArray("referenceData");
                    referenceAlias = obj2.getString("referenceAlias");
                }
                JSONArray cvNameList = filterMapRequest.getJSONArray("cvNameList");
                JSONArray cvIdList = filterMapRequest.getJSONArray("cvIdList");
                JSONArray cvReferenceList = filterMapRequest.getJSONArray("cvReferenceList");
                JSONArray cvAddnReferenceList = filterMapRequest.getJSONArray("cvAddnReferenceList");
                String reportName = "testing";
                Integer graphType = 2;
                String cvName = filterMapRequest.getString("cvName");
                map1.put("data", obj2.get("data"));
                map1.put("isReference", obj2.get("isReference"));
                map1.put("reportName", (Object)reportName);
                map1.put("titles", obj2.get("titles"));
                map1.put("data", obj2.get("data"));
                map1.put("others", obj2.get("others"));
                map1.put("reportId", (Object)reportId);
                map1.put("chartId", (Object)("catReports_" + domainName + "_" + reportId));
                map1.put("page", (Object)"page3");
                map1.put("graphType", (Object)graphType);
                map1.put("reportSum", obj2.get("reportSum"));
                map1.put("cvAddnReference", filterMapRequest.get("cvAddnReference"));
                map1.put("cvReference", filterMapRequest.get("cvReference"));
                String sortColumn = alias.getString(1);
                String sortOrder = "DESC";
                JSONObject map3 = new JSONObject();
                JSONArray columnHeaderList = new JSONArray();
                for (int b1 = 0; b1 < alias.length(); ++b1) {
                    String displayName = titles.getString(b1);
                    JSONObject colHeaderMap = new JSONObject();
                    if (b1 != 0 && sortColumn.equals(alias.getString(b1))) {
                        colHeaderMap.put("isSortedColumn", true);
                        if (sortOrder.equals("ASC")) {
                            colHeaderMap.put("isSortASC", true);
                        } else {
                            colHeaderMap.put("isSortASC", false);
                        }
                    }
                    colHeaderMap.put("sortOrder", (Object)sortOrder);
                    if (b1 != 0) {
                        colHeaderMap.put("sortenabled", true);
                    }
                    if (b1 == 0) {
                        colHeaderMap.put("searchenabled", true);
                    }
                    colHeaderMap.put("displayName", (Object)displayName);
                    colHeaderMap.put("columnAlias", alias.get(b1));
                    if (b1 != 0) {
                        colHeaderMap.put("isSortEnabled", true);
                    } else {
                        colHeaderMap.put("isSortEnabled", false);
                    }
                    columnHeaderList.put((Object)colHeaderMap);
                }
                map3.put("colHeaderList", (Object)columnHeaderList);
                JSONArray rowArray = obj2.getJSONArray("data");
                int colLength = rowArray.getJSONArray(0).length();
                int referenceDataCounter = 0;
                JSONArray rowList = new JSONArray();
                for (int j = 0; j < colLength; ++j) {
                    JSONArray row = new JSONArray();
                    for (int k = 0; k < rowArray.length(); ++k) {
                        JSONArray colArray = rowArray.getJSONArray(k);
                        Object refColValue = null;
                        if (k == 0) {
                            refColValue = colArray.get(j);
                        }
                        JSONObject colMap = new JSONObject();
                        colMap.put("columnValue", colArray.get(j));
                        colMap.put("columnAlias", alias.get(k));
                        colMap.put("visible", true);
                        colMap.put("isData", true);
                        colMap.put("refColumnValue", refColValue);
                        colMap.put("cvReference", filterMapRequest.get("cvReference"));
                        colMap.put("cvAddnReference", filterMapRequest.get("cvAddnReference"));
                        if (isReference.booleanValue()) {
                            colMap.put("referenceAlias", (Object)referenceAlias);
                            colMap.put("referenceData", referenceData.get(referenceDataCounter));
                        }
                        colMap.put("columnIndex", k);
                        if (isReference.booleanValue() && !colArray.getString(j).equals("0") && k != 0) {
                            colMap.put("isLink", true);
                        }
                        row.put((Object)colMap);
                    }
                    ++referenceDataCounter;
                    rowList.put((Object)row);
                }
                JSONArray filterList = new JSONArray();
                for (int a2 = 0; a2 < cvNameList.length(); ++a2) {
                    JSONObject filterMap = new JSONObject();
                    if (cvNameList.get(a2).equals(cvName)) {
                        filterMap.put("isActive", true);
                        filterMap.put("selectedFilter", cvNameList.get(a2));
                    }
                    filterMap.put("cvName", cvNameList.get(a2));
                    filterMap.put("graphType", (Object)graphType);
                    filterMap.put("reportName", (Object)reportName);
                    filterMap.put("reportId", (Object)reportId);
                    filterMap.put("graphType", (Object)graphType);
                    filterMap.put("cvAddnReference", cvAddnReferenceList.get(a2));
                    filterMap.put("cvReference", cvReferenceList.get(a2));
                    filterMap.put("cvReferenceList", (Object)cvReferenceList);
                    filterMap.put("cvAddnReferenceList", (Object)cvAddnReferenceList);
                    filterMap.put("cvIdList", (Object)cvIdList);
                    filterMap.put("cvNameList", (Object)cvNameList);
                    filterMap.put("cvId", cvIdList.get(a2));
                    filterList.put((Object)filterMap);
                }
                map3.put("rowList", (Object)rowList);
                reportData.put("reportData", (Object)map3);
                reportData.put("chartData", (Object)map1);
                reportData.put("filterData", (Object)filterList);
            }
            HashMap<String, JSONObject> returnListMap = new HashMap<String, JSONObject>();
            returnListMap.put("reportData", reportData);
            returnListMap.put("aggrInputParams", aggrInputParams);
            returnListMap.put("pageThreeInputParams", pageThreeInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exportSummaryReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
            Long startTime = this.getAggregateTime(request.getParameter("chosenServerValue"), Long.parseLong(request.getParameter("startTime")), true);
            Long endTime = this.getAggregateTime(request.getParameter("chosenServerValue"), Long.parseLong(request.getParameter("endTime")), false);
            Long categoryType = Long.parseLong(request.getParameter("categoryType"));
            Long offset = 0L;
            Long limit = -1L;
            String orderBy = request.getParameter("orderBy");
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, true, limit, offset, orderBy);
            paramsMap.put("FROM", startTime.toString());
            paramsMap.put("TO", endTime.toString());
            paramsMap.put("objectName", null);
            Long cvID = Long.parseLong(request.getParameter("cvId"));
            String searchCriteria = null;
            HashMap<String, String> reportMap = new HashMap<String, String>();
            reportMap.put("TITLE", request.getParameter("reportName"));
            reportMap.put("DESCRIPTION", request.getParameter("description"));
            reportMap.put("JASPER_NAME", "UserDetails.xml");
            ExportUtil.exportReport((Long)cvID, reportMap, (String)domainName, searchCriteria, (String)request.getParameter("reportType"), paramsMap, null, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exportFullSummaryReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            int timePeriod = Integer.parseInt(request.getParameter("timePeriod"));
            boolean isSearch = Boolean.parseBoolean(request.getParameter("isSearch"));
            Long startTime = this.getAggregateTime(request.getParameter("chosenServerValue"), Long.parseLong(request.getParameter("startTime")), true);
            Long endTime = this.getAggregateTime(request.getParameter("chosenServerValue"), Long.parseLong(request.getParameter("endTime")), false);
            Long categoryType = Long.parseLong(request.getParameter("categoryType"));
            request.setAttribute("timePeriod", (Object)request.getParameter("timePeriod"));
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, categoryType, false, 0L, 0L);
            ArrayList<HashMap<String, Object>> exportList = ComplianceReportHandler.getFullExportData(domainName, categoryType, paramsMap, isSearch, request);
            if (exportList.size() > 0) {
                paramsMap.put("FROM", startTime.toString());
                paramsMap.put("TO", endTime.toString());
                paramsMap.put("objectName", null);
                paramsMap.put("isComplianceSummaryReport", exportList);
                if (isSearch) {
                    paramsMap.put("searchObj", request.getParameter("username"));
                }
                Long cvID = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:54000");
                String searchCriteria = null;
                HashMap<String, String> reportMap = new HashMap<String, String>();
                reportMap.put("JASPER_NAME", "UserDetails.xml");
                ExportUtil.exportReport((Long)cvID, reportMap, (String)domainName, searchCriteria, (String)request.getParameter("reportType"), paramsMap, null, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getUserSearch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = null;
        String searchString = request.getParameter("query");
        searchString = searchString + "%";
        domainName = request.getParameter("domainName");
        try {
            JSONArray resultList = ComplianceReportHandler.getUsersListEmber(domainName, searchString, request);
            JSONObject retObj = new JSONObject();
            retObj.put("searchResults", (Object)resultList);
            retObj.put("searchString", (Object)request.getParameter("query"));
            JsonResponse.getInstance().sendResponse(response, retObj.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getSearchResults(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject searchInputParams = null;
        searchInputParams = reportReqData.getJSONObject("inputParams");
        String domainName = searchInputParams.getString("domainName");
        if (!searchInputParams.has("timePeriod")) {
            searchInputParams.put("timePeriod", 0);
        }
        if (!searchInputParams.has("startTime")) {
            HashMap<String, Long> periodMap = this.getTimePeriod(0);
            searchInputParams.put("startTime", (Object)periodMap.get("startTime"));
            searchInputParams.put("endTime", (Object)periodMap.get("endTime"));
            searchInputParams.put("chosenServerValue", (Object)"0");
        }
        if (!searchInputParams.has("timeList")) {
            searchInputParams.put("timeList", (Object)this.getTimeList(rb));
        }
        int timePeriod = searchInputParams.getInt("timePeriod");
        Long startTime = this.getAggregateTime(searchInputParams.getString("chosenServerValue"), searchInputParams.getLong("startTime"), true);
        Long endTime = this.getAggregateTime(searchInputParams.getString("chosenServerValue"), searchInputParams.getLong("endTime"), false);
        String timeString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDefaultTimeZoneDate((Long)(startTime * 1000L)), TimeUtil.formatDefaultTimeZoneDate((Long)(endTime * 1000L))});
        searchInputParams.put("timeString", (Object)timeString);
        JSONObject userDetails = reportReqData.getJSONObject("userDetails");
        request.setAttribute("usersid", (Object)userDetails.getString("usersid"));
        request.setAttribute("samaccountname", (Object)userDetails.getString("samaccountname"));
        request.setAttribute("timePeriod", (Object)searchInputParams.getString("timePeriod"));
        try {
            HashMap<String, Object> paramsMap = ComplianceReportHandler.getParamsMap(domainName, startTime, endTime, timePeriod, 5L, false, 0L, 0L);
            String jsonText = ComplianceReportHandler.getCategorySum(domainName, 0L, paramsMap, startTime, endTime, true, request);
            JSONArray obj = new JSONArray(jsonText);
            JSONArray groupArray = new JSONArray();
            for (int i = 0; i < obj.length(); ++i) {
                JSONObject obj2 = obj.getJSONObject(i);
                JSONObject group = new JSONObject();
                if (obj2.getInt("count") == 0) {
                    group.put("name", (Object)(rb.getString("adap.UserSearch.Object_History") + " " + userDetails.getString("username")));
                    group.put("collapseId", (Object)"collapse_0");
                    group.put("collapseIdh", (Object)"#collapse_0");
                    group.put("headingId", (Object)"heading_0");
                    group.put("groupId", 0);
                } else if (obj2.getInt("count") == 1) {
                    group.put("name", (Object)(rb.getString("adap.UserSearch.Logon_Activity") + " " + userDetails.getString("username")));
                    group.put("collapseId", (Object)"collapse_1");
                    group.put("collapseIdh", (Object)"#collapse_1");
                    group.put("headingId", (Object)"heading_1");
                    group.put("groupId", 1);
                } else if (obj2.getInt("count") == 2) {
                    group.put("name", (Object)(rb.getString("adap.UserSearch.User_Actions") + " " + userDetails.getString("username")));
                    group.put("collapseId", (Object)"collapse_2");
                    group.put("collapseIdh", (Object)"#collapse_2");
                    group.put("headingId", (Object)"heading_2");
                    group.put("groupId", 2);
                }
                JSONArray catList = obj2.getJSONArray("groups");
                JSONArray sectionArray = new JSONArray();
                JSONArray categoryArray = new JSONArray();
                int s = 0;
                for (int j = 0; j < catList.length(); ++j) {
                    JSONObject obj3 = catList.getJSONObject(j);
                    JSONObject category = new JSONObject();
                    category.put("name", (Object)obj3.getString("categoryName"));
                    category.put("categorySum", (Object)obj3.getString("categorySum"));
                    category.put("categoryId", (Object)obj3.getString("categoryId"));
                    category.put("categoryType", (Object)obj3.getString("categoryType"));
                    JSONArray reportList = obj3.getJSONArray("reports");
                    JSONArray reportArray = new JSONArray();
                    for (int k = 0; k < reportList.length(); ++k) {
                        JSONObject obj4 = reportList.getJSONObject(k);
                        JSONObject report = new JSONObject();
                        report.put("name", (Object)obj4.getString("reportName"));
                        report.put("cvId", (Object)obj4.getString("cvId"));
                        JSONObject cvAddnReferenceArray = null;
                        if (obj4.getBoolean("isReference")) {
                            report.put("referenceAlias", (Object)obj4.getString("referenceAlias"));
                            report.put("cvReference", (Object)obj4.getString("cvReference"));
                            report.put("isReference", (Object)obj4.getString("isReference"));
                            if (obj4.has("cvAddnReference")) {
                                cvAddnReferenceArray = this.getReferenceArray(obj4.getString("cvAddnReference"));
                                report.put("cvAddnReference", (Object)cvAddnReferenceArray.optString(String.valueOf(1)));
                            }
                        }
                        report.put("reportSum", obj4.getJSONArray("sumList").get(0));
                        JSONArray subReportList = obj4.getJSONArray("titles");
                        JSONArray sumList = obj4.getJSONArray("sumList");
                        JSONArray subReportArray = new JSONArray();
                        if (subReportList.length() > 1) {
                            for (int l = 1; l < subReportList.length(); ++l) {
                                String obj5 = subReportList.getString(l);
                                JSONObject subReport = new JSONObject();
                                subReport.put("name", (Object)obj5);
                                subReport.put("subReportSum", sumList.getLong(l));
                                if (obj4.getBoolean("isReference") && cvAddnReferenceArray != null) {
                                    subReport.put("cvAddnReference", (Object)cvAddnReferenceArray.getString(String.valueOf(l + 1)));
                                }
                                if (subReport.getLong("subReportSum") <= 0L) continue;
                                subReportArray.put((Object)subReport);
                            }
                        }
                        report.put("subReportList", (Object)subReportArray);
                        reportArray.put((Object)report);
                    }
                    category.put("reportList", (Object)reportArray);
                    categoryArray.put((Object)category);
                    if (s == 2) {
                        sectionArray.put((Object)categoryArray);
                        categoryArray = new JSONArray();
                        s = 0;
                        continue;
                    }
                    ++s;
                }
                if (categoryArray.length() < 3) {
                    sectionArray.put((Object)categoryArray);
                }
                group.put("categoryList", (Object)sectionArray);
                groupArray.put((Object)group);
            }
            if (groupArray.length() == 0) {
                searchInputParams.put("boldMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                searchInputParams.put("type", (Object)"emptyTable");
            }
            JSONObject refrehsParams = new JSONObject();
            boolean firstRefreshCrunch = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter((String)"firstRefreshCrunch"));
            boolean refreshCrunch = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter((String)"refreshCrunch"));
            String resetCrunch = ADSMPersUtil.getSyMParameter((String)"isCrunchReset");
            String crunchMsg = null;
            if (firstRefreshCrunch) {
                if (!refreshCrunch) {
                    crunchMsg = rb.getString("adap.common.text.firstCrunch");
                } else if (!resetCrunch.equalsIgnoreCase("false")) {
                    crunchMsg = rb.getString("adap.common.text.firstCrunchRunning");
                }
                refrehsParams.put("type", (Object)"info");
            }
            refrehsParams.put("message", crunchMsg);
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            returnListMap.put("searchData", groupArray);
            returnListMap.put("userDetails", userDetails);
            returnListMap.put("searchInputParams", searchInputParams);
            returnListMap.put("refreshParams", refrehsParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JSONObject getReferenceArray(String cvAddnReference) throws Exception {
        String[] a = cvAddnReference.split(";");
        JSONObject c = new JSONObject();
        for (int i = 0; i < a.length; ++i) {
            c.put(a[i].substring(0, 1), (Object)a[i].substring(2, a[i].length()));
        }
        return c;
    }

    public void refreshCrunch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap_aggregatereports.finished_the_crunching_process");
        String msgType = "info";
        try {
            boolean firstRefreshCrunch = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter((String)"firstRefreshCrunch"));
            String refreshCrunch = ADSMPersUtil.getSyMParameter((String)"refreshCrunch");
            if (refreshCrunch.equals("false")) {
                ADSMPersUtil.updateSyMParameter((String)"refreshCrunch", (String)"true");
                if (!firstRefreshCrunch) {
                    DataCruncher.refreshCruncher();
                } else {
                    DataCruncher.oneTimeCrunch((boolean)true);
                }
                ADSMPersUtil.updateSyMParameter((String)"refreshCrunch", (String)"false");
            } else {
                msgTxt = rb.getString("adap_AggregateReports.refreshing_data_is_already_in_progress_please_wait_for_a_while");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgTxt = ex.getMessage();
            msgType = "failure";
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }
}

