/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.report;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.CustomReportConfigUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportConfigHandler {
    private static volatile CustomReportConfigHandler instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomReportConfigHandler getInstance() {
        if (instance != null) return instance;
        Class<CustomReportConfigHandler> clazz = CustomReportConfigHandler.class;
        synchronized (CustomReportConfigHandler.class) {
            if (instance != null) return instance;
            instance = new CustomReportConfigHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CustomReportConfigHandler() {
    }

    public void getCustomReportList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getCustomReportList(request, response, null, null);
    }

    private void getCustomReportList(HttpServletRequest request, HttpServletResponse response, String message, Boolean msgType) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            String domainName = reportInputParams.getString("domainName");
            JSONArray a = new JSONArray();
            JSONArray b = new JSONArray();
            reportInputParams.put("selectedObjectIdList", (Object)a);
            reportInputParams.put("selectedObjectNameList", (Object)b);
            reportInputParams.put("selObjNameIndex", (Object)"2");
            String uvhString = "AUDCVConfig:cv_id:15030";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDTableViewConfig", crit);
            HashMap<String, String> tableDetails = new HashMap<String, String>();
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("AUDTableViewConfig");
                List al = r.getColumns();
                for (int i = 0; i < al.size(); ++i) {
                    String key = String.valueOf(al.get(i));
                    String value = String.valueOf(r.get((String)al.get(i)));
                    tableDetails.put(key, value);
                }
            }
            Long tableId = Long.parseLong((String)tableDetails.get("TABLE_VIEW_ID"));
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, null, null, rb);
            ArrayList reportsList = CustomReportUtil.getReportsList((AdventNetResourceBundle)rb, (String)domainName, (Long)((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID")), (Boolean)true);
            int count = reportsList.size();
            if (count == 0) {
                reportInputParams.put("emptyTableMessage", (Object)rb.getString("adap_customreports_no_custom_reports_are_configured"));
                reportInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                reportInputParams.put("emptyTableMessage2", (Object)rb.getString("adap_ServerConfig.click_here_to_configure"));
            }
            if (message != null) {
                reportInputParams.put("showErrorMsg", true);
                reportInputParams.put("msgTxt", (Object)message);
                reportInputParams.put("msgType", (Object)msgType);
            }
            reportInputParams.put("readOnly", request.getAttribute("readOnly"));
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            JSONObject resultObj = EmberTableConfig.getInstance().getEmberTableData1(tableId, reportsList, tableAllColumnList, reportInputParams, rb);
            JSONObject tableData = resultObj.getJSONObject("tableData");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.ViewCustomReports.audit_entry.Custom_Report_Viewed", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_report_viewed", "-"}));
            returnListMap.put("reportData", tableData.get("tableDataList"));
            returnListMap.put("reportColumnList", tableAllColumnList);
            returnListMap.put("inputParams", reportInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void settingReportTypeView(JSONObject reportData) throws Exception {
        String[] a = new String[]{"tabular", "summary", "pivotal", "graphical"};
        JSONObject reportType = reportData.getJSONObject("reportType");
        reportData.put("isColumnSelection", true);
        for (int i = 0; i < a.length; ++i) {
            if (reportType.getString("class").equals(a[i])) {
                reportData.put(a[i], true);
                continue;
            }
            reportData.put(a[i], false);
        }
        if (reportType.getString("class").equals(a[0])) {
            reportData.put(a[3], true);
        }
        if (reportType.getString("class").equals(a[3])) {
            reportData.put("isColumnSelection", false);
        }
    }

    public void saveCustomReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap.CustomReportBean.Successfully_saved_the_custom_report");
        Boolean msgType = true;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportData = reportReqData.getJSONObject("CRReportData");
        JSONObject customReportConfigInputParams = null;
        customReportConfigInputParams = reportReqData.getJSONObject("inputParams");
        String action = customReportConfigInputParams.getString("action");
        try {
            HttpSession session = request.getSession();
            JSONObject customReportConfigData = reportReqData.getJSONObject("CRConfigData");
            CustomReportConfigUtil obj = new CustomReportConfigUtil();
            if (action.equals("new")) {
                LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap = CustomReportConfigUtil.formCriteriaMap(request, reportData);
                obj.getProperties(action, request, reportData, customReportConfigData, criteriaMap, rb);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateCustomReport.audit_entry.Successfully_created_Custom_Reports", new String[]{reportData.getString("reportName"), reportData.getString("domainName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_report_created", "-"}));
            } else {
                LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap = CustomReportConfigUtil.formCriteriaMap(request, reportData);
                ArrayList selectedSM = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportReqData.getJSONObject("CRReportData").getJSONArray("selectedSubModules"));
                DataObject oldDO = CustomReportHandler.getDataObject((Long)reportData.getLong("customReportId"));
                DataObject dObj = obj.getProperties(action, reportData, customReportConfigData, criteriaMap, (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), request);
                dObj = obj.setSchedulerDetails(dObj, oldDO, reportData, request, action);
                CustomReportHandler.updateThisReport((Long)reportData.getLong("customReportId"), (DataObject)oldDO, (Long)reportData.getLong("selectedModuleId"), (ArrayList)selectedSM, (Integer)reportData.getInt("selectedChartType"), (Long)reportData.getLong("reportId"), (DataObject)dObj, criteriaMap, (String)reportData.getString("domainName"), (Long)reportData.getJSONObject("reportType").getLong("reportTypeId"), (String)reportData.getString("reportName"), (String)reportData.getString("description"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ModifyCustomReport.audit_entry.successfully_modified_custom_report", new String[]{reportData.getString("reportName"), reportData.getString("domainName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_report_modified", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgTxt = "Error while creating/modifying custom report";
            msgType = false;
            if (action.equals("new")) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateCustomReport.audit_entry.Problem_while_creating_custom_report", new String[]{reportData.getString("reportName"), reportData.getString("domainName"), ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_report_created", "-"}));
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.ModifyCustomReport.audit_entry.Failed_to_modify_custom_Report", new String[]{reportData.getString("reportName"), reportData.getString("domainName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_report_modified", "-"}));
        }
        HashMap<String, Object> returnListMap = new HashMap<String, Object>();
        returnListMap.put("msgTxt", msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
    }

    public void getCustomReportPageOneInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject customReportConfigInputParams = null;
            customReportConfigInputParams = reportReqData.getJSONObject("inputParams");
            String action = customReportConfigInputParams.getString("action");
            HashMap<String, ArrayList> customReportConfigData = new HashMap<String, ArrayList>();
            JSONObject reportData = new JSONObject();
            ArrayList reportTypeList = CustomReportUtil.getViewTypeMapEmber((AdventNetResourceBundle)rb);
            ArrayList moduleList = CustomReportUtil.getModulesEmber((AdventNetResourceBundle)rb);
            ArrayList subModuleList = CustomReportUtil.getSubModuleMapEmber((AdventNetResourceBundle)rb);
            if (action.equals("update")) {
                Long customReportId = customReportConfigInputParams.getLong("customReportId");
                CustomReportConfigUtil.getPageOneData(customReportId, reportData, request, response);
                for (int i = 0; i < reportTypeList.size(); ++i) {
                    HashMap map1 = (HashMap)reportTypeList.get(i);
                    if (((Long)map1.get("reportTypeId")).longValue() != reportData.getLong("reportTypeId")) continue;
                    reportData.put("reportType", (Object)JSONUtil.mapToJSONObject((Map)map1));
                    break;
                }
            } else {
                JSONObject jsonObj = JSONUtil.mapToJSONObject((Map)((Map)reportTypeList.get(0)));
                reportData.put("reportType", (Object)jsonObj);
                reportData.put("reportTypeId", jsonObj.getLong("reportTypeId"));
            }
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            customReportConfigData.put("reportTypeList", reportTypeList);
            customReportConfigData.put("moduleList", moduleList);
            customReportConfigData.put("subModuleList", subModuleList);
            returnListMap.put("customReportData", reportData);
            returnListMap.put("customReportConfigData", customReportConfigData);
            returnListMap.put("customReportConfigInputParams", customReportConfigInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JSONArray getSubModulesName(ArrayList<Object> selectedSM, AdventNetResourceBundle rb) throws Exception {
        JSONArray subModule = new JSONArray();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportSubModule"));
        Criteria crit = null;
        crit = new Criteria(Column.getColumn((String)"AUDCustomReportSubModule", (String)"SUB_MODULE_ID"), (Object)selectedSM.toArray(), 8);
        query.setCriteria(crit);
        query.addSelectColumn(Column.getColumn((String)"AUDCustomReportSubModule", (String)"*"));
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        Iterator iter = dObj.getRows("AUDCustomReportSubModule");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            subModule.put((Object)rb.getString((String)row.get("SUB_MODULE_DISPLAY_NAME")));
        }
        return subModule;
    }

    public void getCustomReportPageTwoInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject customReportConfigInputParams = null;
            customReportConfigInputParams = reportReqData.getJSONObject("inputParams");
            String action = customReportConfigInputParams.getString("action");
            HashMap customReportConfigData = JSONUtil.JSONObjectToMap((JSONObject)reportReqData.getJSONObject("CRConfigData"));
            JSONObject reportData = reportReqData.getJSONObject("CRReportData");
            ArrayList selectedSM = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportReqData.getJSONObject("CRReportData").getJSONArray("selectedSubModules"));
            JSONArray selectedSubModules = this.getSubModulesName(selectedSM, rb);
            reportData.put("selectedSubModuleNames", (Object)selectedSubModules);
            this.settingReportTypeView(reportData);
            ArrayList<Object> columnList = CustomReportConfigUtil.getColumnList(reportData.getLong("selectedModuleId"), selectedSM, rb);
            this.getDefaultValue(reportData);
            HashMap<String, Object> columnMap = null;
            JSONObject schedulerData = CustomReportConfigUtil.getScheduleConfigData(rb);
            JSONObject chartData = CustomReportConfigUtil.getChartDetails(rb);
            HashMap relationalOperatorsList = ActionConstants.getRelationalOperaionsEmber();
            ArrayList logicalOperationsList = ActionConstants.getLogicalOperaions();
            JSONObject relationaloperators = JSONUtil.mapToJSONObject((Map)relationalOperatorsList);
            JSONArray logicalOperators = JSONUtil.listToJSONArray((List)logicalOperationsList);
            HashMap timeMap = CustomReportUtil.getTimePeriodsEmber((AdventNetResourceBundle)rb);
            ArrayList timeList = (ArrayList)timeMap.get("timeList");
            HashMap<Long, Object> elementsMap = CustomReportConfigUtil.getCriteriaDetails(rb);
            ArrayList reportCategoryList = CustomReportUtil.getReportCategoriesEmber((AdventNetResourceBundle)rb, (Long)((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID")), (JSONObject)reportData);
            JSONArray columnsArray = new JSONArray();
            JSONObject colOpeMap = new JSONObject();
            JSONObject colElementMap = new JSONObject();
            HashMap<String, HashMap> colIdMap = new HashMap<String, HashMap>();
            for (int i = 0; i < columnList.size(); ++i) {
                HashMap map1 = (HashMap)columnList.get(i);
                JSONObject columnObject = new JSONObject();
                columnObject.put("value", map1.get("COLUMN_ID"));
                columnObject.put("name", map1.get("COLUMN_DISPLAY_NAME"));
                columnsArray.put((Object)columnObject);
                colOpeMap.put(String.valueOf(map1.get("COLUMN_ID")), map1.get("COLUMN_DATA_TYPE"));
                colElementMap.put(String.valueOf(map1.get("COLUMN_ID")), map1.get("ELEMENT_ID"));
                colIdMap.put(String.valueOf(map1.get("COLUMN_ID")), map1);
            }
            if (action.equals("update")) {
                Long customReportId = customReportConfigInputParams.getLong("customReportId");
                columnMap = CustomReportConfigUtil.getPageTwoData(customReportId, reportData, columnMap, colOpeMap, colElementMap, elementsMap, relationaloperators, request, response, rb);
                if (reportData.getLong("selectedModuleId") != reportData.getLong("persistentModuleId")) {
                    columnMap = CustomReportConfigUtil.getColumnList(columnList, reportData.getLong("reportTypeId"), rb);
                }
                if (reportData.getLong("reportTypeId") != reportData.getLong("persistentReportTypeId") && reportData.getLong("reportTypeId") == 1L) {
                    columnMap = CustomReportConfigUtil.getColumnList(columnList, reportData.getLong("reportTypeId"), rb);
                }
            } else {
                columnMap = CustomReportConfigUtil.getColumnList(columnList, reportData.getLong("reportTypeId"), rb);
            }
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            customReportConfigData.put("schedulerData", schedulerData);
            customReportConfigData.put("chartData", chartData);
            customReportConfigData.put("relationalOperators", relationaloperators);
            customReportConfigData.put("logicalOperators", logicalOperators);
            customReportConfigData.put("columnsArray", columnsArray);
            customReportConfigData.put("columnList", columnList);
            customReportConfigData.put("timeList", timeList);
            customReportConfigData.put("columnOperatorMap", colOpeMap);
            customReportConfigData.put("columnElementMap", colElementMap);
            customReportConfigData.put("columnIdMap", colIdMap);
            customReportConfigData.put("columnMap", columnMap);
            customReportConfigData.put("elementsMap", elementsMap);
            customReportConfigData.put("reportCategoryList", reportCategoryList);
            returnListMap.put("customReportData", reportData);
            returnListMap.put("customReportConfigData", customReportConfigData);
            returnListMap.put("customReportConfigInputParams", customReportConfigInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getDefaultValue(JSONObject reportData) throws Exception {
        String fileStoragePath = ReportSchedulerUtil.getFileStoragePath();
        reportData.put("isScheduleSelected", false);
        reportData.put("fileStoragePath", (Object)fileStoragePath);
        reportData.put("hoursValue", 5);
        reportData.put("minsValue", 0);
        reportData.put("forValue", (Object)"Yesterday");
        reportData.put("onValue", (Object)"");
        reportData.put("selectedFreq", (Object)"daily");
        reportData.put("formatValue", (Object)"pdf");
        reportData.put("isMailNotify", false);
        reportData.put("mailAddress", (Object)"");
        reportData.put("mailContent", (Object)"Content");
        reportData.put("mailSubject", (Object)"ADAudit Plus - Schedule Reports");
        reportData.put("sendingOptions", (Object)"ATTACHMENT");
        reportData.put("isZipFile", true);
        reportData.put("BUSINESS_HOUR", (Object)"false");
        reportData.put("isReportsEmpty", true);
        reportData.put("selectedChartType", (Object)"-1");
        reportData.put("chartAxisColumnValue", (Object)"-1");
        reportData.put("chartStackColumnValue", (Object)"-1");
        reportData.put("chartDateFormatValue", (Object)"${PATTERNREPLACE:XCOLUMN_DAY_BASED}");
        reportData.put("chartDisplayFormatValue", (Object)"1");
        reportData.put("chartOrientationValue", (Object)"Vertical");
        reportData.put("chartLimitValue", (Object)"5");
        reportData.put("filterList", (Object)new JSONArray());
        reportData.put("selectedDateLabel", (Object)"twfourhours");
        reportData.put("reportPrivacy", (Object)"public");
    }

    public void deleteCustomReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject customReportParams = null;
            customReportParams = reportReqData.getJSONObject("inputParams");
            Long customReportId = customReportParams.getLong("customReportId");
            ReportUtil.getReportIdfromCustomId((Long)customReportId);
            CustomReportHandler.deleteReports((Long)customReportId);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteCustomReport.audit_entry.Successfully_deleted_custom_report", new String[]{customReportParams.getString("reportName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_deleted", "-"}));
            this.getCustomReportList(request, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_deleted"}));
        }
    }

    public void getCutomReportFilterInputList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            HashMap elementMap = JSONUtil.JSONObjectToMap((JSONObject)reportReqData.getJSONObject("elementMap"));
            JSONArray tabArray = new JSONArray();
            HashMap<String, ArrayList> periodMap = new HashMap<String, ArrayList>();
            if (elementMap.get("attributeProps") != null) {
                ArrayList clientList;
                HashMap propList = (HashMap)elementMap.get("attributeProps");
                if (propList.get("clientValues") != null) {
                    clientList = (ArrayList)propList.get("clientValues");
                    periodMap.put("clientValues", clientList);
                }
                if (propList.get("serverValues") != null) {
                    clientList = (ArrayList)propList.get("serverValues");
                    periodMap.put("serverValues", clientList);
                }
                if (propList.get("onclick") != null && !propList.get("onclick").toString().equals("")) {
                    String onClickStr = (String)propList.get("onclick");
                    onClickStr = onClickStr.substring(onClickStr.indexOf("(this"));
                    String cvidStr = onClickStr.split(",")[1];
                    String objClassStr = onClickStr.split(",")[2];
                    cvidStr = cvidStr.replaceAll("\\s", "").replaceAll("&#34", "");
                    objClassStr = objClassStr.replaceAll("\\s", "").replaceAll("&#34", "");
                    String[] cvid = cvidStr.split(";");
                    String[] objClass = objClassStr.split(";");
                    for (int c = 0; c < cvid.length; ++c) {
                        ObjectClass objectClass;
                        String objectClassStr;
                        if (cvid[c].equals("")) continue;
                        JSONObject tab = new JSONObject();
                        JSONObject tabInputParams = new JSONObject();
                        tabInputParams.put("cvId", (Object)cvid[c]);
                        tab.put("tabInputParams", (Object)tabInputParams);
                        if (objClass.length > c) {
                            objectClassStr = objClass[c].replaceAll("'", "");
                            tabInputParams.put("objectClass", (Object)objectClassStr);
                            objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClassStr);
                            tabInputParams.put("tabDisplayName", (Object)objectClass.getDisplayText());
                        } else {
                            objectClassStr = objClass[0].replaceAll("'", "");
                            tabInputParams.put("objectClass", (Object)objectClassStr);
                            objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClassStr);
                            tabInputParams.put("tabDisplayName", (Object)objectClass.getDisplayText());
                        }
                        tabArray.put((Object)tab);
                    }
                }
            }
            HashMap<String, JSONArray> returnListMap = new HashMap<String, JSONArray>();
            returnListMap.put("CRFilterInputList", tabArray);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void copyCustomReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            Long customReportId = reportReqData.getLong("customReportId");
            String reportName = reportReqData.getString("newName");
            String domainName = reportReqData.getString("newDomainName");
            Boolean domainChanged = reportReqData.getBoolean("domainChanged");
            CustomReportHandler.copyCustomReport((Long)customReportId, (String)reportName, (String)domainName, (Boolean)domainChanged);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.CopyCustomReport.audit_entry.Successfully_copied_custom_report", new String[]{reportReqData.getString("newName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_deleted", "-"}));
            this.getCustomReportList(request, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_copied", "-"}));
        }
    }
}

