/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.report;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.customreport.CustomReportBeanUtil;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportConfigUtil {
    private static final String EVENT_TASK_NAME = "ReportScheduler";

    public static JSONObject getScheduleConfigData(AdventNetResourceBundle rb) {
        JSONObject configData = new JSONObject();
        try {
            String fromTime;
            int i;
            int i2;
            Integer[] hourOfDay = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            Integer[] minutes = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
            JSONArray hourOfDayArray = new JSONArray();
            for (int i3 = 0; i3 < hourOfDay.length; ++i3) {
                JSONObject hourObject = new JSONObject();
                hourObject.put("name", (Object)hourOfDay[i3]);
                hourObject.put("value", (Object)hourOfDay[i3]);
                hourOfDayArray.put((Object)hourObject);
            }
            JSONArray minutesArray = new JSONArray();
            for (int i4 = 0; i4 < minutes.length; ++i4) {
                JSONObject minObject = new JSONObject();
                minObject.put("name", (Object)minutes[i4]);
                minObject.put("value", (Object)minutes[i4]);
                minutesArray.put((Object)minObject);
            }
            configData.put("freqHours", (Object)hourOfDayArray);
            configData.put("freqMins", (Object)minutesArray);
            JSONArray hourlyForArray = new JSONArray();
            String[] hourlyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Hour"), rb.getString("adap.ReportSchedulerBean.Last_60_Minutes")};
            String[] hourlyPeriodValues = new String[]{"lastHour", "onehour"};
            for (int i5 = 0; i5 < hourlyPeriods.length; ++i5) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)rb.getString(hourlyPeriods[i5]));
                forObject.put("value", (Object)hourlyPeriodValues[i5]);
                hourlyForArray.put((Object)forObject);
            }
            JSONObject hourlyData = new JSONObject();
            hourlyData.put("for", (Object)hourlyForArray);
            configData.put("freqHourlyData", (Object)hourlyData);
            JSONArray dailyForArray = new JSONArray();
            String[] dailyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Day00002359"), rb.getString("adap.ReportSchedulerBean.Last_24_Hours"), rb.getString("adap.AudSelectElementAttr.Last_12_Hours"), rb.getString("adap.AudSelectElementAttr.Last_6_Hours")};
            String[] dailyPeriodValues = new String[]{"Yesterday", "twfourhours", "twelvehours", "sixhours"};
            for (int i6 = 0; i6 < dailyPeriods.length; ++i6) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)rb.getString(dailyPeriods[i6]));
                forObject.put("value", (Object)dailyPeriodValues[i6]);
                dailyForArray.put((Object)forObject);
            }
            JSONObject dailyData = new JSONObject();
            dailyData.put("for", (Object)dailyForArray);
            configData.put("freqDailyData", (Object)dailyData);
            JSONArray weeklyForArray = new JSONArray();
            JSONArray weeklyOnArray = new JSONArray();
            String[] daysOfWeek = new String[]{rb.getString("adap.ReportSchedulerBean.Sunday"), rb.getString("adap.ReportSchedulerBean.Monday"), rb.getString("adap.ReportSchedulerBean.Tuesday"), rb.getString("adap.ReportSchedulerBean.Wednesday"), rb.getString("adap.ReportSchedulerBean.Thursday"), rb.getString("adap.ReportSchedulerBean.Friday"), rb.getString("adap.ReportSchedulerBean.Saturday")};
            Integer[] daysOfWeekValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            String[] weeklyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_WeekSun_0000__Sat"), rb.getString("adap.ReportSchedulerBean.Last_7_Days")};
            String[] weeklyPeriodValues = new String[]{"lastWeek", "Last_7_Days"};
            for (i2 = 0; i2 < daysOfWeek.length; ++i2) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)rb.getString(daysOfWeek[i2]));
                onObject.put("value", (Object)daysOfWeekValues[i2]);
                weeklyOnArray.put((Object)onObject);
            }
            for (i2 = 0; i2 < weeklyPeriods.length; ++i2) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)rb.getString(weeklyPeriods[i2]));
                forObject.put("value", (Object)weeklyPeriodValues[i2]);
                weeklyForArray.put((Object)forObject);
            }
            JSONObject weeklyData = new JSONObject();
            weeklyData.put("for", (Object)weeklyForArray);
            weeklyData.put("on", (Object)weeklyOnArray);
            configData.put("freqWeeklyData", (Object)weeklyData);
            JSONArray monthlyForArray = new JSONArray();
            JSONArray monthlyOnArray = new JSONArray();
            Integer[] datesOfMonth = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
            String[] monthlyPeriods = new String[]{rb.getString("adap.ReportSchedulerBean.Previous_Month"), rb.getString("adap.ReportSchedulerBean.Last_30_Days")};
            String[] monthlyPeriodValues = new String[]{"Last_Month", "Last_30_Days"};
            for (i = 0; i < datesOfMonth.length; ++i) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)datesOfMonth[i]);
                onObject.put("value", (Object)datesOfMonth[i]);
                monthlyOnArray.put((Object)onObject);
            }
            for (i = 0; i < monthlyPeriods.length; ++i) {
                JSONObject forObject = new JSONObject();
                forObject.put("name", (Object)monthlyPeriods[i]);
                forObject.put("value", (Object)monthlyPeriodValues[i]);
                monthlyForArray.put((Object)forObject);
            }
            JSONObject monthlyData = new JSONObject();
            monthlyData.put("for", (Object)monthlyForArray);
            monthlyData.put("on", (Object)monthlyOnArray);
            configData.put("freqMonthlyData", (Object)monthlyData);
            JSONObject defhourly = new JSONObject();
            defhourly.put("hoursValue", (Object)"0");
            defhourly.put("minsValue", (Object)"0");
            defhourly.put("onValue", (Object)"");
            defhourly.put("forValue", (Object)"lastHour");
            JSONObject defdaily = new JSONObject();
            defdaily.put("hoursValue", (Object)"0");
            defdaily.put("minsValue", (Object)"0");
            defdaily.put("onValue", (Object)"");
            defdaily.put("forValue", (Object)"Yesterday");
            JSONObject defWeekly = new JSONObject();
            defWeekly.put("hoursValue", (Object)"0");
            defWeekly.put("minsValue", (Object)"0");
            defWeekly.put("onValue", (Object)"1");
            defWeekly.put("forValue", (Object)"lastWeek");
            JSONObject defMonthly = new JSONObject();
            defMonthly.put("hoursValue", (Object)"0");
            defMonthly.put("minsValue", (Object)"0");
            defMonthly.put("onValue", (Object)"1");
            defMonthly.put("forValue", (Object)"Last_Month");
            JSONObject defValues = new JSONObject();
            defValues.put("hourly", (Object)defhourly);
            defValues.put("daily", (Object)defdaily);
            defValues.put("weekly", (Object)defWeekly);
            defValues.put("monthly", (Object)defMonthly);
            configData.put("freqDefaultValues", (Object)defValues);
            JSONArray bussinessHoursArray = new JSONArray();
            String[] bussinessHours = new String[]{"All Hours", "Bussiness Hours", "Non Bussiness Hours"};
            String[] bussinessHoursValues = new String[]{"false", "Bussiness", "NonBussiness"};
            for (int i7 = 0; i7 < bussinessHours.length; ++i7) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)bussinessHours[i7]);
                onObject.put("value", (Object)bussinessHoursValues[i7]);
                bussinessHoursArray.put((Object)onObject);
            }
            configData.put("bussinessHours", (Object)bussinessHoursArray);
            JSONArray fileFormatsArray = new JSONArray();
            String[] fileFormats = new String[]{"pdf", "xls", "csv", "html"};
            for (int i8 = 0; i8 < fileFormats.length; ++i8) {
                JSONObject onObject = new JSONObject();
                onObject.put("name", (Object)fileFormats[i8]);
                onObject.put("value", (Object)fileFormats[i8]);
                fileFormatsArray.put((Object)onObject);
            }
            configData.put("fileFormats", (Object)fileFormatsArray);
            boolean mailConficCheck = MailServerUtil.mailServerConfig();
            HashMap settingsMap = BusinessServerSettings.getBusinessHourSettings();
            String string = fromTime = settingsMap.isEmpty() ? "" : (String)settingsMap.get("FromTime");
            if (fromTime.equals("")) {
                configData.put("bussinessHourConfigured", false);
            } else {
                configData.put("bussinessHourConfigured", true);
            }
            configData.put("mailServerNotConfigured", !mailConficCheck);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public static ArrayList<Object> getColumnList(Long moduleId, ArrayList<Object> selectedSM, AdventNetResourceBundle rb) throws Exception {
        ArrayList columnsList = CustomReportUtil.getColumnListEmber((Long)moduleId, selectedSM, (AdventNetResourceBundle)rb);
        return columnsList;
    }

    public static HashMap<String, Object> getColumnList(ArrayList<Object> columnsList, Long reportType, AdventNetResourceBundle rb) throws Exception {
        HashMap<String, Object> columnMap;
        ArrayList<String> availableColumns = new ArrayList<String>();
        availableColumns.add(rb.getString("adap.common.text.select_column"));
        ArrayList<String> visbleColumns = new ArrayList<String>();
        ArrayList<String> nonVisibleColumns = new ArrayList<String>();
        ArrayList<Long> availableColumnIds = new ArrayList<Long>();
        availableColumnIds.add(new Long(-1L));
        ArrayList<Long> visbleColumnIds = new ArrayList<Long>();
        ArrayList<Long> nonVisibleColumnIds = new ArrayList<Long>();
        ArrayList availableColumns2 = new ArrayList();
        availableColumns.add(rb.getString("adap.common.text.select_column"));
        ArrayList visbleColumns2 = new ArrayList();
        ArrayList nonVisibleColumns2 = new ArrayList();
        HashMap<String, Object> map5 = new HashMap<String, Object>();
        map5.put("value", -1);
        map5.put("name", rb.getString("adap.common.text.select_column"));
        availableColumns2.add(map5);
        for (Object object : columnsList) {
            columnMap = (HashMap<String, Object>)object;
            if (((Boolean)columnMap.get("VISIBLE")).booleanValue()) {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                visbleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                visbleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
                map1.put("value", (Long)columnMap.get("COLUMN_ID"));
                map1.put("name", rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                visbleColumns2.add(map1);
            } else {
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                nonVisibleColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                nonVisibleColumnIds.add((Long)columnMap.get("COLUMN_ID"));
                map2.put("value", (Long)columnMap.get("COLUMN_ID"));
                map2.put("name", rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
                nonVisibleColumns2.add(map2);
            }
            HashMap<String, Object> map3 = new HashMap<String, Object>();
            map3.put("value", (Long)columnMap.get("COLUMN_ID"));
            map3.put("name", rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
            availableColumns2.add(map3);
            availableColumns.add(rb.getString((String)columnMap.get("COLUMN_DISPLAY_NAME")));
            availableColumnIds.add((Long)columnMap.get("COLUMN_ID"));
        }
        HashMap<String, String> map4 = new HashMap<String, String>();
        map4.put("value", "count");
        map4.put("name", rb.getString("adap.AUDColumnConfiguration.displayname.COUNT"));
        ArrayList summaryList = new ArrayList();
        summaryList.add(map5);
        summaryList.add(map4);
        if (reportType != 4L) {
            HashMap<String, String> map6 = new HashMap<String, String>();
            map6.put("value", "max");
            map6.put("name", rb.getString("adap.common.text.max_value"));
            HashMap<String, String> map7 = new HashMap<String, String>();
            map7.put("value", "min");
            map7.put("name", rb.getString("adap.common.text.min_value"));
            summaryList.add(map6);
            summaryList.add(map7);
        }
        columnMap = new HashMap<String, Object>();
        columnMap.put("availableColumns", availableColumns2);
        columnMap.put("visibleColumns", visbleColumns2);
        columnMap.put("nonVisibleColumns", nonVisibleColumns2);
        columnMap.put("summaryColumns", summaryList);
        return columnMap;
    }

    public static HashMap<Long, Object> getCriteriaDetails(AdventNetResourceBundle rb) throws Exception {
        HashMap<Long, Object> elementsMap = new HashMap<Long, Object>();
        ArrayList elementsList = AuditReportParamsAPI.getCustomReportCriteriaElements((AdventNetResourceBundle)rb);
        for (Object object : elementsList) {
            HashMap elementMap = (HashMap)object;
            elementsMap.put((Long)elementMap.get("elementId"), elementMap);
        }
        return elementsMap;
    }

    public String getProperties(String action, HttpServletRequest request, JSONObject reportData, JSONObject customReportConfigData, LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap, AdventNetResourceBundle rb) throws Exception {
        StringBuilder sb = new StringBuilder();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        DataObject customDO = this.getProperties(action, reportData, customReportConfigData, criteriaMap, loginId, request);
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        ArrayList selectedSM = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportData.getJSONArray("selectedSubModules"));
        Long reportId = this.saveThisAsNewReport((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), selectedSM, reportData, customDO, (Boolean)customRow.get("IS_PUBLIC"), criteriaMap, reportData.getString("domainName"));
        sb.append(rb.getString("adap.CustomReportBean.successfully_created_the_report"));
        sb.append("\n");
        customRow.set("AUDIT_REPORT_ID", (Object)reportId);
        if (Boolean.valueOf(reportData.getBoolean("isScheduleSelected")).booleanValue()) {
            DataObject scheDo = this.getSchedulerProperties(action, reportData, request, reportId);
            Row scheduleRow = scheDo.getFirstRow("Schedule");
            Row scheduleMapRow = new Row("AUDCustomReportSchedulerMap");
            scheduleMapRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            scheduleMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            customDO.addRow(scheduleMapRow);
            customDO.merge(scheDo);
        }
        CustomReportHandler.createReportsEmber((DataObject)customDO);
        sb.append(rb.getString("adap.CustomReportBean.Successfully_saved_the_custom_report"));
        return sb.toString();
    }

    public DataObject getProperties(String action, JSONObject reportData, JSONObject customReportConfigData, LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap, Long loginId, HttpServletRequest request) throws Exception {
        JSONArray availableColumns;
        DataObject customDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row customRow = new Row("AUDCustomReports");
        if (action.equalsIgnoreCase("update")) {
            Long reportId = reportData.getLong("customReportId");
            customRow.set("CUSTOM_REPORT_ID", (Object)reportId);
        }
        customRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
        customRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
        customRow.set("DOMAIN_NAME", (Object)reportData.getString("domainName"));
        customRow.set("DEFAULT_REPORT_PERIOD", (Object)reportData.getString("selectedDateLabel"));
        Long viewType = reportData.getJSONObject("reportType").getLong("reportTypeId");
        customRow.set("REPORT_VIEW", (Object)viewType);
        customRow.set("MODULE_ID", (Object)reportData.getLong("selectedModuleId"));
        customRow.set("CHART_ID", (Object)reportData.getInt("selectedChartType"));
        customRow.set("IS_SCHEDULE_ENABLED", (Object)reportData.getBoolean("isScheduleSelected"));
        if (!reportData.isNull("folderName")) {
            reportData.put("selectedFolder", (Object)ReportUtil.addNewReportCategory((String)reportData.getString("folderName")));
        }
        customRow.set("REPORT_CATEGORY_ID", (Object)reportData.getLong("selectedFolder"));
        Boolean isPublic = false;
        if ("public".equalsIgnoreCase(reportData.getString("reportPrivacy"))) {
            isPublic = true;
        }
        customRow.set("IS_PUBLIC", (Object)isPublic);
        customRow.set("ISREADONLY", (Object)false);
        customRow.set("LOGIN_ID", (Object)loginId);
        customRow.set("CRITERIA_PATTERN", (Object)reportData.optString("criteriaValue"));
        if (reportData.getString("selectedDateLabel").equalsIgnoreCase("customPeriod")) {
            customRow.set("FROM_TIME", (Object)reportData.getString("fromTime"));
            customRow.set("TO_TIME", (Object)reportData.getString("toTime"));
        }
        customDO.addRow(customRow);
        String[] colNames = new String[]{"CUSTOM_REPORT_ID", "COLUMN_ID", "COLUMNINDEX", "VISIBLE"};
        if (viewType == 1L) {
            int i;
            availableColumns = reportData.getJSONArray("notSelectedColumns");
            JSONArray selectedColumns = reportData.getJSONArray("selectedColumns");
            for (i = 0; i < selectedColumns.length(); ++i) {
                Object[] colValues = new Object[]{customRow.get("CUSTOM_REPORT_ID"), selectedColumns.getLong(i), i + 1, true};
                customDO.addRow(this.formRow("AUDCustomReportColumnsMapping", colNames, colValues));
            }
            for (i = 0; i < availableColumns.length(); ++i) {
                Long columnId = availableColumns.getLong(i);
                Row row = customDO.getRow("AUDCustomReportColumnsMapping", new Criteria(Column.getColumn((String)"AUDCustomReportColumnsMapping", (String)"COLUMN_ID"), (Object)columnId, 0));
                if (row != null) continue;
                Object[] colValues = new Object[]{customRow.get("CUSTOM_REPORT_ID"), columnId, selectedColumns.length() + i + 1, false};
                customDO.addRow(this.formRow("AUDCustomReportColumnsMapping", colNames, colValues));
            }
        } else {
            availableColumns = customReportConfigData.getJSONObject("columnMap").getJSONArray("availableColumns");
            for (int i = 0; i < availableColumns.length(); ++i) {
                if (availableColumns.getJSONObject(i).getLong("value") == -1L) continue;
                Object[] colValues = new Object[]{customRow.get("CUSTOM_REPORT_ID"), availableColumns.getJSONObject(i).getLong("value"), i + 1, true};
                customDO.addRow(this.formRow("AUDCustomReportColumnsMapping", colNames, colValues));
            }
        }
        JSONArray selectedSM = reportData.getJSONArray("selectedSubModules");
        for (int i = 0; i < selectedSM.length(); ++i) {
            Row selectedSMRow = new Row("AUDCustomReportSubModuleMap");
            selectedSMRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            selectedSMRow.set("SUB_MODULE_ID", (Object)selectedSM.getLong(i));
            customDO.addRow(selectedSMRow);
        }
        if (viewType == 3L) {
            Row summaryRow = new Row("AUDSummaryReportDetails");
            summaryRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            summaryRow.set("GROUP_LEFT_COLUMN_1", (Object)reportData.getLong("summaryFirstColumn"));
            if (!reportData.isNull("summarySecondColumn") && reportData.getLong("summarySecondColumn") != -1L) {
                summaryRow.set("GROUP_LEFT_COLUMN_2", (Object)reportData.getLong("summarySecondColumn"));
            }
            if (!reportData.isNull("summaryThirdColumn") && reportData.getLong("summaryThirdColumn") != -1L) {
                summaryRow.set("GROUP_LEFT_COLUMN_3", (Object)reportData.getLong("summaryThirdColumn"));
            }
            String summaryType = reportData.getString("summaryType");
            summaryRow.set("SUMMARY_TYPE", (Object)summaryType);
            if (!summaryType.equalsIgnoreCase("count")) {
                summaryRow.set("SUMMARY_COLUMN", (Object)reportData.getLong("summaryColumn"));
            }
            customDO.addRow(summaryRow);
        } else if (viewType == 4L) {
            Row matrixRow = new Row("AUDMatrixReportDetails");
            matrixRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            matrixRow.set("GROUP_TOP_COLUMN", (Object)reportData.getLong("pivotTopColumn"));
            matrixRow.set("GROUP_LEFT_COLUMN", (Object)reportData.getLong("pivotLeftColumn"));
            if (!reportData.isNull("pivotSummaryColumn") && reportData.getLong("pivotSummaryColumn") != -1L) {
                matrixRow.set("SUMMARY_COLUMN", (Object)reportData.getLong("pivotSummaryColumn"));
            }
            matrixRow.set("SUMMARY_TYPE", (Object)reportData.getString("pivotSummaryType"));
            customDO.addRow(matrixRow);
        }
        if (reportData.getInt("selectedChartType") != -1) {
            Row chartRow = this.getChartRow(reportData);
            chartRow.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            customDO.addRow(chartRow);
        }
        this.addCriteriaRow(customDO, criteriaMap);
        return customDO;
    }

    private Row formRow(String tableName, String[] colNames, Object[] colValues) throws Exception {
        Row row = new Row(tableName);
        for (int i = 0; i < colNames.length; ++i) {
            row.set(colNames[i], colValues[i]);
        }
        return row;
    }

    private Row getChartRow(JSONObject reportData) throws Exception {
        Row chartRow = new Row("AUDChartProperties");
        Integer chartId = reportData.getInt("selectedChartType");
        if (chartId == 1 || chartId == 2) {
            chartRow.set("XCOLUMN", (Object)reportData.getLong("chartAxisColumnValue"));
            chartRow.set("GROUPBY", (Object)reportData.getLong("chartAxisColumnValue"));
        } else if (chartId == 3 || chartId == 4) {
            chartRow.set("XCOLUMN", (Object)reportData.getLong("chartAxisColumnValue"));
            chartRow.set("GROUPBY", (Object)reportData.getLong("chartAxisColumnValue"));
            chartRow.set("LIMIT_VALUE", (Object)reportData.getInt("chartLimitValue"));
        } else if (chartId == 5) {
            chartRow.set("DATEFORMAT", (Object)reportData.getString("chartDateFormatValue"));
            chartRow.set("GROUPBY", (Object)reportData.getLong("chartAxisColumnValue"));
        } else if (chartId == 6) {
            chartRow.set("DATEFORMAT", (Object)reportData.getString("chartDateFormatValue"));
            chartRow.set("GROUPBY", (Object)reportData.getLong("chartAxisColumnValue"));
        } else if (chartId == 7) {
            chartRow.set("XCOLUMN", (Object)reportData.getLong("chartAxisColumnValue"));
            chartRow.set("XCOLUMN2", (Object)reportData.getLong("chartStackColumnValue"));
            chartRow.set("BARCHARTBY", (Object)reportData.getString("chartOrientationValue"));
        }
        chartRow.set("YCOLUMN", (Object)"adapcount");
        chartRow.set("FORMAT_ID", (Object)new Long(1L));
        return chartRow;
    }

    private void addCriteriaRow(DataObject customDO, LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap) throws Exception {
        Set<Integer> keys = criteriaMap.keySet();
        Row customRow = customDO.getFirstRow("AUDCustomReports");
        int priorityId = 1;
        for (Integer obj : keys) {
            HashMap<String, Object> detailsMap = criteriaMap.get(obj);
            Row row = new Row("AUDCustomReportFilterMapping");
            row.set("CUSTOM_REPORT_ID", customRow.get("CUSTOM_REPORT_ID"));
            row.set("COLUMN_ID", detailsMap.get("columnField"));
            row.set("RELATIONAL_OPERATOR", (Object)Long.parseLong((String)detailsMap.get("relOper")));
            row.set("LOGICAL_OPERATOR", detailsMap.get("logicalOper"));
            row.set("PRIORITY_ID", (Object)priorityId);
            String objectClass = (String)detailsMap.get("objectClass");
            if (objectClass == null || "".equalsIgnoreCase(objectClass)) {
                row.set("VALUE", detailsMap.get("names"));
            } else {
                row.set("VALUE", (Object)(objectClass + ";;;" + detailsMap.get("objectGuidStr")));
            }
            customDO.addRow(row);
            ++priorityId;
        }
    }

    private Long saveThisAsNewReport(Long loginId, ArrayList<Object> selectedSM, JSONObject reportData, DataObject customDO, Boolean isPublic, LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap, String domainName) throws Exception {
        return CustomReportHandler.saveThisAsNewReport((Long)reportData.getLong("selectedFolder"), (String)reportData.getString("reportName"), (String)reportData.getString("description"), (boolean)isPublic, (Long)loginId, (Integer)reportData.getInt("selectedChartType"), (Long)reportData.getJSONObject("reportType").getLong("reportTypeId"), (Long)reportData.getLong("selectedModuleId"), selectedSM, (DataObject)customDO, criteriaMap, (String)domainName);
    }

    public DataObject getSchedulerProperties(String action, JSONObject reportData, HttpServletRequest request, Long reportId) throws Exception {
        reportData.put("scheduleName", (Object)(reportData.getString("reportName") + "_" + reportId));
        return this.getScheduleProperties(action, reportData, request, reportId);
    }

    public DataObject getScheduleProperties(String action, JSONObject reportData, HttpServletRequest request, Long reportId) throws Exception {
        Integer timePeriod = 0;
        String reportPeriod = null;
        DataObject scheduleDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row scheduleRow = new Row("Schedule");
        if (action.equalsIgnoreCase("update")) {
            scheduleRow.set("SCHEDULE_ID", (Object)reportData.getLong("scheduleId"));
        }
        scheduleRow.set("SCHEDULE_NAME", (Object)reportData.getString("scheduleName"));
        scheduleRow.set("DESCRIPTION", (Object)reportData.getString("description"));
        scheduleDO.addRow(scheduleRow);
        if (reportData.getString("selectedFreq").equalsIgnoreCase("hourly")) {
            reportPeriod = reportData.getString("forValue");
            Row periodicRow = new Row("Periodic");
            periodicRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            periodicRow.set("TIME_PERIOD", (Object)1L);
            periodicRow.set("UNIT_OF_TIME", (Object)"Hours");
            Date dateObj = new Date();
            dateObj.setHours(reportData.getInt("hoursValue"));
            dateObj.setMinutes(reportData.getInt("minsValue"));
            dateObj.setSeconds(0);
            periodicRow.set("START_DATE", (Object)new Timestamp(dateObj.getTime()));
            scheduleDO.addRow(periodicRow);
        } else {
            Row calendarRow = new Row("Calendar");
            calendarRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            if (reportData.getString("selectedFreq").equalsIgnoreCase("daily")) {
                reportPeriod = reportData.getString("forValue");
                timePeriod = Integer.valueOf(reportData.getInt("hoursValue")) * 60 + Integer.valueOf(reportData.getInt("minsValue"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
            } else if (reportData.getString("selectedFreq").equalsIgnoreCase("weekly")) {
                reportPeriod = reportData.getString("forValue");
                timePeriod = Integer.valueOf(reportData.getInt("hoursValue")) * 60 + Integer.valueOf(reportData.getInt("minsValue"));
                calendarRow.set("DAY_OF_WEEK", (Object)reportData.getInt("onValue"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
            } else if (reportData.getString("selectedFreq").equalsIgnoreCase("monthly")) {
                reportPeriod = reportData.getString("forValue");
                timePeriod = Integer.valueOf(reportData.getInt("hoursValue")) * 60 + Integer.valueOf(reportData.getInt("minsValue"));
                calendarRow.set("DATE_OF_MONTH", (Object)reportData.getInt("onValue"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
            }
            scheduleDO.addRow(calendarRow);
        }
        Row taskInputRow = new Row("Task_Input");
        taskInputRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskInputRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)EVENT_TASK_NAME));
        Long time = System.currentTimeMillis() + 120000L;
        if (request.getParameter("testNow") != null && request.getParameter("testNow").equals("false")) {
            time = ScheduleUtil.calculateNextScheduleTime((DataObject)scheduleDO, (Long)-1L, (boolean)false);
        }
        taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(time));
        scheduleDO.addRow(taskInputRow);
        Row taskRow = new Row("Scheduled_Task");
        taskRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskRow.set("AUDIT_FLAG", (Object)true);
        taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)EVENT_TASK_NAME));
        taskRow.set("TRANSACTION_TIME", (Object)-1);
        taskRow.set("SKIP_MISSED_SCHEDULE", (Object)true);
        scheduleDO.addRow(taskRow);
        Row schedulerRow = new Row("AUDScheduler");
        schedulerRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        schedulerRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
        schedulerRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
        schedulerRow.set("DOMAIN_NAME", (Object)reportData.getString("domainName"));
        schedulerRow.set("REPORT_PERIOD", (Object)reportPeriod);
        schedulerRow.set("FILE_FORMAT", (Object)reportData.getString("formatValue"));
        schedulerRow.set("FILE_STORAGE_PATH", (Object)reportData.getString("fileStoragePath"));
        schedulerRow.set("IS_NOTIFICATION_ENABLED", (Object)reportData.getBoolean("isMailNotify"));
        schedulerRow.set("TO_MAIL_ADDRESS", (Object)reportData.getString("mailAddress"));
        schedulerRow.set("MAIL_SUBJECT", (Object)reportData.getString("mailSubject"));
        schedulerRow.set("MAIL_CONTENT", (Object)reportData.getString("mailContent"));
        schedulerRow.set("SENDING_OPTIONS", (Object)reportData.getString("sendingOptions"));
        schedulerRow.set("IS_ZIP_FILE", (Object)reportData.getBoolean("isZipFile"));
        schedulerRow.set("IS_REPORTS_EMPTY", (Object)(Boolean.valueOf(reportData.getBoolean("isReportsEmpty")) == false ? 1 : 0));
        schedulerRow.set("BUSINESS_HOUR", (Object)reportData.getString("BUSINESS_HOUR"));
        scheduleDO.addRow(schedulerRow);
        Row reportMapRow = new Row("AUDReportSchedulerMap");
        reportMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        reportMapRow.set("AUDIT_REPORT_ID", (Object)reportId);
        scheduleDO.addRow(reportMapRow);
        return scheduleDO;
    }

    public static LinkedHashMap<Integer, HashMap<String, Object>> formCriteriaMap(HttpServletRequest request, JSONObject reportData) throws Exception {
        LinkedHashMap<Integer, HashMap<String, Object>> criteriaMap = new LinkedHashMap<Integer, HashMap<String, Object>>();
        JSONArray filterList = reportData.getJSONArray("filterList");
        for (int i = 0; i < filterList.length(); ++i) {
            JSONObject filter = filterList.getJSONObject(i);
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            if (i == 0) {
                valueMap.put("logicalOper", "-");
            } else {
                valueMap.put("logicalOper", filter.getString("logOperator"));
            }
            valueMap.put("columnField", filter.getString("columnId"));
            valueMap.put("relOper", filter.getString("relOperator"));
            valueMap.put("names", filter.getString("value"));
            if (!"-".equalsIgnoreCase(filter.getString("objectClass"))) {
                valueMap.put("objectClass", filter.getString("objectClass"));
                JSONArray objectGuidArray = filter.getJSONArray("objectGuid");
                StringBuffer objectGuidStr = null;
                for (int j = 0; j < objectGuidArray.length(); ++j) {
                    if (j == 0) {
                        objectGuidStr = new StringBuffer();
                    } else {
                        objectGuidStr.append(",");
                    }
                    objectGuidStr.append(objectGuidArray.getString(j));
                }
                valueMap.put("object_guid", JSONUtil.JSONArrayToList((JSONArray)filter.getJSONArray("objectGuid")));
                valueMap.put("objectGuidStr", objectGuidStr.toString());
            }
            if (filter.getString("value").equals("")) continue;
            criteriaMap.put(i, valueMap);
        }
        return criteriaMap;
    }

    public static JSONObject getChartDetails(AdventNetResourceBundle rb) throws Exception {
        LinkedHashMap chartMap = CustomReportUtil.getChartDetails();
        Set strSet = chartMap.keySet();
        Integer[] chartIds = new Integer[chartMap.size() + 1];
        String[] chartDetails = new String[chartMap.size() + 1];
        chartIds[0] = -1;
        chartDetails[0] = rb.getString("adap.CustomReportBean.Select_Chart_Type");
        JSONObject map1 = new JSONObject();
        map1.put("name", (Object)"---Select ChartType---");
        map1.put("value", -1);
        int i = 1;
        JSONObject configData = new JSONObject();
        JSONArray chartTypeArray = new JSONArray();
        chartTypeArray.put((Object)map1);
        Iterator iter = strSet.iterator();
        while (iter.hasNext()) {
            Integer id;
            JSONObject chartType = new JSONObject();
            chartIds[i] = id = (Integer)iter.next();
            HashMap detailsMap = (HashMap)chartMap.get(id);
            chartDetails[i] = rb.getString((String)detailsMap.get("CHART_DISPLAY_NAME"));
            chartType.put("name", (Object)rb.getString((String)detailsMap.get("CHART_DISPLAY_NAME")));
            chartType.put("value", (Object)id);
            chartTypeArray.put((Object)chartType);
            ++i;
        }
        configData.put("chartTypes", (Object)chartTypeArray);
        String[] displayFormatNames = new String[]{rb.getString("adap.CustomReportBean.Numeric"), rb.getString("adap.CustomReportBean.Percentage")};
        Long[] displayFormatIds = new Long[]{1L, 2L};
        JSONArray displayFormatArray = new JSONArray();
        for (int j = 0; j < displayFormatNames.length; ++j) {
            JSONObject forObject = new JSONObject();
            forObject.put("name", (Object)rb.getString(displayFormatNames[j]));
            forObject.put("value", (Object)displayFormatIds[j]);
            displayFormatArray.put((Object)forObject);
        }
        JSONObject pieData = new JSONObject();
        pieData.put("displayFormat", (Object)displayFormatArray);
        pieData.put("displayFormatValue", 1L);
        configData.put("pieData", (Object)pieData);
        JSONObject barData = new JSONObject();
        barData.put("limit", (Object)"true");
        barData.put("limitValue", (Object)"5");
        configData.put("barData", (Object)barData);
        String[] dateFormatNames = new String[]{rb.getString("adap.CustomReportBean.XCOLUMN_DAY_BASED"), rb.getString("adap.CustomReportBean.XCOLUMN_HOUR_BASED"), rb.getString("adap.CustomReportBean.XCOLUMN_MONTH_BASED"), rb.getString("adap.CustomReportBean.XCOLUMN_YEAR_BASED")};
        String[] dateFormatIds = new String[]{"${PATTERNREPLACE:XCOLUMN_DAY_BASED}", "${PATTERNREPLACE:XCOLUMN_HOUR_BASED}", "${PATTERNREPLACE:XCOLUMN_MONTH_BASED}", "${PATTERNREPLACE:XCOLUMN_YEAR_BASED}"};
        JSONArray dateFormatArray = new JSONArray();
        for (int j = 0; j < dateFormatNames.length; ++j) {
            JSONObject forObject = new JSONObject();
            forObject.put("name", (Object)rb.getString(dateFormatNames[j]));
            forObject.put("value", (Object)dateFormatIds[j]);
            dateFormatArray.put((Object)forObject);
        }
        JSONObject timeData = new JSONObject();
        timeData.put("dateFormat", (Object)dateFormatArray);
        timeData.put("dateFormatValue", (Object)"${PATTERNREPLACE:XCOLUMN_DAY_BASED}");
        configData.put("timeData", (Object)timeData);
        String[] orientationNames = new String[]{rb.getString("adap.CustomReportBean.Vertical"), rb.getString("adap.CustomReportBean.Horizontal")};
        String[] orientationIds = new String[]{"Vertical", "Horizontal"};
        JSONArray orientationArray = new JSONArray();
        for (int j = 0; j < orientationNames.length; ++j) {
            JSONObject forObject = new JSONObject();
            forObject.put("name", (Object)rb.getString(orientationNames[j]));
            forObject.put("value", (Object)orientationIds[j]);
            orientationArray.put((Object)forObject);
        }
        JSONObject stackedBarData = new JSONObject();
        stackedBarData.put("orientation", (Object)orientationArray);
        stackedBarData.put("stackOn", (Object)"true");
        stackedBarData.put("orientationValue", (Object)"Vertical");
        configData.put("stackedBarData", (Object)stackedBarData);
        JSONObject defBar = new JSONObject();
        defBar.put("dateFormatValue", (Object)"");
        defBar.put("displayFormatValue", (Object)"");
        defBar.put("orientationValue", (Object)"");
        defBar.put("limitValue", (Object)"5");
        JSONObject defPie = new JSONObject();
        defPie.put("dateFormatValue", (Object)"");
        defPie.put("displayFormatValue", 1L);
        defPie.put("orientationValue", (Object)"");
        defPie.put("limitValue", (Object)"");
        JSONObject defTime = new JSONObject();
        defTime.put("dateFormatValue", (Object)"${PATTERNREPLACE:XCOLUMN_DAY_BASED}");
        defTime.put("displayFormatValue", (Object)"");
        defTime.put("orientationValue", (Object)"");
        defTime.put("limitValue", (Object)"");
        JSONObject defStackedBar = new JSONObject();
        defStackedBar.put("dateFormatValue", (Object)"");
        defStackedBar.put("displayFormatValue", (Object)"");
        defStackedBar.put("orientationValue", (Object)"Vertical");
        defStackedBar.put("limitValue", (Object)"");
        JSONObject defValues = new JSONObject();
        defValues.put("pieDefault", (Object)defBar);
        defValues.put("barDefault", (Object)defPie);
        defValues.put("timeDefault", (Object)defTime);
        defValues.put("stackedBarDefault", (Object)defStackedBar);
        configData.put("chartDefaultValues", (Object)defValues);
        return configData;
    }

    public static void getScheduleReportData(Long scheduleId, JSONObject reportData) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject schedulerDO = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("ScheduledReports", crit);
            Row scheduleRow = schedulerDO.getRow("Schedule");
            reportData.put("scheduleId", (Object)scheduleId);
            reportData.put("scheduleName", (Object)((String)scheduleRow.get("SCHEDULE_NAME")));
            reportData.put("description", (Object)((String)scheduleRow.get("DESCRIPTION")));
            Row audSchedulerRow = schedulerDO.getRow("AUDScheduler");
            JSONObject domainData = new JSONObject();
            JSONArray retArray = new JSONArray();
            JSONObject jo = new JSONObject();
            jo.put("name", (Object)((String)audSchedulerRow.get("DOMAIN_NAME")));
            jo.put("value", (Object)((String)audSchedulerRow.get("DOMAIN_NAME")));
            retArray.put((Object)jo);
            domainData.put("domainsList", (Object)retArray);
            domainData.put("selectedDomain", (Object)((String)audSchedulerRow.get("DOMAIN_NAME")));
            reportData.put("domainData", (Object)domainData);
            reportData.put("fileStoragePath", (Object)((String)audSchedulerRow.get("FILE_STORAGE_PATH")));
            reportData.put("formatValue", (Object)((String)audSchedulerRow.get("FILE_FORMAT")));
            reportData.put("isMailNotify", (Object)((Boolean)audSchedulerRow.get("IS_NOTIFICATION_ENABLED")));
            reportData.put("mailAddress", (Object)((String)audSchedulerRow.get("TO_MAIL_ADDRESS")));
            reportData.put("mailContent", (Object)((String)audSchedulerRow.get("MAIL_CONTENT")));
            reportData.put("mailSubject", (Object)((String)audSchedulerRow.get("MAIL_SUBJECT")));
            reportData.put("sendingOptions", (Object)((String)audSchedulerRow.get("SENDING_OPTIONS")));
            reportData.put("isZipFile", (Object)((Boolean)audSchedulerRow.get("IS_ZIP_FILE")));
            reportData.put("BUSINESS_HOUR", (Object)((String)audSchedulerRow.get("BUSINESS_HOUR")));
            reportData.put("isReportsEmpty", (Boolean)audSchedulerRow.get("IS_REPORTS_EMPTY") == false);
            String timePeriod = (String)audSchedulerRow.get("REPORT_PERIOD");
            if (schedulerDO.size("Periodic") > 0) {
                Row periodicRow = schedulerDO.getRow("Periodic");
                Date dateObj = (Date)periodicRow.get("START_DATE");
                reportData.put("hoursValue", dateObj.getHours());
                reportData.put("minsValue", dateObj.getMinutes());
                reportData.put("forValue", (Object)timePeriod);
                reportData.put("selectedFreq", (Object)"hourly");
            } else {
                Row calendarRow = schedulerDO.getRow("Calendar");
                if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("daily")) {
                    reportData.put("hoursValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                    reportData.put("minsValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                    reportData.put("forValue", (Object)timePeriod);
                    reportData.put("selectedFreq", (Object)"daily");
                } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("weekly")) {
                    reportData.put("onValue", (Object)((Integer)calendarRow.get("DAY_OF_WEEK")));
                    reportData.put("hoursValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                    reportData.put("minsValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                    reportData.put("forValue", (Object)timePeriod);
                    reportData.put("selectedFreq", (Object)"weekly");
                } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("monthly")) {
                    reportData.put("onValue", (Object)((Integer)calendarRow.get("DATE_OF_MONTH")));
                    reportData.put("hoursValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                    reportData.put("minsValue", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                    reportData.put("forValue", (Object)timePeriod);
                    reportData.put("selectedFreq", (Object)"monthly");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, Object> setColumnsList(HttpServletRequest request, DataObject dObj, JSONObject reportData, AdventNetResourceBundle rb) throws Exception {
        HashMap<String, ArrayList<Object>> detailsMap = CustomReportBeanUtil.getColumnsListDetails(dObj, rb);
        HashMap<String, Object> columnMap = CustomReportConfigUtil.getColumnList(detailsMap.get("columnsList"), reportData.getLong("reportTypeId"), rb);
        if (reportData.getLong("reportTypeId") == reportData.getLong("persistentReportTypeId")) {
            ArrayList<Object> list1 = detailsMap.get("selectedIdList");
            ArrayList<Object> list2 = detailsMap.get("selectedColsList");
            ArrayList list3 = new ArrayList();
            for (int i = 0; i < list1.size(); ++i) {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("name", list2.get(i));
                map1.put("value", list1.get(i));
                list3.add(map1);
            }
            columnMap.put("visibleColumns", list3);
        }
        return columnMap;
    }

    private static void setChartDetails(Integer chartId, Row chartRow, JSONObject reoportData) throws Exception {
        if (chartId == 1 || chartId == 2) {
            reoportData.put("chartDisplayFormatValue", 1L);
            reoportData.put("chartAxisColumnValue", (Object)((Long)chartRow.get("XCOLUMN")));
        } else if (chartId == 3 || chartId == 4) {
            reoportData.put("chartAxisColumnValue", (Object)((Long)chartRow.get("XCOLUMN")));
            reoportData.put("chartLimitValue", (Object)((Integer)chartRow.get("LIMIT_VALUE")));
        } else if (chartId == 5) {
            reoportData.put("chartDateFormatValue", chartRow.get("DATEFORMAT"));
            reoportData.put("chartAxisColumnValue", (Object)((Long)chartRow.get("GROUPBY")));
        } else if (chartId == 6) {
            reoportData.put("chartDateFormatValue", chartRow.get("DATEFORMAT"));
            reoportData.put("chartAxisColumnValue", (Object)((Long)chartRow.get("GROUPBY")));
        } else if (chartId == 7) {
            reoportData.put("chartAxisColumnValue", (Object)((Long)chartRow.get("XCOLUMN")));
            reoportData.put("chartStackColumnValue", (Object)((Long)chartRow.get("XCOLUMN2")));
            reoportData.put("chartOrientationValue", (Object)((String)chartRow.get("BARCHARTBY")));
        }
        reoportData.put("selectedChartType", (Object)chartId);
    }

    public static void getPageOneData(Long customReportId, JSONObject reportData, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DataObject dObj = CustomReportHandler.getConfiguredReportDetails((Long)customReportId);
        Row reportRow = dObj.getFirstRow("AUDReports");
        reportData.put("reportName", (Object)((String)reportRow.get("AUDIT_REPORT_NAME")));
        reportData.put("description", (Object)((String)reportRow.get("DESCRIPTION")));
        reportData.put("customReportId", (Object)customReportId);
        Row customReportRow = dObj.getFirstRow("AUDCustomReports");
        reportData.put("domainName", (Object)((String)customReportRow.get("DOMAIN_NAME")));
        Long reportView = (Long)customReportRow.get("REPORT_VIEW");
        reportData.put("reportTypeId", (Object)reportView);
        reportData.put("persistentReportTypeId", (Object)reportView);
        reportData.put("selectedModuleId", (Object)((Long)customReportRow.get("MODULE_ID")));
        reportData.put("persistentModuleId", (Object)((Long)customReportRow.get("MODULE_ID")));
        reportData.put("selectedSubModules", (Object)CustomReportUtil.getSubModulesEmber((DataObject)dObj));
    }

    public static HashMap<String, Object> getPageTwoData(Long customReportId, JSONObject reportData, HashMap<String, Object> columnMap, JSONObject colOpeMap, JSONObject colElementMap, HashMap elementsMap, JSONObject relationaloperators, HttpServletRequest request, HttpServletResponse response, AdventNetResourceBundle rb) throws Exception {
        DataObject dObj = CustomReportHandler.getConfiguredReportDetails((Long)customReportId);
        Row reportRow = dObj.getFirstRow("AUDReports");
        Row customReportRow = dObj.getFirstRow("AUDCustomReports");
        Long reportView = (Long)customReportRow.get("REPORT_VIEW");
        reportData.put("isScheduleSelected", (Object)((Boolean)customReportRow.get("IS_SCHEDULE_ENABLED")));
        Integer chartId = (Integer)customReportRow.get("CHART_ID");
        if (chartId != -1 && reportData.getLong("selectedModuleId") == reportData.getLong("persistentModuleId")) {
            CustomReportConfigUtil.setChartDetails(chartId, dObj.getFirstRow("AUDChartProperties"), reportData);
        }
        if (reportData.getLong("selectedModuleId") == reportData.getLong("persistentModuleId")) {
            columnMap = CustomReportConfigUtil.setColumnsList(request, dObj, reportData, rb);
        }
        reportData.put("selectedDateLabel", (Object)((String)customReportRow.get("DEFAULT_REPORT_PERIOD")));
        if ("customPeriod".equalsIgnoreCase((String)customReportRow.get("DEFAULT_REPORT_PERIOD"))) {
            reportData.put("fromTime", (Object)((String)customReportRow.get("FROM_TIME")));
            reportData.put("toTime", (Object)((String)customReportRow.get("TO_TIME")));
        }
        reportData.put("criteriaValue", customReportRow.get("CRITERIA_PATTERN"));
        if (reportView == 3L) {
            Row summaryRow = dObj.getFirstRow("AUDSummaryReportDetails");
            reportData.put("summaryFirstColumn", (Object)((Long)summaryRow.get("GROUP_LEFT_COLUMN_1")));
            reportData.put("summarySecondColumn", (Object)((Long)summaryRow.get("GROUP_LEFT_COLUMN_2")));
            reportData.put("summaryThirdColumn", (Object)((Long)summaryRow.get("GROUP_LEFT_COLUMN_3")));
            reportData.put("summaryColumn", summaryRow.get("SUMMARY_COLUMN") != null ? (Long)summaryRow.get("SUMMARY_COLUMN") : -1L);
            reportData.put("summaryType", (Object)((String)summaryRow.get("SUMMARY_TYPE")));
        } else if (reportView == 4L) {
            Row matrixRow = dObj.getFirstRow("AUDMatrixReportDetails");
            reportData.put("pivotLeftColumn", (Object)((Long)matrixRow.get("GROUP_LEFT_COLUMN")));
            reportData.put("pivotTopColumn", (Object)((Long)matrixRow.get("GROUP_TOP_COLUMN")));
            reportData.put("pivotSummaryColumn", matrixRow.get("SUMMARY_COLUMN") != null ? (Long)matrixRow.get("SUMMARY_COLUMN") : -1L);
            reportData.put("pivotSummaryType", (Object)((String)matrixRow.get("SUMMARY_TYPE")));
        }
        reportData.put("selectedFolder", (Object)((Long)customReportRow.get("REPORT_CATEGORY_ID")));
        if (((Boolean)customReportRow.get("IS_PUBLIC")).booleanValue()) {
            reportData.put("reportPrivacy", (Object)"public");
        } else {
            reportData.put("reportPrivacy", (Object)"private");
        }
        reportData.put("reportId", (Object)((Long)customReportRow.get("AUDIT_REPORT_ID")));
        if (reportData.getLong("selectedModuleId") == reportData.getLong("persistentModuleId")) {
            reportData.put("filterList", (Object)CustomReportConfigUtil.getCriteriaList(dObj, colOpeMap, colElementMap, elementsMap, relationaloperators));
        } else {
            reportData.put("filterList", (Object)new JSONArray());
        }
        if (dObj.size("AUDCustomReportSchedulerMap") > 0) {
            Row scheduleMapRow = dObj.getFirstRow("AUDCustomReportSchedulerMap");
            CustomReportConfigUtil.getScheduleReportData((Long)scheduleMapRow.get("SCHEDULE_ID"), reportData);
        }
        return columnMap;
    }

    public DataObject setSchedulerDetails(DataObject dObj, DataObject oldDO, JSONObject reportData, HttpServletRequest request, String action) throws Exception {
        Row schedMapRow;
        Row reportRow = oldDO.getFirstRow("AUDCustomReports");
        Row row = schedMapRow = oldDO.size("AUDCustomReportSchedulerMap") > 0 ? oldDO.getFirstRow("AUDCustomReportSchedulerMap") : null;
        if (Boolean.valueOf(reportData.getBoolean("isScheduleSelected")).booleanValue() && oldDO.size("AUDCustomReportSchedulerMap") == -1) {
            if (schedMapRow != null) {
                reportData.put("scheduleId", schedMapRow.get("SCHEDULE_ID"));
            } else {
                action = "new";
            }
            DataObject scheDo = this.getSchedulerProperties(action, reportData, request, (Long)reportRow.get("AUDIT_REPORT_ID"));
            Row scheduleRow = scheDo.getFirstRow("Schedule");
            Row scheduleMapRow = new Row("AUDCustomReportSchedulerMap");
            scheduleMapRow.set("CUSTOM_REPORT_ID", (Object)reportData.getLong("customReportId"));
            scheduleMapRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            dObj.addRow(scheduleMapRow);
            dObj.merge(scheDo);
        } else if (!Boolean.valueOf(reportData.getBoolean("isScheduleSelected")).booleanValue() && oldDO.size("AUDCustomReportSchedulerMap") > 0) {
            ReportSchedulerUtil.deleteScheduler((Long)((Long)schedMapRow.get("SCHEDULE_ID")));
        } else if (Boolean.valueOf(reportData.getBoolean("isScheduleSelected")).booleanValue() && oldDO.size("AUDCustomReportSchedulerMap") > 0) {
            dObj.addRow(schedMapRow);
            DataObject scheDo = this.getSchedulerProperties(action, reportData, request, (Long)reportRow.get("AUDIT_REPORT_ID"));
            ReportSchedulerUtil.updateScheduler((DataObject)scheDo, (Long)((Long)schedMapRow.get("SCHEDULE_ID")), null);
        }
        return dObj;
    }

    public static JSONArray getCriteriaList(DataObject dataObj, JSONObject colOpeMap, JSONObject colElementMap, HashMap elementsMap, JSONObject relationaloperators) throws Exception {
        ArrayList criteriaList = new ArrayList();
        JSONArray filterList = new JSONArray();
        if (dataObj.size("AUDCustomReportFilterMapping") > 0) {
            Row filterRow = dataObj.getFirstRow("AUDCustomReportFilterMapping");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDCustomReportFilterMapping"));
            query.addSelectColumn(Column.getColumn((String)"AUDCustomReportFilterMapping", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"AUDCustomReportFilterMapping", (String)"CUSTOM_REPORT_ID"), filterRow.get("CUSTOM_REPORT_ID"), 0));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCustomReportFilterMapping", (String)"PRIORITY_ID"), true));
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            int i = 0;
            int j = 1;
            Iterator iterator = dObj.getRows("AUDCustomReportFilterMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject filter = new JSONObject();
                HashMap<String, Object> detailsMap = new HashMap<String, Object>();
                detailsMap.put("columnField", row.get("COLUMN_ID"));
                detailsMap.put("logicalOper", row.get("LOGICAL_OPERATOR"));
                detailsMap.put("relOper", row.get("RELATIONAL_OPERATOR"));
                String[] val = ((String)row.get("VALUE")).split(";;;");
                filter.put("columnId", row.get("COLUMN_ID"));
                Long elementId = colElementMap.optLong(row.get("COLUMN_ID").toString());
                if (elementId != 0L) {
                    JSONObject elementMap = JSONUtil.mapToJSONObject((Map)((HashMap)elementsMap.get(elementId)));
                    String operatorId = colOpeMap.getString(row.get("COLUMN_ID").toString());
                    JSONArray relOperators = relationaloperators.getJSONArray(operatorId);
                    filter.put("logOperator", row.get("LOGICAL_OPERATOR"));
                    filter.put("relOperator", row.get("RELATIONAL_OPERATOR"));
                    filter.put("filterNo", j);
                    filter.put("elementMap", (Object)elementMap);
                    filter.put("relationalOperators", (Object)relOperators);
                    if (j > 1) {
                        filter.put("showLogicOperator", true);
                    }
                    ++j;
                    filter.put("objectClass", (Object)"-");
                    if (val.length > 1) {
                        detailsMap.put("objectClass", val[0]);
                        detailsMap.put("object_guid", val[1]);
                        filter.put("objectClass", (Object)val[0]);
                        JSONArray objectGuidArray = new JSONArray();
                        String[] val2 = val[1].split(",");
                        for (int k = 0; k < val2.length; ++k) {
                            objectGuidArray.put((Object)val2[k]);
                        }
                        filter.put("objectGuid", (Object)objectGuidArray);
                        filter.put("disabledText", true);
                        if ("share".equalsIgnoreCase(val[0])) {
                            detailsMap.put("names", val[1]);
                            filter.put("value", (Object)val[1]);
                        } else {
                            ArrayList<String> list = new ArrayList<String>();
                            list.addAll(Arrays.asList(val[1].split(",")));
                            Iterator iter = DirectoryObjectAPI.getInstance().getObjectRows(null, list, val[0]);
                            String names = "";
                            if (iter != null) {
                                while (iter.hasNext()) {
                                    Row objectRow = (Row)iter.next();
                                    names = names != "" ? names + "," + (String)objectRow.get("NAME") : (String)objectRow.get("NAME");
                                }
                            } else {
                                names = val[1];
                            }
                            detailsMap.put("names", names);
                            filter.put("value", (Object)names);
                        }
                    } else {
                        detailsMap.put("names", val[0]);
                        filter.put("value", (Object)val[0]);
                    }
                    criteriaList.add(detailsMap);
                    filterList.put((Object)filter);
                }
                ++i;
            }
        }
        return filterList;
    }
}

