/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.report;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditDelegationUtil;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.gpo.PDCHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.SearchReports;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportHandler;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixReportParams;
import com.adventnet.sym.adsm.auditing.server.transformers.MultiRowTransformer;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.EmberTableConfig;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.report.ReportHandlerUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.APIUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.util.JsonResponse;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.export.AdapExporter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.sym.adsm.common.server.wengine.FileUpdateScheduler;
import com.adventnet.sym.adsm.common.webclient.graphs.util.ReportChartUtil;
import com.adventnet.taskengine.TaskContext;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportHandler {
    private static volatile ReportHandler instance = null;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportHandler getInstance() {
        if (instance != null) return instance;
        Class<ReportHandler> clazz = ReportHandler.class;
        synchronized (ReportHandler.class) {
            if (instance != null) return instance;
            instance = new ReportHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ReportHandler() {
    }

    public void getReportInputParams(HttpServletRequest request, HttpServletResponse response) {
        try {
            HashMap settingsMap;
            String fromTime;
            String lastFileUpdateTime;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Long reportId = null;
            JSONObject queryParams = null;
            if (reportReqData.has("queryParams")) {
                queryParams = reportReqData.getJSONObject("queryParams");
            }
            reportId = reportReqData.getLong("reportId");
            String domainName = reportReqData.getString("domainName");
            Integer reportCategoryType = AuditReportCategoryHandler.getCategoryType((Long)reportId);
            HashMap reportMap = AuditReportAPI.getInstance().getReportDetailsEmber(reportId, rb);
            HashMap tableViewConfig = AuditReportAPI.getInstance().getTableViewConfig(reportId);
            Long reportCategoryId = (Long)reportMap.get("REPORT_CATEGORY_ID");
            Boolean isCustomizable = (Boolean)reportMap.get("IS_CUSTOMIZABLE");
            if (isCustomizable != null && !isCustomizable.booleanValue() && !AuditReportAPI.getInstance().isReportAccessible(reportId, reportCategoryId, request).booleanValue()) {
                response.sendError(401);
                throw new Exception("ACCESS DENIED");
            }
            if (isCustomizable != null && isCustomizable.booleanValue()) {
                String reportName = reportMap.get("TITLE").toString();
                reportName = reportName + " " + rb.getString("adap.common.text.in") + " " + AuditReportAPI.getInstance().getDomainName(reportId);
                reportMap.put("TITLE", reportName);
            }
            ArrayList cvIdList = AUDCustomViewAPI.getInstance().getReportCVIdArray(reportId);
            JSONArray reportTabList = ReportHandlerUtil.getInstance().getReportTabDetails(cvIdList, reportMap, rb);
            ArrayList elementList = AuditReportParamsAPI.getReportFormElements((Long)reportId, (boolean)false, (HttpServletRequest)request);
            HashMap<String, Object> inputParamsReport = null;
            if (queryParams != null && queryParams.has("favRepId")) {
                inputParamsReport = ReportHandlerUtil.getInstance().getFavReportInputParams(queryParams.getLong("favRepId"));
                String favReportdomainName = inputParamsReport.get("domainName").toString();
                if (!domainName.equals(favReportdomainName)) {
                    inputParamsReport.put("domainChanged", Boolean.TRUE);
                    domainName = favReportdomainName;
                }
            } else {
                inputParamsReport = ReportHandlerUtil.getInstance().getInputParams(reportId, request);
                if (queryParams != null && queryParams.has("selectedObjects")) {
                    ArrayList<String> selectedObjects = new ArrayList<String>();
                    selectedObjects.add(queryParams.getString("selectedObjects"));
                    inputParamsReport.put("object_guid", selectedObjects);
                }
            }
            Boolean isRealTimeReport = false;
            if (inputParamsReport.get("inputDays").equals("realtime")) {
                isRealTimeReport = true;
            }
            if (queryParams != null && queryParams.has("inputDays")) {
                String inputDays = queryParams.getString("inputDays");
                inputParamsReport.put("inputDays", inputDays);
                if (inputDays.equalsIgnoreCase("customPeriod")) {
                    Long startTime = queryParams.getLong("startDate");
                    Long endTime = queryParams.getLong("endDate");
                    Date date = new Date(startTime * 1000L);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String startDate = sdf.format(date);
                    Integer startHour = date.getHours();
                    Integer startMinute = date.getMinutes();
                    Date date1 = new Date(endTime * 1000L);
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    String endDate = sdf1.format(date1);
                    Integer endHour = date1.getHours();
                    Integer endMinute = date1.getMinutes();
                    inputParamsReport.put("startTime", startDate);
                    inputParamsReport.put("endTime", endDate);
                    inputParamsReport.put("startHour", startHour.toString());
                    inputParamsReport.put("endHour", endHour.toString());
                    inputParamsReport.put("startMinute", startMinute.toString());
                    inputParamsReport.put("endMinute", endMinute.toString());
                }
            }
            ArrayList selectedObjList = null;
            String topSelectedObj = "None";
            if (inputParamsReport.get("printer_name") != null) {
                inputParamsReport.remove("printer_name");
                if (inputParamsReport.get("object_guid") == null) {
                    ArrayList oblist = new ArrayList();
                    inputParamsReport.put("object_guid", oblist);
                }
            }
            if (inputParamsReport.get("objectClass") != null && (inputParamsReport.get("object_guid") != null || inputParamsReport.get("printer_name") != null)) {
                inputParamsReport.put("domainName", domainName);
                HashMap<String, Object> inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParamsReport, domainName, reportId);
                if (inputParamsReport.get("selectedObj") == null) {
                    selectedObjList = new ArrayList();
                } else {
                    selectedObjList = (ArrayList)inputParamsReport.get("selectedObj");
                    if (selectedObjList.size() > 0) {
                        HashMap obj = (HashMap)selectedObjList.get(0);
                        topSelectedObj = (String)obj.get("name");
                    }
                }
            }
            HashMap<Object, Object> reportElementMap = new HashMap();
            reportElementMap = ReportHandlerUtil.getInstance().getReportInputModalList(elementList, rb);
            if (!isRealTimeReport.booleanValue()) {
                HashMap timeMap = (HashMap)reportElementMap.get("periodList");
                inputParams.put("periodList", timeMap.get("clientValues"));
                JSONArray timeList = ReportHandlerUtil.getInstance().getTimePeriods((ArrayList)timeMap.get("serverValues"), (ArrayList)timeMap.get("clientValues"));
                inputParams.put("timeList", timeList);
            }
            inputParams.put("reportId", reportId);
            inputParams.put("domainName", domainName);
            inputParams.put("reportDetailsMap", reportMap);
            inputParams.put("tableViewConfig", tableViewConfig);
            inputParams.put("cvIdList", cvIdList);
            HashMap<String, Object> periodMap = ReportHandlerUtil.getInstance().setTimePeriod(inputParamsReport);
            inputParams.put("startDate", periodMap.get("FROM"));
            inputParams.put("endDate", periodMap.get("TO"));
            inputParams.put("chosenServerValue", periodMap.get("serverValue"));
            if (inputParamsReport.get("objectName") == null) {
                inputParamsReport.put("objectName", "");
            }
            JSONArray myReportCategories = ReportHandlerUtil.getInstance().getMyReportCategories();
            inputParams.put("myReportCategories", myReportCategories);
            if (myReportCategories.length() > 0) {
                inputParams.put("selectedCategoryName", myReportCategories.getJSONObject(0).get("name"));
            } else {
                inputParams.put("selectedCategoryName", "");
            }
            Boolean saclStatus = true;
            if (reportMap.get("SACL_ALERT_OBJ_CLASS") != null && !reportMap.get("SACL_ALERT_OBJ_CLASS").equals("")) {
                saclStatus = AuditDelegationUtil.getDelegationStatus((String)domainName, (String)((String)reportMap.get("SACL_ALERT_OBJ_CLASS")));
                inputParams.put("saclObjectClass", reportMap.get("SACL_ALERT_OBJ_CLASS"));
            }
            if (!saclStatus.booleanValue()) {
                inputParams.put("message", rb.getString("adap.configuration.report_profiles.object_level_ad_auditing_needs_to_configure_for_getting_proper_reports"));
                inputParams.put("linkMessage", rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                inputParams.put("type", "info");
                inputParams.put("actionName", "configureSACL");
            }
            if (reportCategoryId != null && reportCategoryId.equals(15L)) {
                inputParams.put("message", rb.getString("adap.common.text.2k12_Support_Alert"));
                inputParams.put("type", "info");
            }
            Boolean isFimEnabled = FileIntegrityManager.getInstance().isFIMEnabledInDomain(domainName);
            if (reportCategoryId.equals(20L) && !isFimEnabled.booleanValue()) {
                inputParams.put("message", rb.getString("adap.reports.FIM_not_configure_msg"));
                inputParams.put("type", "info");
                inputParams.put("linkMessage", rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                inputParams.put("actionName", "transitToFIM");
            } else if (reportCategoryId.equals(20L) && isFimEnabled.booleanValue()) {
                inputParams.put("message", rb.getString("adap.reports.FIM_audit_policy_alert_msg"));
                inputParams.put("type", "info");
                inputParams.put("linkMessage", rb.getString("adap.DomainConfiguration.Know_More"));
                inputParams.put("actionName", "openHelp");
                inputParams.put("helpType", "fim");
            }
            Integer reportType = (Integer)reportMap.get("REPORT_TYPE");
            if (reportType == 3 && PrintHandler.getConfiguredServerCount((String)domainName, null) == 0) {
                inputParams.put("message", rb.getString("adap.common.No_Printer_Server"));
                inputParams.put("type", "info");
                inputParams.put("linkMessage", rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                inputParams.put("actionName", "transitToPrintServer");
            }
            if (reportType == 2 && !PDCHandler.isGPMCInstalled().booleanValue()) {
                inputParams.put("message", rb.getString("adap_reports_no_gpmc_installed") + "." + rb.getString("adap_reports_after_you_install_gpmc"));
                inputParams.put("type", "info");
                inputParams.put("linkMessage", rb.getString("adap.common.text.policy_update_link.click_here"));
                inputParams.put("actionName", "updateGPMC");
            }
            String pdcName = null;
            pdcName = PDCHandler.getInstance().getPDCName(domainName, Boolean.valueOf(false));
            if (reportType == 2 && pdcName == null) {
                inputParams.put("message", rb.getString("adap.GPOHandler.Not_able_to_find_PDC"));
                inputParams.put("type", "info");
                inputParams.put("linkMessage", rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                inputParams.put("actionName", "showPdc");
            }
            boolean isEvalPeriod = LicenseUtil.isProfEvalPeriod();
            String licenseString = LicenseUtil.getLicenseType();
            String licenseTypeStr = LicenseUtil.getLicenseTypeString();
            JSONObject profLicenseAlertParams = new JSONObject();
            Integer licenseType = (Integer)reportMap.get("LICENSE_TYPE");
            if ((licenseString.equals("T") && licenseTypeStr.equals("Professional") || !licenseTypeStr.equals("Professional") && isEvalPeriod) && licenseType == 2) {
                profLicenseAlertParams.put("message", (Object)rb.getString("adap.AuditReports.Professional_Editon_Reports"));
                profLicenseAlertParams.put("type", (Object)"info");
                profLicenseAlertParams.put("linkMessage", (Object)rb.getString("adap.configuratoin.view_servers.view_member_servers.learn_more.button_text"));
                profLicenseAlertParams.put("actionName", (Object)"openProReportHelp");
            }
            inputParams.put("profLicenseAlertParams", profLicenseAlertParams);
            ArrayList fileCreationReports = AuditReportAPI.getInstance().getFileCreationReports();
            if (fileCreationReports.contains(reportId) && (lastFileUpdateTime = SchedulerUtil.getLastFileUpdateTime()) != null) {
                String timeString = lastFileUpdateTime;
                timeString = timeString.equalsIgnoreCase("-") ? rb.getString("adap.Reports.Audit_Reports.File_Creation_Audit_Scheduler_run_on") + " : -" : rb.getString("adap.Reports.Audit_Reports.File_Creation_Audit_Scheduler_run_on") + " : " + timeString;
                String IsFileUpdateSchedulerRunning = ADSMPersUtil.getSyMParameter((String)"IsFileUpdateSchedulerRunning");
                inputParams.put("linkMessage", "[Run Now]");
                inputParams.put("actionName", "fileCreationRunNow");
                if (IsFileUpdateSchedulerRunning != null && IsFileUpdateSchedulerRunning.equals("true")) {
                    timeString = timeString + " [Running]";
                    inputParams.remove("linkMessage");
                    inputParams.remove("actionName");
                }
                inputParams.put("message", timeString);
                inputParams.put("type", "info");
            }
            String string = fromTime = (settingsMap = BusinessServerSettings.getBusinessHourSettings()).isEmpty() ? "" : (String)settingsMap.get("FromTime");
            if (fromTime.equals("")) {
                inputParams.put("isBusinessHourConfigured", false);
            } else {
                inputParams.put("isBusinessHourConfigured", true);
            }
            String timeString = "";
            if (!isRealTimeReport.booleanValue()) {
                timeString = rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDate((Long)(Long.parseLong(inputParams.get("startDate").toString()) * 1000L)), TimeUtil.formatDate((Long)(Long.parseLong(inputParams.get("endDate").toString()) * 1000L))});
            } else {
                timeString = rb.getString("adap.common.text.realTime");
                inputParams.put("isRealTimeReport", isRealTimeReport);
            }
            inputParams.put("timeString", timeString);
            if (reportMap.get("DOMAIN_DISPLAY_TYPE") == null) {
                inputParams.put("showDomain", false);
            } else {
                inputParams.put("showDomain", true);
            }
            if (reportCategoryType != 1) {
                inputParams.put("showMakeAsDefaultReport", false);
            } else {
                inputParams.put("showMakeAsDefaultReport", true);
            }
            inputParams.put("saclStatus", saclStatus);
            if (inputParamsReport.get("objectClass") == null) {
                inputParamsReport.put("objectClass", "");
            }
            if (inputParamsReport.get("object_guid") == null) {
                inputParamsReport.put("object_guid", "");
            }
            inputParams.put("objectInput", true);
            if (inputParamsReport.get("objectClass") == null || inputParamsReport.get("objectClass").equals("")) {
                inputParams.put("objectInput", false);
            }
            ReportHandlerUtil.getInstance().getChartInputList(inputParams, rb);
            inputParams.put("reportType", (String)reportMap.get("TILE_NAME"));
            inputParams.put("objectName", inputParamsReport.get("objectName"));
            inputParams.put("objectClass", inputParamsReport.get("objectClass"));
            inputParams.put("object_guid", inputParamsReport.get("object_guid"));
            inputParams.put("selectedObjList", selectedObjList);
            inputParams.put("topSelectedObj", topSelectedObj);
            inputParams.put("selectedHour", 0);
            inputParams.put("FROM", periodMap.get("FROM"));
            inputParams.put("TO", periodMap.get("FROM"));
            inputParams.put("reportCategoryType", reportCategoryType);
            inputParams.put("businessHour", 0);
            AuditReportAPI.getInstance().updateFrequentViewReports(reportId, (Long)request.getSession().getAttribute("ADAP_SESSION_LOGIN_ID"));
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_viewed", new String[]{rb.getString(reportMap.get("AUDIT_REPORT_NAME").toString()), domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_generated", "-"}));
            returnListMap.put("inputParams", inputParams);
            returnListMap.put("reportInputModalList", reportElementMap.get("inputModalList"));
            returnListMap.put("elementList", reportElementMap.get("elementList"));
            returnListMap.put("tabList", reportTabList);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSearchCriteria(JSONObject reportReqData, ArrayList<HashMap<String, Object>> tableAllColumnList, Boolean needSearchCriteria) throws Exception {
        String searchCriteria = null;
        JSONObject searchData = null;
        if (reportReqData.has("searchData")) {
            searchData = reportReqData.getJSONObject("searchData");
            for (HashMap<String, Object> tableconfig : tableAllColumnList) {
                TableDefinition tableDefinition;
                String columnName = tableconfig.get("columnalias").toString();
                String tableName = null;
                if (tableconfig.get("tablealias") != null) {
                    tableName = tableconfig.get("tablealias").toString();
                }
                if (!searchData.has(columnName)) continue;
                String columnSearchValue = searchData.get(columnName).toString();
                tableconfig.put("searchValue", searchData.get(columnName).toString());
                String dataType = null;
                if (tableName != null && (tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName)) != null) {
                    ColumnDefinition columnDefinition = tableDefinition.getColumnDefinitionByName(columnName);
                    String string = dataType = columnDefinition != null ? columnDefinition.dataTypeStr() : null;
                }
                if (columnSearchValue == null || columnSearchValue.equalsIgnoreCase("")) continue;
                if (needSearchCriteria.booleanValue()) {
                    columnSearchValue = CommonUtil.getSearchString((String)columnSearchValue);
                    searchCriteria = searchCriteria == null ? new String() : searchCriteria + " AND ";
                    searchCriteria = searchCriteria + ReportHandlerUtil.getInstance().getSearchString(columnName, columnSearchValue, dataType);
                    continue;
                }
                searchCriteria = CommonUtil.getSearchString((String)columnSearchValue);
            }
        }
        if (reportReqData.has("advSearchData")) {
            String mySearchCriteria = null;
            searchData = reportReqData.getJSONObject("advSearchData");
            JSONArray searchGroups = searchData.getJSONArray("searchGroups");
            String nextOperator = "";
            for (int i = 0; i < searchGroups.length(); ++i) {
                JSONObject searchGroup = searchGroups.getJSONObject(i);
                String searchValue = searchGroup.getString("searchValue");
                if (searchValue == null || searchValue.trim().equals("")) continue;
                if (mySearchCriteria == null) {
                    mySearchCriteria = "";
                }
                mySearchCriteria = mySearchCriteria + " " + nextOperator + " ";
                nextOperator = searchGroup.getString("searchOperator");
                for (int o = 0; o < searchGroup.getJSONArray("openBraces").length(); ++o) {
                    mySearchCriteria = mySearchCriteria + " ( ";
                }
                String searchColumn = searchGroup.getString("searchColumn");
                searchColumn = searchColumn.substring(searchColumn.indexOf(".") + 1);
                mySearchCriteria = mySearchCriteria + searchColumn;
                String searchType = searchGroup.getString("searchType");
                searchValue = EscapeUtil.escSplCharsAsSQLForLike((Object)searchValue);
                mySearchCriteria = searchType != null ? (searchType.equals("startswith") ? mySearchCriteria + " LIKE '" + searchValue + "%'" : (searchType.equals("endswith") ? mySearchCriteria + " LIKE '%" + searchValue + "'" : (searchType.equals("notstartswith") ? mySearchCriteria + " NOT LIKE '" + searchValue + "%'" : (searchType.equals("notendswith") ? mySearchCriteria + " NOT LIKE '%" + searchValue + "'" : (searchType.equals("is") ? mySearchCriteria + " LIKE '" + searchValue + "'" : (searchType.equals("notis") ? mySearchCriteria + " NOT LIKE '%" + searchValue + "'" : (searchType.equals("contains") ? mySearchCriteria + " LIKE '%" + searchValue + "%'" : (searchType.equals("notcontains") ? mySearchCriteria + " NOT LIKE '%" + searchValue + "%'" : (searchType.equals("equals") ? mySearchCriteria + " = " + searchValue : (searchType.equals("notequals") ? mySearchCriteria + " != " + searchValue : (searchType.equals("greaterthan") ? mySearchCriteria + " > " + searchValue : (searchType.equals("lesserthan") ? mySearchCriteria + " < " + searchValue : (searchType.equals("greaterthanorequals") ? mySearchCriteria + " >= " + searchValue : (searchType.equals("lesserthanorequals") ? mySearchCriteria + " <= " + searchValue : mySearchCriteria + " LIKE '%" + searchValue + "%'")))))))))))))) : mySearchCriteria + " LIKE '%" + searchValue + "%'";
                for (int o = 0; o < searchGroup.getJSONArray("closeBraces").length(); ++o) {
                    mySearchCriteria = mySearchCriteria + " ) ";
                }
            }
            if (mySearchCriteria != null) {
                searchCriteria = " ( " + mySearchCriteria + " ) ";
                reportLogger.log(Level.INFO, "Advanced Search Criteria : " + searchCriteria);
            }
        }
        return searchCriteria;
    }

    public JSONObject getAdvSearchOptions(JSONObject tabInputParams, ArrayList<HashMap<String, Object>> tableAllColumnList, AdventNetResourceBundle rb) throws Exception {
        JSONObject tableSearchOptions = new JSONObject();
        if (tabInputParams.has("advSearchData")) {
            tableSearchOptions = tabInputParams.getJSONObject("advSearchData");
        } else {
            JSONArray columnsList = new JSONArray();
            JSONArray nonCharColumns = new JSONArray();
            for (int i = 0; i < tableAllColumnList.size(); ++i) {
                TableDefinition tableDefinition;
                HashMap<String, Object> column = tableAllColumnList.get(i);
                if (((Boolean)column.get("bgcolumn")).booleanValue() || !((Boolean)column.get("visible")).booleanValue() || !((Boolean)column.get("searchenabled")).booleanValue()) continue;
                JSONObject searchRowColumn = new JSONObject();
                String tableName = (String)column.get("tablealias");
                String columnName = (String)column.get("columnalias");
                if (tableName == null) {
                    searchRowColumn.put("value", (Object)columnName);
                } else {
                    searchRowColumn.put("value", (Object)(tableName + "." + columnName));
                }
                searchRowColumn.put("name", column.get("displayname"));
                columnsList.put((Object)searchRowColumn);
                String dataType = null;
                if (tableName != null && (tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName)) != null) {
                    ColumnDefinition columnDefinition = tableDefinition.getColumnDefinitionByName(columnName);
                    String string = dataType = columnDefinition != null ? columnDefinition.dataTypeStr() : null;
                }
                if (dataType == null || dataType.toLowerCase().indexOf("char") != -1) continue;
                nonCharColumns.put((Object)(tableName + "." + columnName));
            }
            String[] searchTypesArr = new String[]{"contains", "notcontains", "startswith", "notstartswith", "endswith", "notendswith", "is", "notis"};
            String searchTypesStr = "";
            for (int i = 0; i < searchTypesArr.length; ++i) {
                searchTypesStr = searchTypesStr + "{name:'" + rb.getString("adap.advsearch.searchtypes." + searchTypesArr[i]) + "',value:'" + searchTypesArr[i] + "'},";
            }
            JSONArray searchTypes = new JSONArray("[" + searchTypesStr.substring(0, searchTypesStr.length() - 1) + "]");
            String[] integerSearchTypesArr = new String[]{"equals", "notequals", "greaterthan", "lesserthan", "greaterthanorequals", "lesserthanorequals"};
            String integerSearchTypesStr = "";
            for (int i = 0; i < integerSearchTypesArr.length; ++i) {
                integerSearchTypesStr = integerSearchTypesStr + "{name:'" + rb.getString("adap.advsearch.searchtypes." + integerSearchTypesArr[i]) + "',value:'" + integerSearchTypesArr[i] + "'},";
            }
            JSONArray integerSearchTypes = new JSONArray("[" + integerSearchTypesStr.substring(0, integerSearchTypesStr.length() - 1) + "]");
            JSONArray searchOperators = new JSONArray("[{name:'" + rb.getString("adap.advsearch.operator.and") + "',value:'AND'},{name:'" + rb.getString("adap.advsearch.operator.or") + "',value:'OR'}]");
            JSONObject emptySearchGroup = new JSONObject();
            emptySearchGroup.put("openBraces", (Object)new JSONArray());
            emptySearchGroup.put("searchColumn", ((JSONObject)columnsList.get(0)).get("value"));
            emptySearchGroup.put("searchType", (Object)"contains");
            emptySearchGroup.put("searchValue", (Object)"");
            emptySearchGroup.put("closeBraces", (Object)new JSONArray());
            emptySearchGroup.put("searchOperator", (Object)"AND");
            tableSearchOptions.put("columnsList", (Object)columnsList);
            tableSearchOptions.put("nonCharColumns", (Object)nonCharColumns);
            tableSearchOptions.put("searchTypes", (Object)searchTypes);
            tableSearchOptions.put("integerSearchTypes", (Object)integerSearchTypes);
            tableSearchOptions.put("searchOperators", (Object)searchOperators);
            tableSearchOptions.put("emptySearchGroup", (Object)emptySearchGroup);
            tableSearchOptions.put("searchGroups", (Object)new JSONArray());
        }
        return tableSearchOptions;
    }

    public void getFileSummaryDrillDown(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject tabInputParams = reportReqData.getJSONObject("tabInputParams");
            String cvidString = reportReqData.getString("cvId");
            JSONObject ret = EmberTableConfig.getInstance().getEmberTableData(cvidString, new ArrayList(), new JSONObject(), rb);
            String uvhString = "AUDCVConfig:cv_id:" + cvidString;
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            tabInputParams.put("cvId", (Object)cvId);
            tabInputParams.put("startValue", 1);
            tabInputParams.put("showSearch", true);
            tabInputParams.put("showSearchMethod", (Object)"searchAction");
            JSONArray rangeList = new JSONArray();
            for (int i = 0; i < 4; ++i) {
                JSONObject rangeItem = new JSONObject();
                rangeItem.put("value", (i + 1) * 25);
                rangeList.put((Object)rangeItem);
            }
            tabInputParams.put("rangeList", (Object)rangeList);
            tabInputParams.put("reportName", (Object)("drill down report" + cvId));
            tabInputParams.put("tabName", (Object)("tabName_drilldown" + cvId));
            tabInputParams.put("tabIdh", (Object)("tabIdh_drilldown" + cvId));
            tabInputParams.put("tabId", (Object)("tabId_drilldown" + cvId));
            Iterator i1 = ret.getJSONObject("tableInputParams").keys();
            while (i1.hasNext()) {
                String keyToInsert = (String)i1.next();
                tabInputParams.put(keyToInsert, ret.getJSONObject("tableInputParams").get(keyToInsert));
            }
            request.setAttribute("tabInputParams", (Object)tabInputParams);
            this.getReportData(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportData(HttpServletRequest request, HttpServletResponse response) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("reportInputParams");
            JSONObject tabInputParams = new JSONObject();
            tabInputParams = request.getAttribute("tabInputParams") != null ? (JSONObject)request.getAttribute("tabInputParams") : reportReqData.getJSONObject("tabInputParams");
            Long reportId = reportInputParams.getLong("reportId");
            Long cvId = tabInputParams.getLong("cvId");
            if (reportInputParams.getString("reportType").equals("report")) {
                Long subReportId;
                String businessCriteria;
                String guidStr;
                if (reportInputParams.has("domainChanged") && reportInputParams.getBoolean("domainChanged")) {
                    Long reportCategoryId;
                    reportInputParams.remove("message");
                    reportInputParams.remove("linkMessage");
                    reportInputParams.remove("type");
                    reportInputParams.remove("actionName");
                    tabInputParams.remove("xColumnValue");
                    tabInputParams.remove("searchCriteria");
                    tabInputParams.remove("inputData");
                    tabInputParams.remove("filterText");
                    JSONObject reportMap = reportInputParams.getJSONObject("reportDetailsMap");
                    Boolean saclStatus = true;
                    if (reportMap.has("SACL_ALERT_OBJ_CLASS") && reportMap.get("SACL_ALERT_OBJ_CLASS") != null && !reportMap.get("SACL_ALERT_OBJ_CLASS").equals("")) {
                        saclStatus = AuditDelegationUtil.getDelegationStatus((String)reportInputParams.getString("domainName"), (String)reportMap.getString("SACL_ALERT_OBJ_CLASS"));
                        reportInputParams.put("saclObjectClass", reportMap.get("SACL_ALERT_OBJ_CLASS"));
                    }
                    if (!saclStatus.booleanValue()) {
                        reportInputParams.put("message", (Object)rb.getString("adap.configuration.report_profiles.object_level_ad_auditing_needs_to_configure_for_getting_proper_reports"));
                        reportInputParams.put("linkMessage", (Object)"Configure");
                        reportInputParams.put("type", (Object)"info");
                        reportInputParams.put("actionName", (Object)"configureSACL");
                    }
                    if ((reportCategoryId = Long.valueOf(reportMap.getLong("REPORT_CATEGORY_ID"))) != null && reportCategoryId.equals(15L)) {
                        reportInputParams.put("message", (Object)rb.getString("adap.common.text.2k12_Support_Alert"));
                        reportInputParams.put("type", (Object)"info");
                    }
                    Boolean isFimEnabled = FileIntegrityManager.getInstance().isFIMEnabledInDomain(reportInputParams.getString("domainName"));
                    if (reportCategoryId.equals(20L) && !isFimEnabled.booleanValue()) {
                        reportInputParams.put("message", (Object)rb.getString("adap.reports.FIM_not_configure_msg"));
                        reportInputParams.put("type", (Object)"info");
                        reportInputParams.put("linkMessage", (Object)rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                        reportInputParams.put("actionName", (Object)"transitToFIM");
                    } else if (reportCategoryId.equals(20L) && isFimEnabled.booleanValue()) {
                        reportInputParams.put("message", (Object)rb.getString("adap.reports.FIM_audit_policy_alert_msg"));
                        reportInputParams.put("type", (Object)"info");
                        reportInputParams.put("linkMessage", (Object)rb.getString("adap.DomainConfiguration.Know_More"));
                        reportInputParams.put("actionName", (Object)"openHelp");
                        reportInputParams.put("helpType", (Object)"fim");
                    }
                    Integer reportType = reportMap.getInt("REPORT_TYPE");
                    if (reportType == 3 && PrintHandler.getConfiguredServerCount((String)reportInputParams.getString("domainName"), null) == 0) {
                        reportInputParams.put("message", (Object)rb.getString("adap.common.No_Printer_Server"));
                        reportInputParams.put("type", (Object)"info");
                        reportInputParams.put("linkMessage", (Object)rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                        reportInputParams.put("actionName", (Object)"transitToPrintServer");
                    }
                    String pdcName = null;
                    pdcName = PDCHandler.getInstance().getPDCName(reportInputParams.getString("domainName"), Boolean.valueOf(false));
                    if (reportType == 2 && pdcName == null) {
                        reportInputParams.put("message", (Object)rb.getString("adap.GPOHandler.Not_able_to_find_PDC"));
                        reportInputParams.put("type", (Object)"info");
                        reportInputParams.put("linkMessage", (Object)rb.getString("adap.HomeAlertDiv.text.ConfigureAlert"));
                        reportInputParams.put("actionName", (Object)"showPdc");
                    }
                    reportInputParams.put("domainChanged", false);
                }
                if (reportInputParams.has("isSaveCustomPeriod") && reportInputParams.getBoolean("isSaveCustomPeriod")) {
                    ReportHandlerUtil.getInstance().saveCustomPeriod(reportInputParams.getString("customPeriodName"), reportInputParams.getLong("startDate"), reportInputParams.getLong("endDate"), reportInputParams, rb);
                }
                Boolean isRealTimeReport = false;
                if (reportInputParams.has("isRealTimeReport")) {
                    isRealTimeReport = reportInputParams.getBoolean("isRealTimeReport");
                }
                String timeString = "";
                timeString = isRealTimeReport == false ? rb.handleGetObject("adap.Reports.AuditReports.From_Time_To_Time", new String[]{TimeUtil.formatDate((Long)(Long.parseLong(reportInputParams.getString("startDate")) * 1000L)), TimeUtil.formatDate((Long)(Long.parseLong(reportInputParams.getString("endDate")) * 1000L))}) : rb.getString("adap.common.text.realTime");
                reportInputParams.put("timeString", (Object)timeString);
                JSONArray objectGuids = reportInputParams.optJSONArray("object_guid");
                ArrayList objectGuidList = null;
                objectGuidList = objectGuids != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList();
                HashMap<String, Object> inputParams = new HashMap<String, Object>();
                inputParams.put("objectClass", reportInputParams.getString("objectClass"));
                inputParams.put("object_guid", objectGuidList);
                inputParams.put("domainName", reportInputParams.getString("domainName"));
                inputParams.put("objectName", reportInputParams.getString("objectName"));
                if (!isRealTimeReport.booleanValue()) {
                    inputParams.put("FROM", reportInputParams.getString("startDate"));
                    inputParams.put("TO", reportInputParams.getString("endDate"));
                }
                if (reportInputParams.has("isSelectAllSelected")) {
                    if (reportInputParams.getBoolean("isSelectAllSelected")) {
                        inputParams.put("allObjectSelected", reportInputParams.getString("isSelectAllSelected"));
                    } else {
                        inputParams.remove("allObjectSelected");
                    }
                }
                HashMap inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, reportInputParams.getString("domainName"), reportId);
                if (!isRealTimeReport.booleanValue()) {
                    inputParamsMap.put((String)"FROM", (Object)reportInputParams.getString("startDate"));
                    inputParamsMap.put((String)"TO", (Object)reportInputParams.getString("endDate"));
                } else {
                    inputParamsMap.put((String)"guidStr", (Object)("'" + reportInputParams.getString("genId") + "'"));
                }
                inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputParams, inputParamsMap, (Long)reportId);
                Long gpoCvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:7016");
                if (cvId.equals(gpoCvId) && (guidStr = (String)inputParamsMap.get("guidStr")) != null) {
                    guidStr = guidStr.replaceAll("\\%", "");
                    inputParamsMap.put("guidStr", guidStr);
                }
                String searchCriteria = null;
                HashMap tableViewConfig = JSONUtil.JSONObjectToMap((JSONObject)((JSONObject)reportInputParams.get("tableViewConfig")));
                if (!tabInputParams.has("sortColumn")) {
                    String sortColumn = (String)tableViewConfig.get("SORTCOLUMN");
                    String sortOrder = (String)tableViewConfig.get("SORTORDER");
                    tabInputParams.put("sortColumn", (Object)sortColumn);
                    tabInputParams.put("sortOrder", (Object)sortOrder);
                }
                ArrayList columnList = AuditReportAPI.getInstance().getVisibleColumnList(cvId);
                block2: for (int i = 0; i < columnList.size() && !tabInputParams.get("sortColumn").toString().equalsIgnoreCase(((HashMap)columnList.get(i)).get("COLUMNALIAS").toString()); ++i) {
                    if (i != columnList.size() - 1) continue;
                    for (int j = 0; j < columnList.size(); ++j) {
                        if (!((HashMap)columnList.get(j)).get("SORTENABLED").toString().equalsIgnoreCase("true")) continue;
                        tabInputParams.put("sortColumn", (Object)((HashMap)columnList.get(j)).get("COLUMNALIAS").toString());
                        continue block2;
                    }
                }
                ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, tabInputParams.getString("sortColumn"), tabInputParams.getString("sortOrder"), rb);
                Boolean isSearch = false;
                if (tabInputParams.has("fileSummaryCriteria")) {
                    searchCriteria = tabInputParams.getString("fileSummaryCriteria");
                    String addnsearchCriteria = this.getSearchCriteria(tabInputParams, tableAllColumnList, true);
                    if (addnsearchCriteria != null) {
                        isSearch = true;
                        searchCriteria = searchCriteria + " AND " + addnsearchCriteria;
                    }
                } else {
                    searchCriteria = this.getSearchCriteria(tabInputParams, tableAllColumnList, true);
                    if (searchCriteria != null) {
                        isSearch = true;
                    }
                }
                Integer businessHour = reportInputParams.optInt("businessHour");
                String businessHourString = "";
                if (businessHour != null) {
                    if (businessHour == 0) {
                        businessHourString = "false";
                    } else if (businessHour == 1) {
                        businessHourString = "business";
                    } else if (businessHour == 2) {
                        businessHourString = "nonbusiness";
                    }
                }
                if (!reportInputParams.has("defaultflag")) {
                    Boolean defaultflag = this.checkDefaultFlag(cvId);
                    reportInputParams.put("defaultflag", (Object)defaultflag);
                }
                if ((businessCriteria = ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria(businessHourString, true)) != null && cvId.equals(DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15050"))) {
                    inputParamsMap.put("searchCritBusiness", businessCriteria);
                }
                if (businessCriteria != null) {
                    searchCriteria = searchCriteria != null ? searchCriteria + " AND " + businessCriteria : businessCriteria;
                }
                String inputData = tabInputParams.optString("inputData");
                String countSqlString = null;
                String unionSqlString = null;
                int count = 0;
                if (inputData != null && !inputData.equals("")) {
                    DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvId);
                    Row row = cvDO.getRow("AUDSQLQuery");
                    long queryId = (Long)row.get("QUERY_ID");
                    countSqlString = ADAPSQLQueryUtil.getUnionQueryStackedBarChart((String)inputData, (String)"countString", (Long)queryId);
                    unionSqlString = ADAPSQLQueryUtil.getUnionQueryStackedBarChart((String)inputData, (String)"sqlString", (Long)queryId);
                }
                ArrayList<HashMap<String, ArrayList<HashMap<String, Object>>>> reportsList = new ArrayList<HashMap<String, ArrayList<HashMap<String, Object>>>>();
                String objectName = (String)inputParamsMap.get("objectName");
                if (!reportInputParams.getBoolean("objectInput") || objectName != null && objectName.length() > 0) {
                    if (countSqlString != null) {
                        count = AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, inputParamsMap, countSqlString);
                    } else {
                        searchCriteria = ReportHandlerUtil.getInstance().getSearchCriteria(tabInputParams, searchCriteria);
                        count = AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, inputParamsMap);
                    }
                    if (count > 0) {
                        reportsList = AuditReportAPI.getInstance().getReportRows(cvId, searchCriteria, inputParamsMap, tabInputParams.getString("sortColumn"), tabInputParams.getString("sortOrder"), Integer.parseInt(tabInputParams.getString("startValue")), Integer.parseInt(tabInputParams.getString("rangeValue")), unionSqlString, count, Boolean.valueOf(true));
                    }
                }
                if (count == 0) {
                    tabInputParams.put("emptyTableMessage", (Object)rb.getString("adap.ChartUtil.No_Data_Available"));
                    tabInputParams.put("emptyTableMessage2", (Object)rb.getString("adap.Reports.ReportResultRows.Click_here_to_TroubleShoot"));
                    tabInputParams.put("emptyTableAction", (Object)"emptyTableAction");
                }
                if (null != (subReportId = MultiRowTransformer.getSubReportCvId(tableAllColumnList)) && subReportId != 0L && AuditReportAPI.subReportList.contains(subReportId)) {
                    boolean b = !subReportId.equals(DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)"AUDCVConfig:cv_id:15051"));
                    ArrayList<HashMap<String, Object>> subcolumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(subReportId, b, true, false, tabInputParams.getString("sortColumn"), tabInputParams.getString("sortOrder"), rb);
                    for (HashMap<String, Object> map : subcolumnList) {
                        HashMap cloneMap = (HashMap)map.clone();
                        if (!b) {
                            cloneMap.put("visible", true);
                        }
                        tableAllColumnList.add(cloneMap);
                    }
                    if (!b && count > (reportsList = this.getLogonDurationSubReport((ArrayList<HashMap<String, ArrayList<HashMap>>>)reportsList, subcolumnList)).size()) {
                        count -= reportsList.size();
                    }
                }
                tabInputParams.put("totalCount", count);
                tabInputParams.put("isSearch", (Object)isSearch);
                tabInputParams.put("searchCriteria", (Object)searchCriteria);
                HashMap<String, ArrayList<HashMap<String, Object>>> returnListMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                returnListMap.put("reportData", reportsList);
                returnListMap.put("reportColumnList", tableAllColumnList);
                returnListMap.put("tableSearchOptions", (ArrayList<HashMap<String, Object>>)this.getAdvSearchOptions(tabInputParams, tableAllColumnList, rb));
                returnListMap.put("inputParams", (ArrayList<HashMap<String, Object>>)reportInputParams);
                returnListMap.put("tabInputParams", (ArrayList<HashMap<String, Object>>)tabInputParams);
                JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
            } else if (reportInputParams.getString("reportType").equalsIgnoreCase("matrix")) {
                String searchCriteria = null;
                HashMap<String, String> addnSQLPropsMap = new HashMap<String, String>();
                addnSQLPropsMap.put("sortOrder", "DESC");
                HashMap<String, Object> inputParams = new HashMap<String, Object>();
                inputParams.put("domainName", reportInputParams.getString("domainName"));
                inputParams.put("FROM", reportInputParams.getString("startDate"));
                inputParams.put("TO", reportInputParams.getString("endDate"));
                HashMap<String, Object> inputParamsMap = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, reportInputParams.getString("domainName"), reportId);
                inputParamsMap.put("FROM", reportInputParams.getString("startDate"));
                inputParamsMap.put("TO", reportInputParams.getString("endDate"));
                reportInputParams.put("showAddOrRemove", false);
                tabInputParams.put("rangeList", (Object)new JSONArray());
                tabInputParams.put("rangeValue", 25);
                if (reportInputParams.has("isDataLoaded") && reportInputParams.getBoolean("isDataLoaded")) {
                    this.getMatrixDetails(request, response, reportInputParams, tabInputParams);
                } else {
                    MatrixReportHandler.generateMatrixReport((HttpServletRequest)request, (Long)reportId, inputParamsMap, searchCriteria, addnSQLPropsMap, (Long)cvId);
                    reportInputParams.put("isDataLoaded", true);
                }
                this.formPivotData(request, response, reportInputParams, tabInputParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getMatrixDetails(HttpServletRequest request, HttpServletResponse response, JSONObject reportInputParams, JSONObject tabInputParams) throws Exception {
        try {
            String column_value;
            MatrixReportParams matrixParams = (MatrixReportParams)request.getSession().getAttribute("matrixParams");
            Boolean isSearch = false;
            String searchCriteria = null;
            JSONObject searchData = null;
            if (tabInputParams.has("searchData") && (searchData = tabInputParams.getJSONObject("searchData")).has(column_value = tabInputParams.getString("firstColumn"))) {
                searchCriteria = searchData.get(column_value).toString();
            }
            if (searchCriteria != null) {
                isSearch = true;
            }
            tabInputParams.put("isSearch", (Object)isSearch);
            if (isSearch.booleanValue()) {
                matrixParams.setFirstColValList((Map)matrixParams.getFirstColMap(), searchCriteria);
            } else {
                matrixParams.setFirstColValList((Map)matrixParams.getFirstColMap(), null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void formPivotData(HttpServletRequest request, HttpServletResponse response, JSONObject reportInputParams, JSONObject tabInputParams) throws Exception {
        try {
            MatrixReportParams matrixParams = (MatrixReportParams)request.getSession().getAttribute("matrixParams");
            LinkedHashMap pivotalMap = matrixParams.getPivotDetails();
            ArrayList firstColValList = matrixParams.getFirstColValList();
            Integer range = 100;
            ArrayList columnNameList = matrixParams.getColumnNamesList();
            HashMap columnDetails = matrixParams.getColumnDetails();
            int columnSize = columnNameList.size();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Integer fromIndex = tabInputParams.getInt("startValue");
            tabInputParams.put("totalCount", firstColValList.size());
            ArrayList tableColumnList = null;
            tableColumnList = new ArrayList();
            ArrayList rowList = new ArrayList();
            if (firstColValList.size() > 0) {
                HashMap<String, Object> col1 = new HashMap<String, Object>();
                String firstColumn = rb.getString((String)((HashMap)columnDetails.get("LEFT_COL_DETAILS")).get("COLUMN_DISPLAY_NAME")) + "/" + rb.getString((String)((HashMap)columnDetails.get("TOP_COL_DETAILS")).get("COLUMN_DISPLAY_NAME"));
                tabInputParams.put("firstColumn", (Object)firstColumn);
                col1.put("displayname", firstColumn);
                col1.put("columnalias", firstColumn);
                col1.put("sortenabled", false);
                Integer columnDataType = (Integer)((HashMap)columnDetails.get("LEFT_COL_DETAILS")).get("COLUMN_DATA_TYPE");
                if (columnDataType == 1001 || columnDataType == 1005) {
                    col1.put("searchenabled", true);
                } else {
                    col1.put("searchenabled", false);
                }
                if (tabInputParams.has("isSearch") && tabInputParams.getBoolean("isSearch")) {
                    col1.put("searchValue", tabInputParams.getJSONObject("searchData").getString(firstColumn));
                }
                col1.put("visible", true);
                tableColumnList.add(col1);
                for (int column = 0; column < columnSize; ++column) {
                    HashMap<String, Object> col2 = new HashMap<String, Object>();
                    col2.put("displayname", columnNameList.get(column));
                    col2.put("columnalias", columnNameList.get(column));
                    col2.put("sortenabled", false);
                    col2.put("searchenabled", false);
                    col2.put("visible", true);
                    tableColumnList.add(col2);
                }
                HashMap<String, Object> col3 = new HashMap<String, Object>();
                col3.put("displayname", "Grand Total");
                col3.put("columnalias", "Grand Total");
                col3.put("sortenabled", false);
                col3.put("searchenabled", false);
                col3.put("visible", true);
                tableColumnList.add(col3);
                int i = 0;
                String rowStyle = "rowtable1";
                HashMap<String, Long> columnWiseTotal = new HashMap<String, Long>();
                Long grandTotal = 0L;
                int toIndex = firstColValList.size() < fromIndex + range - 1 ? firstColValList.size() : fromIndex + range - 1;
                int size = fromIndex - 1;
                while (size < toIndex) {
                    HashMap rowMap = new HashMap();
                    rowStyle = i % 2 == 0 ? "rowtable1" : "rowtable2";
                    String keyVal = (String)firstColValList.get(size);
                    HashMap details = (HashMap)pivotalMap.get(keyVal);
                    Long count = 0L;
                    ArrayList columnList = new ArrayList();
                    HashMap<String, Object> columnMap1 = new HashMap<String, Object>();
                    columnMap1.put(firstColumn, keyVal);
                    columnMap1.put("isData", true);
                    columnMap1.put("visible", true);
                    columnMap1.put("columnValue", keyVal);
                    columnMap1.put("COLUMNALIAS", firstColumn);
                    columnList.add(columnMap1);
                    for (int column = 0; column < columnNameList.size(); ++column) {
                        HashMap<String, Object> columnMap = new HashMap<String, Object>();
                        String columnName = (String)columnNameList.get(column);
                        Long value = details.get(columnName) == null ? 0L : (Long)details.get(columnName);
                        columnWiseTotal.put((String)columnNameList.get(column), columnWiseTotal.get((String)columnNameList.get(column)) == null ? value : (Long)columnWiseTotal.get((String)columnNameList.get(column)) + value);
                        count = count + value;
                        grandTotal = grandTotal + value;
                        columnMap.put("isData", true);
                        columnMap.put("visible", true);
                        columnMap.put("columnValue", value);
                        columnMap.put("COLUMNALIAS", columnName);
                        columnList.add(columnMap);
                    }
                    HashMap<String, Object> columnMap3 = new HashMap<String, Object>();
                    columnMap3.put("Grand Total", count);
                    columnMap3.put("isData", true);
                    columnMap3.put("visible", true);
                    columnMap3.put("columnValue", count);
                    columnMap3.put("COLUMNALIAS", "Grand Total");
                    columnList.add(columnMap3);
                    rowMap.put("columnValues", columnList);
                    rowList.add(rowMap);
                    ++size;
                    ++i;
                }
                HashMap rowMap = new HashMap();
                ArrayList columnList = new ArrayList();
                HashMap<String, Object> columnMap1 = new HashMap<String, Object>();
                columnMap1.put(firstColumn, "Grand Total");
                columnMap1.put("isData", true);
                columnMap1.put("visible", true);
                columnMap1.put("columnValue", "Grand Total");
                columnMap1.put("COLUMNALIAS", firstColumn);
                columnList.add(columnMap1);
                for (int column = 0; column < columnSize; ++column) {
                    HashMap<String, Object> columnMap = new HashMap<String, Object>();
                    columnMap.put("isData", true);
                    columnMap.put("visible", true);
                    columnMap.put("columnValue", columnWiseTotal.get((String)columnNameList.get(column)));
                    columnMap.put("COLUMNALIAS", "unknown");
                    columnList.add(columnMap);
                }
                HashMap<String, Object> columnMap3 = new HashMap<String, Object>();
                columnMap3.put("Grand Total", grandTotal);
                columnMap3.put("isData", true);
                columnMap3.put("visible", true);
                columnMap3.put("columnValue", grandTotal);
                columnMap3.put("COLUMNALIAS", "Grand Total");
                columnList.add(columnMap3);
                rowMap.put("columnValues", columnList);
                rowList.add(rowMap);
            }
            HashMap returnListMap = new HashMap();
            returnListMap.put("reportData", rowList);
            returnListMap.put("reportColumnList", tableColumnList);
            returnListMap.put("inputParams", reportInputParams);
            returnListMap.put("tabInputParams", tabInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void submitChartDefault(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject tabInputParams = reportReqData.getJSONObject("tabInputParams");
            String value = reportReqData.getString("value");
            String col = reportReqData.getString("col");
            Long cvId = tabInputParams.getLong("cvId");
            AuditReportAPI.getInstance().changeChartDefault(col, value, cvId);
            JsonResponse.getInstance().sendResponse(response, "1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getReportChartData(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            JSONObject tabInputParams = reportReqData.getJSONObject("tabInputParams");
            Long cvId = tabInputParams.getLong("cvId");
            Long reportId = reportInputParams.getLong("reportId");
            JSONArray objectGuids = reportInputParams.optJSONArray("object_guid");
            ArrayList objectGuidList = null;
            objectGuidList = objectGuids != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList();
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("objectClass", reportInputParams.getString("objectClass"));
            inputParams.put("object_guid", objectGuidList);
            inputParams.put("domainName", reportInputParams.getString("domainName"));
            inputParams.put("objectName", reportInputParams.getString("objectName"));
            inputParams.put("FROM", reportInputParams.getString("startDate"));
            inputParams.put("TO", reportInputParams.getString("endDate"));
            inputParams = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, reportInputParams.getString("domainName"), reportId);
            inputParams.put("object_guid", objectGuidList);
            HashMap inputParamsMap = new HashMap();
            if (inputParamsMap.get("objectSIDStr") == null) {
                inputParamsMap.put("objectSIDStr", inputParams.get("objectSIDStr"));
                inputParamsMap.put("objectSID", inputParams.get("objectSID"));
            }
            inputParamsMap.put("objectDNSName", inputParams.get("objectDNSName"));
            inputParamsMap.put("client_mc_name", inputParams.get("client_mc_name"));
            inputParamsMap.put("guidStr", inputParams.get("guidStr"));
            inputParamsMap.put("objectClass", inputParams.get("objectClass"));
            inputParamsMap.put("objectName", inputParams.get("objectName"));
            inputParamsMap.put("FROM", reportInputParams.getString("startDate"));
            inputParamsMap.put("TO", reportInputParams.getString("endDate"));
            inputParamsMap.put("RDNC", inputParams.get("RDNC"));
            inputParamsMap.put("domainDNSName", inputParams.get("domainDNSName"));
            inputParamsMap.put("domainFlatName", inputParams.get("domainFlatName"));
            inputParamsMap.put("domainName", inputParams.get("domainName"));
            if (reportInputParams.has("isSelectAllSelected")) {
                if (reportInputParams.getBoolean("isSelectAllSelected")) {
                    inputParamsMap.put("allObjectSelected", reportInputParams.getString("isSelectAllSelected"));
                } else {
                    inputParamsMap.remove("allObjectSelected");
                }
            }
            inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputParams, inputParamsMap, (Long)reportId);
            Integer businessHour = reportInputParams.optInt("businessHour");
            String businessHourString = "";
            if (businessHour != null) {
                if (businessHour == 0) {
                    businessHourString = "false";
                } else if (businessHour == 1) {
                    businessHourString = "business";
                } else if (businessHour == 2) {
                    businessHourString = "nonbusiness";
                }
            }
            String businessCriteria = ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria(businessHourString, true);
            HashMap graphMap = ReportChartUtil.getInstance().getReportGraphSQLString(cvId, inputParamsMap, businessCriteria);
            JSONObject jsonobj = null;
            HashMap<String, Object> graphData = new HashMap<String, Object>();
            if (!graphMap.isEmpty()) {
                Long graphOptId = (Long)graphMap.get("graphOptID");
                String graphName = (String)graphMap.get("viewname");
                String chartType = (String)graphMap.get("charttype");
                String objectName = (String)inputParamsMap.get("objectName");
                String limitValue = (String)graphMap.get("limitValue");
                if (!reportInputParams.getBoolean("objectInput") || objectName != null && objectName.length() > 0) {
                    jsonobj = ReportHandlerUtil.getInstance().getReportGraphValues((String)graphMap.get("sqlString"), false, chartType, graphName, graphMap);
                }
                JSONArray a1 = new JSONArray();
                String[] chartInputNames = null;
                String[] chartInputValues = null;
                String[] chartInputClasses = null;
                String headingName = (String)graphMap.get("graphTitle");
                if (chartType.equalsIgnoreCase("verticalbar3d") || chartType.equalsIgnoreCase("horizontalbar3d") || chartType.equalsIgnoreCase("pie3d")) {
                    chartInputNames = new String[]{"", "", ""};
                    chartInputValues = new String[]{"verticalbar3d", "horizontalbar3d", "pie3d"};
                    chartInputClasses = new String[]{"chart1", "chart2", "chart3"};
                } else if (chartType.equalsIgnoreCase("stackedverticalbar3d") || chartType.equalsIgnoreCase("stackedhorizontalbar3d")) {
                    chartInputNames = new String[]{"", ""};
                    chartInputValues = new String[]{"stackedverticalbar3d", "stackedhorizontalbar3d"};
                    chartInputClasses = new String[]{"chart1", "chart2"};
                }
                if (chartInputNames != null) {
                    for (int i = 0; i < chartInputNames.length; ++i) {
                        if (chartType.equalsIgnoreCase((String)chartInputValues[i])) {
                            chartInputNames[i] = "active";
                        }
                        JSONObject obj = new JSONObject();
                        obj.put("name", (Object)chartInputNames[i]);
                        obj.put("value", (Object)chartInputValues[i]);
                        obj.put("class", (Object)chartInputClasses[i]);
                        a1.put((Object)obj);
                    }
                }
                String xlabel = (String)graphMap.get("xlabel");
                String ylabel = (String)graphMap.get("ylabel");
                graphData.put("graphData", jsonobj);
                graphData.put("xlabel", xlabel);
                graphData.put("ylabel", ylabel);
                graphData.put("graphTitle", headingName);
                graphData.put("chartInputList", a1);
                graphData.put("graphOptId", graphOptId);
                graphData.put("cvID", cvId);
                graphData.put("chartType", chartType);
                graphData.put("defaultChartType", chartType);
                graphData.put("limitValue", limitValue);
                graphData.put("isHomeGraph", false);
                graphData.put("graphId", "graphId_" + graphOptId);
                graphData.put("graphName", "graphName_" + graphOptId);
                graphData.put("width", 550);
                graphData.put("height", 300);
                graphData.put("isChartNotEmpty", true);
                JSONArray xList = null;
                String xValue = null;
                if (jsonobj != null) {
                    xList = jsonobj.getJSONArray("xList");
                    xValue = xList.optString(0);
                }
                if (xValue == null || xValue.equals("") || xValue.equals("null")) {
                    graphData.put("isChartNotEmpty", false);
                }
                if (!AuditReportAPI.isThisGraphAdded((Long)((Long)graphMap.get("graphOptID")))) {
                    graphData.put("isGraphNotAdded", true);
                } else {
                    graphData.put("isGraphNotAdded", false);
                }
                graphData.put("reportId", reportInputParams.getInt("reportId"));
                HashMap<String, HashMap<String, Object>> returnListMap = new HashMap<String, HashMap<String, Object>>();
                returnListMap.put("chartData", graphData);
                String a = APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap));
                JsonResponse.getInstance().sendResponse(response, a);
            } else {
                String chartType = (String)graphMap.get("charttype");
                String xlabel = "";
                String ylabel = "";
                JSONObject reportObj = new JSONObject();
                ArrayList xlist = new ArrayList();
                ArrayList ylist = new ArrayList();
                reportObj.put("xList", (Object)new JSONArray(xlist));
                reportObj.put("yList", (Object)new JSONArray(ylist));
                graphData.put("graphData", reportObj);
                graphData.put("xlabel", xlabel);
                graphData.put("ylabel", ylabel);
                graphData.put("graphTitle", "");
                graphData.put("graphOptId", "");
                graphData.put("cvID", cvId);
                graphData.put("chartType", chartType);
                graphData.put("isHomeGraph", false);
                graphData.put("isChartNotEmpty", false);
                graphData.put("reportId", reportInputParams.getInt("reportId"));
                HashMap<String, HashMap<String, Object>> returnListMap = new HashMap<String, HashMap<String, Object>>();
                returnListMap.put("chartData", graphData);
                String a = APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap));
                JsonResponse.getInstance().sendResponse(response, a);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reportGraphUnderlyingData(HttpServletRequest request, HttpServletResponse response) {
        try {
            String businessCriteria;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            JSONObject tabInputParams = reportReqData.getJSONObject("tabInputParams");
            JSONObject tabChartData = reportReqData.getJSONObject("tabChartData");
            Long reportId = reportInputParams.getLong("reportId");
            JSONObject reportDetailsMap = reportInputParams.getJSONObject("reportDetailsMap");
            Long cvId = tabInputParams.getLong("cvId");
            JSONArray objectGuids = reportInputParams.optJSONArray("object_guid");
            ArrayList objectGuidList = null;
            objectGuidList = objectGuids != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList();
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("objectClass", reportInputParams.get("objectClass"));
            inputParams.put("object_guid", objectGuidList);
            inputParams.put("domainName", reportInputParams.get("domainName"));
            inputParams.put("objectName", reportInputParams.get("objectName"));
            inputParams.put("FROM", reportInputParams.getString("startDate"));
            inputParams.put("TO", reportInputParams.getString("endDate"));
            inputParams = ReportHandlerUtil.getInstance().getInputParamsValues(inputParams, reportInputParams.getString("domainName"), reportId);
            inputParams.put("object_guid", objectGuidList);
            HashMap inputParamsMap = new HashMap();
            if (inputParamsMap.get("objectSIDStr") == null) {
                inputParamsMap.put("objectSIDStr", inputParams.get("objectSIDStr"));
                inputParamsMap.put("objectSID", inputParams.get("objectSID"));
            }
            inputParamsMap.put("objectDNSName", inputParams.get("objectDNSName"));
            inputParamsMap.put("client_mc_name", inputParams.get("client_mc_name"));
            inputParamsMap.put("guidStr", inputParams.get("guidStr"));
            inputParamsMap.put("objectClass", inputParams.get("objectClass"));
            inputParamsMap.put("objectName", inputParams.get("objectName"));
            inputParamsMap.put("domainName", inputParams.get("domainName"));
            inputParamsMap.put("FROM", reportInputParams.getString("startDate"));
            inputParamsMap.put("TO", reportInputParams.getString("endDate"));
            inputParamsMap.put("RDNC", inputParams.get("RDNC"));
            inputParamsMap.put("domainDNSName", inputParams.get("domainDNSName"));
            inputParamsMap.put("domainFlatName", inputParams.get("domainFlatName"));
            inputParamsMap.put("domainName", inputParams.get("domainName"));
            inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputParams, inputParamsMap, (Long)reportId);
            HashMap tableViewConfig = JSONUtil.JSONObjectToMap((JSONObject)((JSONObject)reportInputParams.get("tableViewConfig")));
            if (!tabInputParams.has("sortColumn") || tabInputParams.get("sortColumn") == null) {
                String sortColumn = (String)tableViewConfig.get("SORTCOLUMN");
                String sortOrder = (String)tableViewConfig.get("SORTORDER");
                tabInputParams.put("sortColumn", (Object)sortColumn);
                tabInputParams.put("sortOrder", (Object)sortOrder);
            }
            ArrayList<HashMap<String, Object>> tableAllColumnList = ReportHandlerUtil.getInstance().getVisibleColumnList(cvId, true, true, true, tabInputParams.getString("sortColumn").toString(), tabInputParams.getString("sortOrder"), rb);
            Boolean isSearch = false;
            reportInputParams.put("isSearch", (Object)isSearch);
            Long graphOptId = Long.parseLong(tabInputParams.getString("graphOptId"));
            String inputData1 = tabInputParams.getString("inputData");
            String inputData = EscapeUtil.escSplCharsAsSQL((Object)inputData1);
            String xColumnValue = AuditReportAPI.getInstance().getXColumnValue(cvId, graphOptId, inputData);
            Integer businessHour = reportInputParams.optInt("businessHour");
            String businessHourString = "";
            if (businessHour != null) {
                if (businessHour == 0) {
                    businessHourString = "false";
                } else if (businessHour == 1) {
                    businessHourString = "business";
                } else if (businessHour == 2) {
                    businessHourString = "nonbusiness";
                }
            }
            if ((businessCriteria = ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria(businessHourString, true)) != null && xColumnValue != null) {
                xColumnValue = xColumnValue + " AND " + businessCriteria;
            }
            int count = AuditReportAPI.getInstance().getRowsCount(cvId, graphOptId, inputData, inputParamsMap, xColumnValue);
            ArrayList reportsList = AuditReportAPI.getInstance().getReportRows(cvId, graphOptId, inputData, inputParamsMap, xColumnValue, tabInputParams.getString("sortColumn"), tabInputParams.getString("sortOrder"), Integer.parseInt(tabInputParams.getString("startValue")), Integer.parseInt(tabInputParams.getString("rangeValue")), count, Boolean.valueOf(true));
            if (tabChartData.getString("xlabel").equals("HOUR")) {
                String[] hrs = inputData.split(";;;");
                inputData = "( HOURS " + hrs[0] + " To " + (Integer.parseInt(hrs[0]) + 1) + " )";
            }
            if (inputData.contains(";;")) {
                inputData = inputData.replace(";;", ":");
            }
            inputData = reportDetailsMap.getString("AUDIT_REPORT_NAME") + ":" + inputData;
            tabInputParams.put("totalCount", count);
            tabInputParams.put("showFilterText", true);
            tabInputParams.put("filterText", (Object)inputData);
            tabInputParams.put("xColumnValue", (Object)xColumnValue);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.Report_Graph_underlying_data_generated", new String[]{rb.getString(reportDetailsMap.getString("AUDIT_REPORT_NAME").toString())}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Generate_Report_graph_underlying_data", "-"}));
            HashMap<String, ArrayList<HashMap<String, Object>>> returnListMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            returnListMap.put("reportData", reportsList);
            returnListMap.put("reportColumnList", tableAllColumnList);
            JSONObject tableSearchOptions = this.getAdvSearchOptions(tabInputParams, tableAllColumnList, rb);
            tableSearchOptions.put("searchGroups", (Object)new JSONArray());
            tableSearchOptions.put("searchQuery", (Object)"");
            tabInputParams.put("isSearch", false);
            returnListMap.put("tableSearchOptions", (ArrayList<HashMap<String, Object>>)tableSearchOptions);
            returnListMap.put("inputParams", (ArrayList<HashMap<String, Object>>)reportInputParams);
            returnListMap.put("tabInputParams", (ArrayList<HashMap<String, Object>>)tabInputParams);
            JsonResponse.getInstance().sendResponse(response, APIUtil.getInstance().mapToJSONString(new HashMap<Object, Object>(returnListMap)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAddOrRemoveColumns(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "Successfully updated report columns";
        Boolean type = true;
        Boolean defaultflag = false;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            JSONObject tabInputParams = null;
            tabInputParams = reportReqData.getJSONObject("tabInputParams");
            JSONObject reportDetailsMap = reportInputParams.getJSONObject("reportDetailsMap");
            ArrayList countResultList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.getJSONArray("cvIdList"));
            Long cvId = tabInputParams.getLong("cvId");
            String defaultCol = reportInputParams.getString("defaultCol");
            if (defaultCol == null || defaultCol.equalsIgnoreCase("null")) {
                ArrayList colIdList = (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.getJSONArray("columnIds"));
                Long[] visibleColumns = new Long[colIdList.size()];
                for (int i = 0; i < colIdList.size(); ++i) {
                    visibleColumns[i] = Long.valueOf(colIdList.get(i).toString());
                }
                AUDCustomViewAPI.getInstance().updateColumnList(cvId, visibleColumns);
                defaultflag = this.checkDefaultFlag(cvId);
            } else {
                AUDCustomViewAPI.getInstance().setToDefaultColumn(cvId);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_column_changed", new String[]{rb.getString((String)reportDetailsMap.get("AUDIT_REPORT_NAME"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Column_changed", "-"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)message);
        returnListMap.put("msgType", (Object)type);
        returnListMap.put("defaultflag", (Object)defaultflag);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    private Boolean checkDefaultFlag(Long cvId) throws Exception {
        Boolean defaultflag = false;
        Criteria c = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
        DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDColumnConfiguration", c);
        if (!dObj.isEmpty()) {
            Iterator it = dObj.getRows("AUDColumnConfiguration", (Criteria)null);
            while (it.hasNext()) {
                Row s = (Row)it.next();
                int defaultColumnIndexInDB = Integer.parseInt(s.get("DEFAULTCOLUMNINDEX").toString());
                if (s.get("VISIBLE") == s.get("DEFAULTVISIBLE") || defaultColumnIndexInDB == -1) continue;
                defaultflag = true;
                break;
            }
        }
        return defaultflag;
    }

    public void addToDashBoard(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = null;
        Boolean type = true;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject chartInputParams = reportReqData.getJSONObject("chartInputParams");
            String action = chartInputParams.getString("action");
            JSONObject chartData = chartInputParams.getJSONObject("chartData");
            String layoutName = null;
            Long tabId = 1L;
            String selTab = chartInputParams.optString("tabId");
            if (selTab != null && selTab.equalsIgnoreCase("3")) {
                tabId = 3L;
                layoutName = "admp.home.layout.name.file_audit_layout";
            }
            if (action.equalsIgnoreCase("add")) {
                JSONArray objectGuids;
                JSONObject reportInputParams = null;
                reportInputParams = chartInputParams.optJSONObject("reportInputParams");
                String[] interval = chartInputParams.getString("timeInterval").split(";;;");
                HashMap<String, Object> inputMap = new HashMap<String, Object>();
                inputMap.put("GRAPH_TITLE", chartInputParams.getString("graphTitle"));
                inputMap.put("GRAPH_OPT_ID", Long.parseLong(chartData.getString("graphOptId")));
                inputMap.put("FIRST_GRAPH_DURATION", Long.parseLong(interval[0]));
                inputMap.put("SECOND_GRAPH_DURATION", Long.parseLong(interval[1]));
                inputMap.put("LOGIN_ID", new Long(1L));
                inputMap.put("VISIBLE", true);
                if (reportInputParams != null && reportInputParams.get("reportCategoryType") != null) {
                    inputMap.put("GRAPH_TYPE", (Integer)reportInputParams.get("reportCategoryType"));
                    inputMap.put("PRIORITY_ID", AuditReportAPI.getInstance().getPriorityId(reportInputParams.getInt("reportCategoryType")));
                }
                if (reportInputParams != null && reportInputParams.optString("objectClass") != null && reportInputParams.optString("objectClass") != "") {
                    inputMap.put("IS_INPUT_NEEDED", true);
                } else {
                    inputMap.put("IS_INPUT_NEEDED", false);
                }
                inputMap.put("IS_THIS_REPORT_GRAPH", true);
                JSONObject adsContainerDetail = new JSONObject();
                Credential credential = AuthUtil.getUserCredential();
                if (chartData.has("conId")) {
                    adsContainerDetail.put("CONTAINER_ID", chartData.optLong("conId"));
                } else {
                    adsContainerDetail.put("CONTAINER_ID", null);
                }
                adsContainerDetail.put("CONTAINER_NAME", (Object)chartInputParams.getString("graphTitle"));
                adsContainerDetail.put("COMPONENT_ID", Long.parseLong(chartData.getString("graphOptId")));
                adsContainerDetail.put("USER_ID", (Object)credential.getUserId());
                adsContainerDetail.put("MODULE_ID", 1L);
                adsContainerDetail.put("TAB_ID", (Object)tabId);
                adsContainerDetail.put("FIRST_GRAPH_DURATION", Long.parseLong(interval[0]));
                adsContainerDetail.put("SECOND_GRAPH_DURATION", Long.parseLong(interval[1]));
                adsContainerDetail.put("TOOL_TIP_TEXT", (Object)"adap.home.layout.container.duration_last_x_days");
                adsContainerDetail.put("ONCLICK_FUNC", (Object)"LayoutUtil.triggerFunction('ComponentDurationChange', this)");
                adsContainerDetail.put("LAYOUT_NAME", (Object)layoutName);
                ArrayList objectGuidList = null;
                objectGuidList = reportInputParams != null ? ((objectGuids = reportInputParams.optJSONArray("object_guid")) != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList()) : new ArrayList();
                HashMap<String, Object> inputParamsMap = new HashMap<String, Object>();
                if (reportInputParams != null) {
                    inputParamsMap.put("objectClass", reportInputParams.get("objectClass"));
                }
                inputParamsMap.put("object_guid", objectGuidList);
                message = AuditReportAPI.getInstance().modifyDashBoard(request, inputMap, inputParamsMap, adsContainerDetail);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Home", rb.handleGetObject("adap.AuditReportAction.audit_entry.graph_added_to_dashboard", new String[]{chartInputParams.getString("graphTitle")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Graph_added_to_dashboard", "-"}));
            } else if (action.equalsIgnoreCase("remove")) {
                Long conId = chartData.getLong("conId");
                message = conId != null ? AuditReportAPI.getInstance().removeFromDashBoard(request, (Object)chartData.getLong("graphOptId"), conId) : AuditReportAPI.getInstance().removeFromDashBoard((Object)chartData.getLong("graphOptId"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Home", rb.handleGetObject("adap.AuditReportAction.audit_entry.graph_removed_to_dashboard", new String[]{rb.getString(chartData.getString("graphTitle"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_Graph_removed_from_dashboard", "-"}));
            }
        }
        catch (Exception ex) {
            type = false;
            ex.printStackTrace();
            message = rb.getString("adap_Reports.error_while_adding_graph_to_dashboard");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Home", rb.getString("adap.AuditReportAction.audit_entry.problem_addorremove_graph_to_dashboard"), 8, 16, ex.getMessage(), "adap.ADAPUserAuditSeverities.audit_name.problem_removed_graph_from_dashboard", "-"}));
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)message);
        returnListMap.put("msgType", (Object)type);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void saveAnnotation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = rb.getString("adap_Reports.successfully_updated_annotation");
        Boolean type = true;
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            JSONObject reportDetailsMap = reportInputParams.getJSONObject("reportDetailsMap");
            Long reportId = Long.parseLong(reportInputParams.getString("reportId"));
            String desc = reportInputParams.getString("description");
            AuditReportAPI.getInstance().updateDescription(reportId, desc);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_description_update", new String[]{rb.getString((String)reportDetailsMap.get("AUDIT_REPORT_NAME")), desc}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.descriptoin_updated", "-"}));
        }
        catch (Exception ex) {
            type = false;
            ex.printStackTrace();
            message = rb.getString("adap_Reports.error_while_updating_annotation");
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)message);
        returnListMap.put("msgType", (Object)type);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void makeAsDefaultReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = rb.getString("adap.AuditReportAction.Failure_to_make_this_report_as_default");
        boolean type = true;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = null;
        reportInputParams = reportReqData.getJSONObject("inputParams");
        JSONObject reportDetailsMap = reportInputParams.getJSONObject("reportDetailsMap");
        try {
            if (DBObjectUtil.setDefaultReport((String)reportInputParams.getString("reportId"))) {
                message = rb.getString("adap.ProductConfigServlet.Successfully_Configured");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_set_as_default", new String[]{rb.getString((String)reportDetailsMap.get("AUDIT_REPORT_NAME"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_default_report", "-"}));
        }
        catch (Exception ex) {
            type = false;
            ex.printStackTrace();
            message = rb.getString("adap.AuditReportAction.Failure_to_make_this_report_as_default");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.failed_to_set_default_report", new String[]{rb.getString((String)reportDetailsMap.get("AUDIT_REPORT_NAME"))}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_default_report", "-"}));
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)message);
        returnListMap.put("msgType", type);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void addORRemoveFavorites(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap_Reports.successfully_created_myreport");
        Boolean msgType = true;
        JSONArray myReportCategories = null;
        Boolean isDuplicate = false;
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject reportInputParams = null;
            JSONObject inputParams = reportReqData.getJSONObject("inputParams");
            reportInputParams = reportReqData.getJSONObject("reportInputParams");
            JSONObject reportDetailsMap = reportInputParams.getJSONObject("reportDetailsMap");
            String domainName = reportInputParams.getString("domainName");
            String reportId = reportInputParams.getString("reportId");
            String reportName = inputParams.getString("myReportName");
            String categoryName = inputParams.getString("myReportCategoryName");
            Boolean isNewCategory = inputParams.getBoolean("isNewCategory");
            Long loginId = AuthUtil.getUserCredential().getLoginId();
            String routeName = inputParams.getString("routeName");
            String selectedTab = null;
            if (routeName.equals("reports.report")) {
                selectedTab = "reports";
            } else if (routeName.equals("fileaudit.report")) {
                selectedTab = "fileAudit";
            } else if (routeName.equals("serveraudit.report")) {
                selectedTab = "serverAudit";
            }
            if (!isNewCategory.booleanValue()) {
                Long categoryId = MyFavRepHandler.getCategoryId((String)categoryName, (Long)loginId);
                JSONObject jsonObj = MyFavRepHandler.getDataSource();
                ArrayList list = (ArrayList)jsonObj.get("repObj");
                for (int j = 0; j < list.size(); ++j) {
                    JSONObject reportObj = (JSONObject)list.get(j);
                    int productId = reportObj.getInt("PRODUCT_ID");
                    Long categoryId2 = reportObj.getLong("CATEGORY_ID");
                    if (productId != 3 || !categoryId.equals(categoryId2) || !reportObj.getString("DISPLAY_NAME").equalsIgnoreCase(reportName)) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate.booleanValue()) {
                    throw new Exception(rb.getString("ads_myfavreport_report_duplicate_name"));
                }
            }
            if (isNewCategory.booleanValue()) {
                JSONObject json = new JSONObject();
                json.put("CategoryName", (Object)categoryName);
                json.put("LoginId", (Object)loginId);
                MyFavRepHandler.addCategory((JSONObject)json);
                myReportCategories = ReportHandlerUtil.getInstance().getMyReportCategories();
            }
            Long startTime = reportInputParams.getLong("startDate");
            Long endTime = reportInputParams.getLong("endDate");
            Date date = new Date(startTime * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = sdf.format(date);
            Integer startHour = date.getHours();
            Integer startMinute = date.getMinutes();
            Date date1 = new Date(endTime * 1000L);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            String endDate = sdf1.format(date1);
            Integer endHour = date1.getHours();
            Integer endMinute = date1.getMinutes();
            JSONArray objectGuids = reportInputParams.optJSONArray("object_guid");
            ArrayList objectGuidList = null;
            objectGuidList = objectGuids != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList();
            JSONObject jsonRep = new JSONObject();
            JSONObject param = new JSONObject();
            JSONArray exclude = new JSONArray();
            param.put("reportId", (Object)reportId.toString());
            param.put("methodToCall", (Object)"report");
            param.put("selectedTab", (Object)selectedTab);
            param.put("domainName", (Object)domainName);
            if (reportInputParams.has("categoryId")) {
                param.put("categoryId", reportInputParams.getLong("categoryId"));
            }
            param.put("inputDays", (Object)reportInputParams.getString("chosenServerValue"));
            param.put("startTime", (Object)startDate);
            param.put("endTime", (Object)endDate);
            param.put("startHour", (Object)startHour.toString());
            param.put("endHour", (Object)endHour.toString());
            param.put("startMinute", (Object)startMinute.toString());
            param.put("endMinute", (Object)endMinute.toString());
            if (reportInputParams.has("objectClass") && reportInputParams.getString("objectClass") != null && !reportInputParams.getString("objectClass").equalsIgnoreCase("")) {
                param.put("objectClass", (Object)reportInputParams.getString("objectClass"));
            }
            if (reportInputParams.has("allObjectSelected")) {
                param.put("allObjectSelected", reportInputParams.get("allObjectSelected"));
            }
            param.put("loginId", (Object)loginId.toString());
            param.put("init", (Object)"true");
            if (objectGuidList != null && objectGuidList.size() > 0) {
                int i = 0;
                for (Object s : objectGuidList) {
                    param.put("object_guid_" + i, (Object)URLEncoder.encode(s.toString(), "utf-8"));
                    exclude.put((Object)("object_guid_" + i));
                    ++i;
                }
            }
            jsonRep.put("Category", (Object)categoryName);
            jsonRep.put("ReportName", (Object)reportName);
            jsonRep.put("ReportType", (Object)"AuditReports.do?");
            jsonRep.put("ProductId", 3L);
            jsonRep.put("Param", (Object)param);
            MyFavRepHandler.addReport((JSONObject)jsonRep);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.AuditReportAction.audit_entry.report_added_to_favourites", new String[]{rb.getString(reportDetailsMap.getString("AUDIT_REPORT_NAME"))}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Reports_Added_To_favourites", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgTxt = isDuplicate != false ? ex.getMessage() : rb.getString("adap.AuditReportAction.Failure_to_add_to_Favourites");
            msgType = false;
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        returnListMap.put("myReportCategories", myReportCategories);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void exportReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            String exportType = reportReqData.optString("exportType");
            if (exportType != null && !exportType.trim().equals("")) {
                if (AdapExporter.isNewExport((HttpServletRequest)request)) {
                    new AdapExporter().addExportTask(request);
                    JsonResponse.getInstance().sendResponse(response, new JSONObject().toString());
                } else {
                    JsonResponse.getInstance().sendResponse(response, new JSONObject("{\"callOldMethod\":\"true\"}").toString());
                }
            } else {
                ReportHandlerUtil.getInstance().exportReport(request, response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setExportData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)"successfully set export data");
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void searchReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONArray resultantList = new JSONArray();
            ArrayList reportsDetails = AuditReportAPI.getInstance().getReportsDetails(request);
            ArrayList reportsDetailsClone = (ArrayList)reportsDetails.clone();
            String searchString = request.getParameter("query");
            String reportName = null;
            String title = null;
            String desc = null;
            String labels = null;
            if (searchString != null) {
                JSONObject map;
                HashMap reportMap;
                int i;
                searchString = searchString.toLowerCase();
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    reportName = reportMap.get("AUDIT_REPORT_NAME").toString();
                    if (reportName.indexOf(searchString) == -1) continue;
                    map = new JSONObject();
                    map.put("routeName", (Object)this.getRouteName((Integer)reportMap.get("REPORT_CATEGORY_TYPE")));
                    map.put("modelId", reportMap.get("AUDIT_REPORT_ID"));
                    map.put("value", (Object)reportMap.get("DISPLAYNAME").toString());
                    reportsDetailsClone.remove(reportMap);
                    resultantList.put((Object)map);
                }
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    title = reportMap.get("TITLE").toString();
                    if (title.indexOf(searchString) == -1) continue;
                    map = new JSONObject();
                    map.put("routeName", (Object)this.getRouteName((Integer)reportMap.get("REPORT_CATEGORY_TYPE")));
                    map.put("modelId", reportMap.get("AUDIT_REPORT_ID"));
                    map.put("value", (Object)reportMap.get("DISPLAYNAME").toString());
                    resultantList.put((Object)map);
                    reportsDetailsClone.remove(reportMap);
                }
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    desc = reportMap.get("DESCRIPTION").toString();
                    if (desc.indexOf(searchString) == -1) continue;
                    map = new JSONObject();
                    map.put("routeName", (Object)this.getRouteName((Integer)reportMap.get("REPORT_CATEGORY_TYPE")));
                    map.put("modelId", reportMap.get("AUDIT_REPORT_ID"));
                    map.put("value", (Object)reportMap.get("DISPLAYNAME").toString());
                    resultantList.put((Object)map);
                    reportsDetailsClone.remove(reportMap);
                }
                for (i = 0; i < reportsDetailsClone.size(); ++i) {
                    reportMap = (HashMap)reportsDetailsClone.get(i);
                    labels = reportMap.get("LABELS").toString();
                    if (labels.indexOf(searchString) == -1) continue;
                    map = new JSONObject();
                    map.put("routeName", (Object)this.getRouteName((Integer)reportMap.get("REPORT_CATEGORY_TYPE")));
                    map.put("modelId", reportMap.get("AUDIT_REPORT_ID"));
                    map.put("value", (Object)reportMap.get("DISPLAYNAME").toString());
                    resultantList.put((Object)map);
                    reportsDetailsClone.remove(reportMap);
                }
            }
            JSONObject returnListMap = new JSONObject();
            returnListMap.put("resultList", (Object)resultantList);
            JsonResponse.getInstance().sendResponse(response, resultantList.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getRouteName(int reportCategoryType) {
        String ret = "reports.report";
        if (reportCategoryType == 2) {
            ret = "fileaudit.report";
        } else if (reportCategoryType == 3) {
            ret = "serveraudit.report";
        }
        return ret;
    }

    public void setSystemACL(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = null;
        reportInputParams = reportReqData.getJSONObject("inputParams");
        String msgTxt = "";
        Boolean msgType = true;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String domainName = reportInputParams.getString("domainName");
        try {
            AuditDelegationHandler delegationHandler = new AuditDelegationHandler(domainName);
            delegationHandler.setSystemACLForDS();
            msgTxt = rb.getString("adap.DomainPolicy.Successfully_configured_systemACL");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", msgTxt + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.set_SACL", "-"}));
        }
        catch (Exception e) {
            msgTxt = e.getMessage();
            if (msgTxt.toLowerCase().contains("error while setting object level ad auditing:access is denied - error code:0")) {
                msgTxt = rb.getString("adap.domainpolicy.Error_While_Setting_Object_Level_Ad_Access_Denied");
            }
            msgType = false;
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", msgTxt + "\n " + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.set_SACL", "-"}));
            e.printStackTrace();
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void saveSearchReports(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String msgTxt = "";
        Boolean msgType = true;
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject reportInputParams = reportReqData.getJSONObject("reportInputParams");
        JSONObject reportDetailsMap = reportInputParams.getJSONObject("reportDetailsMap");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject tabInputParams = reportReqData.getJSONObject("tabInputParams");
            Long categoryId = Long.parseLong(reportInputParams.getString("searchReportCategoryId"));
            SearchReports.getInstance().saveSearchReportsResult(categoryId, reportInputParams.getString("searchReportName"), reportInputParams.getString("searchReportDescription"), Long.valueOf(reportInputParams.getLong("reportId")), tabInputParams.optString("searchCriteria"), (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"));
            msgTxt = rb.getString("adap_Reports.successfully_created_new_report");
            AuditReportAPI.getInstance().setReportsDetails();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.success_to_save_report_with_search", new String[]{rb.getString((String)reportDetailsMap.get("AUDIT_REPORT_NAME")), reportInputParams.getString("searchReportName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_saved_with_searchstring", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgTxt = rb.getString("adap_Reports.error_while_creating_new_report");
            msgType = false;
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Report", rb.handleGetObject("adap.AuditReportAction.audit_entry.failed_to_save_report_with_search", new String[]{rb.getString((String)reportDetailsMap.get("AUDIT_REPORT_NAME")), reportInputParams.getString("searchReportName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Report_saved_with_searchstring"}));
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void getReportCategories(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            JSONArray resultList = SearchReports.getInstance().getAllCategoriesEmber(request);
            JSONObject returnListMap = new JSONObject();
            returnListMap.put("reportCategories", (Object)resultList);
            JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap.DeleteCustomReport.Reports_Deleted_Successfully");
        boolean msgType = true;
        String message = null;
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject customReportParams = null;
            customReportParams = reportReqData.getJSONObject("inputParams");
            Long reportId = customReportParams.getLong("reportId");
            Row row = ReportUtil.getFirstRow((String)"AUDReports", (String)"AUDIT_REPORT_ID", (Object)reportId, (int)0);
            if (!CustomReportHandler.deleteFromReportsTab((Long)reportId)) {
                msgTxt = rb.getString("adap.DeleteCustomReport.Reports_Deleted_failed");
                msgType = false;
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteCustomReport.audit_entry.Failed_to_deleted_reprt", new String[]{(String)row.get("TITLE")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_deleted", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteCustomReport.audit_entry.Successfully_deleted_from_reports", new String[]{(String)row.get("TITLE")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_deleted", "-"}));
            }
        }
        catch (Exception ex) {
            msgType = false;
            msgTxt = rb.getString("adap.DeleteCustomReport.Reports_Deleted_failed");
            ex.printStackTrace();
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_Report_deleted"}));
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void deleteCustomPeriod(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = rb.getString("adap.Reports.custom_period_deleted_successfully");
        boolean msgType = true;
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            JSONObject customReportParams = null;
            customReportParams = reportReqData.getJSONObject("inputParams");
            String uid = customReportParams.getString("serverValue");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"SERVER_NAME"), (Object)uid, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDReportElementMap", (String)"INPUT_VALUE"), (Object)uid, 0);
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("AUDReportElementMap");
            updateQuery.setCriteria(criteria2);
            updateQuery.setUpdateColumn("INPUT_VALUE", null);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
        }
        catch (Exception ex) {
            msgTxt = rb.getString("adap_Reports.error_while_deleting_custom_period");
            ex.printStackTrace();
            msgType = false;
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void runFileUpdateScheduler(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", rb.getString("adap.AuditReportAction.audit_entry.file_creation_started_manually"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Manual_file_creation_run", "-"}));
        class FileUpdateThread
        extends Thread {
            public FileUpdateThread() {
                super("ManualFileUpdateThread");
            }

            @Override
            public void run() {
                try {
                    FileUpdateScheduler scheduler = new FileUpdateScheduler();
                    scheduler.executeTask(new TaskContext());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        new FileUpdateThread().start();
        String msgType = "info";
        String msgTxt = (String)rb.handleGetObject("adap.fileaudit.generating_files_created_report");
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void savePdc(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean msgType = true;
        String msgTxt = "";
        JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
        JSONObject customReportParams = null;
        customReportParams = reportReqData.getJSONObject("inputParams");
        String pdcName = customReportParams.getString("pdcName");
        String domainName = customReportParams.getString("domainName");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long dcId = PDCHandler.getInstance().getDCIdFromDB(domainName, pdcName);
            if (dcId == 0L) {
                ArrayList<String> dcList = new ArrayList<String>();
                dcList.add(pdcName);
                Properties domainProperties = DomainHandler.getConfiguredValuesForModify((String)domainName);
                domainProperties.put("DOMAIN_CONTROLLER_LIST", dcList);
                DomainHandler.getDomainDetails((Properties)domainProperties, (boolean)true);
                DomainHandler.addDomainControllers((Properties)domainProperties);
                dcId = PDCHandler.getInstance().getDCIdFromDB(domainName, pdcName);
            }
            PDCHandler.getInstance().updatePDC(domainName, dcId);
            msgTxt = rb.getString("adap.AuditReportAction.Successfully_saved_PDC");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", msgTxt + rb.handleGetObject("adap.AuditReportAction.audit_entry.pdc_name", new String[]{pdcName, domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Get_PDC_Name", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = false;
            msgTxt = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", msgTxt + rb.handleGetObject("adap.AuditReportAction.audit_entry.pdc_name", new String[]{pdcName, domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Get_PDC_Name", "-"}));
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public void checkArchiveEvents(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            Long reportId = reportReqData.getLong("reportId");
            if (reportReqData.has("FROM")) {
                String fromVal = reportReqData.optString("FROM");
                String toVal = reportReqData.getString("TO");
                AuditReportAPI.getInstance();
                ArrayList tableNames = AuditReportAPI.getTableNames((Long)reportId);
                DataObject dObj = MetaTableHandler.getArchivedTableDetails((String)fromVal, (String)toVal, (ArrayList)tableNames);
                if (dObj.size("AUDBackUpMetaTable") > 0) {
                    Iterator iter = dObj.getRows("AUDBackUpMetaTable");
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        String action = rb.getString("adap.RestoreArchivedEventTable.Unloaded");
                        boolean b = Boolean.valueOf(row.get("IS_REGENERATE_DATA").toString());
                        if (b) {
                            action = rb.getString("adap.RestoreArchivedEventTable.Loaded");
                        }
                        HashMap detailsMap = ReportUtil.formMap((String[])new String[]{"FILE_NAME", "LOOKUP_TABLENAME", "START_TIME", "END_TIME", "STATUS", "ACTION"}, (Object[])new Object[]{(String)row.get("FILE_NAME"), (String)row.get("LOOKUP_TABLENAME"), TimeUtil.formatDate((Long)((Long)row.get("START_TIME") * 1000L)), TimeUtil.formatDate((Long)((Long)row.get("END_TIME") * 1000L)), (String)row.get("STATUS"), action});
                        list.add(detailsMap);
                    }
                }
            }
            ret = EmberTableConfig.getInstance().getEmberTableData("15039", list, new JSONObject(), rb);
            ret.put("selectedObjectIdList", (Object)new JSONArray());
            JSONObject tableInputParams = ret.getJSONObject("tableInputParams");
            tableInputParams.put("hideBorder", true);
            tableInputParams.put("hideTopDivider", true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public void realTimeReportRun(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            int i;
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            String selectedDomain = reportReqData.getString("domainName");
            String genId = reportReqData.getString("genId");
            Properties domainDetails = ADHandler.getDomainDetails((String)selectedDomain, (Long)1L);
            JSONArray usersList = reportReqData.getJSONArray("selectedList1");
            JSONArray machinesList = reportReqData.getJSONArray("selectedList2");
            ArrayList<String> usersGUIDarray = new ArrayList<String>();
            ArrayList<String> machinesGUIDarray = new ArrayList<String>();
            for (i = 0; i < usersList.length(); ++i) {
                usersGUIDarray.add(((JSONObject)usersList.get(i)).getString("OBJECT_GUID"));
            }
            for (i = 0; i < machinesList.length(); ++i) {
                machinesGUIDarray.add(((JSONObject)machinesList.get(i)).getString("OBJECT_GUID"));
            }
            ArrayList<String> machines = new ArrayList<String>();
            ArrayList<String> users = new ArrayList<String>();
            Iterator iter = DirectoryObjectAPI.getInstance().getObjectRows(null, usersGUIDarray, "user");
            for (String uGUID : usersGUIDarray) {
                Row row = (Row)iter.next();
                users.add((String)row.get("SAM_ACCOUNT_NAME"));
                users.add((String)row.get("SAM_ACCOUNT_NAME") + "@" + domainDetails.get("DOMAIN_DNS_NAME"));
                users.add(domainDetails.get("DOMAIN_DNS_NAME") + "\\" + (String)row.get("SAM_ACCOUNT_NAME"));
                users.add(domainDetails.get("DOMAIN_FLAT_NAME") + "\\" + (String)row.get("SAM_ACCOUNT_NAME"));
                users.add((String)row.get("SAM_ACCOUNT_NAME") + "@" + domainDetails.get("DOMAIN_FLAT_NAME"));
                users.add(".\\" + (String)row.get("SAM_ACCOUNT_NAME"));
                if (((String)row.get("SAM_ACCOUNT_NAME")).equals((String)row.get("NAME"))) continue;
                users.add((String)row.get("NAME"));
                users.add((String)row.get("NAME") + "@" + domainDetails.get("DOMAIN_DNS_NAME"));
                users.add(domainDetails.get("DOMAIN_DNS_NAME") + "\\" + (String)row.get("NAME"));
                users.add(domainDetails.get("DOMAIN_FLAT_NAME") + "\\" + (String)row.get("NAME"));
                users.add((String)row.get("NAME") + "@" + domainDetails.get("DOMAIN_FLAT_NAME"));
                users.add(".\\" + (String)row.get("NAME"));
            }
            iter = DirectoryObjectAPI.getInstance().getObjectRows(null, machinesGUIDarray, "computer");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                machines.add((String)row.get("NAME"));
            }
            JSONArray errMessages = new JSONArray();
            HashMap resultMap = new HashMap();
            Criteria c = new Criteria(new Column("AUDADUserServices", "USERNAME"), (Object)"*", 2);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(c);
            for (String machine : machines) {
                resultMap = ADHandler.getComponentList((String)selectedDomain, (String)"", (String)machine, (String)"service3");
                if (resultMap.get("result") != null) {
                    ArrayList resultList = (ArrayList)resultMap.get("result");
                    for (int i2 = 0; i2 < resultList.size(); ++i2) {
                        Hashtable tempHash = (Hashtable)resultList.get(i2);
                        String[] startTypeValues = new String[]{rb.getString("adap.Reports.AuditReports.user_services.bootstart"), rb.getString("adap.Reports.AuditReports.user_services.systemstart"), rb.getString("adap.Reports.AuditReports.user_services.autostart"), rb.getString("adap.Reports.AuditReports.user_services.demandstart"), rb.getString("adap.Reports.AuditReports.user_services.disabled")};
                        String[] serviceStatusValues = new String[]{"", rb.getString("adap.Reports.AuditReports.user_services.stopped"), rb.getString("adap.Reports.AuditReports.user_services.startpending"), rb.getString("adap.Reports.AuditReports.user_services.stoppending"), rb.getString("adap.Reports.AuditReports.user_services.servicerunning"), rb.getString("adap.Reports.AuditReports.user_services.continuepending"), rb.getString("adap.Reports.AuditReports.user_services.pausepending"), rb.getString("adap.Reports.AuditReports.user_services.paused")};
                        Row r = new Row("AUDADUserServices");
                        String user = (String)tempHash.get("serviceStartName");
                        if (usersList.length() != 0 && !this.caseInsensitiveContains(users, user).booleanValue()) continue;
                        r.set("USERNAME", (Object)user);
                        r.set("USERGUID", (Object)genId);
                        r.set("MACHINE_NAME", (Object)machine);
                        r.set("SERVICE_NAME", tempHash.get("serviceName"));
                        r.set("BINARY_PATH", tempHash.get("binaryPath"));
                        r.set("DISPLAY_NAME", tempHash.get("displayName"));
                        r.set("START_TYPE", (Object)startTypeValues[Integer.parseInt((String)tempHash.get("startType"))]);
                        r.set("SERVICE_STATUS", (Object)serviceStatusValues[Integer.parseInt((String)tempHash.get("serviceStatus"))]);
                        DataObject d = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        d.addRow(r);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(d);
                    }
                }
                if (resultMap.get("errorMessage") == null) continue;
                errMessages.put((Object)(machine + "  :  " + (String)resultMap.get("errorMessage")));
            }
            ret.put("statusMessage", (Object)rb.getString("adap.Reports.AuditReports.fetching_success"));
            ret.put("errMessage", (Object)errMessages);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("statusMessage", (Object)(rb.getString("adap.Reports.AuditReports.fetching_failed") + " : " + e.getMessage()));
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public Boolean caseInsensitiveContains(ArrayList<String> arr, String str) {
        for (int i = 0; i < arr.size(); ++i) {
            if (!str.equalsIgnoreCase(String.valueOf(arr.get(i)))) continue;
            return true;
        }
        return false;
    }

    public void updateGPMC(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String msgTxt = null;
        String msgType = "success";
        try {
            Boolean b = PDCHandler.getInstance().updateIsGPMCInstalled();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", "GPMC Updated", 8, 8, "adap.ADAPUserAuditSeverities.audit_name.update_GPMC", "-"}));
            if (b.booleanValue()) {
                String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
                ArrayList reportIds = new ArrayList();
                Hashtable<String, Integer> reportTable = new Hashtable<String, Integer>();
                reportTable.put("report_id", 503);
                reportIds.add(reportTable);
                ObjectUpdateHandler.runDailyReport((String)domainName, (Long)1L, reportIds);
                msgTxt = rb.getString("adap.AuditReportAction.gpmc_installation_successful");
            } else {
                msgTxt = rb.getString("adap.AuditReportAction.please_install_gpmc");
                msgType = "info";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msgType = "failure";
            msgTxt = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "General", "GPMC Updated", 8, 16, "adap.ADAPUserAuditSeverities.audit_name.update_GPMC", "-"}));
        }
        JSONObject returnListMap = new JSONObject();
        returnListMap.put("msgTxt", (Object)msgTxt);
        returnListMap.put("msgType", (Object)msgType);
        JsonResponse.getInstance().sendResponse(response, returnListMap.toString());
    }

    public static void setDefaultTimePeriod(HttpServletRequest request, HttpServletResponse response) {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String data = request.getParameter("data");
            JSONObject jo = new JSONObject(data);
            String reportId = jo.getString("reportId");
            String inputValue = jo.getString("defaultTimePeriod");
            String message = AuditReportAPI.getInstance().setDefaultTimePeriod(Long.valueOf(reportId), inputValue);
            if (message.equals("success")) {
                message = rb.getString("adap.datepicker.setDefaultValue");
                ret.put("success", true);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.datepicker.setDefaultValue.successMessage", new String[]{reportId, inputValue}), 8, 8, "", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", rb.handleGetObject("adap.datepicker.setDefaultValue.failMessage", new String[]{reportId, inputValue}), 8, 16, "", "-"}));
            }
            ret.put("message", (Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResponse.getInstance().sendResponse(response, ret.toString());
    }

    public ArrayList<HashMap<String, ArrayList<HashMap<String, Object>>>> getLogonDurationSubReport(ArrayList<HashMap<String, ArrayList<HashMap>>> reportsList, ArrayList<HashMap<String, Object>> columnList) {
        ArrayList<HashMap<String, ArrayList<HashMap<String, Object>>>> list = new ArrayList<HashMap<String, ArrayList<HashMap<String, Object>>>>();
        try {
            for (HashMap<String, ArrayList<HashMap>> map : reportsList) {
                ArrayList<HashMap> subRowList = new ArrayList<HashMap>();
                HashMap<String, ArrayList<HashMap>> rowMap = new HashMap<String, ArrayList<HashMap>>();
                ArrayList<HashMap> rowList = map.get("columnValues");
                String userName = "";
                String source = "";
                for (HashMap columnMap : rowList) {
                    Object mapVal = columnMap.get("columnValue");
                    if (mapVal instanceof ArrayList) {
                        HashMap subRowMap = (HashMap)((ArrayList)mapVal).get(0);
                        for (HashMap<String, Object> subColumnMap : columnList) {
                            HashMap cloneMap = (HashMap)subColumnMap.clone();
                            String key = cloneMap.get("columnalias").toString();
                            if (key.equalsIgnoreCase("DETAILS")) {
                                ArrayList<String> clickInput = new ArrayList<String>();
                                clickInput.add(userName);
                                clickInput.add(source);
                                cloneMap.put("isLink", true);
                                cloneMap.put("actionName", "showDetails");
                                cloneMap.put("linkInput", clickInput);
                                cloneMap.put("isData", false);
                                cloneMap.put("linkText", "Details");
                                cloneMap.put("visible", true);
                                subRowList.add(cloneMap);
                                continue;
                            }
                            Object columnVal = subRowMap.get(key);
                            cloneMap.put("columnValue", columnVal);
                            cloneMap.put("visible", true);
                            cloneMap.put("isData", true);
                            subRowList.add(cloneMap);
                        }
                        continue;
                    }
                    if (columnMap.get("columnalias").toString().equalsIgnoreCase("USERNAME")) {
                        userName = columnMap.get("columnValue").toString();
                    } else if (columnMap.get("columnalias").toString().equalsIgnoreCase("SOURCE")) {
                        source = columnMap.get("columnValue").toString();
                    }
                    subRowList.add(columnMap);
                }
                rowMap.put("columnValues", subRowList);
                list.add(rowMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }
}

