/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.ember.api.report;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixExportUtil;
import com.adventnet.sym.adsm.common.server.WorkGroupHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportHandlerUtil {
    private static volatile ReportHandlerUtil instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportHandlerUtil getInstance() {
        if (instance != null) return instance;
        Class<ReportHandlerUtil> clazz = ReportHandlerUtil.class;
        synchronized (ReportHandlerUtil.class) {
            if (instance != null) return instance;
            instance = new ReportHandlerUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ReportHandlerUtil() {
    }

    public void getReportTableRangeList(JSONObject inputParams) throws Exception {
        if (!inputParams.has("rangeList")) {
            Integer pagelength = 25;
            inputParams.put("rangeValue", 25);
            inputParams.put("startValue", 1);
            JSONArray rangeList = new JSONArray();
            for (int i = 1; i <= 4; ++i) {
                JSONObject rangevalue = new JSONObject();
                rangevalue.put("value", pagelength * i);
                rangeList.put((Object)rangevalue);
            }
            inputParams.put("rangeList", (Object)rangeList);
        }
    }

    public HashMap<String, Object> getReportInputModalList(ArrayList<HashMap<String, Object>> elementList, AdventNetResourceBundle rb) throws Exception {
        HashMap<String, Object> reportElementMap = new HashMap<String, Object>();
        HashMap<String, ArrayList> periodMap = new HashMap<String, ArrayList>();
        JSONObject element = new JSONObject();
        JSONArray elements = new JSONArray();
        for (HashMap<String, Object> elementMap : elementList) {
            ArrayList clientList;
            JSONArray tabsArray = new JSONArray();
            if (elementMap.get("attributeProps") == null) continue;
            Properties propList = (Properties)elementMap.get("attributeProps");
            if (propList.get("clientValues") != null) {
                clientList = (ArrayList)propList.get("clientValues");
                periodMap.put("clientValues", clientList);
            }
            if (propList.get("serverValues") != null) {
                clientList = (ArrayList)propList.get("serverValues");
                periodMap.put("serverValues", clientList);
            }
            if (propList.get("onclick") == null || propList.get("onclick").toString().trim().equals("") || !propList.get("onclick").toString().contains("this")) continue;
            String onClickStr = (String)propList.get("onclick");
            onClickStr = onClickStr.substring(onClickStr.indexOf("(this"));
            String cvidStr = onClickStr.split(",")[1];
            String objClassStr = onClickStr.split(",")[2];
            String selectAllStr = null;
            String[] splitArray = onClickStr.split(",");
            if (splitArray != null && splitArray.length == 5) {
                selectAllStr = onClickStr.split(",")[4];
            }
            cvidStr = cvidStr.replaceAll("\\s", "").replaceAll("&#34", "");
            objClassStr = objClassStr.replaceAll("\\s", "").replaceAll("&#34", "");
            String[] cvid = cvidStr.split(";");
            String[] objClass = objClassStr.split(";");
            for (int c = 0; c < cvid.length; ++c) {
                ObjectClass objectClass;
                String objectClassStr;
                int count;
                String cvId;
                if (cvid[c].equals("") || (cvId = cvid[c]).equals("27") && (count = WorkGroupHandler.getWorkGroupServerCount()) == 0) continue;
                JSONObject tab = new JSONObject();
                JSONObject tabInputParams = new JSONObject();
                tabInputParams.put("cvId", (Object)cvId);
                tab.put("tabInputParams", (Object)tabInputParams);
                if (objClass.length > c) {
                    objectClassStr = objClass[c].replaceAll("'", "");
                    tabInputParams.put("objectClass", (Object)objectClassStr);
                    objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClassStr);
                    tabInputParams.put("tabDisplayName", (Object)this.getTabDisplayName(Long.parseLong(cvid[c]), objectClass.getDisplayText(), rb));
                } else {
                    objectClassStr = objClass[0].replaceAll("'", "");
                    tabInputParams.put("objectClass", (Object)objectClassStr);
                    objectClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClassStr);
                    tabInputParams.put("tabDisplayName", (Object)this.getTabDisplayName(Long.parseLong(cvid[c]), objectClass.getDisplayText(), rb));
                }
                if (selectAllStr != null) {
                    selectAllStr = selectAllStr.replaceAll("'", "").replaceAll("\\)", "").trim();
                    tabInputParams.put("showSelectAll", Boolean.parseBoolean(selectAllStr));
                }
                tabsArray.put((Object)tab);
            }
            element.put(elementMap.get("elementId").toString(), (Object)tabsArray);
            elements.put(elementMap.get("elementId"));
        }
        reportElementMap.put("periodList", periodMap);
        reportElementMap.put("inputModalList", element);
        reportElementMap.put("elementList", elements);
        return reportElementMap;
    }

    private String getTabDisplayName(Long cvId, String displayText, AdventNetResourceBundle rb) {
        if (cvId == 2L) {
            return rb.getString("adap.reports.view_computers.tab_heading");
        }
        if (cvId == 3L || cvId == 898L) {
            return rb.getString("adap.reports.view_computers.tab_heading.domain_controllers");
        }
        if (cvId == 4L || cvId == 899L) {
            return rb.getString("adap.reports.view_computers.tab_heading.member_servers");
        }
        if (cvId == 8L || cvId == 896L || cvId == 895L) {
            return rb.getString("adap.reports.view_computers.tab_heading.work_stations");
        }
        if (cvId == 1L) {
            return rb.getString("adap.SecurityComparator.ApplicableUsers_All");
        }
        if (cvId == 7L) {
            return rb.getString("adap.ADMPObjects.display_text.Organizational_Unit");
        }
        if (cvId == 5L) {
            return rb.getString("adap.SelectUsers.Group_Based_Users");
        }
        if (cvId == 100002L) {
            return rb.getString("adap.FileAuditQuickLinks.Windows_File_Server");
        }
        return displayText;
    }

    public JSONArray getTimePeriods(ArrayList<String> timeList, ArrayList<String> clientValues) throws Exception {
        JSONArray resultList = new JSONArray();
        for (int i = 0; i < timeList.size(); ++i) {
            JSONObject obj = new JSONObject();
            if (timeList.get(i).toString().equals("customPeriod") || timeList.get(i).toString().trim().equals("-----") || timeList.get(i).toString().trim().equals("Last_n_period")) continue;
            Long from = null;
            Long to = null;
            if (timeList.get(i) != null && timeList.get(i).toString().startsWith("UD_")) {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"SERVER_NAME"), (Object)timeList.get(i).toString(), 0);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDCustomPeriod", crit);
                Row row = dataObject.getFirstRow("AUDCustomPeriod");
                from = TimeUtil.getTimePeriod((String)((String)row.get("START_TIME")), (String)((String)row.get("START_HOUR")), (String)((String)row.get("START_MINUTE")));
                to = TimeUtil.getTimePeriod((String)((String)row.get("END_TIME")), (String)((String)row.get("END_HOUR")), (String)((String)row.get("END_MINUTE")));
                obj.put("isCustomPeriod", true);
            } else {
                HashMap timeMap = TimeUtil.getTimePeriod((String)timeList.get(i).toString());
                from = (Long)timeMap.get("FROM");
                to = (Long)timeMap.get("TO");
                obj.put("isCustomPeriod", false);
            }
            obj.put("name", (Object)clientValues.get(i));
            obj.put("start", (Object)from);
            obj.put("end", (Object)to);
            obj.put("serverValue", (Object)timeList.get(i));
            resultList.put((Object)obj);
        }
        return resultList;
    }

    public HashMap<String, Object> setTimePeriod(HashMap<String, Object> inputParams) throws Exception {
        HashMap<String, Object> inputParamsMap = new HashMap<String, Object>();
        String inputDays = (String)inputParams.get("inputDays");
        if (inputDays != null && inputDays.equals("customPeriod")) {
            Long from = TimeUtil.getTimePeriod((String)((String)inputParams.get("startTime")), (String)((String)inputParams.get("startHour")), (String)((String)inputParams.get("startMinute")));
            Long to = TimeUtil.getTimePeriod((String)((String)inputParams.get("endTime")), (String)((String)inputParams.get("endHour")), (String)((String)inputParams.get("endMinute")));
            inputParamsMap.put("FROM", from.toString());
            inputParamsMap.put("TO", to.toString());
            inputParamsMap.put("serverValue", "customPeriod");
        } else if (inputDays != null && inputDays.startsWith("UD_")) {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"SERVER_NAME"), (Object)inputDays, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDCustomPeriod", crit);
            Row row = dataObject.getFirstRow("AUDCustomPeriod");
            Long from = TimeUtil.getTimePeriod((String)((String)row.get("START_TIME")), (String)((String)row.get("START_HOUR")), (String)((String)row.get("START_MINUTE")));
            Long to = TimeUtil.getTimePeriod((String)((String)row.get("END_TIME")), (String)((String)row.get("END_HOUR")), (String)((String)row.get("END_MINUTE")));
            inputParamsMap.put("FROM", from.toString());
            inputParamsMap.put("TO", to.toString());
            inputParamsMap.put("serverValue", inputDays);
        } else {
            HashMap periodMap = TimeUtil.getTimePeriod((String)inputDays);
            inputParamsMap.put("FROM", ((Long)periodMap.get("FROM")).toString());
            inputParamsMap.put("TO", ((Long)periodMap.get("TO")).toString());
            inputParamsMap.put("serverValue", inputDays);
        }
        return inputParamsMap;
    }

    public JSONArray getMyReportCategories() throws JSONException {
        JSONArray list = MyFavRepHandler.getCategoryList();
        JSONArray newList = new JSONArray();
        for (int i = 0; i < list.length(); ++i) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)list.getString(i));
            obj.put("value", (Object)list.getString(i));
            newList.put((Object)obj);
        }
        return newList;
    }

    public JSONArray getReportTabDetails(ArrayList<HashMap<String, Object>> cvIdList, HashMap<String, Object> reportMap, AdventNetResourceBundle rb) throws Exception {
        JSONArray tabList = new JSONArray();
        for (int i = 0; i < cvIdList.size(); ++i) {
            HashMap<String, Object> map = cvIdList.get(i);
            JSONObject tab = new JSONObject();
            JSONObject tabInputParams = new JSONObject();
            Long cvId = Long.parseLong(map.get("cvID").toString());
            tabInputParams.put("cvId", Long.parseLong(map.get("cvID").toString()));
            if (cvIdList.size() > 1) {
                tabInputParams.put("displayName", (Object)rb.getString(map.get("name").toString()));
            } else {
                tabInputParams.put("displayName", reportMap.get("AUDIT_REPORT_NAME"));
            }
            tabInputParams.put("tabId", (Object)("tabId_" + cvId));
            tabInputParams.put("tabIdh", (Object)("#tabId_" + cvId));
            tabInputParams.put("tabName", (Object)("tabName_" + cvId));
            tabInputParams.put("showSearch", true);
            tabInputParams.put("showSaveReport", true);
            tabInputParams.put("showSearchMethod", (Object)"searchAction");
            tabInputParams.put("showAddOrRemove", true);
            tabInputParams.put("showAdvSearch", true);
            tabInputParams.put("showAdvSearchMethod", (Object)"advSearchAction");
            tabInputParams.put("showSearchTooltip", (Object)rb.getString("adap.actions.search"));
            Long monitorId = AuditMonitorAPI.getInstance().getMonitorIdForReport((Long)reportMap.get("AUDIT_REPORT_ID"));
            if (monitorId != null) {
                tabInputParams.put("monitorId", (Object)monitorId);
                String monitorDomainName = (String)AuditMonitorAPI.getInstance().getMonitorDetails(monitorId).get("DOMAIN_NAME");
                tabInputParams.put("monitorDomainName", (Object)monitorDomainName);
            }
            this.getReportTableRangeList(tabInputParams);
            tab.put("tabInputParams", (Object)tabInputParams);
            tab.put("tabReportData", (Object)new JSONObject());
            tab.put("tabChartData", (Object)new JSONObject());
            tabList.put((Object)tab);
        }
        return tabList;
    }

    public HashMap<String, Object> getFavReportInputParams(Long favouriteId) throws Exception {
        JSONObject jsonObj = MyFavRepHandler.getParamDetails((Long)favouriteId);
        Iterator iter = jsonObj.keys();
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.indexOf("object_guid_") != -1) {
                list.add(URLDecoder.decode(jsonObj.getString(key), "utf-8"));
                continue;
            }
            inputParams.put(key, jsonObj.getString(key));
        }
        if (list.size() > 0) {
            inputParams.put("object_guid", list);
            inputParams.put("objectClass", jsonObj.getString("objectClass"));
        } else {
            inputParams.remove("object_guid");
            inputParams.remove("objectClass");
        }
        return inputParams;
    }

    public void getChartInputList(HashMap<String, Object> inputParams, AdventNetResourceBundle rb) throws Exception {
        JSONArray l1 = new JSONArray();
        JSONArray l2 = new JSONArray();
        String[] chartInputNames = new String[]{rb.getString("adap.ReportGraphs.oneday_twoday"), rb.getString("adap.ReportGraphs.oneday_oneweek"), rb.getString("adap.ReportGraphs.oneweek_onemonth")};
        String[] chartInputValues = new String[]{"1;;;2", "1;;;7", "7;;;30"};
        for (int i = 0; i < chartInputNames.length; ++i) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)chartInputNames[i]);
            obj.put("value", (Object)chartInputValues[i]);
            l1.put((Object)obj);
        }
        String[] businessHoursNames = new String[]{rb.getString("adap.BusinessReports.ReportsAllHours"), rb.getString("adap.BusinessReports.ReportsBusiness"), rb.getString("adap.BusinessReports.ReportsNonBusiness")};
        String[] businessHoursValues = new String[]{"0", "1", "2"};
        for (int j = 0; j < businessHoursNames.length; ++j) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)businessHoursNames[j]);
            obj.put("value", (Object)businessHoursValues[j]);
            l2.put((Object)obj);
        }
        inputParams.put("chartInputList", l1);
        inputParams.put("businessInputList", l2);
    }

    public ArrayList<HashMap<String, Object>> getVisibleColumnList(Long cvId, Boolean visible, boolean isMandatory, boolean all, String sortColumn, String sortOrder, AdventNetResourceBundle rb) {
        ArrayList<HashMap<String, Object>> columnList = new ArrayList<HashMap<String, Object>>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
            if (!all) {
                criteria = criteria.and(Column.getColumn((String)"AUDColumnConfiguration", (String)"VISIBLE"), (Object)visible, 0);
                if (!isMandatory) {
                    criteria = criteria.and(Column.getColumn((String)"AUDColumnConfiguration", (String)"MANDATORY"), (Object)isMandatory, 0);
                }
            }
            Table table = Table.getTable((String)"AUDColumnConfiguration");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNINDEX"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDColumnConfiguration");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    HashMap<String, Object> columnDetailsMap = new HashMap<String, Object>();
                    List list = row.getColumns();
                    for (String columnName : list) {
                        if (columnName.equals("COLUMNALIAS") && sortColumn != null && row.get(columnName).toString().equals(sortColumn)) {
                            columnDetailsMap.put("isSortedColumn", true);
                            if (sortOrder.equals("ASC")) {
                                columnDetailsMap.put("isSortASC", true);
                            } else {
                                columnDetailsMap.put("isSortASC", false);
                            }
                        }
                        if (columnName.equals("VIEWNAME") && row.get(columnName) != null) {
                            columnDetailsMap.put(row.get(columnName).toString(), true);
                        }
                        if (columnName.equals("DATE_FORMAT") && row.get(columnName) != null) {
                            columnDetailsMap.put(columnName.toLowerCase(), TimeUtil.getDateFormat());
                            continue;
                        }
                        if (columnName.equals("DISPLAYNAME") && row.get(columnName) != null) {
                            columnDetailsMap.put(columnName.toLowerCase(), rb.getString(row.get(columnName).toString()));
                            continue;
                        }
                        if (columnName.equals("SORTENABLED") && sortColumn == null) {
                            columnDetailsMap.put(columnName.toLowerCase(), false);
                            continue;
                        }
                        columnDetailsMap.put(columnName.toLowerCase(), row.get(columnName));
                    }
                    columnList.add(columnDetailsMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    public String getSearchString(String columnName, String val, String dataType) {
        if (dataType == null) {
            return columnName + " LIKE '" + val + "'";
        }
        if (dataType.toLowerCase().indexOf("char") != -1) {
            return columnName + " LIKE '" + val + "'";
        }
        val = val.replaceAll("%", "");
        return columnName + " = " + val;
    }

    public HashMap<String, Object> getInputParams(Long reportId, HttpServletRequest request) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        try {
            ArrayList inputParamsList = AuditReportParamsAPI.getInputParams((Long)reportId);
            HashMap selectedObjectsMap = null;
            for (HashMap inputMap : inputParamsList) {
                String inputType = (String)inputMap.get("inputType");
                String name = (String)inputMap.get("name");
                String nameValue = request.getParameter(name);
                ArrayList inputList = new ArrayList();
                if (inputType.equalsIgnoreCase("single")) {
                    if (nameValue != null) {
                        inputParams.put(name, nameValue);
                        continue;
                    }
                    inputParams.put(name, (String)inputMap.get("defaultValue"));
                    continue;
                }
                if (!inputType.equalsIgnoreCase("multiple")) continue;
                if (nameValue == null) {
                    if ((String)inputMap.get("defaultValue") != null) {
                        inputList.add((String)inputMap.get("defaultValue"));
                    }
                } else if (nameValue.equalsIgnoreCase("range") || nameValue.equalsIgnoreCase("all")) {
                    if (!selectedObjectsMap.isEmpty()) {
                        inputList = (ArrayList)selectedObjectsMap.get(name);
                    }
                } else if (nameValue.equalsIgnoreCase("allobjects")) {
                    inputList.add("allobjects");
                    inputParams.put("allObjectSelected", "true");
                } else if (!"".equals(nameValue)) {
                    inputList.add(nameValue);
                }
                inputParams.put(name, inputList);
            }
            inputParams = this.getCustomPeriod(inputParams, request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return inputParams;
    }

    private HashMap<String, Object> getCustomPeriod(HashMap<String, Object> inputParams, HttpServletRequest request) throws Exception {
        if (((String)inputParams.get("inputDays")).equalsIgnoreCase("customPeriod")) {
            inputParams.put("startTime", request.getParameter("startTime"));
            inputParams.put("endTime", request.getParameter("endTime"));
            inputParams.put("startHour", request.getParameter("startHour"));
            inputParams.put("endHour", request.getParameter("endHour"));
        }
        return inputParams;
    }

    public static Row getObjectRow(String matchStr, HashMap<String, Object> inputParams) throws Exception {
        String domainSID = AuditReportAPI.getInstance().getDomainSIDString((String)inputParams.get("domainName"));
        String callerSID = matchStr.replace("RID::", domainSID + "-");
        Row objectRow = DirectoryObjectAPI.getInstance().getObjectRow((String)inputParams.get("domainName"), callerSID, "SID_STRING", (String)inputParams.get("objectClass"));
        return objectRow;
    }

    public String getSearchCriteria(JSONObject reportInputParams, String searchCriteria) throws Exception {
        String xColumnValue = reportInputParams.optString("xColumnValue");
        if (xColumnValue != null && !"".equals(xColumnValue)) {
            searchCriteria = searchCriteria != null ? xColumnValue + " AND " + searchCriteria : xColumnValue;
        }
        return searchCriteria;
    }

    public HashMap<String, Object> getInputParamsValues(HashMap<String, Object> inputParams, String domainName, Long reportId) {
        Pattern sIDPattern = Pattern.compile("RID::([^\\}]*)");
        HashMap inputParamsMap = null;
        try {
            HashMap inputParamsCopy = (HashMap)inputParams.clone();
            if (inputParamsCopy != null && !inputParamsCopy.isEmpty()) {
                for (String key : inputParamsCopy.keySet()) {
                    if (!key.equals("object_guid")) continue;
                    ArrayList<String> guidList = (ArrayList<String>)inputParams.remove(key);
                    if (guidList != null && !guidList.isEmpty()) {
                        String objectClass = (String)inputParams.get("objectClass");
                        for (int i = 0; i < guidList.size(); ++i) {
                            String guidStr = (String)guidList.get(i);
                            Matcher match = sIDPattern.matcher(guidStr);
                            if (match.find()) {
                                Row objectRow = ReportHandlerUtil.getObjectRow(match.group(), inputParams);
                                if (objectRow != null) {
                                    guidList.set(i, (String)objectRow.get("OBJECT_GUID"));
                                    continue;
                                }
                                guidList = new ArrayList<String>();
                                continue;
                            }
                            if (!guidStr.equalsIgnoreCase("DEFAULT") || !objectClass.equalsIgnoreCase("Computer")) continue;
                            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                            DataObject dObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMDCConfiguration", criteria);
                            if (dObject.isEmpty()) continue;
                            Row row = dObject.getFirstRow("ADSMDCConfiguration");
                            Row objectRow = DirectoryObjectAPI.getInstance().getComputerObjectRow(objectClass, null, (String)row.get("DOMAIN_CONTROLLER_NAME"), domainName);
                            if (objectRow != null) {
                                guidList.set(i, (String)objectRow.get("OBJECT_GUID"));
                                inputParams.put("objectName", (String)objectRow.get("NAME"));
                                continue;
                            }
                            inputParams.put("objectName", "");
                            guidList = new ArrayList();
                        }
                    }
                    inputParams.put(key, guidList);
                }
            }
            inputParamsMap = AuditReportParamsAPI.getInputParamsValues(inputParams, (Long)reportId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return inputParamsMap;
    }

    public void exportReport(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject reportInputParams = null;
            reportInputParams = reportReqData.getJSONObject("inputParams");
            JSONObject tabInputParams = reportReqData.getJSONObject("tabInputParams");
            Long reportId = reportInputParams.getLong("reportId");
            Long cvId = tabInputParams.getLong("cvId");
            String domainName = reportInputParams.getString("domainName");
            String reportType = request.getParameter("reportType");
            if (reportType == "null") {
                reportType = "";
            }
            String sortColumn = null;
            String sortOrder = null;
            HashMap tableViewConfig = JSONUtil.JSONObjectToMap((JSONObject)((JSONObject)reportInputParams.get("tableViewConfig")));
            if (!tabInputParams.has("sortColumn") || tabInputParams.get("sortColumn") == null) {
                sortColumn = (String)tableViewConfig.get("SORTCOLUMN");
                sortOrder = (String)tableViewConfig.get("SORTORDER");
            } else {
                sortColumn = (String)tabInputParams.get("sortColumn");
                sortOrder = (String)tabInputParams.get("sortOrder");
            }
            String searchCriteria = null;
            if (tabInputParams.has("searchCriteria")) {
                searchCriteria = tabInputParams.getString("searchCriteria");
            }
            if (tabInputParams.optString("xColumnValue") != null && !"".equals(tabInputParams.optString("xColumnValue"))) {
                searchCriteria = searchCriteria != null ? tabInputParams.getString("xColumnValue") + " AND " + searchCriteria : tabInputParams.getString("xColumnValue");
            }
            HashMap<String, String> addionalSQLPropsMap = new HashMap<String, String>();
            addionalSQLPropsMap.put("sortColumn", sortColumn);
            addionalSQLPropsMap.put("sortOrder", sortOrder);
            HashMap reportMap = AuditReportAPI.getInstance().getReportDetails(reportId);
            String tileName = reportInputParams.getString("reportType");
            JSONArray objectGuids = reportInputParams.optJSONArray("object_guid");
            ArrayList objectGuidList = null;
            objectGuidList = objectGuids != null ? (ArrayList)JSONUtil.JSONArrayToList((JSONArray)reportInputParams.optJSONArray("object_guid")) : new ArrayList();
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("objectClass", reportInputParams.getString("objectClass"));
            inputParams.put("object_guid", objectGuidList);
            inputParams.put("domainName", reportInputParams.getString("domainName"));
            inputParams.put("objectName", reportInputParams.getString("objectName"));
            Boolean isRealTimeReport = false;
            if (reportInputParams.has("isRealTimeReport")) {
                isRealTimeReport = reportInputParams.getBoolean("isRealTimeReport");
            }
            if (!isRealTimeReport.booleanValue()) {
                inputParams.put("FROM", reportInputParams.getString("startDate"));
                inputParams.put("TO", reportInputParams.getString("endDate"));
            }
            HashMap inputParamsMap = this.getInputParamsValues(inputParams, reportInputParams.getString("domainName"), reportId);
            if (!isRealTimeReport.booleanValue()) {
                inputParamsMap.put((String)"FROM", (Object)reportInputParams.getString("startDate"));
                inputParamsMap.put((String)"TO", (Object)reportInputParams.getString("endDate"));
            } else {
                inputParamsMap.put((String)"guidStr", (Object)("'" + reportInputParams.getString("genId") + "'"));
            }
            inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputParams, inputParamsMap, (Long)reportId);
            if (tileName.equalsIgnoreCase("matrix")) {
                MatrixExportUtil.exportReport((HttpServletRequest)request, (HttpServletResponse)response, (Long)reportId, (HashMap)inputParamsMap, (String)searchCriteria, new HashMap(), (Long)cvId, (String)reportType, (Long)((Long)request.getSession().getAttribute("ADAP_SESSION_LOGIN_ID")), (String)"simple");
            } else {
                ExportUtil.exportReport((Long)cvId, (HashMap)reportMap, (String)domainName, (String)searchCriteria, (String)reportType, (HashMap)inputParamsMap, addionalSQLPropsMap, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Reports", rb.handleGetObject("adap.AuditReportBean.audit_entry.report_was_exported", new String[]{rb.getString((String)reportMap.get("AUDIT_REPORT_NAME")), reportType, domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.report_exported", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Long getReportIdFromFavouriteId(Long favouriteId) {
        Long reportId = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDFavourites", (String)"FAVOURITE_ID"), (Object)favouriteId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDFavourites", criteria);
            if (!dataObj.isEmpty()) {
                Row favRow = dataObj.getFirstRow("AUDFavourites");
                reportId = (Long)favRow.get("AUDIT_REPORT_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportId;
    }

    public String saveCustomPeriod(String displayName, Long fromTime, Long toTime, JSONObject reportInputParams, AdventNetResourceBundle rb) throws Exception {
        Date date = new Date(fromTime * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = sdf.format(date);
        Integer startHour = date.getHours();
        Integer startMinute = date.getMinutes();
        Date date1 = new Date(toTime * 1000L);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String endDate = sdf1.format(date1);
        Integer endHour = date1.getHours();
        Integer endMinute = date1.getMinutes();
        String message = rb.getString("adap.AUDReports.status_message.Successfully_Configured_CustomPeriod");
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row row = null;
        row = new Row("AUDCustomPeriod");
        row.set("CLIENT_NAME", (Object)displayName);
        row.set("SERVER_NAME", (Object)("UD_" + displayName.replace(" ", "_")));
        row.set("START_TIME", (Object)startDate);
        row.set("END_TIME", (Object)endDate);
        row.set("START_HOUR", (Object)startHour);
        row.set("END_HOUR", (Object)endHour);
        row.set("START_MINUTE", (Object)startMinute);
        row.set("END_MINUTE", (Object)endMinute);
        dataObject.addRow(row);
        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
        JSONArray timeList = (JSONArray)reportInputParams.get("timeList");
        JSONObject obj = new JSONObject();
        obj.put("name", (Object)displayName);
        obj.put("start", (Object)fromTime);
        obj.put("end", (Object)toTime);
        obj.put("serverValue", row.get("SERVER_NAME"));
        obj.put("isCustomPeriod", true);
        timeList.put((Object)obj);
        reportInputParams.put("chosenServerValue", row.get("SERVER_NAME"));
        message = rb.getString("adap.AUDReports.status_message.Exception_while_Stroing_Custom_Period");
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getReportGraphValues(String sqlString, boolean isStacked, String chartType, String viewName, HashMap graphMap) {
        JSONObject reportObj = new JSONObject();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                ArrayList<String> categories = new ArrayList<String>();
                TreeMap categoryMap = new TreeMap();
                JSONArray cateArray = new JSONArray();
                ArrayList<String> stackList = new ArrayList<String>();
                while (resultSet.next()) {
                    TreeMap<String, Long> stackMap;
                    String category = resultSet.getString(2);
                    String stack = resultSet.getString(3);
                    Long stackValue = resultSet.getLong(1);
                    if (!categories.contains(category)) {
                        categories.add(category);
                        cateArray.put((Object)category);
                    }
                    if (category == null) {
                        category = "-";
                    }
                    if ((stackMap = (TreeMap<String, Long>)categoryMap.get(category)) == null) {
                        stackMap = new TreeMap<String, Long>();
                        categoryMap.put(category, stackMap);
                    }
                    if (!stackList.contains(stack)) {
                        stackList.add(stack);
                    }
                    stackMap.put(stack, stackValue);
                }
                Iterator it = categoryMap.entrySet().iterator();
                JSONArray catList = new JSONArray();
                JSONObject map2 = new JSONObject();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    catList.put(pair.getKey());
                    TreeMap obj = (TreeMap)pair.getValue();
                    for (int i = 0; i < stackList.size(); ++i) {
                        String stack = (String)stackList.get(i);
                        Long stackValue = null;
                        stackValue = obj.get(stack) == null ? Long.valueOf(0L) : (Long)obj.get(stack);
                        JSONArray l2 = map2.optJSONArray(stack);
                        if (l2 == null) {
                            l2 = new JSONArray();
                            map2.put(stack, (Object)l2);
                        }
                        l2.put((Object)stackValue);
                    }
                }
                JSONArray l3 = new JSONArray();
                Iterator it2 = map2.keys();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    if (!(map2.get(key) instanceof JSONArray)) continue;
                    JSONObject map3 = new JSONObject();
                    map3.put("name", (Object)key);
                    map3.put("data", (Object)map2.getJSONArray(key));
                    l3.put((Object)map3);
                }
                reportObj.put("xList", (Object)catList);
                reportObj.put("yList", (Object)l3);
            } else if (chartType.equals("timeseries") || chartType.equals("line")) {
                ArrayList<String> categories = new ArrayList<String>();
                TreeMap categoryMap = new TreeMap();
                JSONArray cateArray = new JSONArray();
                ArrayList<String> stackList = new ArrayList<String>();
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, Long> stackMap;
                    String category = resultSet.getString(2);
                    String stack = null;
                    stack = graphMap.get("mColumn") != null ? resultSet.getString(graphMap.get("mColumn").toString()) : viewName;
                    Long stackValue = resultSet.getLong(1);
                    if (!categories.contains(category)) {
                        categories.add(category);
                        cateArray.put((Object)category);
                    }
                    if ((stackMap = (TreeMap<String, Long>)categoryMap.get(category)) == null) {
                        stackMap = new TreeMap<String, Long>();
                        categoryMap.put(category, stackMap);
                    }
                    if (!stackList.contains(stack)) {
                        stackList.add(stack);
                    }
                    stackMap.put(stack, stackValue);
                }
                Iterator it = categoryMap.entrySet().iterator();
                JSONArray catList = new JSONArray();
                JSONObject map2 = new JSONObject();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    catList.put(pair.getKey());
                    TreeMap obj = (TreeMap)pair.getValue();
                    for (int i = 0; i < stackList.size(); ++i) {
                        String stack = (String)stackList.get(i);
                        Long stackValue = null;
                        stackValue = obj.get(stack) == null ? Long.valueOf(0L) : (Long)obj.get(stack);
                        JSONArray l2 = map2.optJSONArray(stack);
                        if (l2 == null) {
                            l2 = new JSONArray();
                            map2.put(stack, (Object)l2);
                        }
                        l2.put((Object)stackValue);
                    }
                }
                JSONArray l3 = new JSONArray();
                Iterator it2 = map2.keys();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    if (!(map2.get(key) instanceof JSONArray)) continue;
                    JSONObject map3 = new JSONObject();
                    map3.put("name", (Object)key);
                    map3.put("data", (Object)map2.getJSONArray(key));
                    l3.put((Object)map3);
                }
                reportObj.put("xList", (Object)cateArray);
                reportObj.put("yList", (Object)l3);
            } else {
                ArrayList<String> xlist = new ArrayList<String>();
                ArrayList<Long> ylist = new ArrayList<Long>();
                while (resultSet.next()) {
                    xlist.add(resultSet.getString(2));
                    ylist.add(resultSet.getLong(1));
                }
                reportObj.put("xList", (Object)new JSONArray(xlist));
                reportObj.put("yList", (Object)new JSONArray(ylist));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return reportObj;
    }
}

