/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit.cluster;

import com.adventnet.sym.adsm.auditing.webclient.fileaudit.cluster.ClusterBean;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.ntfs.cluster.ClusterConfigAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ClusterAction
extends DispatchAction {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(ClusterAction.class.getName());

    public ActionForward wizard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = null;
        String message = null;
        String cardName = null;
        try {
            ClusterBean temp = (ClusterBean)form;
            cardName = (String)temp.get("cardName");
            temp.init(request);
            request.setAttribute("operation", temp.get("operation"));
            request.setAttribute("domain", temp.get("domain"));
            if (cardName.equals("clusterIntro")) {
                forwardPage = cardName;
            } else if (cardName.equals("clusterDes")) {
                forwardPage = cardName;
                String operation = (String)temp.get("operation");
                temp.set("CLUSTER_NAME", "");
            } else if (cardName.equals("clusterNodes")) {
                forwardPage = cardName;
            } else if (cardName.equals("clusterCaps")) {
                forwardPage = cardName;
            } else if (cardName.equals("clusterShares")) {
                forwardPage = cardName;
            } else if (cardName.equals("clusterSummary")) {
                forwardPage = cardName;
                request.setAttribute("CLUSTER_NAME", temp.get("CLUSTER_NAME"));
                request.setAttribute("clusterCapName", temp.get("clusterCapName"));
            }
            if (request.getParameter("save") != null) {
                message = temp.addFileServer(request);
                forwardPage = "viewServers";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String mess = e.getMessage();
            if (mess != null) {
                request.setAttribute("errorMessage", (Object)mess);
            }
            forwardPage = cardName;
        }
        request.setAttribute("cardName", (Object)cardName);
        if (message != null) {
            request.setAttribute("message", message);
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getClusterNodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "viewClusterNodes";
        String message = null;
        try {
            ClusterBean bean = (ClusterBean)form;
            String clusterName = (String)bean.get("CLUSTER_NAME");
            String domainName = (String)bean.get("domain");
            Long clusterId = (Long)bean.get("clusterId");
            String refresh = request.getParameter("refresh");
            String searchTxt = (String)bean.get("clusterNodeSearchTxt");
            ArrayList nodeList = new ArrayList();
            Hashtable nodeTable = ClusterConfigAPI.getInstance().getClusterNodeInfo(domainName, clusterName, clusterId, searchTxt, refresh);
            nodeList = (ArrayList)nodeTable.get("Nodes");
            int nodeCount = nodeList.size();
            message = (String)nodeTable.get("message");
            request.setAttribute("nodeCount", (Object)nodeCount);
            request.setAttribute("nodeList", (Object)nodeList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        if (message != null) {
            request.setAttribute("message", (Object)message);
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward getClusterResources(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ClusterBean bean = (ClusterBean)form;
        String forwardName = "viewServerObjects";
        String message = null;
        try {
            String domainName = (String)bean.get("domain");
            String clusterName = (String)bean.get("CLUSTER_NAME");
            Long clusterId = (Long)bean.get("clusterId");
            String searchTxt = (String)bean.get("clusterCapSearchTxt");
            String refresh = request.getParameter("refresh");
            ArrayList capList = new ArrayList();
            Hashtable capTable = ClusterConfigAPI.getInstance().getClusterResourceInfo(domainName, clusterName, clusterId, searchTxt, null, null, refresh);
            capList = (ArrayList)capTable.get("Caps");
            int count = capList.size();
            if (count < (Integer)bean.get("FROM_INDEX")) {
                bean.set("FROM_INDEX", 1);
                bean.set("PAGE_NUMBER", "1");
            }
            message = (String)capTable.get("message");
            if (count > 0) {
                refresh = "false";
                capTable = ClusterConfigAPI.getInstance().getClusterResourceInfo(domainName, clusterName, clusterId, searchTxt, (Integer)bean.get("FROM_INDEX"), (Integer)bean.get("RANGE"), refresh);
                capList = (ArrayList)capTable.get("Caps");
            }
            request.setAttribute("selectType", (Object)request.getParameter("selectType"));
            request.setAttribute("count", (Object)count);
            request.setAttribute("capList", (Object)capList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (message != null) {
            request.setAttribute("message", message);
        }
        if (request.getParameter("status") != null) {
            return null;
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward getClusterShares(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "viewShareObjects";
        String message = null;
        try {
            ClusterBean bean = (ClusterBean)form;
            String hostName = (String)bean.get("clusterCapName");
            String hostGuid = (String)bean.get("clusterCapGuid");
            String domainName = (String)bean.get("domain");
            String refresh = request.getParameter("refresh");
            String searchTxt = (String)bean.get("clusterShareSearchTxt");
            String operation = (String)bean.get("operation");
            String shareAction = "";
            if (operation.equals("addCap") || operation.equals("new")) {
                shareAction = "ALL";
            } else if (operation.equals("addShare")) {
                shareAction = "ADD";
            }
            HashMap<String, String> shareMap = new HashMap<String, String>();
            shareMap.put("HOST_NAME", hostName);
            shareMap.put("REFRESH", refresh);
            shareMap.put("DOMAIN_NAME", domainName);
            shareMap.put("SHARE_ACTION", shareAction);
            Hashtable shareTable = FileSystemAPI.getInstance().getSharesForServer(null, shareMap, searchTxt, Integer.valueOf(0));
            ArrayList shareList = (ArrayList)shareTable.get("Shares");
            int shareCount = shareList.size();
            message = (String)shareTable.get("message");
            request.setAttribute("shareList", (Object)shareList);
            request.setAttribute("shareCount", (Object)shareCount);
            request.setAttribute("operation", (Object)operation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        if (message != null) {
            request.setAttribute("message", (Object)message);
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward validateShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "Shares";
        try {
            ClusterBean temp = (ClusterBean)form;
            temp.validateShare(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward validateNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "Nodes";
        try {
            ClusterBean temp = (ClusterBean)form;
            temp.validateNode(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward isExists(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ClusterBean bean = (ClusterBean)form;
        bean.init(request);
        String message = null;
        String CLUSTER_NAME = (String)bean.get("CLUSTER_NAME");
        String domainName = (String)bean.get("domain");
        try {
            Long clusterId = ClusterConfigAPI.validateClusterName((String)CLUSTER_NAME, (String)domainName);
            if (clusterId != null && !clusterId.equals("")) {
                bean.set("clusterId", clusterId);
                bean.set("CLUSTER_NAME", CLUSTER_NAME);
                request.setAttribute("operation", (Object)"new");
                request.setAttribute("cardName", (Object)"clusterNodes");
                return mapping.findForward("temp");
            }
            throw new Exception(rb.getString("adap.ClusterAction.Error_occured_ClusterID_could_not_be_null"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            request.setAttribute("message", (Object)message);
            request.setAttribute("operation", (Object)"new");
            return mapping.findForward("clusterDes");
        }
    }
}

