/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit.cluster;

import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class ClusterBean
extends DynaValidatorForm {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private ArrayList clusterShareList = new ArrayList();
    private ArrayList clusterNodeList = new ArrayList();

    public void setClusterNodeList(ArrayList l) {
        this.clusterNodeList = l;
    }

    public ArrayList getClusterNodeList() {
        return this.clusterNodeList;
    }

    public void setClusterShareList(ArrayList l) {
        this.clusterShareList = l;
    }

    public ArrayList getClusterShareList() {
        return this.clusterShareList;
    }

    public void init(HttpServletRequest request) throws Exception {
        try {
            String operation = (String)this.get("operation");
            String cardName = (String)this.get("cardName");
            HttpSession session = request.getSession();
            if (operation.equals("new") && cardName.equals("clusterIntro")) {
                this.set("operation", operation);
                this.set("cardName", cardName);
                this.set("clusterCapName", "");
                this.set("clusterNodeSearchTxt", "");
                this.set("clusterCapSearchTxt", "");
                this.set("clusterShareSearchTxt", "");
                this.clusterNodeList = new ArrayList();
                this.clusterShareList = new ArrayList();
            } else if (operation.equals("new") && cardName.equals("clusterDes")) {
                this.set("CLUSTER_NAME", (String)this.get("CLUSTER_NAME"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", "Initiate to configure the Windows Failover Cluster " + (String)this.get("CLUSTER_NAME"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.initiate_configure_Failovercluster", "-"}));
                this.set("clusterId", null);
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("new") && cardName.equals("clusterNodes")) {
                this.clusterNodeList = new ArrayList();
                this.set("clusterNodeSearchTxt", "");
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("new") && cardName.equals("clusterCaps")) {
                this.clusterShareList = new ArrayList();
                this.set("clusterCapName", "");
                this.set("clusterCapSearchTxt", "");
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("new") && cardName.equals("clusterShares")) {
                this.clusterShareList = new ArrayList();
                this.set("clusterShareSearchTxt", "");
                this.set("clusterCapName", (String)this.get("clusterCapName"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("new") && cardName.equals("clusterSummary")) {
                this.set("CLUSTER_NAME", (String)this.get("CLUSTER_NAME"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("addNode") && cardName.equals("clusterNodes")) {
                this.clusterNodeList = new ArrayList();
                this.set("clusterNodeSearchTxt", "");
            } else if (operation.equals("addCap") && cardName.equals("clusterCaps")) {
                this.clusterShareList = new ArrayList();
                this.set("clusterCapName", "");
                this.set("clusterCapSearchTxt", "");
                this.set("clusterShareSearchTxt", "");
                this.set("PAGE_NUMBER", "1");
                this.set("RANGE", 25);
                this.set("FROM_INDEX", 1);
                this.set("TO_INDEX", 25);
            } else if (operation.equals("addCap") && cardName.equals("clusterShares")) {
                this.clusterShareList = new ArrayList();
                this.set("clusterCapName", (String)this.get("clusterCapName"));
                this.set("clusterShareSearchTxt", "");
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("addCap") && cardName.equals("clusterSummary")) {
                this.set("CLUSTER_NAME", (String)this.get("CLUSTER_NAME"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("addShare") && cardName.equals("clusterShares")) {
                this.clusterShareList = new ArrayList();
                this.set("clusterCapName", (String)this.get("clusterCapName"));
                this.set("clusterShareSearchTxt", "");
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("addShare") && cardName.equals("clusterSummary")) {
                this.set("CLUSTER_NAME", (String)this.get("CLUSTER_NAME"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("save")) {
                this.set("operation", operation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String addFileServer(HttpServletRequest request) throws Exception {
        String message = "";
        String messageType = "Success";
        Object shareAction = null;
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"fileServers", (ADAPAuthObject)authObj);
        try {
            String operation = (String)this.get("operation");
            String clusterName = (String)this.get("CLUSTER_NAME");
            String domainName = (String)this.get("domain");
            Long clusterId = (Long)this.get("clusterId");
            String clusterResourceName = (String)this.get("clusterCapName");
            ArrayList<String> shareUNCNameList = new ArrayList<String>();
            String isSacl = request.getParameter("isSacl");
            String isGpo = request.getParameter("isGpo");
            for (int i = 0; i < this.clusterShareList.size(); ++i) {
                Hashtable shareTable = (Hashtable)this.clusterShareList.get(i);
                String shareUNCName = (String)shareTable.get("SHARE_UNC_NAME");
                if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                    shareUNCName = EscapeUtil.escSplCharsAsMSSQL((Object)shareUNCName);
                }
                if (shareUNCNameList.contains(shareUNCName)) continue;
                shareUNCNameList.add(shareUNCName);
            }
            ArrayList clusterNodeDetails = this.clusterNodeList;
            if (accessType == 32) {
                if (operation.equals("new")) {
                    message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, (ArrayList)clusterNodeDetails, (String)clusterResourceName, shareUNCNameList, (String)operation, (String)isSacl, (String)isGpo);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", rb.handleGetObject("adap.ClusterBean.audit_entry.Successfully_configured_Cluster", new String[]{(String)this.get("CLUSTER_NAME"), clusterNodeDetails.toString(), clusterResourceName, shareUNCNameList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.cluster_config_successfully", "-"}));
                } else if (operation.equals("addNode")) {
                    message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, (ArrayList)clusterNodeDetails, null, null, (String)operation, null, (String)isGpo);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", rb.handleGetObject("adap.ClusterBean.audit_entry.Successfully_confiugured_cluster_node", new String[]{(String)this.get("CLUSTER_NAME"), clusterNodeDetails.toString(), shareUNCNameList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.cluster_node_config_successfully", "-"}));
                } else if (operation.equals("addCap")) {
                    message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, null, (String)clusterResourceName, shareUNCNameList, (String)operation, (String)isSacl, null);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", rb.handleGetObject("adap.ClusterBean.audit_entry.Successfully_configured_client_access_point", new String[]{(String)this.get("CLUSTER_NAME"), clusterResourceName, shareUNCNameList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.CAP_Config_successfully", "-"}));
                } else if (operation.equals("addShare")) {
                    message = ClusterHandler.addClusterConfig((String)domainName, (String)clusterName, (Long)clusterId, null, (String)clusterResourceName, shareUNCNameList, (String)operation, (String)isSacl, null);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", rb.handleGetObject("adap.ClusterBean.audit_entry.Successfully_configured_cluster_share", new String[]{(String)this.get("CLUSTER_NAME"), shareUNCNameList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Cluster_share_added", "-"}));
                }
            } else {
                message = rb.getString("adap.access_denied.ClusterBean.fail");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "File Audit", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            messageType = "Error";
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "File Audit", rb.handleGetObject("adap.ClusterBean.audit_entry.Problem_while_configuring_failover_cluster", new String[]{(String)this.get("CLUSTER_NAME")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.fail_to_configure_clsuter", "-"}));
        }
        request.setAttribute("messageType", (Object)messageType);
        request.setAttribute("message", (Object)message);
        return message;
    }

    public void validateShare(HttpServletRequest request) {
        String shareOperation = (String)this.get("shareOperation");
        if (shareOperation.equals("")) {
            String selectedValues = request.getParameter("selectedValues");
            if (selectedValues == null) {
                return;
            }
            StringTokenizer token = new StringTokenizer(selectedValues, ",");
            while (token.hasMoreTokens()) {
                String shareUNCName = (String)token.nextElement();
                boolean status = false;
                for (int i = 0; i < this.clusterShareList.size(); ++i) {
                    Hashtable p = (Hashtable)this.clusterShareList.get(i);
                    String shareName = (String)p.get("SHARE_UNC_NAME");
                    if (!shareName.equals(shareUNCName)) continue;
                    status = true;
                    break;
                }
                if (status) continue;
                Hashtable<String, String> p = new Hashtable<String, String>();
                p.put("SHARE_UNC_NAME", shareUNCName);
                this.clusterShareList.add(0, p);
            }
        } else if (shareOperation.equals("DeleteAll")) {
            this.clusterShareList.clear();
        } else {
            String selectedShareListValue = request.getParameter("shareListValue");
            for (int i = 0; i < this.clusterShareList.size(); ++i) {
                Hashtable p = (Hashtable)this.clusterShareList.get(i);
                String shareUNCName = (String)p.get("SHARE_UNC_NAME");
                if (!shareUNCName.equals(selectedShareListValue) || !shareOperation.equals("delete")) continue;
                this.clusterShareList.remove(i);
                --i;
                break;
            }
        }
    }

    public void validateNode(HttpServletRequest request) {
        String nodeOperation = (String)this.get("nodeOperation");
        if (nodeOperation.equals("")) {
            String selectedValues = request.getParameter("selectedValues");
            String selectedValuesNames = request.getParameter("selectedValuesNames");
            if (selectedValues == null) {
                return;
            }
            StringTokenizer token = new StringTokenizer(selectedValuesNames, ",");
            while (token.hasMoreTokens()) {
                String str = (String)token.nextElement();
                int andIndex = str.indexOf("~");
                String clusterNodeGuid = str.substring(0, andIndex);
                String clusterNodeName = str.substring(andIndex + 1, str.length());
                boolean status = false;
                for (int i = 0; i < this.clusterNodeList.size(); ++i) {
                    Hashtable p = (Hashtable)this.clusterNodeList.get(i);
                    String nodeGuid = (String)p.get("OBJECT_GUID");
                    if (!nodeGuid.equals(clusterNodeGuid)) continue;
                    status = true;
                    break;
                }
                if (status) continue;
                Hashtable<String, String> p = new Hashtable<String, String>();
                p.put("OBJECT_GUID", clusterNodeGuid);
                p.put("NODE_NAME", clusterNodeName);
                this.clusterNodeList.add(0, p);
            }
        } else if (nodeOperation.equals("DeleteAll")) {
            this.clusterNodeList.clear();
        } else {
            String selectedNodeListValue = request.getParameter("nodeListValue");
            for (int i = 0; i < this.clusterNodeList.size(); ++i) {
                Hashtable p = (Hashtable)this.clusterNodeList.get(i);
                String nodeGuid = (String)p.get("OBJECT_GUID");
                if (!nodeGuid.equals(selectedNodeListValue) || !nodeOperation.equals("delete")) continue;
                this.clusterNodeList.remove(i);
                --i;
                break;
            }
        }
    }
}

