/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.fileaudit.netapp;

import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class ViewNetAppFilers
extends Action {
    private static Logger logger = Logger.getLogger(ViewNetAppFilers.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forwardPage = "viewNetApps";
        String[] fileServerTypes = new String[]{"Windows File Server", "Windows FailOver Cluster", "NetApp Server", "EMC Server"};
        DynaActionForm bean = (DynaActionForm)form;
        HttpSession session = request.getSession();
        String domainName = request.getParameter("domainName");
        String fileServerType = (String)bean.get("FILE_SERVER_TYPE");
        if (domainName == null) {
            domainName = (String)bean.get("DOMAIN_NAME");
        }
        if (domainName == null) {
            domainName = DomainDetailsAPI.getDefaultDomainName();
        }
        if (request.getParameter("init") != null) {
            bean.initialize(mapping);
        }
        if ("".equals(domainName)) {
            domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        } else {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        logger.log(Level.FINE, "Domain Name" + domainName);
        if (request.getParameter("sortColumn") != null) {
            bean.set("sortColumn", (Object)request.getParameter("sortColumn"));
            bean.set("sortOrder", (Object)request.getParameter("sortOrder"));
            bean.set("PAGE_NUMBER", (Object)"1");
            bean.set("FROM_INDEX", (Object)1);
        }
        if (request.getParameter("clearSearch") != null) {
            bean.set("searchString", (Object)"");
            bean.set("PAGE_NUMBER", (Object)"1");
            bean.set("FROM_INDEX", (Object)1);
        }
        Long cvID = 100000L;
        String searchCriteria = this.getColumnSearchCriteria(request, cvID, bean);
        HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
        addnParamsMap.put("sortColumn", (String)bean.get("sortColumn"));
        addnParamsMap.put("sortOrder", (String)bean.get("sortOrder"));
        addnParamsMap.put("tableName", (String)bean.get("tableName"));
        addnParamsMap.put("noOfObjects", bean.get("RANGE"));
        addnParamsMap.put("startIndex", bean.get("FROM_INDEX"));
        logger.log(Level.FINE, "HashMap addnParamsMap values" + addnParamsMap);
        String action = (String)bean.get("action");
        if (action == null) {
            action = "All";
        }
        int[] machineTypes = NetAppHandler.getMachineTypes((String)fileServerType, (String)action);
        int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, (String)searchCriteria, null, (int[])machineTypes, null);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ServerConfigAPI.getConfiguredServers((String)domainName, addnParamsMap, (String)searchCriteria, null, null, (int[])machineTypes, (Integer)count);
        }
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        ArrayList domainList = authObject.getConfiguredDomainList();
        String[] domainNames = new String[domainList.size()];
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
        }
        Properties defAuditConfig = new Properties();
        defAuditConfig.put("naVserverDefRotType", NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_TYPE"));
        defAuditConfig.put("naVserverDefFileCnt", NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_LIMIT"));
        defAuditConfig.put("naVserverDefFileSize", NetAppHandler.getNaVserverDefaultAuditConfig().get("ROTATE_SIZE_STR"));
        defAuditConfig.put("naVserverDefFilePath", NetAppHandler.getNaVserverDefaultAuditConfig().get("EVT_FILE_JUNCTION_PATH"));
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, Boolean.valueOf(true));
        request.setAttribute("columnList", (Object)columnList);
        bean.set("domainNames", (Object)domainNames);
        bean.set("DOMAIN_NAME", (Object)domainName);
        bean.set("FILE_SERVER_TYPE", (Object)fileServerType);
        bean.set("fileServerTypes", (Object)fileServerTypes);
        request.setAttribute("count", (Object)count);
        request.setAttribute("list", (Object)list);
        request.setAttribute("defVserverAuditConfig", (Object)defAuditConfig);
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "File Audit", rb.handleGetObject("adap.ViewNetAppFilers.audit_entry.Netapp_filer_viewd_for_doamin", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.netapp_filer_Viewed", "-"}));
        return mapping.findForward(forwardPage);
    }

    public String getColumnSearchCriteria(HttpServletRequest request, Long cvId, DynaActionForm bean) {
        String searchCriteria = null;
        String columnName = "";
        String tableName = "";
        try {
            String searchString = (String)bean.get("searchString");
            boolean search = false;
            if (request.getParameter("search") != null) {
                searchString = "";
                search = true;
            }
            Boolean visible = true;
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            for (int i = 0; i < columnList.size(); ++i) {
                HashMap columnMap = (HashMap)columnList.get(i);
                tableName = (String)columnMap.get("TABLEALIAS");
                columnName = (String)columnMap.get("COLUMNALIAS");
                Long columnConfId = (Long)columnMap.get("COLUMN_CONF_ID");
                String val = null;
                if (search) {
                    if (request.getParameter("search_" + columnConfId.toString()) != null) {
                        val = request.getParameter("search_" + columnConfId);
                        if (!searchString.equalsIgnoreCase("")) {
                            searchString = searchString + "&";
                        }
                        searchString = searchString + "search_" + columnConfId + "=" + val;
                    }
                } else {
                    val = ViewNetAppFilers.getSearchString(searchString, columnConfId);
                }
                if (val == null || val.equalsIgnoreCase("")) continue;
                val = CommonUtil.getSearchString((String)val);
                searchCriteria = searchCriteria == null ? new String() : searchCriteria + " AND ";
                searchCriteria = searchCriteria + columnName + " LIKE '" + val + "'";
                logger.log(Level.INFO, "searchCriteria is: " + searchCriteria);
            }
            if (search) {
                bean.set("searchString", (Object)searchString);
                bean.set("PAGE_NUMBER", (Object)"1");
                bean.set("FROM_INDEX", (Object)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchCriteria;
    }

    public static String getSearchString(String searchString, Long id) throws Exception {
        String val = "";
        int index = searchString.indexOf("search_" + id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }
}

