/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileaudit.ModifySaclThread;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.webclient.monitor.model.MonitorBean;
import com.adventnet.sym.adsm.auditing.webclient.monitor.util.AuditActionClientUtil;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditMonitor
extends DispatchAction {
    public ActionForward getActionsForCategory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            String categoryId = request.getParameter("categoryId");
            ArrayList availableActionsList = AuditCategoryHandler.getInstance().getActionsForCategory(Long.valueOf(Long.parseLong(categoryId)));
            AuditActionClientUtil.setXMLElement(response, availableActionsList, "actions");
            bean.set("availableActionsList", availableActionsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward selectObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("selectObjects");
    }

    public ActionForward addObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            ArrayList objectList;
            String selectedObjects = request.getParameter("selectedObjects");
            String selectedObjectNames = request.getParameter("selectedObjectNames");
            String objectClass = request.getParameter("objectClass");
            StringTokenizer objectTokenizer = new StringTokenizer(selectedObjects, ";;;");
            StringTokenizer objectNamesTokenizer = new StringTokenizer(selectedObjectNames, ";;;");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            String clearDomain = request.getParameter("clearDomain");
            if (clearDomain != null) {
                selectedObjectsMap = new HashMap();
            }
            if ((objectList = (ArrayList)selectedObjectsMap.get(objectClass)) == null) {
                objectList = new ArrayList();
            }
            while (objectTokenizer.hasMoreTokens()) {
                String object = objectTokenizer.nextToken();
                String objectName = objectNamesTokenizer.nextToken();
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("OBJECT_GUID", object);
                objectMap.put("NAME", objectName);
                if (objectList.contains(objectMap)) continue;
                objectList.add(objectMap);
            }
            selectedObjectsMap.put(objectClass, objectList);
            bean.set("selectedObjectsMap", selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeAllObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            bean.set("selectedObjectsMap", new HashMap());
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            String selectedObjects = request.getParameter("selectedObjects");
            String selectedObjectNames = request.getParameter("selectedObjectNames");
            String objectClass = request.getParameter("objectClass");
            StringTokenizer objectTokenizer = new StringTokenizer(selectedObjects, ";;;");
            StringTokenizer objectNamesTokenizer = new StringTokenizer(selectedObjectNames, ";;;");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList objectList = (ArrayList)selectedObjectsMap.get(objectClass);
            if (objectList == null) {
                objectList = new ArrayList();
            }
            while (objectTokenizer.hasMoreTokens()) {
                String object = objectTokenizer.nextToken();
                String objectName = objectNamesTokenizer.nextToken();
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("OBJECT_GUID", object);
                objectMap.put("NAME", objectName);
                objectList.remove(objectMap);
            }
            if (objectList.isEmpty()) {
                selectedObjectsMap.remove(objectClass);
            } else {
                selectedObjectsMap.put(objectClass, objectList);
            }
            bean.set("selectedObjectsMap", selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeShares(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            String selectedServer = request.getParameter("selectedServer");
            String selectedShares = request.getParameter("selectedShares");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            System.out.println("selectedShares : " + selectedShares);
            System.out.println("selectedObjectsMap before removal of shares : " + selectedObjectsMap);
            ArrayList shareNameList = (ArrayList)selectedObjectsMap.get(selectedServer);
            StringTokenizer shareTokenizer = new StringTokenizer(selectedShares, ";;;");
            while (shareTokenizer.hasMoreTokens()) {
                shareNameList.remove(shareTokenizer.nextToken());
            }
            selectedObjectsMap.put(selectedServer, shareNameList);
            bean.set("selectedObjectsMap", selectedObjectsMap);
            System.out.println("selectedObjectsMap after removal of shares : " + selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward addShares(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            Hashtable<String, Object> saclDetails = new Hashtable<String, Object>();
            String shareIDs = request.getParameter("SHARE_LOCATIONS");
            String userSelection = request.getParameter("userSelection");
            ArrayList<String> shareIdList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(shareIDs, ",");
            while (tokenizer.hasMoreTokens()) {
                shareIdList.add(tokenizer.nextToken());
            }
            saclDetails.put("LOCATIONS", shareIdList);
            DataObject dataObject = FileSystemAPI.getShareDO((Object[])shareIdList.toArray(new Object[shareIdList.size()]), (String)"LOCATION");
            Row row = dataObject.getRow("ADSMShareGeneralDetails");
            String serverName = (String)row.get("HOST_COMPUTER");
            saclDetails.put("serverName", serverName);
            saclDetails.put("domainName", (String)row.get("DOMAIN_NAME"));
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList<String> shareNameList = (ArrayList<String>)selectedObjectsMap.get(serverName);
            if (shareNameList == null) {
                shareNameList = new ArrayList<String>();
            }
            Iterator iterator = dataObject.getRows("ADSMShareGeneralDetails");
            while (iterator.hasNext()) {
                Row shareRow = (Row)iterator.next();
                String shareName = (String)shareRow.get("LOCATION");
                if (shareNameList.contains(shareName)) continue;
                shareNameList.add(shareName);
            }
            selectedObjectsMap.put(serverName, shareNameList);
            bean.set("selectedObjectsMap", selectedObjectsMap);
            System.out.println("selectedObjectsMap after adding : " + selectedObjectsMap);
            EditMonitor.setShareXMLElement(response, serverName, shareNameList);
            System.out.println("saclDetails" + saclDetails);
            System.out.println("user Selection is" + userSelection);
            if (userSelection != null) {
                if (userSelection.equalsIgnoreCase("yes")) {
                    new ModifySaclThread(saclDetails);
                } else {
                    System.out.println("user is not ready to set SACL");
                }
            } else {
                System.out.println("user Selection is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeServer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitorBean bean = (MonitorBean)form;
        try {
            String selectedServer = request.getParameter("selectedServer");
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            selectedObjectsMap.remove(selectedServer);
            bean.set("selectedObjectsMap", selectedObjectsMap);
            System.out.println("selectedObjectsMap after removal : " + selectedObjectsMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    private static void setShareXMLElement(HttpServletResponse response, String serverName, ArrayList shareList) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element count = document.createElement("server");
            count.setAttribute("value", serverName);
            data.appendChild(count);
            for (Object object : shareList) {
                Element shareElement = document.createElement("share");
                String shareName = (String)object;
                shareElement.setAttribute("name", shareName);
                data.appendChild(shareElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

