/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.monitor.model.MonitorBean;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SaveMonitor
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forwardString = "modify";
        String selectedTab = "config";
        MonitorBean bean = (MonitorBean)form;
        int monitorType = 1;
        if (request.getParameter("selectedTab") != null) {
            selectedTab = request.getParameter("selectedTab");
        }
        if (selectedTab.equalsIgnoreCase("fileAudit")) {
            forwardString = "fileAuditMonitor";
            monitorType = 2;
        } else if (selectedTab.equalsIgnoreCase("serverAudit")) {
            forwardString = "serverAuditMonitor";
            monitorType = 3;
        }
        System.out.println("bean : " + (Object)((Object)bean));
        Long categoryId = (Long)bean.get("CATEGORY_ID");
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put("MONITOR_NAME", bean.get("MONITOR_NAME"));
        propsMap.put("MONITOR_DESCRIPTION", bean.get("MONITOR_DESCRIPTION"));
        propsMap.put("CATEGORY_ID", categoryId);
        propsMap.put("MONITOR_TYPE", monitorType);
        String defaultNaminContext = (String)bean.get("DEFAULT_NAMING_CONTEXT");
        String domainName = DomainDetailsAPI.getDomainName((String)defaultNaminContext);
        propsMap.put("DOMAIN_NAME", domainName);
        HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
        ArrayList<Long> actionsList = new ArrayList<Long>();
        String selectedActions = (String)bean.get("selectedActions");
        StringTokenizer actionsTokenizer = new StringTokenizer(selectedActions, ",");
        while (actionsTokenizer.hasMoreTokens()) {
            try {
                long id = Long.parseLong(actionsTokenizer.nextToken());
                actionsList.add(id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap categoryColumnMap = AuditCategoryHandler.getInstance().getCategoryReportColumns((Object)categoryId);
        HashMap categoryElementColumnMap = AuditCategoryHandler.getInstance().getCategoryElementMapColumns((Object)categoryId);
        String defaultSortColumn = AuditCategoryHandler.getInstance().getDeafultSortColumn(categoryId);
        boolean status = AuditMonitorHandler.getInstance().saveMonitor(propsMap, actionsList, selectedObjectsMap, categoryColumnMap, defaultSortColumn, categoryElementColumnMap);
        if (status) {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Configuration", rb.handleGetObject("adap.SaveMonitor.audit_entry.Successfully_saved_the_report_profile", new String[]{(String)bean.get("MONITOR_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.saved_report_profiles", "-"}));
            forwardString = "view";
            String statusPageLink = "/DomainConfig.do?methodToCall=view&selectedTab=home";
            if (selectedTab.equalsIgnoreCase("fileAudit")) {
                forwardString = "fileAuditView";
                statusPageLink = "/ViewFileServers.do?selectedTab=fileAudit&CategoryId=0&selectedTile=fileServers&categoryType=2&init=true";
            } else if (selectedTab.equalsIgnoreCase("serverAudit")) {
                forwardString = "serverAuditView";
                statusPageLink = "/DomainConfig.do?methodToCall=view&selectedTab=home";
            }
            request.setAttribute("CategoryId", (Object)categoryId.toString());
            request.setAttribute("domain", (Object)domainName);
            request.setAttribute("sortColumn", (Object)"CREATION_TIME");
            HashMap<String, String> addnParamMap = new HashMap<String, String>();
            addnParamMap.put("sortColumn", "CREATION_TIME");
            addnParamMap.put("sortOrder", "DESC");
            ArrayList monitorsList = AuditMonitorAPI.getInstance().getMonitorsList(null, domainName, categoryId.toString(), addnParamMap, null, null);
            request.setAttribute("monitorsList", (Object)monitorsList);
            request.setAttribute("message", rb.handleGetObject("adap.SaveMonitor.Successfully_Saved_the_Report_Profile"));
            request.setAttribute("noteTxt", rb.handleGetObject("adap.SaveMonitor.Reports_for_this_profile_will"));
            request.setAttribute("statusPageLink", (Object)statusPageLink);
            request.setAttribute("status_img", (Object)"/images/info_icon1.gif");
        }
        return mapping.findForward(forwardString);
    }
}

