/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.monitor;

import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.monitor.model.MonitorBean;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdateMonitor
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"reportProfiles", (ADAPAuthObject)authObj);
        String forwardString = "modify";
        MonitorBean bean = (MonitorBean)form;
        String selectedTab = "config";
        int monitorType = 1;
        if (request.getParameter("selectedTab") != null) {
            selectedTab = request.getParameter("selectedTab");
        }
        if (selectedTab.equalsIgnoreCase("fileAudit")) {
            forwardString = "fileAuditMonitor";
            monitorType = 2;
        } else if (selectedTab.equalsIgnoreCase("serverAudit")) {
            forwardString = "serverAuditMonitor";
            monitorType = 3;
        }
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        Long monitorId = (Long)bean.get("MONITOR_ID");
        propsMap.put("MONITOR_NAME", bean.get("MONITOR_NAME"));
        propsMap.put("MONITOR_DESCRIPTION", bean.get("MONITOR_DESCRIPTION"));
        propsMap.put("CATEGORY_ID", bean.get("CATEGORY_ID"));
        String defaultNaminContext = (String)bean.get("DEFAULT_NAMING_CONTEXT");
        String domainName = DomainDetailsAPI.getDomainName((String)defaultNaminContext);
        propsMap.put("DOMAIN_NAME", domainName);
        if (accessType == 32) {
            HashMap selectedObjectsMap = (HashMap)bean.get("selectedObjectsMap");
            ArrayList<Long> actionsList = new ArrayList<Long>();
            String selectedActions = (String)bean.get("selectedActions");
            StringTokenizer actionsTokenizer = new StringTokenizer(selectedActions, ",");
            while (actionsTokenizer.hasMoreTokens()) {
                try {
                    long id = Long.parseLong(actionsTokenizer.nextToken());
                    actionsList.add(id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean status = AuditMonitorHandler.getInstance().updateMonitor(monitorId, propsMap, actionsList, selectedObjectsMap);
            if (status) {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.UpdateMonitor.audit_entry.Successfully_update_report_profiles", new String[]{(String)bean.get("MONITOR_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.updated_report_profiles", "-"}));
                forwardString = "view";
                String statusPageLink = "/DomainConfig.do?methodToCall=view&selectedTab=home";
                if (selectedTab.equalsIgnoreCase("fileAudit")) {
                    forwardString = "fileAuditView";
                    statusPageLink = "/ViewFileServers.do?selectedTab=fileAudit&CategoryId=0&selectedTile=fileServers&categoryType=2&init=true";
                } else if (selectedTab.equalsIgnoreCase("serverAudit")) {
                    forwardString = "serverAuditView";
                    statusPageLink = "/DomainConfig.do?methodToCall=view&selectedTab=home";
                }
                request.setAttribute("statusPageLink", (Object)statusPageLink);
                request.setAttribute("message", rb.handleGetObject("adap.UpdateMonitor.Successfully_Updated_the_Report_Profile"));
                request.setAttribute("noteTxt", rb.handleGetObject("adap.UpdateMonitor.Reports_for_this_profile_will"));
                request.setAttribute("status_img", (Object)"/images/info_icon1.gif");
            }
        } else {
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.access_denied.UpdateMonitor.update"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            request.setAttribute("message", (Object)rb.getString("adap.access_denied.UpdateMonitor.update"));
        }
        Long categoryId = (Long)bean.get("CATEGORY_ID");
        request.setAttribute("CategoryId", (Object)categoryId.toString());
        request.setAttribute("domain", (Object)domainName);
        request.setAttribute("sortColumn", (Object)"MODIFICATION_TIME");
        HashMap<String, String> addnParamMap = new HashMap<String, String>();
        addnParamMap.put("sortColumn", "MODIFICATION_TIME");
        addnParamMap.put("sortOrder", "DESC");
        ArrayList monitorsList = AuditMonitorAPI.getInstance().getMonitorsList(null, domainName, categoryId.toString(), addnParamMap, null, null);
        request.setAttribute("monitorsList", (Object)monitorsList);
        return mapping.findForward(forwardString);
    }
}

