/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.printaudit;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.ntfs.PrintSystemAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ConfiguredPrintServerAction
extends DispatchAction {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    protected static Logger logger = Logger.getLogger(ConfiguredPrintServerAction.class.getName());
    private static boolean printerConfigSuccess = false;

    public ActionForward getPrintServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "ViewPrintServers";
        try {
            HttpSession session = request.getSession();
            logger.log(Level.FINE, "*******************Inside get Print Servers******************");
            DynaActionForm bean = (DynaActionForm)form;
            String strObjClass = request.getParameter("strType");
            ObjectClass objectClass = DirectoryObjectAPI.getInstance().getObjectClass(strObjClass);
            String searchPattern = request.getParameter("searchTxt") != null ? request.getParameter("searchTxt") : null;
            searchPattern = searchPattern != null && !searchPattern.equalsIgnoreCase("") ? CommonUtil.getSearchString((String)searchPattern) : null;
            String domainName = (String)bean.get("DOMAIN_NAME");
            if (domainName == null) {
                domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
            }
            bean.set("RANGE", (Object)100);
            if (request.getParameter("next") != null) {
                if (request.getParameter("next") != null) {
                    bean.set("FROM_INDEX", (Object)Integer.parseInt(request.getParameter("next")));
                }
                bean.set("RANGE", (Object)Integer.parseInt(request.getParameter("range")));
            }
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            String cv_id = request.getParameter("cv_id");
            request.setAttribute("cv_id", (Object)Long.valueOf(cv_id));
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("defaultNamingContext", (Object)defaultNamingContext);
            request.setAttribute("objectClass", (Object)objectClass);
            request.setAttribute("selectType", (Object)"radio");
            request.setAttribute("guidName", (Object)request.getParameter("guidName"));
            Long cvID = Long.parseLong(cv_id);
            ArrayList rowsList = new ArrayList();
            rowsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, "computer", searchPattern, ((Integer)bean.get("FROM_INDEX")).intValue(), ((Integer)bean.get("RANGE")).intValue(), cvID, Long.valueOf(DirectoryObjectAPI.getInstance().getObjectsCount(defaultNamingContext, "computer", searchPattern, cvID)));
            request.setAttribute("rowList", (Object)rowsList);
            request.setAttribute("range", (Object)Integer.parseInt(request.getParameter("range")));
            request.setAttribute("totalRowCount", (Object)DirectoryObjectAPI.getInstance().getObjectsCount(defaultNamingContext, "computer", searchPattern, cvID));
            request.setAttribute("startIndex", (Object)((Integer)bean.get("FROM_INDEX")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward startListener(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintSystemAPI.startThread((String)request.getParameter("guidName"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward viewPrinterAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "PrintServerConfigured";
        try {
            DynaActionForm bean = (DynaActionForm)form;
            if (request.getParameter("init") != null) {
                bean.initialize(mapping);
            }
            HttpSession session = request.getSession();
            String domainName = request.getParameter("domainName");
            HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
            String sortColumn = request.getParameter("sortColumn") != null ? request.getParameter("sortColumn") : (String)bean.get("sortColumn");
            addnParamsMap.put("sortTableName", "ADSMComputerGeneralDetails");
            if (request.getParameter("tableName") != null) {
                addnParamsMap.put("sortTableName", request.getParameter("tableName"));
            }
            bean.set("sortColumn", (Object)sortColumn);
            Integer noOfObjects = request.getParameter("RANGE") != null ? Integer.parseInt(request.getParameter("RANGE")) : (Integer)bean.get("RANGE");
            addnParamsMap.put("sortColumn", sortColumn);
            addnParamsMap.put("sortOrder", request.getParameter("sortOrder") != null ? request.getParameter("sortOrder") : (String)bean.get("sortOrder"));
            addnParamsMap.put("noOfObjects", noOfObjects);
            addnParamsMap.put("startIndex", request.getParameter("FROM_INDEX") != null ? Integer.valueOf(Integer.parseInt(request.getParameter("FROM_INDEX"))) : bean.get("FROM_INDEX"));
            if (request.getParameter("clearSearch") != null) {
                bean.set("searchString", (Object)"");
                bean.set("PAGE_NUMBER", (Object)"1");
                bean.set("FROM_INDEX", (Object)1);
            }
            if (domainName == null) {
                domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
            }
            if (domainName == null) {
                domainName = (String)bean.get("DOMAIN_NAME");
            }
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
            if (domainName == null) {
                domainName = DomainDetailsAPI.getDefaultDomainName();
            }
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
            String action = "view";
            if (request.getParameter("action") != null) {
                action = request.getParameter("action");
            }
            if (action.equalsIgnoreCase("delete")) {
                String[] printerArray = request.getParameter("printerArray").split(",");
                PrintHandler.deleteConfiguredPrinters(Arrays.asList(printerArray), (String)request.getParameter("guidName"), (boolean)true);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Printers", "Successfully deleted the Printers in the Server " + request.getParameter("hostName"), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.deleted_printers", "-"}));
            } else if (action.equalsIgnoreCase("enable") || action.equalsIgnoreCase("disable")) {
                forwardPage = null;
                ArrayList<String> guidList = new ArrayList<String>();
                guidList.add(request.getParameter("guidName"));
                bean.set("isLicensed", (Object)PrintHandler.enableDiablePrintServers((action.equalsIgnoreCase("enable") ? 1 : 0) != 0, guidList, (String)domainName, null));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Printers", "Successfully changed the Printer " + request.getParameter("computerName") + "\n Action : " + action, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Updated_printer_details", "-"}));
            } else if (action.equalsIgnoreCase("deleteServer")) {
                PrintHandler.deletePrintServer((String)request.getParameter("guidName"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Printers", "Successfully deleted the Print Server " + request.getParameter("computerName"), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_print_server", "-"}));
                forwardPage = null;
                ClientUtil.setStatusXMLElement(response, "Success", request.getParameter("computerName") + "_listRow");
            }
            String searchString = request.getParameter("searchString");
            searchString = searchString != null ? CommonUtil.getSearchString((String)searchString) : searchString;
            addnParamsMap.put("searchString", searchString);
            int count = PrintHandler.getConfiguredServerCount((String)domainName, (String)searchString);
            addnParamsMap.put("count", count);
            ArrayList printersList = PrintHandler.getConfiguredServers((String)domainName, addnParamsMap);
            HashMap<String, ArrayList> computerPrinterMap = new HashMap<String, ArrayList>();
            HashMap<String, String> guidPrinterMap = new HashMap<String, String>();
            for (int k = 0; k < printersList.size(); ++k) {
                Properties prop = (Properties)printersList.get(k);
                computerPrinterMap.put((String)prop.get("COMPUTER_NAME"), PrintHandler.getPrinters((String)((String)prop.get("OBJECT_GUID"))));
                guidPrinterMap.put((String)prop.get("COMPUTER_NAME"), (String)prop.get("OBJECT_GUID"));
            }
            ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            ArrayList domainList = authObject.getConfiguredDomainList();
            String[] domainNames = new String[domainList.size()];
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProp = (Properties)domainList.get(i);
                domainNames[i] = domainProp.getProperty("DOMAIN_NAME");
            }
            bean.set("domainNames", (Object)domainNames);
            request.setAttribute("computerPrinterMap", computerPrinterMap);
            bean.set("DOMAIN_NAME", (Object)domainName);
            request.setAttribute("guidPrinterMap", guidPrinterMap);
            request.setAttribute("PrintAddedSuccess", (Object)printerConfigSuccess);
            request.setAttribute("count", (Object)count);
            bean.set("printerConfigSuccess", (Object)false);
            if (searchString != null) {
                bean.set("searchString", (Object)searchString);
            }
            printerConfigSuccess = false;
            request.setAttribute("list", (Object)printersList);
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Configuration", rb.handleGetObject("adap.ConfiguredPrintServerAction.audit_entry_Print_servers_viewed", new String[]{domainName}), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.view_print_servers", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward saveOrUpdatePrinters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardName = null;
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"printers", (ADAPAuthObject)authObj);
        try {
            if (accessType == 32) {
                DynaActionForm bean = (DynaActionForm)form;
                String[] selectedPrintersArray = request.getParameter("selectedObjects").split(",");
                String[] portsArray = request.getParameter("portsArray").split(",");
                HashMap<String, Object> seletedObjectsMap = new HashMap<String, Object>();
                String shareAction = request.getParameter("shareAction");
                seletedObjectsMap.put("selectedObjectsList", Arrays.asList(selectedPrintersArray));
                seletedObjectsMap.put("seletedPortList", Arrays.asList(portsArray));
                seletedObjectsMap.put("hostName", request.getParameter("hostName"));
                seletedObjectsMap.put("guidName", request.getParameter("objectGuid"));
                seletedObjectsMap.put("sharesList", Arrays.asList(request.getParameter("sharesArray").split(",")));
                printerConfigSuccess = true;
                bean.set("isLicensed", (Object)PrintHandler.addOrUpdatePrinters(seletedObjectsMap, (String)shareAction, (String)((String)session.getAttribute("MONITOR_DOMAIN_NAME"))));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Printers", rb.handleGetObject("adap.ConfiguredPrintServerAction.audit_entry.Successfully_saved_printer", new String[]{request.getParameter("hostName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Printers_Saved", "-"}));
                bean.set("printerConfigSuccess", (Object)true);
                ClientUtil.setStatusXMLElement(response, "Success", "true");
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Printers", rb.handleGetObject("adap.access_denied.ConfiguredPrintServerAction.save"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                ClientUtil.setStatusXMLElement(response, "Success", "adap.access_denied.ConfiguredPrintServerAction.save");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }

    public ActionForward getPrinters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName = "viewPrinters";
        String displayText = "Printer Names";
        String searchPattern = null;
        try {
            int shareCount;
            DynaActionForm bean = (DynaActionForm)form;
            logger.log(Level.FINE, "Bean Object is" + bean);
            HttpSession session = request.getSession();
            if (request.getParameter("init") != null) {
                bean.initialize(mapping);
            }
            String hostName = request.getParameter("hostName");
            String hostGuid = request.getParameter("hostGuid");
            String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
            if (domainName == null) {
                domainName = request.getParameter("domainName");
            }
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            String refresh = request.getParameter("refresh");
            String shareAction = request.getParameter("shareAction");
            String selectType = "checkbox";
            String searchTxt = request.getParameter("searchTxt");
            if (searchTxt != null && !"".equalsIgnoreCase(searchTxt) && searchTxt.indexOf("%") == -1) {
                searchPattern = CommonUtil.getSearchString((String)searchTxt);
            }
            logger.log(Level.FINE, "searchTxt is" + searchTxt);
            logger.log(Level.FINE, "searchPattern is" + searchPattern);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            bean.set("RANGE", (Object)100);
            if (request.getParameter("next") != null) {
                if (request.getParameter("next") != null) {
                    bean.set("FROM_INDEX", (Object)Integer.parseInt(request.getParameter("next")));
                }
                bean.set("RANGE", (Object)Integer.parseInt(request.getParameter("range")));
            }
            params.put("FROM_INDEX", (Integer)bean.get("FROM_INDEX"));
            params.put("RANGE", (Integer)bean.get("RANGE"));
            HashMap<String, String> shareMap = new HashMap<String, String>();
            shareMap.put("HOST_NAME", hostName);
            shareMap.put("REFRESH", refresh);
            shareMap.put("DOMAIN_NAME", domainName);
            shareMap.put("SHARE_ACTION", shareAction);
            shareMap.put("HOST_GUID", hostGuid);
            Hashtable shareTable = PrintSystemAPI.getInstance().getSharesForServer(new HashMap(), shareMap, searchTxt, Integer.valueOf(0));
            ArrayList shareList = (ArrayList)shareTable.get("printers");
            String errorCode = (String)shareTable.get("errorCode");
            if (errorCode != null) {
                shareList = new ArrayList();
            }
            if ((shareCount = shareList.size()) < (Integer)bean.get("FROM_INDEX")) {
                bean.set("FROM_INDEX", (Object)1);
                bean.set("PAGE_NUMBER", (Object)"1");
                params.put("FROM_INDEX", (Integer)bean.get("FROM_INDEX"));
                params.put("RANGE", (Integer)bean.get("RANGE"));
            }
            if (shareCount > 0) {
                shareMap.put("REFRESH", "false");
                shareTable = PrintSystemAPI.getInstance().getSharesForServer(params, shareMap, searchTxt, Integer.valueOf(shareCount));
                shareList = (ArrayList)shareTable.get("printers");
            }
            Long countL = shareCount;
            request.setAttribute("totalRowCount", (Object)shareCount);
            request.setAttribute("startIndex", (Object)((Integer)bean.get("FROM_INDEX")));
            request.setAttribute("rowsList", (Object)shareList);
            request.setAttribute("range", (Object)100);
            if (errorCode != null) {
                request.setAttribute("errorCode", (Object)errorCode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }
}

