/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.customreport;

import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.customreport.CustomReportBean;
import com.adventnet.sym.adsm.auditing.webclient.reports.customreport.CustomReportBeanUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CreateCustomReport
extends Action {
    private static Logger logger = Logger.getLogger("QueryLogger");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CustomReportBean custReportBean = (CustomReportBean)form;
        String forwardName = "custReportBasicInfo";
        String message = null;
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"CusomReports", (ADAPAuthObject)authObj);
        try {
            if (request.getParameter("init") != null) {
                custReportBean.initialize(mapping);
                custReportBean.init(request);
                forwardName = "createCustReport";
            } else {
                String action = request.getParameter("action");
                if (action.equalsIgnoreCase("domainChange")) {
                    session.setAttribute("MONITOR_DOMAIN_NAME", (Object)((String)custReportBean.get("domainName")));
                    custReportBean.set("viewType", new Long(1L));
                    custReportBean.getModules(rb);
                } else if (action.equalsIgnoreCase("viewChange")) {
                    custReportBean.set("moduleId", new Long(2L));
                    custReportBean.getModules(rb);
                    message = "";
                } else if (action.equalsIgnoreCase("moduleChange")) {
                    logger.log(Level.INFO, "Module Change Action Done");
                } else if (action.equalsIgnoreCase("back")) {
                    logger.log(Level.INFO, "Back Action Done");
                } else if (action.equalsIgnoreCase("next")) {
                    custReportBean.getColumnList(rb);
                    forwardName = custReportBean.getForwardName();
                } else if (action.equalsIgnoreCase("save")) {
                    if (accessType == 32) {
                        logger.log(Level.INFO, "Going to create the Custom Report : " + (String)custReportBean.get("customReportName"));
                        LinkedHashMap criteriaMap = CustomReportBeanUtil.formCriteriaMap(request);
                        message = custReportBean.getProperties(action, request, criteriaMap);
                        request.setAttribute("message", (Object)message);
                        logger.log(Level.INFO, "Successfully created the Custom Report : " + custReportBean.get("customReportName"));
                        AuditReportAPI.getInstance().setReportsDetails();
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateCustomReport.audit_entry.Successfully_created_Custom_Reports", new String[]{(String)custReportBean.get("customReportName"), (String)custReportBean.get("domainName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.custom_report_created", "-"}));
                    } else {
                        message = rb.getString("adap.access_denied.CreateCustomReport.save");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                    }
                    ArrayList list = CustomReportUtil.getReportsList((AdventNetResourceBundle)rb, (String)((String)session.getAttribute("MONITOR_DOMAIN_NAME")), (Long)((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID")), (Boolean)false);
                    request.setAttribute("reportsList", (Object)list);
                    forwardName = "viewCustomReports";
                } else if (action.equalsIgnoreCase("reset")) {
                    custReportBean.initialize(mapping);
                    custReportBean.init(request);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception occured while creating the report : " + custReportBean.get("customReportName"));
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateCustomReport.audit_entry.Problem_while_creating_custom_report", new String[]{(String)custReportBean.get("customReportName"), (String)custReportBean.get("domainName"), ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.custom_report_created", "-"}));
                logger.log(Level.INFO, "The exception is " + ex.getMessage());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ex.printStackTrace();
        }
        return mapping.findForward(forwardName);
    }
}

