/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.scheduler;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.reports.scheduler.ReportSchedulerBean;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CreateReportScheduler
extends Action {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardName = "createSchedule";
        String message = null;
        HttpSession session = request.getSession();
        ReportSchedulerBean schedulerBean = (ReportSchedulerBean)form;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ScheduledReports", (ADAPAuthObject)authObj);
        try {
            if (request.getParameter("init") != null) {
                schedulerBean.initialize(mapping);
                schedulerBean.init(request);
            } else if (request.getParameter("domainChange") != null) {
                schedulerBean.set("reportInputs", new HashMap());
                schedulerBean.set("categoryMap", new HashMap());
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)((String)schedulerBean.get("domainName")));
            } else if (request.getParameter("action") != null) {
                if (request.getParameter("isZipFile") == null) {
                    schedulerBean.set("isZipFile", false);
                }
                if (request.getParameter("isReportsEmpty") == null) {
                    schedulerBean.set("isReportsEmpty", false);
                }
                if (accessType == 32) {
                    DataObject dataObject = schedulerBean.getProperties(request.getParameter("action"), request);
                    ReportSchedulerUtil.createScheduler((DataObject)dataObject);
                    message = request.getParameter("testNow") != null && request.getParameter("testNow").equals("false") ? rb.getString("adap.CreateReportScheduler.Successfully_created_the_scheduled_Report") : rb.getString("adap.CreateReportScheduler.created_test_now");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message + " , Schedule Name is " + (String)schedulerBean.get("scheduleName"), 512, 8, "adap.ADAPUserAuditSeverities.audit_name.schedule_report_created", "-"}));
                } else {
                    message = rb.getString("adap.access_denied.CreateReportScheduler.create");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Reports", message, 512, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
                forwardName = "viewScheduler";
            }
        }
        catch (DataAccessException ex) {
            reportLogger.log(Level.INFO, "Exception while adding the scheduler - " + (String)schedulerBean.get("scheduleName"));
            ex.printStackTrace();
            message = ex.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stktrc = sw.toString();
            if (message.indexOf("Duplicate entry") != -1 || stktrc.indexOf("duplicate key") != -1) {
                message = rb.getString("adap.CreateReportScheduler.The_Schedule_Name_Already_Configured");
            }
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateReportScheduler.audit_entry.Problem_crating_schedule_name", new String[]{message, (String)schedulerBean.get("scheduleName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.failed_to_create_report_scheduler", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap.CreateReportScheduler.Failure_occurred");
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Reports", rb.handleGetObject("adap.CreateReportScheduler.audit_entry.Problem_crating_schedule_name", new String[]{message, (String)schedulerBean.get("scheduleName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.failed_to_create_report_scheduler", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward(forwardName);
    }
}

