/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.scheduler;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DeleteReportScheduler
extends Action {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"ScheduledReports", (ADAPAuthObject)authObj);
            if (accessType == 32) {
                String scheduleId = request.getParameter("scheduleId");
                Row row = ReportUtil.getFirstRow((String)"Schedule", (String)"SCHEDULE_ID", (Object)Long.parseLong(scheduleId), (int)0);
                ReportSchedulerUtil.deleteScheduler((Long)Long.parseLong(scheduleId));
                request.setAttribute("message", (Object)rb.getString("adap.DeleteReportScheduler.Successfully_Deleted_the_Scheduler_Report"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteReportScheduler.audit_entry.Successfully_deleted", new String[]{(String)row.get("SCHEDULE_NAME")}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports", "-"}));
            } else {
                String message = rb.getString("adap.access_denied.DeleteReportScheduler.delete");
                request.setAttribute("message", (Object)message);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", message, 16, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            request.setAttribute("message", (Object)ex.getMessage());
            ex.printStackTrace();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Reports", rb.handleGetObject("adap.DeleteReportScheduler.audit_entry.Failed_to_delete", new String[]{ex.getMessage()}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.delete_scheduled_reports", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return mapping.findForward("viewScheduler");
    }
}

