/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.reports.scheduler;

import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.common.webclient.components.UICreator;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchedulerBeanUtil {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public static TreeMap getFormElements(ArrayList elementList) {
        TreeMap inputElement = new TreeMap();
        try {
            for (Object object : elementList) {
                HashMap elementMap = (HashMap)object;
                String uiCreatorClass = (String)elementMap.get("UICreator");
                Class<?> classToInvoke = Class.forName(uiCreatorClass.trim());
                UICreator creator = (UICreator)classToInvoke.newInstance();
                Long priorityId = (Long)elementMap.get("priorityId");
                Properties attributeProps = (Properties)elementMap.get("attributeProps");
                String htmlText = creator.constructCell(attributeProps, null);
                HashMap<String, Object> tdMap = new HashMap<String, Object>();
                tdMap.put("htmlText", htmlText);
                tdMap.put("new_row", (Boolean)elementMap.get("new_row"));
                inputElement.put(priorityId, tdMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return inputElement;
    }

    public static void getReportDetails(HashMap categoryMap, Long reportId) throws Exception {
        HashMap reportDetailsMap = AuditReportAPI.getInstance().getReportDetailsMap((Object)reportId);
        HashMap<String, String> reportDetails = null;
        Long categoryId = (Long)reportDetailsMap.get("REPORT_CATEGORY_ID");
        String reportName = (String)reportDetailsMap.get("TITLE");
        ArrayList formElements = AuditReportParamsAPI.getReportFormElements((Long)reportId, (boolean)true);
        TreeMap inputElement = SchedulerBeanUtil.getFormElements(formElements);
        HashMap<Long, HashMap<String, String>> reportMap = (HashMap<Long, HashMap<String, String>>)categoryMap.get(categoryId);
        if (reportMap == null) {
            reportMap = new HashMap<Long, HashMap<String, String>>();
        } else {
            reportDetails = (HashMap<String, String>)reportMap.get(reportId);
        }
        if (reportDetails == null) {
            reportDetails = new HashMap<String, String>();
        }
        reportDetails.put("reportName", reportName);
        reportDetails.put("inputParams", (String)((Object)inputElement));
        reportMap.put(reportId, reportDetails);
        categoryMap.put(categoryId, reportMap);
    }

    public static ByteArrayOutputStream getDIVXMLElement(ArrayList historyList) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element data = document.createElement("data");
        document.appendChild(data);
        for (int i = 0; i < historyList.size(); ++i) {
            HashMap historyMap = (HashMap)historyList.get(i);
            Element child = document.createElement("child");
            child.setAttribute("NodeId", Integer.valueOf(i).toString());
            child.setAttribute("fileStoragePath", (String)historyMap.get("fileStoragePath"));
            child.setAttribute("scheduleTime", historyMap.get("scheduleTime").toString());
            data.appendChild(child);
        }
        DOMSource source = new DOMSource(data);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream outNode = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outNode);
        transformer.transform(source, result);
        return outNode;
    }
}

