/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.eventcollection.realtime.RealTimeEventUtil;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DCHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.SchemaUpdate;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.DomainClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class DomainAction
extends DispatchAction {
    protected static Logger logger = Logger.getLogger("ReportLogger");

    public ActionForward addDomainDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String forward = "domainDetails";
        DynaActionForm domainDetails = (DynaActionForm)form;
        domainDetails.initialize(mapping);
        request.setAttribute("operation", (Object)"add");
        String message = null;
        if (DomainHandler.startDomainDiscovery()) {
            message = rb.getString("adap.DomainAction.Domain_discovery_is_in_progress");
            request.setAttribute("message", (Object)message);
        }
        return mapping.findForward(forward);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String showDetailsPage;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        DynaActionForm domainDetails = (DynaActionForm)form;
        String forwardPage = "list";
        String message = null;
        this.checkBoxValues(domainDetails, request);
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        String operation = (String)domainDetails.get("operation");
        if (accessType == 32) {
            block23: {
                String params;
                if (DomainHandler.startDomainDiscovery()) {
                    message = "adap.DomainAction.Domain_discovery_is_in_progress";
                }
                if (request.getParameter("save") != null) {
                    params = "add";
                    message = this.save(domainDetails, request, params);
                    logger.log(Level.INFO, "DOMAIN ADDED SUCCESSFULLY");
                } else if (request.getParameter("update") != null) {
                    params = "update";
                    message = this.save(domainDetails, request, params);
                    logger.log(Level.INFO, "DOMAIN UPDATED SUCCESSFULLY");
                } else if (operation.equals("delete")) {
                    try {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.start_to_Delete_domain", new String[]{domainName}), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", "-"}));
                        if (DomainHandler.deleteDomain((String)domainName)) {
                            message = "adap.AdminHandler.Successfully_Deleted";
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.getString("adap.AdminHandler.Successfully_Deleted"), 16, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName})}));
                            logger.log(Level.INFO, "DOMAIN DELETED SUCCESSFULLY");
                            domainName = DomainDetailsAPI.getDefaultDomainName();
                            break block23;
                        }
                        message = "adap.DomainAction.Problem_in_deleting_the_Domain";
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_deleting_Domain", new String[]{domainName}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", "-"}));
                        request.setAttribute("errHandler", (Object)"1");
                    }
                    catch (Exception e) {
                        message = e.getMessage();
                        request.setAttribute("errHandler", (Object)"1");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_deleting_Domain", new String[]{domainName}), 16, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_deleted", "-"}));
                    }
                } else if (operation.equals("connect")) {
                    this.connect(domainName, rb, request);
                } else if (operation.equals("updateDomainData")) {
                    String[] selectedUpdates = request.getParameterValues("updates");
                    message = rb.getString("adap.DomainAction.Refresh_request_is_being_processed");
                    try {
                        DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
                        logger.log(Level.INFO, "DOMAIN OBJECT UPDATES - UPDATED SUCCESSFULLY");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.Successfully_updated_the_domain_objecst", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_object_updated", "-"}));
                    }
                    catch (Exception e) {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_updated_domain_objects", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_object_updated", "-"}));
                        message = e.getMessage();
                    }
                }
            }
            authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
        } else {
            message = rb.getString("adap.access_denied.DomainAction.change");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
        }
        ArrayList list = authObj.getConfiguredDomainList();
        request.setAttribute("list", (Object)list);
        request.setAttribute("policyStatusMap", (Object)this.getPolicyStatus(list));
        if (operation.equals("modify")) {
            this.modifyDetails(domainDetails, request, mapping);
        }
        if (operation.equals("")) {
            operation = "init";
            domainDetails.set("operation", (Object)operation);
        }
        if (message != null) {
            request.setAttribute("message", (Object)message);
        }
        if ((showDetailsPage = (String)request.getAttribute("showDetailsPage")) != null && showDetailsPage.equalsIgnoreCase("true")) {
            forwardPage = "domainDetails";
            domainName = DomainDetailsAPI.getDefaultDomainName();
        }
        if (request.getParameter("save") == null) {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        }
        domainDetails.set("operation", (Object)operation);
        request.setAttribute("operation", (Object)operation);
        ArrayList dcList = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
        if (operation.equalsIgnoreCase("delete")) {
            domainDetails.initialize(mapping);
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        DynaActionForm domainDetails = (DynaActionForm)form;
        String message = null;
        if (DomainHandler.startDomainDiscovery()) {
            message = "adap.DomainAction.Domain_discovery_is_in_progress";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Domain Settings", rb.getString(message), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Domain_settings_viewed", "-"}));
        }
        if (message != null) {
            request.setAttribute("message", (Object)message);
        }
        domainDetails.set("operation", (Object)"view");
        request.setAttribute("operation", (Object)"view");
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
        ArrayList list = authObj.getConfiguredDomainList();
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Domain Settings", rb.getString("adap.DomainAction.Refresh_domain_Settings_page"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Domain_settings_viewed", "-"}));
        request.setAttribute("policyStatusMap", (Object)this.getPolicyStatus(list));
        request.setAttribute("list", (Object)list);
        return mapping.findForward("list");
    }

    private void setTimePeriodMap(Properties properties) {
        String[] hours = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
        ArrayList<String> hourList = new ArrayList<String>();
        for (String string : hours) {
            hourList.add(string);
        }
        properties.put("HOUR_PERIOD_VALUES", hourList);
        properties.put("HOUR_PERIOD_DISPLAY", hourList);
        String[] minutes = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
        ArrayList<String> minuteList = new ArrayList<String>();
        for (String string : minutes) {
            minuteList.add(string);
        }
        properties.put("MINUTE_PERIOD_VALUES", minuteList);
        properties.put("MINUTE_PERIOD_DISPLAY", minuteList);
    }

    public ActionForward addDCDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "list";
        DynaActionForm domainDetails = (DynaActionForm)form;
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = null;
        try {
            if (accessType == 32) {
                String domainName = request.getParameter("domainName");
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
                ArrayList<String> dcList = new ArrayList<String>();
                String dcNames = request.getParameter("substring");
                System.out.println("dcNames : " + dcNames);
                StringTokenizer st = new StringTokenizer(dcNames, ",");
                while (st.hasMoreTokens()) {
                    String dcName = st.nextToken();
                    dcList.add(dcName.toLowerCase());
                }
                Properties domainProperties = DomainHandler.getConfiguredValuesForModify((String)domainName);
                domainProperties.put("DOMAIN_CONTROLLER_LIST", dcList);
                DomainHandler.getDomainDetails((Properties)domainProperties, (boolean)true);
                DomainHandler.addDomainControllers((Properties)domainProperties);
                EventDataUtil.getComputerDetails((String)domainName, null);
                if (DomainHandler.startDomainDiscovery()) {
                    message = "adap.DomainAction.Domain_discovery_is_in_progress";
                }
                if (message == null) {
                    message = "adap.DomainAction.Successfully_added_domain_controllers_Event";
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.added_dc_for_domain", new String[]{dcNames, domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.dc_added", "-"}));
            } else {
                message = rb.getString("adap.access_denied.DomainAction.addDC");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
            request.setAttribute("message", (Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("message", (Object)(rb.getString("adap.Home.Domain_Settings.Add_domain_controllers.Error_while_adding_domain_controller") + e.getMessage()));
            request.setAttribute("errHandler", (Object)"1");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.getString("adap.Home.Domain_Settings.Add_domain_controllers.Error_while_adding_domain_controller") + e.getMessage(), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.dc_added", "-"}));
        }
        domainDetails.set("operation", (Object)"view");
        request.setAttribute("operation", (Object)"view");
        authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
        ArrayList list = authObj.getConfiguredDomainList();
        request.setAttribute("policyStatusMap", (Object)this.getPolicyStatus(list));
        request.setAttribute("list", (Object)list);
        return mapping.findForward("list");
    }

    public ActionForward getDCDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
        System.out.println("in the method getDCDetails : ");
        DynaActionForm domainDetails = (DynaActionForm)form;
        ArrayList<Properties> dcList = (ArrayList<Properties>)domainDetails.get("DOMAIN_CONTROLLER_LIST");
        if (dcList == null) {
            dcList = new ArrayList<Properties>();
        }
        String dcNames = request.getParameter("substring");
        System.out.println("dcNames : " + dcNames);
        StringTokenizer st = new StringTokenizer(dcNames, ",");
        while (st.hasMoreTokens()) {
            String dcName = st.nextToken().trim();
            if ("".equals(dcName)) continue;
            Properties properties = new Properties();
            properties.setProperty("DOMAIN_CONTROLLER_NAME", dcName);
            properties.setProperty("HOUR_PERIOD", "2");
            properties.setProperty("MINUTE_PERIOD", "0");
            this.setTimePeriodMap(properties);
            dcList.add(properties);
        }
        domainDetails.set("DC_PROPERTIES_LIST", dcList);
        String authen = request.getParameter("authen");
        if (authen != null) {
            domainDetails.set("IS_AUTHENTICATION_REQUIRED", (Object)authen);
        }
        request.setAttribute("showDetailsPage", (Object)"true");
        request.setAttribute("operation", (Object)"add");
        return mapping.findForward("domainDetails");
    }

    private void modifyDetails(DynaActionForm domainDetails, HttpServletRequest request, ActionMapping mapping) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            String display = request.getParameter("display");
            if (display == null || display.equals("")) {
                System.out.println("do nothing");
            } else {
                domainDetails.initialize(mapping);
                String domainName = request.getParameter("DOMAIN_NAME");
                Properties p = DomainHandler.getConfiguredValuesForModify((String)domainName);
                System.out.println("getting configured values : " + p);
                this.setValues(domainDetails, p);
                domainDetails.set("DOMAIN_NAME", (Object)domainName);
                domainDetails.set("PASSWORD", (Object)"");
                request.setAttribute("showDetailsPage", (Object)"true");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.getString("adap.DomainAction.Modify_Domain_Successfully") + "\n" + rb.handleGetObject("adap.audit_entry_addn.Domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.Domain_settings_changed", "-"}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void connect(String domainName, AdventNetResourceBundle rb, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
            if (accessType == 32) {
                DomainHandler.setDefaultDomain((String)domainName, (boolean[])new boolean[0]);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.set_as_Default_Domain", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.default_dommain_set", "-"}));
                logger.log(Level.INFO, "DEFAULT DOMAIN SET SUCCESSFULLY: domain name is " + domainName);
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.getString("adap.access_denied.DomainAction.change"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                logger.log(Level.INFO, "DEFAULT DOMAIN SET Access Denied: domain name is " + domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String save(DynaActionForm domainDetails, HttpServletRequest request, String params) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = 1L;
        String errHandler = "0";
        String showDetailsPage = "false";
        String userName = "";
        String userPwd = "";
        if (request.getParameter("USER_DISTINGUISHED_NAME") != null) {
            userName = request.getParameter("USER_DISTINGUISHED_NAME");
        }
        if (request.getParameter("PASSWORD") != null) {
            userPwd = request.getParameter("PASSWORD");
        }
        ArrayList dcDetails = new ArrayList();
        String message = null;
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        Properties prop = new Properties();
        prop.put("DOMAIN_NAME", domainDetails.get("DOMAIN_NAME"));
        prop.put("USER_DISTINGUISHED_NAME", userName);
        prop.put("PASSWORD", userPwd);
        prop.put("IS_AUTHENTICATION_REQUIRED", domainDetails.get("IS_AUTHENTICATION_REQUIRED"));
        Properties selectedDomain = DomainHandler.getSelectedDomain((Long)1L);
        if (selectedDomain.getProperty("IS_DEFAULT_DOMAIN") == null || selectedDomain.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("false")) {
            prop.put("IS_DEFAULT_DOMAIN", "true");
        } else {
            prop.put("IS_DEFAULT_DOMAIN", "false");
        }
        Enumeration enumeration = request.getParameterNames();
        ArrayList dcPropertiesList = DomainClientUtil.getPropertiesList(enumeration, request);
        ArrayList<String> dcList = new ArrayList<String>();
        HashMap<String, Properties> dcPropsMap = new HashMap<String, Properties>();
        System.out.println("DC_PROPERTIES_LIST :" + dcPropertiesList);
        for (Object object : dcPropertiesList) {
            Properties dcProperties = (Properties)object;
            try {
                String hour = dcProperties.getProperty("HOUR_PERIOD");
                String minute = dcProperties.getProperty("MINUTE_PERIOD");
                Long timePeriod = Long.parseLong(hour) * 60L + Long.parseLong(minute);
                dcProperties.setProperty("TIME_PERIOD", timePeriod.toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            String domainControllerName = dcProperties.getProperty("DOMAIN_CONTROLLER_NAME");
            dcList.add(domainControllerName.toLowerCase());
            dcPropsMap.put(domainControllerName, dcProperties);
        }
        System.out.println("DC_PROPERTIES_LIST 2:" + dcPropertiesList);
        prop.put("DOMAIN_CONTROLLER_LIST", dcList);
        prop.put("DC_PROP_MAP", dcPropsMap);
        ArrayList beanPropList = (ArrayList)dcPropertiesList.clone();
        for (Object object2 : beanPropList) {
            Properties properties = (Properties)object2;
            this.setTimePeriodMap(properties);
        }
        domainDetails.set("DC_PROPERTIES_LIST", (Object)beanPropList);
        try {
            if (params == "add") {
                if (DomainHandler.addDomainDetails((Properties)prop, (boolean[])new boolean[0])) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.new_Domain_Added", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.New_domain_added", rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()})}));
                    message = "adap.DomainAction.Domain_added_successfully";
                    new SchemaUpdate(domainName).start();
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.problem_adding_new_domain", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.New_domain_added", rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()})}));
                    message = "adap.DomainAction.Problem_in_Adding_the_Domain";
                    showDetailsPage = "true";
                }
            } else {
                Properties p = DomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                prop.put("IS_DEFAULT_DOMAIN", (String)p.get("IS_DEFAULT_DOMAIN"));
                if (DomainHandler.updateDomainDetails((Properties)prop, (boolean[])new boolean[0])) {
                    String[] selectedUpdates = new String[]{"Exchange", "Policy"};
                    DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
                    message = "adap.DomainAction.Successfully_Updated_the_Values";
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.domain_values_updated", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()})}));
                } else {
                    message = "adap.DomainAction.Problem_in_Updating_the_Domain";
                    showDetailsPage = "true";
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.domain_values_updated_failed", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.domain_values_updated_failed", new String[]{domainName}) + "\n " + message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            showDetailsPage = "true";
            errHandler = "1";
        }
        request.setAttribute("showDetailsPage", (Object)showDetailsPage);
        request.setAttribute("errHandler", (Object)errHandler);
        return message;
    }

    public ActionForward schedulerUpdation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        if (request.getParameter("domainName") != null) {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)request.getParameter("domainName"));
        }
        String action = request.getParameter("action");
        ArrayList<Long> selectedSchedulers = new ArrayList<Long>();
        String scheduleIdStr = request.getParameter("scheduleId");
        if (scheduleIdStr != null) {
            StringTokenizer objectTokenizer = new StringTokenizer(scheduleIdStr, ";;;");
            while (objectTokenizer.hasMoreTokens()) {
                String object = objectTokenizer.nextToken();
                if (selectedSchedulers.contains(object)) continue;
                selectedSchedulers.add(Long.parseLong(object));
            }
        }
        String message = null;
        String forward = "list";
        System.out.println("schedulerUpdation action : " + action);
        if (accessType == 32) {
            ArrayList dcList = ReportUtil.getDCFromScheduleId(selectedSchedulers);
            if (action.equalsIgnoreCase("Disable")) {
                message = "adap.DomainAction.The_event_collection_from_the";
                System.out.println("Disabling Scheduler ..");
                for (int i = 0; i < selectedSchedulers.size(); ++i) {
                    EventSchedulerUtil.enableDisableScheduler((Long)((Long)selectedSchedulers.get(i)), (String)"Disable");
                }
                logger.log(Level.INFO, "DC SCHEDULER DISABLED SUCCESSFULLY");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.disabled_DCS", new String[]{String.valueOf(selectedSchedulers.size()), request.getParameter("domainName")}) + "\n" + rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
            } else if (action.equalsIgnoreCase("Enable")) {
                message = "adap.DomainAction.Successfully_scheduled_the_event_collection";
                for (int i = 0; i < selectedSchedulers.size(); ++i) {
                    System.out.println("id is " + (Long)selectedSchedulers.get(i));
                    int enabledSchedulerCount = EventSchedulerUtil.getEnabledEventSchedulerCount();
                    String domainControllers = LicenseUtil.getLicenseProperty((String)"DomainController", (String)"NumberOfDomainControllers");
                    int domainControllersCount = Integer.parseInt(domainControllers);
                    if (enabledSchedulerCount < domainControllersCount) {
                        EventSchedulerUtil.enableDisableScheduler((Long)((Long)selectedSchedulers.get(i)), (String)"Enable");
                        continue;
                    }
                    message = "adap.DomainAction.License_Level_Exceed";
                }
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.enabled_dcs", new String[]{String.valueOf(selectedSchedulers.size()), request.getParameter("domainName")}) + "\n " + rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                logger.log(Level.INFO, "DC SCHEDULER ENABLED SUCCESSFULLY");
            } else if (action.equalsIgnoreCase("modifyPeriod")) {
                Long dcId = new Long(request.getParameter("dcId"));
                Row row = ReportUtil.getFirstRow((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID", (Object)dcId, (int)0);
                String osVersion = request.getParameter("osVersion");
                Integer fetchMode = new Integer(request.getParameter("fetchMode"));
                try {
                    boolean changeMode;
                    if (fetchMode == 1) {
                        DomainAction.updateScheduleTime(selectedSchedulers, request);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.event_fetch_interval_changed", new String[]{(String)row.get("DOMAIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                    }
                    if (null != osVersion && osVersion.startsWith("6.") && (changeMode = DCHandler.isEventFetchChange((Long)dcId, (Integer)fetchMode))) {
                        RealTimeEventUtil.getInstance().changeDcFetchMode(dcId, fetchMode);
                        RealTimeEventUtil.getInstance().checkAndUpdate(dcId, fetchMode);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.event_fetch_interval_to_real_Time", new String[]{(String)row.get("DOMAIN_CONTROLLER_NAME"), (String)row.get("DOMAIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                    }
                    ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.ImportLogFileAction.Successfully_updated"));
                    forward = null;
                }
                catch (Exception ex) {
                    ClientUtil.setStatusXMLElement(response, "Error", rb.getString("adap.DomainConfiguration.Error_While_updating_time"));
                    ex.printStackTrace();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.failed_to_change_real_time", new String[]{(String)row.get("DOMAIN_CONTROLLER_NAME"), request.getParameter("domainName")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                }
                logger.log(Level.INFO, "DC SCHEDULER TIME CHANGED SUCCESSFULLY");
            } else if (action.equalsIgnoreCase("modifySelectedPeriods")) {
                try {
                    DomainAction.updateScheduleTime(selectedSchedulers, request);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.event_fetch_interval_changed", new String[]{request.getParameter("domainName")}) + "\n" + rb.handleGetObject("adap.DomainAction.audit_entry.added_dcs", new String[]{dcList.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.domain_updated", "-"}));
                    message = "adap.DomainAction.Successfully_Updated_the_Event_Fetch";
                    logger.log(Level.INFO, "DC SCHEDULER TIME CHANGED SUCCESSFULLY modifySelectedPeriods");
                }
                catch (Exception ex) {
                    message = ex.getMessage();
                    ex.printStackTrace();
                }
            }
        } else {
            message = rb.getString("adap.access_denied.DomainAction.updateDC");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
        }
        if (forward != null) {
            authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
            ArrayList list = authObj.getConfiguredDomainList();
            request.setAttribute("policyStatusMap", (Object)this.getPolicyStatus(list));
            request.setAttribute("list", (Object)list);
            request.setAttribute("message", (Object)message);
        }
        return mapping.findForward(forward);
    }

    public ActionForward updateDomainDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward;
        block7: {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
            String operation = request.getParameter("operation");
            forward = "list";
            if (accessType == 32) {
                if (operation.equalsIgnoreCase("modifyCredentials")) {
                    String domainName = request.getParameter("domainName");
                    try {
                        System.out.println("Into Modify Credentials");
                        String authChecked = request.getParameter("authChecked");
                        session.setAttribute("MONITOR_DOMAIN_NAME", (Object)request.getParameter("domainName"));
                        String userName = "";
                        String password = "";
                        Properties domainDetails = DomainHandler.getConfiguredValuesForModify((String)domainName);
                        domainDetails.setProperty("IS_AUTHENTICATION_REQUIRED", authChecked);
                        if (authChecked.equalsIgnoreCase("true")) {
                            userName = request.getParameter("userName");
                            password = request.getParameter("password");
                            domainDetails.setProperty("USER_DISTINGUISHED_NAME", userName);
                            domainDetails.setProperty("PASSWORD", password);
                        }
                        Properties properties = DomainHandler.getDomainDetails((Properties)domainDetails, (boolean)true);
                        boolean status = DomainHandler.updateCredentials((Properties)properties);
                        forward = null;
                        if (status) {
                            ClientUtil.setStatusXMLElement(response, "Success", rb.handleGetObject("adap.DomainAction.Successfully_updated_the_Credentails", new String[]{domainName}));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.credential_updated", new String[]{domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.cred_updated", "-"}));
                            break block7;
                        }
                        ClientUtil.setStatusXMLElement(response, "Error", rb.handleGetObject("adap.DomainAction.Error_in_Updating_Credentails", new String[]{domainName}));
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.failed_to_update_credential", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.cred_updated", "-"}));
                    }
                    catch (Exception e) {
                        forward = null;
                        System.out.println(e.getMessage());
                        ClientUtil.setStatusXMLElement(response, "Error", rb.handleGetObject("adap.DomainAction.Error_in_Updating_Credentails", new String[]{domainName}) + e.getMessage());
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.Error_in_Updating_Credentails", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.cred_updated", e.getMessage()}));
                    }
                }
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.getString("adap.access_denied.DomainAction.changeCred"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        return mapping.findForward(forward);
    }

    public ActionForward updateDomainControllers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter("operation");
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"DomainSettings", (ADAPAuthObject)authObj);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        session.setAttribute("MONITOR_DOMAIN_NAME", (Object)request.getParameter("domainName"));
        String message = "adap.MSHandler.Successfully_deleted";
        String forward = "list";
        if (accessType == 32) {
            if (operation.equalsIgnoreCase("delete")) {
                String dcIdStr = request.getParameter("DOMAIN_CONTROLLER_ID");
                StringTokenizer objectTokenizer = new StringTokenizer(dcIdStr, ";;;");
                while (objectTokenizer.hasMoreTokens()) {
                    String object = objectTokenizer.nextToken();
                    Long dcId = Long.parseLong(object);
                    Row row = ReportUtil.getFirstRow((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID", (Object)dcId, (int)0);
                    DomainHandler.deleteDomainController((Long)dcId);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.deleted_dcs", new String[]{(String)row.get("DOMAIN_CONTROLLER_NAME"), (String)session.getAttribute("MONITOR_DOMAIN_NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.delete_dcs", "-"}));
                }
                logger.log(Level.INFO, "DC DELETED SUCCESSFULLY");
            }
            authObj.setConfiguredDomainList((Long)session.getAttribute("ADAP_SESSION_LOGIN_ID"), true);
        } else {
            message = rb.getString("adap.access_denied.DomainAction.deleteDC");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
        }
        ArrayList list = authObj.getConfiguredDomainList();
        request.setAttribute("policyStatusMap", (Object)this.getPolicyStatus(list));
        request.setAttribute("list", (Object)list);
        request.setAttribute("message", (Object)message);
        return mapping.findForward(forward);
    }

    public ActionForward runDCEventScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        String dcIdStr = request.getParameter("dcId");
        String scheduleIdStr = request.getParameter("scheduleId");
        Long scheduleId = Long.parseLong(scheduleIdStr);
        String message = "";
        String messageType = rb.getString("adap.DomainAction.Success");
        if (dcIdStr != null) {
            Long dcId = Long.parseLong(dcIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMDCConfiguration", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMDCConfiguration");
                String domainName = (String)row.get("DOMAIN_NAME");
                session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
                String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                try {
                    EventDataHandler.getInstance().fillEventData(domainName, dcName, scheduleId, 1, null);
                    message = rb.handleGetObject("adap.DomainAction.Started_fetching_Event_Data_from", new String[]{dcName});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.run_now_dc", new String[]{dcName, domainName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manual_dc_run", "-"}));
                }
                catch (Exception e) {
                    messageType = rb.getString("adap.ConfigureComputerAction.Error");
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Domain Settings", rb.handleGetObject("adap.DomainAction.audit_entry.runnow_dc_failed", new String[]{dcName, e.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.manual_dc_run", "-"}));
                }
            }
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return mapping.findForward(null);
    }

    private void setValues(DynaActionForm form, Properties p) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            try {
                if (form.get(key) == null) continue;
                form.set(key, p.get(key));
            }
            catch (Exception ex) {}
        }
    }

    private void checkBoxValues(DynaActionForm domainDetails, HttpServletRequest request) {
        String[] arr = new String[]{"IS_AUTHENTICATION_REQUIRED"};
        if (request.getParameter(arr[0]) == null) {
            domainDetails.set(arr[0], (Object)"false");
        } else {
            domainDetails.set(arr[0], (Object)"true");
        }
    }

    private HashMap getPolicyStatus(ArrayList list) throws Exception {
        HashMap<String, Properties> domainMap = new HashMap<String, Properties>();
        PolicyHandler polHandler = new PolicyHandler();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Properties prop = (Properties)list.get(i);
                String gpoGuids = "";
                String policyStatus = "";
                String domainName = prop.getProperty("DOMAIN_NAME");
                boolean auditDDCPolicyState = polHandler.getAuditPolicy(domainName, "{6AC1786C-016F-11D2-945F-00C04fB984F9}", false);
                boolean gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)4);
                if (gpoStatus && auditDDCPolicyState) {
                    policyStatus = "adap.DomainAction.Success";
                } else if (!auditDDCPolicyState && !gpoStatus) {
                    policyStatus = "adap.DomainAction.Configure_Default_Domain_Controllers_Policy_Member_Servers";
                    gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                    gpoGuids = gpoGuids + ",";
                    gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
                } else if (!gpoStatus) {
                    policyStatus = "adap.DomainAction.Configure_Default_Domain_Policy";
                    gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
                } else if (!auditDDCPolicyState) {
                    gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                    policyStatus = "adap.DomainAction.Configure_Default_Domain_Controllers_Policy";
                }
                Properties props = new Properties();
                props.put("gpoGuids", gpoGuids);
                props.put("policyStatus", policyStatus);
                domainMap.put(domainName, props);
            }
        }
        return domainMap;
    }

    public ActionForward getDomainScope(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println("*************Inside getDomainScope*********************");
        String domainName = request.getParameter("domainName");
        String messageType = "Success";
        String message = "false";
        HttpSession session = request.getSession();
        session.setAttribute("MONITOR_DOMAIN_NAME", (Object)domainName);
        try {
            String domainFlatName = DomainDetailsAPI.getDomainFlatName((String)domainName, (boolean)false);
            System.out.println("DomainFlat Name is: " + domainFlatName);
            boolean domainScope = false;
            if (domainFlatName == null) {
                String msg = "adap.PolicyHandler.Domain_Flat_name_returns_empty";
                domainScope = true;
            } else {
                boolean bl = domainScope = ADHandler.IsLocalDomain((String)domainFlatName) || ADHandler.isTrustedDomain((String)domainName);
            }
            message = domainScope ? "true" : "false";
        }
        catch (Exception e) {
            messageType = "adap.domain_settings.view_domain.text.error";
            message = "true";
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        System.out.println("***************Leaving getDomainScope***********************");
        return mapping.findForward(null);
    }

    public static void updateScheduleTime(ArrayList selectedSchedulers, HttpServletRequest request) {
        try {
            if (!selectedSchedulers.isEmpty()) {
                Long[] scheduleIds = new Long[selectedSchedulers.size()];
                for (int i = 0; i < selectedSchedulers.size(); ++i) {
                    scheduleIds[i] = (Long)selectedSchedulers.get(i);
                }
                HashMap<String, Object> schedulerPropsMap = new HashMap<String, Object>();
                String timePeriod = request.getParameter("timePeriod");
                String unitOfTime = request.getParameter("unitOfTime");
                schedulerPropsMap.put("SCHEDULE_ID", scheduleIds);
                schedulerPropsMap.put("TIME_PERIOD", Long.parseLong(timePeriod));
                schedulerPropsMap.put("UNIT_OF_TIME", unitOfTime);
                SchedulerUtil.updatePeriodicScheduler(schedulerPropsMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

