/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.AlertSchedulerUtil;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class AlertsSettings
extends DispatchAction {
    private static Logger logger = Logger.getLogger(AlertsSettings.class.getName());

    public ActionForward createClearAlertsRule(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = request.getParameter("selectedTile");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ClearAlertsSettings", (ADAPAuthObject)authObj);
        try {
            if (request.getParameter("action") != null) {
                String option = request.getParameter("action");
                if (option != null && option.equalsIgnoreCase("save")) {
                    HashMap idMap = AlertSchedulerUtil.getScheduledId((String)"adap.Schedule.schedule_name.Clear_Alerts");
                    Long scheduleId = (Long)idMap.get("scheduleId");
                    System.out.println("scheduleId is " + scheduleId);
                    HashMap<String, Object> schMap = new HashMap<String, Object>();
                    schMap.put("scheduleId", scheduleId);
                    schMap.put("taskId", idMap.get("taskId"));
                    schMap.put("alertLife", Long.parseLong(request.getParameter("alertLife")));
                    schMap.put("units", "days");
                    if (accessType == 32) {
                        boolean stat = AlertSchedulerUtil.createAlertScheduler(schMap);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AlertsSettings.audit_entry.Successfully_delete_alerts_config", new String[]{request.getParameter("alertLife")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Save_Delete_Alerts", "-"}));
                    } else {
                        String message = rb.getString("adap.access_denied.AlertsSettings.save");
                        request.setAttribute("message", (Object)message);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.access_denied.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                    }
                } else if (option.equalsIgnoreCase("modify")) {
                    HashMap<String, Number> schMap = new HashMap<String, Number>();
                    Integer adminStatus = Integer.parseInt(request.getParameter("adminStatus"));
                    System.out.println(" admin status is1 " + adminStatus);
                    if (accessType == 32) {
                        if (adminStatus == 4) {
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.AlertsSettings.audit_entry.Successfully_disabled_delete_alerts"), 8, 8, "ADAPUserAuditSeverities.audit_name.Disable_Delete_Alerts", "-"}));
                            boolean b = AlertSchedulerUtil.deleteAlertScheduleRow();
                            System.out.println("boolean b is " + b + " admin status is " + adminStatus);
                        } else {
                            schMap.put("adminStatus", adminStatus);
                            schMap.put("alertLife", Long.parseLong(request.getParameter("alertLife")));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.AlertsSettings.audit_entry.Successfully_updated_delete_alerts", new String[]{request.getParameter("alertLife")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Enable_Delete_Alerts", "-"}));
                            AlertSchedulerUtil.modifyAlertScheduler(schMap);
                        }
                    } else {
                        String message = rb.getString("adap.access_denied.AlertsSettings.save");
                        request.setAttribute("message", (Object)message);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.access_denied.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                    }
                } else if (option.equalsIgnoreCase("view")) {
                    HashMap schMap = AlertSchedulerUtil.viewAlertScheduler();
                    request.setAttribute("schMap", (Object)schMap);
                }
            }
            if (request.getParameter("status") != null) {
                request.setAttribute("message", (Object)rb.getString("adap.AlertsSettings.Successfully_saved_the_settings"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return actionmapping.findForward(tile);
    }
}

