/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFileAPI;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreArchivedEventTable;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.BackupTableUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class BackupTableSettings
extends DispatchAction {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward createBackUpTableSettigs(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"", (ADAPAuthObject)authObj);
            String option = request.getParameter("action");
            String folder = request.getParameter("archiveDir");
            if (option != null) {
                if (option.equalsIgnoreCase("save")) {
                    ArrayList updateDetailsList = new ArrayList();
                    ArrayList tableNameList = BackupTableUtil.getCategoryTableNames();
                    for (int i = 0; i < tableNameList.size(); ++i) {
                        String tableName = "txt" + (String)tableNameList.get(i);
                        if (request.getParameter(tableName) == null) continue;
                        HashMap<String, Object> updateDetailsMap = new HashMap<String, Object>();
                        String daysAndChekVal = request.getParameter(tableName);
                        String[] daysAndChekValArray = daysAndChekVal.split(",");
                        long days = Long.valueOf(daysAndChekValArray[0]);
                        boolean isBackUp = Boolean.valueOf(daysAndChekValArray[1]);
                        updateDetailsMap.put("TABLE_NAME", (String)tableNameList.get(i));
                        updateDetailsMap.put("TIME_PERIOD", days);
                        updateDetailsMap.put("IS_BACKUP", isBackUp);
                        updateDetailsList.add(updateDetailsMap);
                    }
                    String message = ArchiveFileAPI.getInstance().checkArchiveFolderPermission(folder);
                    if (message != null && message.equalsIgnoreCase("Success")) {
                        if (accessType == 32) {
                            boolean b = BackupTableUtil.updateBackUpTableData(updateDetailsList, (String)folder);
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.BackupTableSettings.audit_entry.Archive_settings_successfully_saved"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.archive_settings_changed", rb.handleGetObject("adap.BackupTableSettings.audit_entry_addn.Details", new String[]{updateDetailsList.toString()})}));
                            if (b) {
                                request.setAttribute("message", (Object)"Success");
                            }
                        } else {
                            request.setAttribute("message", (Object)rb.getString("adap.access_denied.BackupTableSettings.save"));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.BackupTableSettings.save"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                        }
                    } else {
                        request.setAttribute("message", (Object)message);
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.BackupTableSettings.audit_entry.Failed_to_save_Archive_Settings", new String[]{message}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.archive_settings_changed", "-"}));
                    }
                }
                ArrayList backupTableSettingsList = BackupTableUtil.getBackUpTableSettings();
                request.setAttribute("backupTableSettingsList", (Object)backupTableSettingsList);
            }
        }
        catch (Exception e) {
            request.setAttribute("message", (Object)e.getMessage());
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.BackupTableSettings.audit_entry.Failed_to_save_Archive_Settings", new String[]{e.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.archive_settings_changed", "-"}));
            e.printStackTrace();
        }
        return actionmapping.findForward("BackUpTableSettings");
    }

    public ActionForward archiveEvents(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"BackUpTableSettings", (ADAPAuthObject)authObj);
        String messageType = "Success";
        String message = (String)rb.handleGetObject("adap.BackupTableSettings.Backup_table_start");
        if (accessType == 32) {
            BackupTableUtil.archiveEvents();
            RestoreArchivedEventTable.deleteFromDB();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.manual_archived", "-"}));
        } else {
            messageType = "Failure";
            message = rb.getString("adap.access_denied.BackupTableSettings.cantrunnow");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return actionmapping.findForward(null);
    }
}

