/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ConfigureMailServer
extends DispatchAction {
    String forward = "MailServerSettings";

    public ActionForward serverSettings(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String save = request.getParameter("Save");
        DynaActionForm mailserverForm = (DynaActionForm)actionform;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"MailServerSettings", (ADAPAuthObject)authObj);
        try {
            if (save != null) {
                Properties modifiedProperties = new Properties();
                try {
                    if (accessType == 32) {
                        for (String str : MailServerUtil.mailServerAttr) {
                            String val = request.getParameter(str);
                            if (val == null || val.equals("")) continue;
                            modifiedProperties.put(str, val);
                        }
                        boolean isUpdated = MailServerUtil.setMailServerSettings((Properties)modifiedProperties);
                        modifiedProperties.remove("PASSWORD");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureMailServer.audit_entry.SuccessFully_saved_mail_Server_settings", new String[]{modifiedProperties.toString()}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.mail_server_settings_changed", "-"}));
                        ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.admin.general.mail_server.message.configured_successfully"));
                    } else {
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.mail_server.configure"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                        ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.access_denied.mail_server.configure"));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureMailServer.audit_entry.Failed_to_update_mail_Server", new String[]{request.getParameter("MAIL_SERVER"), ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.mail_server_settings_changed", "-"}));
                    ClientUtil.setStatusXMLElement(response, "Error", ex.getMessage());
                }
                return null;
            }
            if (request.getParameter("init") != null) {
                mailserverForm.initialize(actionmapping);
                Properties mailProp = MailServerUtil.getMailServerSettings();
                for (String str : MailServerUtil.mailServerAttr) {
                    if (mailProp.get(str) == null) continue;
                    mailserverForm.set(str, mailProp.get(str));
                }
                String[] connValue = new String[]{"none", "ssl", "tls"};
                String[] connDisplay = new String[]{"None", "SSL", "TLS/STARTTLS"};
                mailserverForm.set("USE_SECURE_CONN_VALUE", (Object)connValue);
                mailserverForm.set("USE_SECURE_CONN_DISPLAY", (Object)connDisplay);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionmapping.findForward(this.forward);
    }

    public ActionForward sendTestMail(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"MailServerSettings", (ADAPAuthObject)authObj);
        try {
            if (accessType == 32) {
                Properties mailServerProperty = new Properties();
                for (String str : MailServerUtil.mailServerAttr) {
                    String val = request.getParameter(str);
                    if (val == null || val.equals("")) continue;
                    mailServerProperty.put(str, val);
                }
                String toAddress = request.getParameter("TO_ADDRESS");
                mailServerProperty.put("TO_ADDRESS", toAddress);
                String sentMail = MailServerUtil.sendTestMail((Properties)mailServerProperty);
                ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.admin.general.mail_server.message.send_mail_status") + " :" + sentMail);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.admin.general.mail_server.message.send_mail_status") + " :" + sentMail, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.sent_test_mail", rb.handleGetObject("adap.ConfigureMailServer.audit_entry_addn.send_mail_Details", new String[]{(String)mailServerProperty.get("TO_ADDRESS")})}));
            } else {
                ClientUtil.setStatusXMLElement(response, "Success", rb.getString("adap.access_denied.mail_server.send_mail_status"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.access_denied.mail_server.send_mail_status"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", ex.getMessage());
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.ConfigureMailServer.audit_entry.failed_to_send_test_mail", new String[]{request.getParameter("MAIL_SERVER"), request.getParameter("TO_ADDRESS")}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.sent_test_mail", "-"}));
        }
        return null;
    }
}

