/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ConfigureServiceAccounts
extends Action {
    private static Logger logger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.log(Level.INFO, "Now am going to view the service accounts");
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"ConfigureServiceAccounts", (ADAPAuthObject)authObj);
        String actionForward = "ConfigureServiceAccounts";
        String message = null;
        ArrayList excludedUsersList = new ArrayList();
        String domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        if (request.getParameter("domainName") != null) {
            session.setAttribute("MONITOR_DOMAIN_NAME", (Object)request.getParameter("domainName"));
            domainName = request.getParameter("domainName");
        }
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDServiceAccountFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDServiceAccountFilter", crit);
            String action = request.getParameter("action");
            if (action.equalsIgnoreCase("save")) {
                if (accessType == 32) {
                    String userName = "";
                    dObj.deleteRows("AUDServiceAccountFilter", crit);
                    if (request.getParameter("userGuid") != null) {
                        String userGuid = request.getParameter("userGuid");
                        StringTokenizer objectTokenizer = new StringTokenizer(userGuid, ",");
                        ArrayList<String> list = new ArrayList<String>();
                        while (objectTokenizer.hasMoreTokens()) {
                            list.add(objectTokenizer.nextToken());
                        }
                        Iterator iter = DirectoryObjectAPI.getInstance().getObjectRows(domainName, list, "user");
                        while (iter.hasNext()) {
                            Row row = (Row)iter.next();
                            Row userRow = new Row("AUDServiceAccountFilter");
                            userRow.set("OBJECT_GUID", row.get("OBJECT_GUID"));
                            userRow.set("USER_NAME", row.get("NAME"));
                            userRow.set("DOMAIN_NAME", (Object)domainName);
                            userName = userName != "" ? userName + "," + (String)row.get("NAME") : (String)row.get("NAME");
                            dObj.addRow(userRow);
                        }
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
                    AuditEventAPI.getInstance();
                    AuditEventAPI.getServiceAccountDetails();
                    message = rb.getString("adap.AlertsSettings.Successfully_saved_the_settings");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ConfigureServiceAccounts.audit_entry.Successfully_excluded"), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.service_account_settings_changed", rb.handleGetObject("adap.ConfigureServiceAccounts.audit_entryaddn.users_are", new String[]{userName})}));
                } else {
                    message = rb.getString("adap.access_denied.ConfigureServiceAccounts.save");
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
            }
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows("AUDServiceAccountFilter");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("USER_NAME", (String)row.get("USER_NAME"));
                    map.put("OBJECT_GUID", (String)row.get("OBJECT_GUID"));
                    excludedUsersList.add(map);
                }
            }
            AuditEventAPI.getInstance();
            AuditEventAPI.getServiceAccountDetails();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap.ConfigureServiceAccounts.Exception_While_adding_Removing_Users");
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.getString("adap.ConfigureServiceAccounts.audit_entry.Failed_to_exclude_users"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.service_account_settings_changed", "-"}));
        }
        finally {
            ArrayList configuredList = DomainHandler.getConfiguredList((Long)1L);
            request.setAttribute("configuredList", (Object)configuredList);
            String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext((String)domainName);
            String searchStr = null;
            int totalobj = DirectoryObjectAPI.getInstance().getDomainObjectsCount((String)session.getAttribute("MONITOR_DOMAIN_NAME"), "user", null, Long.valueOf(1L));
            Long total = totalobj;
            ArrayList rowsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, "user", searchStr, 1, 50, Long.valueOf(1L), total);
            request.setAttribute("rowsList", (Object)rowsList);
            request.setAttribute("excludedUsersList", excludedUsersList);
            request.setAttribute("message", (Object)message);
            request.setAttribute("totalrows", (Object)totalobj);
        }
        return mapping.findForward(actionForward);
    }
}

