/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.json.JSONObject;

public class TechnicianConfiguration
extends Action {
    private static Logger logger = Logger.getLogger(TechnicianHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardName;
        block26: {
            forwardName = "TechDetails";
            HttpSession session = request.getSession();
            ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
            Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
            try {
                forwardName = request.getParameter("forward") != null ? request.getParameter("forward") : forwardName;
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                DynaActionForm bean = (DynaActionForm)form;
                String action = request.getParameter("action");
                if (action == null) break block26;
                forwardName = "viewTechnician";
                JSONObject jsonObj = new JSONObject(request.getParameter("params"));
                String messageType = "success";
                String message = "";
                Long userId = null;
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                if (!action.equalsIgnoreCase("create")) {
                    userId = Long.parseLong(jsonObj.getString("userId"));
                }
                String samAccountName = null;
                try {
                    if (accessType == 32) {
                        if (action.equalsIgnoreCase("create")) {
                            String domainFlatName;
                            String name = jsonObj.getString("loginName");
                            String objectClass = jsonObj.getString("objectClass") != null ? jsonObj.getString("objectClass") : "";
                            samAccountName = name;
                            props.put("samAccountName", samAccountName);
                            String defaultNamingContext = jsonObj.getString("domainName");
                            if (!defaultNamingContext.equalsIgnoreCase("ADAP Authentication")) {
                                String domainName = DomainDetailsAPI.getDNCDomainName((String)defaultNamingContext);
                                logger.log(Level.INFO, "domain name in TechnicianConfiguration is :" + domainName);
                                Row row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, name, "OBJECT_GUID", objectClass);
                                logger.log(Level.FINE, "row is " + row);
                                if (row != null) {
                                    samAccountName = objectClass.equalsIgnoreCase("user") ? (String)row.get("SAM_ACCOUNT_NAME") : (String)row.get("NAME");
                                }
                                logger.log(Level.INFO, "samAccountName is " + samAccountName);
                                props.put("samAccountName", samAccountName);
                                logger.log(Level.INFO, "props is " + props);
                                if (objectClass != null && !objectClass.equalsIgnoreCase("user")) {
                                    samAccountName = name;
                                }
                                logger.log(Level.INFO, "samAccountName is " + samAccountName);
                            }
                            if (!(domainFlatName = defaultNamingContext).equalsIgnoreCase("ADAP Authentication")) {
                                domainFlatName = DomainDetailsAPI.getDnFlatName((String)defaultNamingContext);
                                message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_assigned_the_user");
                            } else {
                                message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_created_and_assigned_the");
                            }
                            userId = TechnicianHandler.createUser((String)domainFlatName, (String)samAccountName, (String)jsonObj.getString("password"), (Long)jsonObj.getLong("roleId"), (String)objectClass, (String)jsonObj.getString("delegatedDomain"));
                            props.put("objectClass", objectClass);
                            props.put("roleId", jsonObj.getLong("roleId"));
                            if (!domainFlatName.equalsIgnoreCase("ADAP Authentication")) {
                                props.put("domainFlatName", domainFlatName);
                            } else {
                                props.put("domainFlatName", (String)rb.handleGetObject("adap.TechnicianConfiguration.ADAuditPlus_Authentication"));
                            }
                            String roleName = TDHandler.getRoleName((Long)jsonObj.getLong("roleId"));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_added", new String[]{TDHandler.getUserName((Long)userId, (String)objectClass), rb.getString(roleName)}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_added", "-"}));
                        } else if (action.equalsIgnoreCase("changeRole")) {
                            Long roleId = jsonObj.getLong("roleId");
                            TechnicianHandler.updateUser((Long)userId, (Long)roleId, (String)jsonObj.getString("objectClass"), (String)jsonObj.getString("delegatedDomain"));
                            message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_updated_the_role");
                            String roleName = TDHandler.getRoleName((Long)roleId);
                            String userName = TDHandler.getUserName((Long)userId, (String)jsonObj.getString("objectClass"));
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_role_changed", new String[]{roleName, userName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_changed", "-"}));
                        } else if (action.equalsIgnoreCase("changePassword")) {
                            TechnicianHandler.changePassword((Long)userId, (String)jsonObj.getString("password"));
                            message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_updated_the_password");
                            String userName = TDHandler.getUserName((Long)userId, (String)"user");
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_pwd_changed", new String[]{userName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_password_changed", "-"}));
                        } else if (action.equalsIgnoreCase("delete")) {
                            String userName = TDHandler.getUserName((Long)userId, (String)jsonObj.getString("objectClass"));
                            TechnicianHandler.deleteUser((Long)userId, (String)jsonObj.getString("objectClass"));
                            message = (String)rb.handleGetObject("adap.TechnicianConfiguration.Successfully_deleted_the_user");
                            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.tech_deleted", new String[]{userName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_deleted", "-"}));
                        } else if (action.equalsIgnoreCase("search")) {
                            String searchString = jsonObj.getString("SEARCH_STRING");
                        }
                        props.put("objectClass", jsonObj.getString("objectClass"));
                        props.put("userId", userId);
                    } else {
                        message = rb.getString("adap.access_denied.TechnicianConfiguration.audit_entry.technician");
                        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_deleted", "-"}));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    messageType = (String)rb.handleGetObject("adap.TechnicianConfiguration.error");
                    message = e.getMessage();
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianConfiguration.audit_entry.problem_while_changing", new String[]{message}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.problem_while_updating_technician", rb.handleGetObject("adap.TechnicianConfiguration.Name_of_technician", new String[]{samAccountName})}));
                }
                request.setAttribute("message", (Object)message);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                request.setAttribute("TECHNICIAN_LIST", (Object)TechnicianHandler.getUsers());
            }
        }
        return mapping.findForward(forwardName);
    }
}

