/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.validator.DynaValidatorForm;

public class ImportLogFileBean
extends DynaValidatorForm {
    private static String event_task_name = "ImportLogSchedule";

    protected void init(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Integer[] hourOfDay = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        Integer[] minutes = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        this.set("hours", hourOfDay);
        this.set("minutes", minutes);
        this.set("hoursOfDay", hourOfDay);
        this.set("minutesOfDay", minutes);
        String[] daysOfWeek = new String[]{rb.getString("adap.ReportSchedulerBean.Sunday"), rb.getString("adap.ReportSchedulerBean.Monday"), rb.getString("adap.ReportSchedulerBean.Tuesday"), rb.getString("adap.ReportSchedulerBean.Wednesday"), rb.getString("adap.ReportSchedulerBean.Thursday"), rb.getString("adap.ReportSchedulerBean.Friday"), rb.getString("adap.ReportSchedulerBean.Saturday")};
        Integer[] daysOfWeekValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        this.set("daysOfWeek", daysOfWeek);
        this.set("daysOfWeekValues", daysOfWeekValues);
        this.set("hoursOfWeek", hourOfDay);
        this.set("minutesOfWeek", minutes);
    }

    public DataObject getImportLogDO(String action) throws Exception {
        Integer timePeriod = 0;
        DataObject importLogDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Row scheduleRow = new Row("Schedule");
        if (action.equalsIgnoreCase("update")) {
            scheduleRow.set("SCHEDULE_ID", this.get("scheduleId"));
        }
        scheduleRow.set("SCHEDULE_NAME", this.get("fileLocation"));
        scheduleRow.set("DESCRIPTION", this.get("fileLocation"));
        importLogDO.addRow(scheduleRow);
        if (this.get("reportType").toString().equalsIgnoreCase("hourly") || this.get("reportType").toString().equalsIgnoreCase("once")) {
            Row periodicRow = new Row("Periodic");
            periodicRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            periodicRow.set("TIME_PERIOD", (Object)1L);
            periodicRow.set("UNIT_OF_TIME", (Object)"Hours");
            Date dateObj = new Date();
            dateObj.setHours((Integer)this.get("selectedHour"));
            dateObj.setMinutes((Integer)this.get("selectedMinute"));
            dateObj.setSeconds(0);
            periodicRow.set("START_DATE", (Object)new Timestamp(dateObj.getTime()));
            importLogDO.addRow(periodicRow);
        } else {
            Row calendarRow = new Row("Calendar");
            calendarRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            if (((String)this.get("reportType")).equalsIgnoreCase("daily")) {
                timePeriod = (Integer)this.get("selectedHourOfDay") * 60 + (Integer)this.get("selectedMinuteOfDay");
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
            } else if (((String)this.get("reportType")).equalsIgnoreCase("weekly")) {
                timePeriod = (Integer)this.get("hourOfWeek") * 60 + (Integer)this.get("minuteOfWeek");
                calendarRow.set("DAY_OF_WEEK", (Object)((Integer)this.get("dayOfWeek")));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
            } else if (((String)this.get("reportType")).equalsIgnoreCase("monthly")) {
                timePeriod = (Integer)this.get("hourOfMonth") * 60 + (Integer)this.get("minuteOfMonth");
                calendarRow.set("DATE_OF_MONTH", this.get("dateOfMonth"));
                calendarRow.set("TIME_OF_DAY", (Object)timePeriod.longValue());
                calendarRow.set("UNIT_OF_TIME", (Object)"Minutes");
                calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
            }
            importLogDO.addRow(calendarRow);
        }
        Row taskInputRow = new Row("Task_Input");
        taskInputRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskInputRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)event_task_name));
        Long time = ScheduleUtil.calculateNextScheduleTime((DataObject)importLogDO, (Long)-1L, (boolean)false);
        taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(time));
        importLogDO.addRow(taskInputRow);
        Row taskRow = new Row("Scheduled_Task");
        taskRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        taskRow.set("AUDIT_FLAG", (Object)true);
        taskRow.set("TASK_ID", (Object)SchedulerUtil.getTaskID((String)event_task_name));
        taskRow.set("TRANSACTION_TIME", (Object)-1);
        taskRow.set("SKIP_MISSED_SCHEDULE", (Object)true);
        importLogDO.addRow(taskRow);
        if (action.equalsIgnoreCase("update")) {
            Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogPathConfig", (String)"SCHEDULE_ID"), this.get("scheduleId"), 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AudImportLogPathConfig", crit);
            Row pathRow = dataObject.getRow("AudImportLogPathConfig");
            pathRow.set("PATH_ID", pathRow.get("PATH_ID"));
            pathRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            pathRow.set("REPORT_TYPE", this.get("reportType"));
            importLogDO.addRow(pathRow);
        } else {
            Row pathRow = new Row("AudImportLogPathConfig");
            pathRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            pathRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
            pathRow.set("REPORT_TYPE", this.get("reportType"));
            pathRow.set("EVENT_LOG_PATH", (Object)((String)this.get("fileLocation")));
            importLogDO.addRow(pathRow);
        }
        return importLogDO;
    }

    public void setProperties(Long scheduleId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject schedulerDO = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("AudImportLogPathConfig", crit);
        Row scheduleRow = schedulerDO.getRow("Schedule");
        Row importLogRow = schedulerDO.getRow("AudImportLogPathConfig");
        this.set("fileLocation", (String)importLogRow.get("EVENT_LOG_PATH"));
        if (schedulerDO.size("Periodic") > 0) {
            Row periodicRow = schedulerDO.getRow("Periodic");
            Date dateObj = (Date)periodicRow.get("START_DATE");
            this.set("selectedHour", dateObj.getHours());
            this.set("selectedMinute", dateObj.getMinutes());
            this.set("reportType", "hourly");
            if (importLogRow.get("REPORT_TYPE").toString().equalsIgnoreCase("once")) {
                this.set("reportType", "once");
            }
        } else {
            Row calendarRow = schedulerDO.getRow("Calendar");
            if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("daily")) {
                this.set("selectedHourOfDay", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                this.set("selectedMinuteOfDay", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                this.set("reportType", "daily");
            } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("weekly")) {
                this.set("dayOfWeek", (Integer)calendarRow.get("DAY_OF_WEEK"));
                this.set("hourOfWeek", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                this.set("minuteOfWeek", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                this.set("reportType", "weekly");
            } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("monthly")) {
                this.set("dateOfMonth", (Integer)calendarRow.get("DATE_OF_MONTH"));
                this.set("hourOfMonth", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                this.set("minuteOfMonth", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                this.set("reportType", "monthly");
            }
        }
    }
}

